/*
 * Decompiled with CFR 0.152.
 */
package com.mna.blocks.tileentities.wizard_lab;

import com.mna.advancements.CustomAdvancementTriggers;
import com.mna.api.affinity.Affinity;
import com.mna.api.events.GenericProgressionEvent;
import com.mna.api.events.ProgressionEventIDs;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.blocks.tileentities.init.TileEntityInit;
import com.mna.blocks.tileentities.wizard_lab.WizardLabTile;
import com.mna.capabilities.worlddata.WorldMagicProvider;
import com.mna.items.ritual.MoteItem;
import com.mna.recipes.RecipeInit;
import com.mna.recipes.eldrin.FumeFilterRecipe;
import com.mna.tools.ContainerTools;
import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class EldrinFumeTile
extends WizardLabTile {
    public static final float GENERATION_RATE_PER_TICK = 0.01f;
    public static final int SLOT_FUEL = 0;
    public static final int SLOT_MOTE = 1;
    public static final int INVENTORY_SIZE = 2;
    private float fuelBurnTicks = 100.0f;
    private float moteBurnTicks = 0.0f;
    private float moteBurnTicksRemaining = 0.0f;
    private Affinity selectedAffinity = Affinity.UNKNOWN;

    public EldrinFumeTile(BlockEntityType<?> type, BlockPos pos, BlockState state, int inventorySize) {
        super(type, pos, state, inventorySize);
    }

    public EldrinFumeTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileEntityInit.ELDRIN_FUME.get(), pos, state, 2);
    }

    private boolean itemsPresent() {
        Pair<Affinity, Float> fuelValues = this.getFuelValues(this.f_58857_);
        return this.hasStack(0) && (this.moteBurnTicksRemaining > 0.0f || ((Float)fuelValues.getSecond()).floatValue() > 0.0f && fuelValues.getFirst() != Affinity.UNKNOWN);
    }

    private Pair<Affinity, Float> getFuelValues(Level level) {
        Affinity affinity = Affinity.UNKNOWN;
        float amount = 0.0f;
        if (!this.hasStack(1)) {
            return new Pair((Object)affinity, (Object)Float.valueOf(amount));
        }
        Optional<FumeFilterRecipe> recipe = level.m_7465_().m_44013_((RecipeType)RecipeInit.FUME_FILTER_TYPE.get()).stream().filter(r -> r.matches(ContainerTools.createTemporaryContainer(this.m_8020_(1)), level)).findFirst();
        if (recipe.isEmpty()) {
            return new Pair((Object)affinity, (Object)Float.valueOf(amount));
        }
        return new Pair((Object)recipe.get().getAffinity(), (Object)Float.valueOf(recipe.get().getTotalGeneration()));
    }

    @Override
    public boolean canActivate(Player player) {
        return this.itemsPresent() && ForgeHooks.getBurnTime((ItemStack)this.m_8020_(0), null) > 0;
    }

    @Override
    protected boolean canContinue() {
        this.injectPower();
        return true;
    }

    @Override
    public float getPctComplete() {
        return this.getFuelPctRemaining();
    }

    public float getMotePctRemaining() {
        return this.moteBurnTicksRemaining / this.moteBurnTicks;
    }

    public float getFuelPctRemaining() {
        return (float)this.getActiveTicks() / this.fuelBurnTicks;
    }

    @Override
    protected List<Integer> getSyncedInventorySlots() {
        return Arrays.asList(0, 1);
    }

    @Override
    protected boolean canActiveTick() {
        this.injectPower();
        return true;
    }

    private void injectPower() {
        if (!this.m_58904_().m_5776_() && this.selectedAffinity != null) {
            this.m_58904_().getCapability(WorldMagicProvider.MAGIC).ifPresent(m -> m.getWellspringRegistry().insertPower(this.getCrafterID(), this.f_58857_, this.selectedAffinity, 0.01f));
        }
    }

    @Override
    protected void onCraftStart(Player crafter) {
        Pair<Affinity, Float> values;
        ItemStack potentialFuel = this.m_8020_(0);
        this.fuelBurnTicks = ForgeHooks.getBurnTime((ItemStack)potentialFuel, null);
        if (potentialFuel.hasCraftingRemainingItem()) {
            this.m_6836_(0, potentialFuel.getCraftingRemainingItem());
        } else {
            potentialFuel.m_41774_(1);
        }
        ItemStack burnableStack = this.m_8020_(1);
        if (!burnableStack.m_41619_() && (values = this.getFuelValues(this.f_58857_)).getFirst() != Affinity.UNKNOWN && ((Float)values.getSecond()).floatValue() > 0.0f) {
            this.selectedAffinity = (Affinity)((Object)values.getFirst());
            this.moteBurnTicksRemaining = this.moteBurnTicks = ((Float)values.getSecond()).floatValue();
            burnableStack.m_41774_(1);
        }
        if (crafter != null && !crafter.m_9236_().m_5776_()) {
            MinecraftForge.EVENT_BUS.post((Event)new GenericProgressionEvent(crafter, ProgressionEventIDs.ELDRIN_FUME_LIT));
            if (crafter instanceof ServerPlayer) {
                CustomAdvancementTriggers.LIGHT_FUME.trigger((ServerPlayer)crafter, this.selectedAffinity);
            }
        }
    }

    @Override
    protected void onComplete() {
        if (this.itemsPresent()) {
            ItemStack mote = this.m_8020_(1);
            if (mote.m_41720_() instanceof MoteItem) {
                this.selectedAffinity = ((MoteItem)mote.m_41720_()).getRelatedAffinity();
            }
            this.m_58904_().getCapability(WorldMagicProvider.MAGIC).ifPresent(m -> {
                if (m.getWellspringRegistry().getNodeNetworkAmountFor(this.getCrafterID(), this.f_58857_).getOrDefault((Object)this.selectedAffinity, Float.valueOf(0.0f)).floatValue() < 1000.0f) {
                    this.reactivate();
                }
            });
        }
    }

    @Override
    protected boolean needsPower() {
        return false;
    }

    @Override
    protected CompoundTag getMeta() {
        CompoundTag meta = new CompoundTag();
        meta.m_128350_("burnTime", this.fuelBurnTicks);
        meta.m_128350_("moteBurnTime", this.moteBurnTicks);
        meta.m_128350_("moteBurnTimeRemaining", this.moteBurnTicksRemaining);
        meta.m_128405_("affinity", this.selectedAffinity.ordinal());
        return meta;
    }

    @Override
    protected void loadMeta(CompoundTag tag) {
        if (tag.m_128441_("burnTime")) {
            this.fuelBurnTicks = tag.m_128457_("burnTime");
        }
        if (tag.m_128441_("moteBurnTime")) {
            this.moteBurnTicks = tag.m_128457_("moteBurnTime");
        }
        if (tag.m_128441_("moteBurnTimeRemaining")) {
            this.moteBurnTicksRemaining = tag.m_128457_("moteBurnTimeRemaining");
        }
        if (tag.m_128441_("affinity")) {
            this.selectedAffinity = Affinity.values()[tag.m_128451_("affinity")];
        }
    }

    @Override
    protected void tick() {
        super.tick();
        if (this.m_58904_().m_5776_()) {
            this.spawnParticles();
        } else if (this.isActive()) {
            this.moteBurnTicksRemaining -= 1.0f;
            if (this.moteBurnTicksRemaining < 1.0f) {
                this.setInactive();
            }
        }
    }

    private void spawnParticles() {
        if (this.isActive()) {
            int[] color = this.selectedAffinity.getColor();
            float colorMultiplier = 0.25f;
            float secondaryColorMultiplier = 0.075f;
            Vec3 particlePos = Vec3.m_82514_((Vec3i)this.m_58899_(), (double)1.2);
            this.m_58904_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FLAME.get())).setColor((int)((float)color[0] * colorMultiplier), (int)((float)color[1] * colorMultiplier), (int)((float)color[2] * colorMultiplier)), particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 0.0, 0.0, 0.0);
            this.m_58904_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FLAME.get())).setColor((int)((float)color[0] * secondaryColorMultiplier), (int)((float)color[1] * secondaryColorMultiplier), (int)((float)color[2] * secondaryColorMultiplier)).setMaxAge(40), particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 0.0, (double)0.015f, 0.0);
        }
    }

    public Affinity getGeneratingAffinity() {
        return this.selectedAffinity;
    }

    @Override
    public int[] m_7071_(Direction side) {
        return new int[]{1, 0};
    }

    @Override
    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return !this.isActive();
    }

    @Override
    public boolean m_7155_(int index, ItemStack stack, Direction direction) {
        if (this.isActive()) {
            return false;
        }
        ItemStack existing = this.m_8020_(index);
        return existing.m_41619_() || existing.m_41613_() < existing.m_41741_() && ItemStack.m_150942_((ItemStack)stack, (ItemStack)existing);
    }
}

