/*
 * Decompiled with CFR 0.152.
 */
package com.mna.blocks.tileentities.wizard_lab;

import com.mna.advancements.CustomAdvancementTriggers;
import com.mna.api.config.GeneralConfigValues;
import com.mna.blocks.BlockInit;
import com.mna.blocks.tileentities.init.TileEntityInit;
import com.mna.blocks.tileentities.wizard_lab.WizardLabTile;
import com.mna.events.EventDispatcher;
import com.mna.gui.containers.block.ContainerRunescribingTable;
import com.mna.items.ItemInit;
import com.mna.items.runes.ItemRunePattern;
import com.mna.items.runes.ItemRunescribingRecipe;
import com.mna.network.ClientMessageDispatcher;
import com.mna.network.messages.to_server.RunescribingTableMutexChangeMessage;
import com.mna.recipes.RecipeInit;
import com.mna.recipes.runeforging.RunescribingRecipe;
import com.mna.tools.ContainerTools;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class RunescribingTableTile
extends WizardLabTile
implements MenuProvider,
Consumer<FriendlyByteBuf> {
    public static final int SLOT_HAMMER = 0;
    public static final int SLOT_CHISEL = 1;
    public static final int SLOT_PATTERN = 2;
    public static final int SLOT_GUIDE = 3;
    public static final int SLOT_CLAY = 4;
    public static final int SLOT_PATTERNS_START = 5;
    public static final int SLOT_PATTERNS_END = 29;
    public static final int INVENTORY_SIZE = 30;

    public RunescribingTableTile(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state, 30);
    }

    public RunescribingTableTile(BlockPos pos, BlockState state) {
        this((BlockEntityType)TileEntityInit.RUNESCRIBING_TABLE.get(), pos, state);
    }

    @Override
    public boolean canActivate(Player player) {
        return false;
    }

    @Override
    public float getPctComplete() {
        return 1.0f;
    }

    @Override
    protected boolean canContinue() {
        return true;
    }

    @Override
    protected List<Integer> getSyncedInventorySlots() {
        return Arrays.asList(0, 1, 2, 3, 4);
    }

    public long getHMutex() {
        ItemStack patternStack = this.m_8020_(2);
        if (patternStack.m_41720_() == ItemInit.RUNE_PATTERN.get() && patternStack.m_41782_()) {
            return patternStack.m_41784_().m_128454_("hmutex");
        }
        return 0L;
    }

    public long getVMutex() {
        ItemStack patternStack = this.m_8020_(2);
        if (patternStack.m_41720_() == ItemInit.RUNE_PATTERN.get() && patternStack.m_41782_()) {
            return patternStack.m_41783_().m_128454_("vmutex");
        }
        return 0L;
    }

    public boolean canUndo(Player player) {
        return !this.m_8020_(4).m_41619_() && player.f_36079_ >= GeneralConfigValues.ExperiencePerRunescribeUndo;
    }

    public boolean hasRequiredItems(boolean toolsRequired) {
        ItemStack patternStack = this.m_8020_(2);
        ItemStack chiselStack = this.m_8020_(1);
        ItemStack hammerStack = this.m_8020_(0);
        if (toolsRequired) {
            return patternStack.m_41720_() == ItemInit.RUNE_PATTERN.get() && chiselStack.m_41720_() == ItemInit.RUNESMITH_CHISEL.get() && (hammerStack.m_41720_() == ItemInit.RUNESMITH_HAMMER.get() || hammerStack.m_41720_() == ItemInit.RUNIC_MALUS.get());
        }
        return patternStack.m_41720_() == ItemInit.RUNE_PATTERN.get();
    }

    private void damageHammerAndChisel(RandomSource source) {
        ItemStack chiselStack = this.m_8020_(1);
        ItemStack hammerStack = this.m_8020_(0);
        if (chiselStack.m_41720_() == ItemInit.RUNESMITH_CHISEL.get() && chiselStack.m_220157_(1, source, null)) {
            this.m_6836_(1, ItemStack.f_41583_);
        }
        if (hammerStack.m_41720_() == ItemInit.RUNESMITH_HAMMER.get() && hammerStack.m_220157_(1, source, null)) {
            this.m_6836_(0, ItemStack.f_41583_);
        }
    }

    @Nullable
    public RunescribingRecipe getRecipeFromGuideSlot() {
        ItemStack recipe = this.m_8020_(3);
        if (recipe.m_41619_()) {
            return null;
        }
        return ((ItemRunescribingRecipe)ItemInit.RECIPE_SCRAP_RUNESCRIBING.get()).getRecipe(recipe, this.f_58857_);
    }

    public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player playerEntity) {
        return new ContainerRunescribingTable(id, playerInventory, this);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"mna:container.inscription_table");
    }

    @Override
    public void accept(FriendlyByteBuf data) {
        data.m_130064_(this.m_58899_());
    }

    public RunescribingTableTile readFrom(FriendlyByteBuf data) {
        return this;
    }

    public boolean writeMutexChanges(long hMutex, long vMutex, Player player, int playerTier, boolean isRemove, RandomSource source) {
        RunescribingRecipe recipe;
        ItemStack patternStack;
        boolean returnValue = false;
        if (this.m_58904_().m_5776_()) {
            ClientMessageDispatcher.sendRunescribingMutexChange(this, hMutex, vMutex, playerTier, isRemove);
            return returnValue;
        }
        if (isRemove) {
            if (!this.canUndo(player)) {
                return false;
            }
            this.m_8020_(4).m_41774_(1);
            player.m_6756_(-GeneralConfigValues.ExperiencePerRunescribeUndo);
        }
        if ((patternStack = this.m_8020_(2)).m_41720_() == ItemInit.RUNE_PATTERN.get()) {
            ((ItemRunePattern)ItemInit.RUNE_PATTERN.get()).setHMutex(patternStack, hMutex);
            ((ItemRunePattern)ItemInit.RUNE_PATTERN.get()).setVMutex(patternStack, vMutex);
        }
        if ((recipe = (RunescribingRecipe)this.m_58904_().m_7465_().m_44015_((RecipeType)RecipeInit.RUNESCRIBING_TYPE.get(), (Container)ContainerTools.createTemporaryContainer(patternStack), this.f_58857_).orElse(null)) != null && (playerTier < 0 || recipe.getTier() <= playerTier) && EventDispatcher.DispatchRunescribeCraft(recipe, recipe.getResultItem(), player)) {
            this.m_6836_(2, recipe.getResultItem());
            if (player instanceof ServerPlayer) {
                CustomAdvancementTriggers.RUNESCRIBE.trigger((ServerPlayer)player, recipe.getResultItem());
            }
            returnValue = true;
        }
        if (playerTier > 0) {
            this.damageHammerAndChisel(source);
        }
        return returnValue;
    }

    private static RunescribingTableTile getAndVerify(Level world, BlockPos position) {
        BlockEntity te;
        if (world.m_46749_(position) && world.m_8055_(position).m_60734_() == BlockInit.RUNESCRIBING_TABLE.get() && (te = world.m_7702_(position)) != null && te instanceof RunescribingTableTile) {
            return (RunescribingTableTile)te;
        }
        return null;
    }

    public static void handleMutexChangeMessage(ServerPlayer sendingPlayer, RunescribingTableMutexChangeMessage message) {
        RunescribingTableTile te = RunescribingTableTile.getAndVerify(sendingPlayer.m_9236_(), message.getPosition());
        if (te == null) {
            return;
        }
        te.writeMutexChanges(message.getHMutex(), message.getVMutex(), (Player)sendingPlayer, message.getPlayerTier(), message.getIsRemove(), sendingPlayer.m_9236_().m_213780_());
    }

    @Override
    public boolean m_7155_(int index, ItemStack itemStackIn, Direction direction) {
        if (itemStackIn.m_41613_() != 1) {
            return false;
        }
        if (index == 0 && this.m_8020_(0).m_41619_() && itemStackIn.m_41720_() == ItemInit.RUNESMITH_HAMMER.get()) {
            return true;
        }
        if (index == 1 && this.m_8020_(1).m_41619_() && itemStackIn.m_41720_() == ItemInit.RUNESMITH_CHISEL.get()) {
            return true;
        }
        if (index == 4 && itemStackIn.m_41720_() == Items.f_42461_) {
            return true;
        }
        return index == 2 && this.m_8020_(2).m_41619_() && itemStackIn.m_41720_() == ItemInit.RUNE_PATTERN.get();
    }

    @Override
    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        if (this.m_8020_(index).m_41619_() || !ItemStack.m_41728_((ItemStack)this.m_8020_(index), (ItemStack)stack)) {
            return false;
        }
        return direction == Direction.EAST || direction == Direction.WEST || direction == Direction.NORTH || direction == Direction.SOUTH ? index == 0 || index == 1 || index == 4 : (direction == Direction.DOWN || direction == Direction.UP) && index == 2;
    }

    public boolean m_7013_(int slot, ItemStack stack) {
        switch (slot) {
            case 0: {
                return stack.m_41720_() == ItemInit.RUNESMITH_HAMMER.get() || stack.m_41720_() == ItemInit.RUNIC_MALUS.get();
            }
            case 1: {
                return stack.m_41720_() == ItemInit.RUNESMITH_CHISEL.get();
            }
            case 2: {
                return stack.m_41720_() == ItemInit.RUNE_PATTERN.get();
            }
            case 3: {
                return stack.m_41720_() == ItemInit.RECIPE_SCRAP_RUNESCRIBING.get();
            }
            case 4: {
                return stack.m_41720_() == Items.f_42461_;
            }
        }
        if (slot >= 5 && slot <= 29) {
            return stack.m_41720_() == ItemInit.RECIPE_SCRAP_RUNESCRIBING.get();
        }
        return false;
    }

    @Override
    public int[] m_7071_(Direction side) {
        if (side == Direction.EAST || side == Direction.WEST || side == Direction.NORTH || side == Direction.SOUTH) {
            return new int[]{0, 1, 4};
        }
        if (side == Direction.DOWN || side == Direction.UP) {
            return new int[]{2};
        }
        return new int[0];
    }

    public int m_6893_() {
        return 64;
    }
}

