/*
 * Decompiled with CFR 0.152.
 */
package com.mna.blocks.tileentities.wizard_lab;

import com.mna.Registries;
import com.mna.api.affinity.Affinity;
import com.mna.api.blocks.tile.IEldrinConsumerTile;
import com.mna.api.blocks.tile.PowerStatus;
import com.mna.api.capabilities.IPlayerRoteSpells;
import com.mna.api.sound.SFX;
import com.mna.api.spells.base.ISpellComponent;
import com.mna.api.spells.parts.SpellEffect;
import com.mna.blocks.tileentities.init.TileEntityInit;
import com.mna.blocks.tileentities.wizard_lab.ISelectSpellComponents;
import com.mna.blocks.tileentities.wizard_lab.WizardLabTile;
import com.mna.capabilities.playerdata.rote.PlayerRoteSpellsProvider;
import com.mna.items.ItemInit;
import com.mna.items.sorcery.ItemTornJournalPage;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class ThesisDeskTile
extends WizardLabTile
implements IEldrinConsumerTile,
ISelectSpellComponents {
    public static final int SLOT_PAPER = 0;
    public static final int SLOT_INK = 1;
    public static final int SLOT_BOOK = 2;
    public static final int SLOT_OUTPUT = 3;
    public static final int INVENTORY_SIZE = 4;
    private float ticksRequired = 1800.0f;
    private float powerPerTick = 5.0f;
    private float powerAccum = 0.0f;
    private ISpellComponent selectedComponent;
    private PowerStatus powerConsumeStatus = PowerStatus.NOT_REQUESTING;

    public ThesisDeskTile(BlockEntityType<?> type, BlockPos pos, BlockState state, int inventorySize) {
        super(type, pos, state, inventorySize);
    }

    public ThesisDeskTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileEntityInit.THESIS_DESK.get(), pos, state, 4);
    }

    @Override
    public boolean canActivate(Player player) {
        boolean baseActivate = this.canContinue();
        if (!baseActivate) {
            return false;
        }
        if (!this.hasStack(0) || this.m_8020_(0).m_41613_() < this.getPaperCount() || !this.hasStack(1) || this.m_8020_(1).m_41776_() - this.m_8020_(1).m_41773_() < this.getInkDamage()) {
            return false;
        }
        LazyOptional roteData = player.getCapability(PlayerRoteSpellsProvider.ROTE);
        return player.m_7500_() || roteData.isPresent() && ((IPlayerRoteSpells)roteData.resolve().get()).isRote(this.selectedComponent);
    }

    @Override
    protected void onCraftStart(Player crafter) {
        if (crafter instanceof ServerPlayer) {
            this.m_8020_(1).m_220157_(this.getInkDamage(), this.f_58857_.f_46441_, (ServerPlayer)crafter);
            if (this.m_8020_(1).m_41773_() >= this.m_8020_(1).m_41776_()) {
                this.m_6836_(1, ItemStack.f_41583_);
            }
            this.m_8020_(0).m_41774_(this.getPaperCount());
        }
    }

    private int getInkDamage() {
        if (this.selectedComponent == null) {
            return 0;
        }
        return this.selectedComponent.getTier(this.f_58857_) * 5;
    }

    private int getPaperCount() {
        if (this.selectedComponent == null) {
            return 0;
        }
        return this.selectedComponent.getTier(this.f_58857_) * 5;
    }

    @Override
    protected CompoundTag getMeta() {
        CompoundTag tag = new CompoundTag();
        if (this.selectedComponent != null) {
            tag.m_128359_("part", this.selectedComponent.getRegistryName().toString());
        }
        this.writePowerConsumeStatus(this.powerConsumeStatus, tag);
        tag.m_128350_("accum", this.powerAccum);
        return tag;
    }

    @Override
    protected void loadMeta(CompoundTag tag) {
        this.powerConsumeStatus = this.readPowerConsumeStatus(tag);
        this.selectedComponent = null;
        if (tag.m_128441_("part")) {
            ResourceLocation part = new ResourceLocation(tag.m_128461_("part"));
            if (Registries.Shape.get().containsKey(part)) {
                this.selectedComponent = (ISpellComponent)Registries.Shape.get().getValue(part);
            } else if (Registries.Modifier.get().containsKey(part)) {
                this.selectedComponent = (ISpellComponent)Registries.Modifier.get().getValue(part);
            } else if (Registries.SpellEffect.get().containsKey(part)) {
                this.selectedComponent = (ISpellComponent)Registries.SpellEffect.get().getValue(part);
            }
        }
        if (tag.m_128441_("accum")) {
            this.powerAccum = tag.m_128457_("accum");
        }
    }

    @Override
    protected boolean canContinue() {
        return this.selectedComponent != null && this.hasStack(2) && !this.hasStack(3);
    }

    @Override
    public float getPctComplete() {
        return (float)this.getActiveTicks() / this.ticksRequired;
    }

    @Override
    protected List<Integer> getSyncedInventorySlots() {
        return Arrays.asList(0, 1, 2);
    }

    public Affinity getSelectedAffinity() {
        return this.selectedComponent instanceof SpellEffect ? ((SpellEffect)this.selectedComponent).getAffinity().getShiftAffinity() : Affinity.ARCANE;
    }

    @Override
    protected boolean canActiveTick() {
        float amount = this.consume(this.getCrafter(), this.m_58899_(), Vec3.m_82512_((Vec3i)this.m_58899_()), this.getSelectedAffinity(), this.powerPerTick);
        this.powerConsumeStatus = this.calculatePowerStatus(this.powerPerTick, amount);
        this.powerAccum += Math.max(amount, 0.0f);
        if (this.powerAccum >= this.powerPerTick) {
            this.powerAccum = 0.0f;
            if (this.getActiveTicks() == 1799 && !this.m_58904_().m_5776_()) {
                this.m_58904_().m_6263_(null, (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), SFX.Gui.CHARCOAL_SCRIBBLE, SoundSource.BLOCKS, 1.0f, (float)(0.95 + Math.random() * (double)0.1f));
            }
            return true;
        }
        return false;
    }

    @Override
    public ISpellComponent getSpellComponent() {
        return this.selectedComponent;
    }

    @Override
    public void setSpellComponent(ISpellComponent component) {
        if (!this.isActive()) {
            this.selectedComponent = component;
        }
    }

    @Override
    protected void onComplete() {
        ItemStack thesis = new ItemStack((ItemLike)ItemInit.SPELL_PART_THESIS.get());
        ((ItemTornJournalPage)ItemInit.SPELL_PART_THESIS.get()).setComponent(thesis, this.selectedComponent);
        this.m_6836_(3, thesis);
        this.powerConsumeStatus = PowerStatus.NOT_REQUESTING;
    }

    @Override
    protected void onDeactivated() {
        this.powerConsumeStatus = PowerStatus.NOT_REQUESTING;
    }

    @Override
    public int getXPCost(Player crafter) {
        return 100;
    }

    @Override
    public HashMap<Affinity, PowerStatus> powerRequirementStatus() {
        HashMap<Affinity, PowerStatus> reqs = new HashMap<Affinity, PowerStatus>();
        reqs.put(this.getSelectedAffinity(), this.powerConsumeStatus);
        return reqs;
    }

    @Override
    protected PlayState handleAnimState(AnimationState<? extends WizardLabTile> state) {
        if (this.isActive()) {
            return state.setAndContinue(RawAnimation.begin().thenLoop("animation.thesis.quillwrite"));
        }
        return state.setAndContinue(RawAnimation.begin().thenLoop("animation.thesis.quillidle"));
    }

    @Override
    public int[] m_7071_(Direction side) {
        if (side == Direction.DOWN || side == Direction.UP) {
            return new int[]{3};
        }
        return new int[]{1, 0};
    }

    @Override
    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return !this.isActive();
    }

    @Override
    public boolean m_7155_(int index, ItemStack stack, Direction direction) {
        if (this.isActive()) {
            return false;
        }
        ItemStack existing = this.m_8020_(index);
        switch (index) {
            case 1: {
                return stack.m_41720_() == ItemInit.ARCANIST_INK.get() && existing.m_41619_();
            }
            case 0: {
                return stack.m_41720_() == ItemInit.VELLUM.get() && (existing.m_41619_() || existing.m_41613_() < existing.m_41741_());
            }
        }
        return false;
    }
}

