/*
 * Decompiled with CFR 0.152.
 */
package com.mna.capabilities.playerdata.magic.resources;

import com.mna.api.capabilities.resource.CastingResourceIDs;
import com.mna.api.capabilities.resource.SimpleCastingResource;
import com.mna.api.config.GeneralConfigValues;
import com.mna.api.entities.DamageHelper;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.biome.Biome;

public class Brimstone
extends SimpleCastingResource {
    public Brimstone() {
        super(GeneralConfigValues.TotalManaRegenTicks);
    }

    @Override
    public float getRegenerationModifier(LivingEntity caster) {
        float baseline = super.getRegenerationModifier(caster) / 2.0f;
        Holder biome = caster.m_9236_().m_204166_(caster.m_20183_());
        if (((Biome)biome.m_203334_()).m_198904_(caster.m_20183_())) {
            baseline *= 2.0f;
        } else if (biome.m_203656_(BiomeTags.f_263828_)) {
            baseline *= 0.5f;
        }
        return baseline;
    }

    @Override
    public ResourceLocation getRegistryName() {
        return CastingResourceIDs.BRIMSTONE;
    }

    @Override
    public void setMaxAmountByLevel(int level) {
        this.setMaxAmount(50 + 10 * level);
    }

    @Override
    public boolean hungerAffectsRegenRate() {
        return false;
    }

    @Override
    public void consume(LivingEntity caster, float amount) {
        if (this.getAmount() < amount) {
            ItemStack mainHand = caster.m_21205_();
            ItemStack offHand = caster.m_21206_();
            float brimstonePerHeart = GeneralConfigValues.BrimstonePerHeart;
            if (mainHand.getEnchantmentLevel(Enchantments.f_44990_) > 0 || offHand.getEnchantmentLevel(Enchantments.f_44990_) > 0) {
                brimstonePerHeart *= 2.0f;
            }
            int heartsRequired = (int)Math.ceil((amount - this.getAmount()) / brimstonePerHeart);
            caster.m_6469_(DamageHelper.forType(DamageHelper.CONFLAGRATE, caster.m_9236_().m_9598_()), (float)heartsRequired);
        }
        super.consume(caster, amount);
    }

    @Override
    public boolean hasEnough(LivingEntity caster, float amount) {
        float hearts_add;
        if (caster.m_9236_().m_46791_() == Difficulty.HARD) {
            return true;
        }
        float base = this.getAmount();
        return amount <= base + (hearts_add = (caster.m_21223_() - 1.0f) * (float)GeneralConfigValues.BrimstonePerHeart);
    }
}

