/*
 * Decompiled with CFR 0.152.
 */
package com.mna.capabilities.playerdata.progression;

import com.mna.Registries;
import com.mna.advancements.CustomAdvancementTriggers;
import com.mna.api.capabilities.CodexBreadcrumb;
import com.mna.api.capabilities.IPlayerMagic;
import com.mna.api.capabilities.IPlayerProgression;
import com.mna.api.capabilities.resource.CastingResourceIDs;
import com.mna.api.config.GeneralConfigValues;
import com.mna.api.entities.FactionRaidRegistry;
import com.mna.api.entities.IFactionEnemy;
import com.mna.api.faction.FactionDifficultyStats;
import com.mna.api.faction.IFaction;
import com.mna.api.spells.base.ISpellComponent;
import com.mna.capabilities.playerdata.magic.PlayerMagicProvider;
import com.mna.capabilities.playerdata.rote.PlayerRoteSpellsProvider;
import com.mna.progression.ProgressionEventHandler;
import com.mna.recipes.progression.ProgressionCondition;
import com.mna.tools.SummonUtils;
import com.mna.tools.math.MathUtils;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class PlayerProgression
implements IPlayerProgression {
    public static final int MAX_TIERS = 5;
    public static final double RAID_IRE = 1.0;
    private int tier = 1;
    private IFaction allied_faction = null;
    private int faction_standing;
    private List<ResourceLocation> metTierProgressions;
    private int ally_cooldown;
    private HashMap<IFaction, Double> raidChances = new HashMap();
    private ArrayList<IFaction> forcedRaids;
    private boolean dirty;
    private LinkedList<CodexBreadcrumb> _breadcrumbs;
    private HashMap<IFaction, FactionDifficultyStats> factionDifficultyStats = new HashMap();

    public PlayerProgression() {
        this.metTierProgressions = new ArrayList<ResourceLocation>();
        this._breadcrumbs = new LinkedList();
        this.forcedRaids = new ArrayList();
        this.setDirty();
    }

    @Override
    public int getTier() {
        return this.tier;
    }

    @Override
    public void setTier(int tier, @Nullable Player player, boolean notifyTierRote) {
        if (this.tier == tier) {
            return;
        }
        if (player != null) {
            AttributeModifier modifier;
            int modifierAmount;
            int index;
            int t;
            AttributeInstance inst = player.m_21051_(Attributes.f_22276_);
            for (t = 1; t <= 5; ++t) {
                index = t - 1;
                modifierAmount = GeneralConfigValues.TierHealthBoosts.size() >= index ? GeneralConfigValues.TierHealthBoosts.get(index) : 0;
                modifier = new AttributeModifier(UUID.fromString(Tier_Health_Boost_IDs[index]), "Tier Health Boost " + t, (double)modifierAmount, AttributeModifier.Operation.ADDITION);
                if (!inst.m_22109_(modifier)) continue;
                inst.m_22120_(modifier.m_22209_());
            }
            for (t = 1; t <= 5; ++t) {
                index = t - 1;
                modifierAmount = GeneralConfigValues.TierHealthBoosts.size() >= index ? GeneralConfigValues.TierHealthBoosts.get(index) : 0;
                modifier = new AttributeModifier(UUID.fromString(Tier_Health_Boost_IDs[index]), "Tier Health Boost " + t, (double)modifierAmount, AttributeModifier.Operation.ADDITION);
                if (modifierAmount <= 0 || tier < t || inst.m_22109_(modifier)) continue;
                inst.m_22125_(modifier);
            }
            if (player.m_21223_() > player.m_21233_()) {
                player.m_21153_(player.m_21233_());
            }
        }
        this.tier = MathUtils.clamp(tier, 1, 5);
        this.metTierProgressions.clear();
        if (player != null && player instanceof ServerPlayer) {
            CustomAdvancementTriggers.TIER_CHANGE.trigger((ServerPlayer)player, tier);
        }
        int belowTier = GeneralConfigValues.AutoRoteLowTier;
        int roteTier = this.tier - belowTier;
        if (player != null && roteTier > 0) {
            player.getCapability(PlayerRoteSpellsProvider.ROTE).ifPresent(r -> {
                Registries.Shape.get().getValues().forEach(s -> {
                    if (s.getTier(player.m_9236_()) <= roteTier) {
                        r.addRoteXP(null, (ISpellComponent)s, s.requiredXPForRote());
                    }
                });
                Registries.SpellEffect.get().getValues().forEach(s -> {
                    if (s.getTier(player.m_9236_()) <= roteTier) {
                        r.addRoteXP(null, (ISpellComponent)s, s.requiredXPForRote());
                    }
                });
                Registries.Modifier.get().getValues().forEach(s -> {
                    if (s.getTier(player.m_9236_()) <= roteTier) {
                        r.addRoteXP(null, (ISpellComponent)s, s.requiredXPForRote());
                    }
                });
                if (!player.m_9236_().m_5776_() && notifyTierRote) {
                    player.m_213846_((Component)Component.m_237110_((String)"mna:progresscondition.tier_rote", (Object[])new Object[]{roteTier}));
                }
            });
        }
        if (player != null) {
            ProgressionEventHandler.confirmExistingAdvancements(player);
        }
        this.setDirty();
    }

    @Override
    public IFaction getAlliedFaction() {
        return this.allied_faction;
    }

    @Override
    public boolean hasAlliedFaction() {
        return this.allied_faction != null;
    }

    @Override
    public void setAlliedFaction(IFaction faction, @Nullable Player player) {
        this.allied_faction = faction;
        if (player != null) {
            player.getCapability(PlayerMagicProvider.MAGIC).ifPresent(magic -> {
                if (faction != null) {
                    boolean curResourceIsForFaction = Arrays.asList(faction.getCastingResources()).contains(magic.getCastingResource().getRegistryName());
                    if (magic.getCastingResource() == null || !curResourceIsForFaction) {
                        magic.setCastingResourceType(faction.getCastingResource(player));
                    }
                } else {
                    magic.setCastingResourceType(CastingResourceIDs.MANA);
                }
            });
            if (player instanceof ServerPlayer) {
                CustomAdvancementTriggers.FACTION_JOIN.trigger((ServerPlayer)player, faction == null ? null : Registries.Factions.get().getKey((Object)faction));
            }
        }
        this.setDirty();
    }

    @Override
    public int getFactionStanding() {
        return this.faction_standing;
    }

    @Override
    public void setFactionStanding(int standing) {
        this.faction_standing = standing;
        this.setDirty();
    }

    @Override
    public void increaseFactionStanding(int amount) {
        this.faction_standing += amount;
        this.setDirty();
    }

    @Override
    public boolean needsSync() {
        return this.dirty;
    }

    @Override
    public void clearSyncFlag() {
        this.dirty = false;
    }

    @Override
    public void addTierProgressionComplete(ResourceLocation complededCondition) {
        if (!this.metTierProgressions.contains(complededCondition)) {
            this.metTierProgressions.add(complededCondition);
            this.setDirty();
        }
    }

    @Override
    public float getTierProgress(Level world) {
        int req = ProgressionCondition.getCompletionRequirementForTier(world, this.getTier());
        return MathUtils.clamp01((float)this.metTierProgressions.size() / (float)req);
    }

    @Override
    public List<ResourceLocation> getCompletedProgressionSteps() {
        return this.metTierProgressions;
    }

    @Override
    public void setTierProgression(List<ResourceLocation> complededCondition) {
        this.metTierProgressions.clear();
        this.metTierProgressions.addAll(complededCondition);
        this.setDirty();
    }

    @Override
    public void setDirty() {
        this.dirty = true;
    }

    @Override
    public double getRaidChance(IFaction faction) {
        if (this.forcedRaids.contains(faction)) {
            return 1.0;
        }
        return this.raidChances.getOrDefault(faction, 0.0);
    }

    @Override
    public void setRaidChance(IFaction faction, double chance) {
        this.raidChances.put(faction, chance);
    }

    @Override
    public int getRelativeRaidStrength(IFaction faction, Player player) {
        if (this.hasForceRaid()) {
            return GeneralConfigValues.ForcedRaidStrength;
        }
        int strength = 0;
        IPlayerMagic magic = (IPlayerMagic)player.getCapability(PlayerMagicProvider.MAGIC).orElse(null);
        if (magic != null) {
            strength = (int)((double)magic.getMagicLevel() * 1.5);
        }
        return strength *= this.tier;
    }

    @Override
    public boolean canBeRaided(Player player) {
        if (this.hasForceRaid()) {
            return true;
        }
        return !player.m_7500_() && this.getAlliedFaction() != null && Registries.Factions.get().getValues().stream().anyMatch(f -> this.canBeRaided((IFaction)f, player));
    }

    @Override
    public boolean canBeRaided(IFaction faction, Player player) {
        if (this.hasForceRaid()) {
            return true;
        }
        return this.raidChances.getOrDefault(faction, 0.0) >= 1.0;
    }

    @Override
    public boolean hasForceRaid() {
        return this.forcedRaids.size() > 0;
    }

    @Override
    public void raidImmediate(IFaction faction) {
        if (Registries.Factions.get().containsValue((Object)faction)) {
            this.forcedRaids.add(faction);
        }
    }

    @Override
    @Nullable
    public IFaction getForceRaid() {
        if (this.forcedRaids.size() > 0) {
            return this.forcedRaids.get(0);
        }
        return null;
    }

    @Override
    public void clearForceRaid() {
        if (this.forcedRaids.size() > 0) {
            this.forcedRaids.remove(0);
        }
    }

    @Override
    public void incrementFactionAggro(IFaction faction, float min, float max) {
        double chance = this.raidChances.getOrDefault(faction, 0.0) + ((double)min + Math.random() * (double)(max - min));
        this.raidChances.put(faction, chance);
    }

    @Override
    @Nullable
    public CodexBreadcrumb popCodexBreadcrumb() {
        return this._breadcrumbs.pollLast();
    }

    @Override
    @Nullable
    public CodexBreadcrumb peekCodexBreadcrumb() {
        return this._breadcrumbs.peekLast();
    }

    @Override
    public int breadcrumbLength() {
        return this._breadcrumbs.size();
    }

    @Override
    public void clearCodexEntryHistory() {
        this._breadcrumbs.clear();
    }

    @Override
    public void pushCodexBreadcrumb(CodexBreadcrumb.Type type, String key, int page, String ... metadata) {
        if (!this._breadcrumbs.stream().anyMatch(c -> c.Type == type && c.Key == key && c.Page == page)) {
            this._breadcrumbs.add(new CodexBreadcrumb(type, key, page, metadata));
        }
    }

    @Override
    public int getTierMaxComplexity() {
        if (this.getTier() == 5) {
            return GeneralConfigValues.Tier5ComplexityLimit;
        }
        return 20 * this.getTier();
    }

    @Override
    public FactionDifficultyStats getFactionDifficultyStats(IFaction faction) {
        if (!this.factionDifficultyStats.containsKey(faction)) {
            this.factionDifficultyStats.put(faction, new FactionDifficultyStats());
        }
        return this.factionDifficultyStats.get(faction);
    }

    @Override
    public void tickClassicRaids(Player player) {
        if (!GeneralConfigValues.ClassicRaids || this.getAlliedFaction() == null || this.getTier() < 3) {
            return;
        }
        if (player.m_9236_().m_46467_() % 12000L == 0L) {
            double base_increase = GeneralConfigValues.RaidChanceBase;
            double tier_increase = GeneralConfigValues.RaidChanceTier * (double)(this.getTier() - 3);
            List allFactions = Registries.Factions.get().getValues().stream().toList();
            IFaction anger = (IFaction)allFactions.get((int)Math.random() * allFactions.size());
            if (anger == null || anger == this.getAlliedFaction()) {
                return;
            }
            float aggro_amount = (float)(base_increase + tier_increase);
            this.incrementFactionAggro(anger, aggro_amount, aggro_amount);
        }
    }

    @Override
    public int getAllyCooldown() {
        return this.ally_cooldown;
    }

    @Override
    public void setAllyCooldown(int cooldown) {
        this.ally_cooldown = cooldown;
    }

    @Override
    public void summonRandomAlly(Player ally) {
        Pair<EntityType<? extends IFactionEnemy<? extends Mob>>, Integer> soldier = FactionRaidRegistry.getSoldier(this.getAlliedFaction(), 20 * this.getTier());
        if (soldier == null) {
            return;
        }
        IFactionEnemy entity = (IFactionEnemy)((EntityType)soldier.getFirst()).m_20615_(ally.m_9236_());
        SummonUtils.setSummon((Mob)entity, (LivingEntity)ally, 1200);
        entity.setTier((Integer)soldier.getSecond());
        ((LivingEntity)entity).m_6034_(ally.m_20185_(), ally.m_20186_(), ally.m_20189_());
        ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19606_, 40, 3));
        ally.m_9236_().m_7967_((Entity)entity);
        this.setAllyCooldown(6000);
    }
}

