/*
 * Decompiled with CFR 0.152.
 */
package com.mna.effects.harmful;

import com.mna.api.config.GeneralConfigValues;
import com.mna.effects.harmful.SimpleHarmfulEffect;
import com.mna.effects.interfaces.INoCreeperLingering;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class EffectDisjunction
extends SimpleHarmfulEffect
implements INoCreeperLingering {
    public static final String NBT_DISJUNCTION = "disjunction";
    public static final String NBT_ENCHANTMENTS = "Enchantments";

    public void m_6385_(LivingEntity pLivingEntity, AttributeMap pAttributeMap, int pAmplifier) {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            EffectDisjunction.ApplyDisjunction(pLivingEntity.m_6844_(slot), pAmplifier + 1);
        }
    }

    public void m_6386_(LivingEntity pLivingEntity, AttributeMap pAttributeMap, int pAmplifier) {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            EffectDisjunction.RemoveDisjunction(pLivingEntity.m_6844_(slot));
        }
    }

    public static void ApplyDisjunction(ItemStack stack, int maxLevels) {
        if (!stack.m_41782_() || maxLevels < 1 || stack.m_41783_().m_128441_(NBT_DISJUNCTION)) {
            return;
        }
        ListTag listtag = stack.m_41785_();
        if (listtag.size() == 0) {
            return;
        }
        stack.m_41783_().m_128365_(NBT_DISJUNCTION, (Tag)listtag);
        Map chants = EnchantmentHelper.m_44831_((ItemStack)stack);
        List<Enchantment> keys = Arrays.asList(chants.keySet().toArray(new Enchantment[0]));
        Collections.shuffle(keys);
        int total = chants.values().stream().mapToInt(Integer::intValue).sum();
        int suppression = (int)Math.min(Math.ceil((float)total / (float)chants.size()), (double)maxLevels);
        int totalSuppressed = 0;
        for (Enchantment e : keys) {
            if (GeneralConfigValues.DisjunctionBlacklist.contains(ForgeRegistries.ENCHANTMENTS.getKey((Object)e).toString())) continue;
            Integer existing = (Integer)chants.get(e);
            int loopSuppression = Math.min(suppression, maxLevels - totalSuppressed);
            if (existing > loopSuppression) {
                totalSuppressed += loopSuppression;
                chants.put(e, existing - loopSuppression);
            } else {
                totalSuppressed += existing.intValue();
                chants.remove(e);
            }
            if (totalSuppressed < maxLevels) continue;
            break;
        }
        EnchantmentHelper.m_44865_((Map)chants, (ItemStack)stack);
    }

    public static void RemoveDisjunction(ItemStack stack) {
        if (!stack.m_41782_() || !stack.m_41783_().m_128441_(NBT_DISJUNCTION)) {
            return;
        }
        ListTag backup = stack.m_41783_().m_128437_(NBT_DISJUNCTION, 10);
        stack.m_41783_().m_128365_(NBT_ENCHANTMENTS, (Tag)backup);
        stack.m_41783_().m_128473_(NBT_DISJUNCTION);
    }
}

