/*
 * Decompiled with CFR 0.152.
 */
package com.mna.enchantments.framework;

import com.mna.effects.EffectInit;
import com.mna.enchantments.Beheading;
import com.mna.enchantments.Bouncing;
import com.mna.enchantments.Cloudstep;
import com.mna.enchantments.ExperienceToSouls;
import com.mna.enchantments.Fireproof;
import com.mna.enchantments.Gilded;
import com.mna.enchantments.ManaRepair;
import com.mna.enchantments.Returning;
import com.mna.enchantments.Soulbound;
import com.mna.enchantments.TransitoryStep;
import com.mna.enchantments.auras.Aura;
import com.mna.enchantments.staves.Bludgeoning;
import com.mna.enchantments.staves.DurationModifier;
import com.mna.enchantments.staves.RangeModifier;
import com.mna.enchantments.staves.SpeedModifier;
import com.mna.network.ClientMessageDispatcher;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="mna", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EnchantmentInit {
    public static final DeferredRegister<Enchantment> ENCHANTMENTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENCHANTMENTS, (String)"mna");
    public static final RegistryObject<Aura> HEALING = ENCHANTMENTS.register("aura-healing", () -> new Aura(Enchantment.Rarity.VERY_RARE).withEffect(MobEffects.f_19605_).withManaCost(10.0f).withPredicate(p -> p.m_21223_() <= p.m_21233_() * 0.75f && p.m_21124_(MobEffects.f_19605_) == null));
    public static final RegistryObject<Aura> RUNNING = ENCHANTMENTS.register("aura-running", () -> new Aura(Enchantment.Rarity.COMMON).withEffect(MobEffects.f_19596_).withMagnitude(3).withManaCost(0.075f));
    public static final RegistryObject<Aura> PILGRIM = ENCHANTMENTS.register("aura-pilgrim", () -> new Aura(Enchantment.Rarity.VERY_RARE).withEffect(EffectInit.PILGRIM).withMagnitude(0).withManaCost(0.0f));
    public static final RegistryObject<Aura> JUMPING = ENCHANTMENTS.register("aura-jumping", () -> new Aura(Enchantment.Rarity.COMMON).withEffect(MobEffects.f_19603_).withMagnitude(5).withManaCost(0.075f));
    public static final RegistryObject<Aura> WATER_BREATHING = ENCHANTMENTS.register("aura-depths", () -> new Aura(Enchantment.Rarity.COMMON).withEffect(MobEffects.f_19592_).withManaCost(0.075f).withPredicate(p -> p.m_20072_()));
    public static final RegistryObject<Aura> MINING_BOOST = ENCHANTMENTS.register("aura-mining", () -> new Aura(Enchantment.Rarity.UNCOMMON).withEffect(MobEffects.f_19598_).withMagnitude(3).withManaCost(0.05f));
    public static final RegistryObject<Aura> BULWARK = ENCHANTMENTS.register("aura-bulwark", () -> new Aura(Enchantment.Rarity.UNCOMMON).withEffect(EffectInit.BULWARK).withMaxLevel(3).withManaCost(0.05f));
    public static final RegistryObject<Aura> REPAIR = ENCHANTMENTS.register("aura-repair", () -> new Aura(Enchantment.Rarity.VERY_RARE).withEffect(EffectInit.REPAIR).withManaCost(0.25f).withPredicate(p -> {
        for (int i = 0; i < p.m_150109_().m_6643_(); ++i) {
            ItemStack stack = p.m_150109_().m_8020_(i);
            if (stack.m_41619_() || !stack.isRepairable() || !stack.m_41768_()) continue;
            return true;
        }
        return false;
    }));
    public static final RegistryObject<Bouncing> BOUNCING = ENCHANTMENTS.register("bouncing", () -> new Bouncing(Enchantment.Rarity.COMMON));
    public static final RegistryObject<Cloudstep> LEAPING = ENCHANTMENTS.register("cloudstep", () -> new Cloudstep(Enchantment.Rarity.COMMON));
    public static final RegistryObject<Beheading> BEHEADING = ENCHANTMENTS.register("beheading", () -> new Beheading());
    public static final RegistryObject<TransitoryStep> TRANSITORY_STEP = ENCHANTMENTS.register("transitorystep", () -> new TransitoryStep(Enchantment.Rarity.RARE));
    public static final RegistryObject<Gilded> GILDED = ENCHANTMENTS.register("gilded", () -> new Gilded());
    public static final RegistryObject<Fireproof> FIREPROOF = ENCHANTMENTS.register("fireproof", () -> new Fireproof());
    public static final RegistryObject<ManaRepair> MANA_REPAIR = ENCHANTMENTS.register("mana-repair", () -> new ManaRepair());
    public static final RegistryObject<Returning> RETURNING = ENCHANTMENTS.register("returning", () -> new Returning());
    public static final RegistryObject<Bludgeoning> BLUDGEONING = ENCHANTMENTS.register("bludgeoning", () -> new Bludgeoning());
    public static final RegistryObject<DurationModifier> DURATION_MOD = ENCHANTMENTS.register("duration_modifier", () -> new DurationModifier());
    public static final RegistryObject<RangeModifier> RANGE_MOD = ENCHANTMENTS.register("range_modifier", () -> new RangeModifier());
    public static final RegistryObject<SpeedModifier> SPEED_MOD = ENCHANTMENTS.register("speed_modifier", () -> new SpeedModifier());
    public static final RegistryObject<ExperienceToSouls> XP_TO_SOULS = ENCHANTMENTS.register("xp_to_souls", () -> new ExperienceToSouls());
    public static final RegistryObject<Soulbound> SOULBOUND = ENCHANTMENTS.register("soulbound", () -> new Soulbound());

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        ItemStack boots;
        if (event.player.m_9236_().m_46467_() % 5L == 0L) {
            EnchantmentInit.tickAuras(event.player, event.player.m_9236_().m_5776_() || event.player.m_9236_().m_46467_() % 60L != 0L);
        }
        if ((boots = event.player.m_6844_(EquipmentSlot.FEET)).getEnchantmentLevel((Enchantment)TRANSITORY_STEP.get()) > 0) {
            ((TransitoryStep)((Object)TRANSITORY_STEP.get())).apply(event.player, 1);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlayerFall(LivingFallEvent event) {
        ItemStack boots;
        Player player;
        if (event.isCanceled()) {
            return;
        }
        if (event.getEntity() instanceof Player && event.getDistance() > 2.0f && !(player = (Player)event.getEntity()).m_6144_() && player.m_21124_((MobEffect)EffectInit.GRAVITY_WELL.get()) == null && !(boots = player.m_6844_(EquipmentSlot.FEET)).m_41619_() && boots.getEnchantmentLevel((Enchantment)BOUNCING.get()) > 0) {
            event.setCanceled(true);
            if (player.m_9236_().m_5776_()) {
                float maxVelocity = 4.0f;
                float bounceVelocity = (float)(player.m_20184_().f_82480_ * -0.5);
                Vec3 velocity = new Vec3(player.m_20184_().f_82479_, (double)Math.min(maxVelocity, bounceVelocity), player.m_20184_().f_82481_);
                player.m_20334_(velocity.f_82479_, velocity.f_82480_, velocity.f_82481_);
                ClientMessageDispatcher.sendPlayerBounce(velocity);
            }
        }
    }

    private static void tickAuras(Player player, boolean manaOnly) {
        for (ItemStack armorStack : player.m_6168_()) {
            if (armorStack.m_41619_()) continue;
            for (RegistryObject enchantment : ENCHANTMENTS.getEntries()) {
                int level;
                if (!(enchantment.get() instanceof Aura) || (level = armorStack.getEnchantmentLevel((Enchantment)enchantment.get())) <= 0) continue;
                ((Aura)((Object)enchantment.get())).apply(player, level, manaOnly);
            }
        }
    }
}

