/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities;

import com.mna.ManaAndArtifice;
import com.mna.entities.state.EntityStateMachine;
import com.mna.tools.math.MathUtils;
import java.util.ArrayList;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public abstract class LivingUtilityEntity
extends LivingEntity {
    protected static final EntityDataAccessor<String> CASTER_UUID = SynchedEntityData.m_135353_(LivingUtilityEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    protected static final EntityDataAccessor<Byte> STATE = SynchedEntityData.m_135353_(LivingUtilityEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected static final EntityDataAccessor<String> CURRENT_ANIMATION = SynchedEntityData.m_135353_(LivingUtilityEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    protected static final EntityDataAccessor<String> CURRENT_SEQUENCE = SynchedEntityData.m_135353_(LivingUtilityEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    protected int stateTicks = 0;
    protected float lastTickAnimationPct;
    protected int lastAnimationChangeTimer = 0;
    protected float animationPct;
    protected EntityStateMachine<LivingUtilityEntity> stateMachine = new EntityStateMachine<LivingUtilityEntity>(this, CURRENT_SEQUENCE);
    protected Player caster;

    protected LivingUtilityEntity(EntityType<? extends LivingEntity> type, Level worldIn) {
        super(type, worldIn);
        this.m_20242_(true);
        this.m_20225_(false);
        this.m_20331_(true);
        this.f_19794_ = true;
    }

    public void m_8119_() {
        super.m_8119_();
        ++this.stateTicks;
        ++this.lastAnimationChangeTimer;
        this.lastTickAnimationPct = this.animationPct;
        if (this.caster == null) {
            this.caster = this.getCaster();
        }
    }

    public static AttributeSupplier.Builder getGlobalAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 6.0);
    }

    public Iterable<ItemStack> m_6168_() {
        return new ArrayList<ItemStack>();
    }

    public ItemStack m_6844_(EquipmentSlot slotIn) {
        return ItemStack.f_41583_;
    }

    public void m_8061_(EquipmentSlot slotIn, ItemStack stack) {
    }

    public HumanoidArm m_5737_() {
        return HumanoidArm.RIGHT;
    }

    public boolean m_6087_() {
        return true;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_7301_(MobEffectInstance effectInstanceIn) {
        return false;
    }

    public boolean m_6097_() {
        return false;
    }

    public boolean m_5801_() {
        return false;
    }

    protected void m_6475_(DamageSource damageSrc, float damageAmount) {
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CASTER_UUID, (Object)"");
        this.f_19804_.m_135372_(STATE, (Object)0);
        this.f_19804_.m_135372_(CURRENT_ANIMATION, (Object)"neutral");
        this.f_19804_.m_135372_(CURRENT_SEQUENCE, (Object)"");
    }

    public void m_7380_(CompoundTag compound) {
        compound.m_128359_("caster", (String)this.f_19804_.m_135370_(CASTER_UUID));
        compound.m_128344_("state", this.getState());
    }

    public void m_7378_(CompoundTag compound) {
        if (compound.m_128441_("caster")) {
            this.f_19804_.m_135381_(CASTER_UUID, (Object)compound.m_128461_("caster"));
        }
        if (compound.m_128441_("state")) {
            this.f_19804_.m_135381_(STATE, (Object)compound.m_128445_("state"));
        }
    }

    @Nullable
    protected Player getCaster() {
        UUID caster = this.getCasterUUID();
        if (caster != null) {
            return this.m_9236_().m_46003_(caster);
        }
        return null;
    }

    public UUID getCasterUUID() {
        try {
            UUID uUID = UUID.fromString((String)this.f_19804_.m_135370_(CASTER_UUID));
            return uUID;
        }
        catch (Exception exception) {
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        return null;
    }

    public void setCasterUUID(UUID casterUUID) {
        if (casterUUID != null) {
            this.f_19804_.m_135381_(CASTER_UUID, (Object)casterUUID.toString());
        } else {
            ManaAndArtifice.LOGGER.error("Received null UUID for ritual caster.  Some effects may not apply!");
        }
    }

    protected void setState(byte state) {
        this.f_19804_.m_135381_(STATE, (Object)state);
        this.stateTicks = 0;
    }

    public byte getState() {
        return (Byte)this.f_19804_.m_135370_(STATE);
    }

    public float getAnimationPct(float partialTicks) {
        return MathUtils.lerpf(this.lastTickAnimationPct, this.animationPct, partialTicks);
    }

    public void setCurrentAnimation(String anim) {
        this.f_19804_.m_135381_(CURRENT_ANIMATION, (Object)anim);
        this.lastAnimationChangeTimer = 0;
        this.lastTickAnimationPct = 0.0f;
        this.animationPct = 0.0f;
    }

    public String getCurrentAnimation() {
        return (String)this.f_19804_.m_135370_(CURRENT_ANIMATION);
    }

    public int getLastAnimChangeTimer() {
        return this.lastAnimationChangeTimer;
    }

    protected void enableFlightFor(Player player) {
        if (player == null) {
            return;
        }
        player.m_20242_(true);
        ManaAndArtifice.instance.proxy.setFlightEnabled(player, true);
    }

    protected void disableFlightFor(Player player) {
        if (player == null) {
            return;
        }
        player.m_20242_(false);
        ManaAndArtifice.instance.proxy.setFlightEnabled(player, false);
    }
}

