/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.boss;

import com.google.common.collect.Maps;
import com.mna.advancements.CustomAdvancementTriggers;
import com.mna.api.spells.attributes.Attribute;
import com.mna.api.spells.targeting.SpellSource;
import com.mna.api.spells.targeting.SpellTarget;
import com.mna.api.tools.CollectionUtils;
import com.mna.effects.EffectInit;
import com.mna.entities.ai.ThreatTable;
import com.mna.spells.SpellCaster;
import com.mna.spells.crafting.ModifiedSpellPart;
import com.mna.spells.crafting.SpellRecipe;
import com.mna.tools.StructureUtils;
import com.mna.tools.SummonUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableObject;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.keyframe.event.CustomInstructionKeyframeEvent;
import software.bernie.geckolib.core.keyframe.event.SoundKeyframeEvent;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class BossMonster<T extends BossMonster<?>>
extends Monster
implements GeoEntity,
AnimationController.CustomKeyframeHandler<BossMonster<?>>,
AnimationController.SoundKeyframeHandler<BossMonster<?>> {
    protected AnimatableInstanceCache animCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Integer> DATA_ID_TARGET = SynchedEntityData.m_135353_(BossMonster.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_ID_INV = SynchedEntityData.m_135353_(BossMonster.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_STATE = SynchedEntityData.m_135353_(BossMonster.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_SHOW_BOSS_BAR = SynchedEntityData.m_135353_(BossMonster.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final Predicate<LivingEntity> LIVING_ENTITY_SELECTOR = entity -> entity.m_6084_() && entity.m_5789_();
    protected static final TargetingConditions TARGETING_CONDITIONS = TargetingConditions.m_148352_().m_26883_(20.0).m_26888_(LIVING_ENTITY_SELECTOR);
    private static final TargetingConditions HURT_BY_TARGETING = TargetingConditions.m_148352_().m_148355_().m_26893_();
    protected static final int ACTION_ATTACK = 1;
    private final Map<Integer, Integer> cooldowns = Maps.newHashMap();
    private final Map<String, Tuple<MutableInt, Runnable>> timers = Maps.newHashMap();
    private BoundingBox arenaBB;
    protected ThreatTable threat = new ThreatTable(e -> {
        if (e == this) {
            return false;
        }
        return !(e instanceof Player) || !((Player)e).m_7500_() && !((Player)e).m_5833_();
    });
    protected LivingEntity target;
    protected boolean killedByPlayer = false;

    protected BossMonster(EntityType<? extends Monster> p_i48553_1_, Level p_i48553_2_) {
        super(p_i48553_1_, p_i48553_2_);
    }

    public void m_8119_() {
        super.m_8119_();
        this.cooldowns.keySet().forEach(c -> {
            int cd = this.cooldowns.get(c);
            if (cd > 0) {
                this.cooldowns.put((Integer)c, cd - 1);
            }
        });
        ArrayList timersToRemove = new ArrayList();
        this.timers.forEach((k, v) -> {
            ((MutableInt)this.timers.get(k).m_14418_()).subtract(1);
            if (((MutableInt)this.timers.get(k).m_14418_()).getValue() <= 0) {
                timersToRemove.add(k);
            }
        });
        timersToRemove.forEach(id -> {
            ((Runnable)this.timers.get(id).m_14419_()).run();
            this.timers.remove(id);
        });
        if (this.arenaBB != null && !this.m_9236_().m_5776_() && this.m_9236_().m_46467_() % 100L == 0L) {
            if (!this.arenaBB.m_71051_((Vec3i)this.m_20183_())) {
                BlockPos newPos = this.arenaBB.m_162394_();
                this.m_146884_(new Vec3((double)newPos.m_123341_(), (double)newPos.m_123342_(), (double)newPos.m_123343_()));
            }
            this.threat.forEach((id, threat) -> {
                Entity e = this.m_9236_().m_6815_(id.intValue());
                if (e != null && e instanceof LivingEntity && e.m_6084_() && !this.arenaBB.m_71051_((Vec3i)e.m_20183_())) {
                    this.m_142687_(Entity.RemovalReason.DISCARDED);
                    return;
                }
            });
        }
        if (this.m_9236_().m_5776_()) {
            this.spawnParticles();
        } else if (this.m_9236_().m_46467_() % 300L == 0L) {
            this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82400_(32.0), e -> e.m_6084_() && e instanceof LivingEntity && !this.threat.isOn((LivingEntity)e) && this.m_21574_().m_148306_(e) && !SummonUtils.isTargetFriendly(e, (LivingEntity)this)).stream().map(e -> (LivingEntity)e).forEach(e -> this.threat.addThreat((LivingEntity)e, 1.0f, this.m_5448_()));
        }
    }

    public boolean m_6573_(Player player) {
        return false;
    }

    public boolean m_7301_(MobEffectInstance pPotioneffect) {
        return !Arrays.asList((MobEffect)EffectInit.REDUCE.get(), (MobEffect)EffectInit.ENLARGE.get(), (MobEffect)EffectInit.CHOOSING_WELLSPRING.get(), (MobEffect)EffectInit.LIFT.get(), (MobEffect)EffectInit.SILENCE.get(), (MobEffect)EffectInit.CIRCLE_OF_POWER.get(), (MobEffect)EffectInit.COLD_DARK.get(), (MobEffect)EffectInit.MIND_CONTROL.get(), (MobEffect)EffectInit.POSSESSION.get()).contains(pPotioneffect.m_19544_());
    }

    public boolean m_6072_() {
        return false;
    }

    public void m_6593_(@Nullable Component p_200203_1_) {
        super.m_6593_(p_200203_1_);
        this.getBossEvent().m_6456_(this.m_5446_());
    }

    protected void m_8024_() {
        super.m_8024_();
        if (this.doesRegenerate() && this.f_19797_ % this.getPassiveHealRate() == 0) {
            this.m_5634_(this.getPassiveHealAmount());
        }
        this.getBossEvent().m_142711_(this.m_21223_() / this.m_21233_());
    }

    public void m_7601_(BlockState p_213295_1_, Vec3 p_213295_2_) {
    }

    public void m_6457_(ServerPlayer p_184178_1_) {
        super.m_6457_(p_184178_1_);
        if (((Boolean)this.f_19804_.m_135370_(DATA_SHOW_BOSS_BAR)).booleanValue()) {
            this.getBossEvent().m_6543_(p_184178_1_);
        }
    }

    public void m_6452_(ServerPlayer p_184203_1_) {
        super.m_6452_(p_184203_1_);
        this.getBossEvent().m_6539_(p_184203_1_);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_INV, (Object)0);
        this.f_19804_.m_135372_(DATA_STATE, (Object)this.defaultState());
        this.f_19804_.m_135372_(DATA_SHOW_BOSS_BAR, (Object)true);
        this.f_19804_.m_135372_(DATA_ID_TARGET, (Object)-1);
    }

    public LivingEntity m_5448_() {
        Entity e;
        int targetID;
        if (this.target == null && (targetID = ((Integer)this.f_19804_.m_135370_(DATA_ID_TARGET)).intValue()) != -1 && (e = this.m_9236_().m_6815_(targetID)) instanceof LivingEntity) {
            this.target = (LivingEntity)e;
        }
        return this.target;
    }

    public void m_6710_(LivingEntity pLivingEntity) {
        if (pLivingEntity == null) {
            this.f_19804_.m_135381_(DATA_ID_TARGET, (Object)-1);
        } else {
            this.f_19804_.m_135381_(DATA_ID_TARGET, (Object)pLivingEntity.m_19879_());
        }
        this.target = pLivingEntity;
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("Invul", this.getInvulnerableTicks());
        nbt.m_128405_("state", ((Integer)this.f_19804_.m_135370_(DATA_STATE)).intValue());
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setInvulnerableTicks(nbt.m_128451_("Invul"));
        if (this.m_8077_()) {
            this.getBossEvent().m_6456_(this.m_5446_());
        }
        this.f_19804_.m_135381_(DATA_STATE, (Object)nbt.m_128451_("state"));
    }

    public boolean m_6469_(DamageSource type, float amount) {
        if (this.getInvulnerableTicks() > 0 && !type.m_276093_(DamageTypes.f_268724_)) {
            return false;
        }
        if (this.isDamageCheaty(type) || this.isSourceTooFar(type)) {
            this.teleportToTarget(type);
            return false;
        }
        boolean success = super.m_6469_(type, amount);
        if (success && type.m_7639_() != null && type.m_7639_() instanceof LivingEntity && type.m_7639_().m_19879_() != this.m_19879_()) {
            this.threat.addThreat((LivingEntity)type.m_7639_(), amount, this.m_5448_());
        }
        return success;
    }

    public void m_6667_(DamageSource pCause) {
        super.m_6667_(pCause);
        if (pCause.m_7639_() != null && pCause.m_7639_() instanceof LivingEntity) {
            boolean validKill = pCause.m_7639_() instanceof Player;
            if (SummonUtils.isSummon(pCause.m_7639_()) && SummonUtils.getSummoner((LivingEntity)pCause.m_7639_()) instanceof Player) {
                validKill = true;
            }
            if (validKill) {
                this.threat.players(this.m_9236_()).forEach(p -> {
                    if (p instanceof ServerPlayer) {
                        ResourceLocation typeName = ForgeRegistries.ENTITY_TYPES.getKey((Object)this.m_6095_());
                        ResourceLocation killStat = new ResourceLocation(typeName.toString() + "_kills");
                        p.m_36222_(killStat, 1);
                        int totalKills = ((ServerPlayer)p).m_8951_().m_13015_(Stats.f_12988_.m_12902_((Object)killStat));
                        CustomAdvancementTriggers.DEFEAT_BOSS.trigger((ServerPlayer)p, typeName, totalKills);
                    }
                });
                this.killedByPlayer = true;
            }
        }
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        if (this.m_9236_() instanceof ServerLevel && this.getArenaStructureID() != null) {
            this.arenaBB = StructureUtils.getStructureBoundingBoxAt((ServerLevel)this.m_9236_(), this.m_20183_(), this.getArenaStructureID(), this.getArenaStructureSegment());
        }
    }

    protected int defaultState() {
        return 0;
    }

    protected boolean isDamageCheaty(DamageSource type) {
        return type.m_276093_(DamageTypes.f_268613_) || type.m_276093_(DamageTypes.f_268546_) || type.m_276093_(DamageTypes.f_268612_) || type.m_276093_(DamageTypes.f_268526_);
    }

    protected boolean isSourceTooFar(DamageSource type) {
        Entity e = type.m_7639_();
        if (e == null) {
            return false;
        }
        return this.m_20182_().m_82557_(e.m_20182_()) > 1024.0;
    }

    protected abstract ServerBossEvent getBossEvent();

    protected void setCooldown(int id, int ticks) {
        this.cooldowns.put(id, ticks);
    }

    protected boolean isOnCooldown(int id) {
        return this.cooldowns.getOrDefault(id, 0) > 0;
    }

    protected float getPassiveHealAmount() {
        return 1.0f;
    }

    protected int getPassiveHealRate() {
        return 40;
    }

    protected boolean doesRegenerate() {
        if (this.getInvulnerableTicks() > 0) {
            return false;
        }
        return this.getPassiveHealRate() > 0 && this.getPassiveHealAmount() > 0.0f;
    }

    protected void setState(int ... flags) {
        int finalFlag = 0;
        for (int i : flags) {
            finalFlag |= i;
        }
        this.f_19804_.m_135381_(DATA_STATE, (Object)finalFlag);
    }

    protected void clearState(int ... flags) {
        int finalFlag = (Integer)this.f_19804_.m_135370_(DATA_STATE);
        for (int i : flags) {
            finalFlag &= ~i;
        }
        this.f_19804_.m_135381_(DATA_STATE, (Object)finalFlag);
    }

    protected void clearState() {
        this.f_19804_.m_135381_(DATA_STATE, (Object)0);
    }

    protected boolean flagSet(int flag) {
        int data = (Integer)this.f_19804_.m_135370_(DATA_STATE);
        return (data & flag) != 0;
    }

    protected int getStateFlag() {
        return (Integer)this.f_19804_.m_135370_(DATA_STATE);
    }

    protected void onFlagChanged(int newFlags) {
    }

    protected void showBossBar() {
        this.f_19804_.m_135381_(DATA_SHOW_BOSS_BAR, (Object)true);
        this.getBossEvent().m_8321_(true);
    }

    protected void hideBossBar() {
        this.f_19804_.m_135381_(DATA_SHOW_BOSS_BAR, (Object)false);
        this.getBossEvent().m_8321_(false);
    }

    protected boolean shouldShowBossBar() {
        return (Boolean)this.f_19804_.m_135370_(DATA_SHOW_BOSS_BAR);
    }

    public void m_7350_(EntityDataAccessor<?> param) {
        super.m_7350_(param);
        if (param == DATA_STATE) {
            this.onFlagChanged((Integer)this.f_19804_.m_135370_(DATA_STATE));
        } else if (param == DATA_ID_TARGET) {
            this.target = null;
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar registrar) {
        AnimationController controller = new AnimationController((GeoAnimatable)this, state -> this.handleAnimState(state));
        this.addControllerListeners(controller);
        registrar.add(new AnimationController[]{controller});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animCache;
    }

    protected void addControllerListeners(AnimationController<BossMonster<?>> controller) {
        controller.setSoundKeyframeHandler((AnimationController.SoundKeyframeHandler)this);
        controller.setCustomInstructionKeyframeHandler((AnimationController.CustomKeyframeHandler)this);
        controller.transitionLength(5);
    }

    public void handle(CustomInstructionKeyframeEvent<BossMonster<?>> event) {
    }

    public void handle(SoundKeyframeEvent<BossMonster<?>> event) {
    }

    protected abstract PlayState handleAnimState(AnimationState<? extends BossMonster<?>> var1);

    protected void teleportToTarget(DamageSource type) {
        Entity e = type.m_7639_();
        if (e != null) {
            if (e instanceof LivingEntity) {
                this.threat.initializeThreat((LivingEntity)e);
            }
            this.m_6021_(e.m_20185_(), e.m_20186_(), e.m_20189_());
        }
    }

    @Nullable
    protected Player getRandomNearbyPlayer(Predicate<Player> predicate) {
        List nearbyPlayers = this.m_9236_().m_45955_(TARGETING_CONDITIONS, (LivingEntity)this, this.m_20191_().m_82400_(20.0));
        MutableObject selection = new MutableObject(null);
        if (predicate != null) {
            CollectionUtils.getRandom(nearbyPlayers.stream().filter(p -> predicate.test((Player)p)).collect(Collectors.toList())).ifPresent(p -> selection.setValue(p));
        }
        if (selection.getValue() == null) {
            CollectionUtils.getRandom(nearbyPlayers).ifPresent(p -> selection.setValue(p));
        }
        return (Player)selection.getValue();
    }

    public int getInvulnerableTicks() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_INV);
    }

    public void setInvulnerableTicks(int ticks) {
        this.f_19804_.m_135381_(DATA_ID_INV, (Object)ticks);
    }

    public abstract void setupSpawn();

    @Nullable
    protected LivingEntity getRandomThreatTableTarget(double distance) {
        return this.getRandomThreatTableTarget(distance, null);
    }

    @Nullable
    protected LivingEntity getRandomThreatTableTarget(double distance, @Nullable Predicate<LivingEntity> selectionPredicate) {
        int entityID = this.threat.getRandomThreatEntry(this.m_9236_(), (LivingEntity)this, distance, selectionPredicate);
        if (entityID == -1) {
            return this.m_5448_();
        }
        Entity e = this.m_9236_().m_6815_(entityID);
        if (e == null || !(e instanceof LivingEntity) || !this.m_21574_().m_148306_(e)) {
            return this.m_5448_();
        }
        return (LivingEntity)e;
    }

    protected void spawnParticles() {
    }

    protected void setTimer(String id, int delay, Runnable callback) {
        this.setTimer(id, delay, callback, true);
    }

    protected void setTimer(String id, int delay, Runnable callback, boolean runIfExists) {
        if (runIfExists && this.timers.containsKey(id)) {
            ((Runnable)this.timers.get(id).m_14419_()).run();
        }
        this.timers.put(id, (Tuple<MutableInt, Runnable>)new Tuple((Object)new MutableInt(delay), (Object)callback));
    }

    @Nullable
    public abstract ResourceLocation getArenaStructureID();

    public abstract int getArenaStructureSegment();

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_6043_() {
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean isPushedByFluid(FluidType type) {
        return false;
    }

    public class AdjustableSpeedMeleeAttackGoal
    extends Goal {
        protected int attackRate;
        protected float reachMultiplier = 1.0f;
        protected final PathfinderMob mob;
        private final double speedModifier;
        private final boolean followingTargetEvenIfNotSeen;
        private Path path;
        private double pathedTargetX;
        private double pathedTargetY;
        private double pathedTargetZ;
        private int ticksUntilNextPathRecalculation;
        private int ticksUntilNextAttack;
        private long lastCanUseCheck;
        private int failedPathFindingPenalty = 0;
        private boolean canPenalize = true;

        public AdjustableSpeedMeleeAttackGoal(PathfinderMob pMob, double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen, int attackRate) {
            this.mob = pMob;
            this.attackRate = attackRate;
            this.speedModifier = pSpeedModifier;
            this.followingTargetEvenIfNotSeen = pFollowingTargetEvenIfNotSeen;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public AdjustableSpeedMeleeAttackGoal setReachMultiplier(float multiplier) {
            this.reachMultiplier = multiplier;
            return this;
        }

        public boolean m_8036_() {
            long i = this.mob.m_9236_().m_46467_();
            if (i - this.lastCanUseCheck < 20L) {
                return false;
            }
            this.lastCanUseCheck = i;
            LivingEntity livingentity = this.mob.m_5448_();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.m_6084_()) {
                return false;
            }
            if (this.canPenalize) {
                if (--this.ticksUntilNextPathRecalculation <= 0) {
                    this.path = this.mob.m_21573_().m_6570_((Entity)livingentity, 0);
                    this.ticksUntilNextPathRecalculation = 4 + this.mob.m_217043_().m_188503_(7);
                    return this.path != null;
                }
                return true;
            }
            this.path = this.mob.m_21573_().m_6570_((Entity)livingentity, 0);
            if (this.path != null) {
                return true;
            }
            return this.getAttackReachSqr(livingentity) >= this.mob.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
        }

        public boolean m_8045_() {
            LivingEntity livingentity = this.mob.m_5448_();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.m_6084_()) {
                return false;
            }
            if (!this.followingTargetEvenIfNotSeen) {
                return !this.mob.m_21573_().m_26571_();
            }
            if (!this.mob.m_21444_(livingentity.m_20183_())) {
                return false;
            }
            return !(livingentity instanceof Player) || !livingentity.m_5833_() && !((Player)livingentity).m_7500_();
        }

        public void m_8056_() {
            this.mob.m_21573_().m_26536_(this.path, this.speedModifier);
            this.mob.m_21561_(true);
            this.ticksUntilNextPathRecalculation = 0;
            this.ticksUntilNextAttack = 0;
        }

        public void m_8041_() {
            LivingEntity livingentity = this.mob.m_5448_();
            if (!EntitySelector.f_20406_.test(livingentity)) {
                this.mob.m_6710_((LivingEntity)null);
            }
            this.mob.m_21561_(false);
            this.mob.m_21573_().m_26573_();
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            LivingEntity livingentity = this.mob.m_5448_();
            if (livingentity != null) {
                this.mob.m_21563_().m_24960_((Entity)livingentity, 30.0f, 30.0f);
                double d0 = this.mob.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
                this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
                if ((this.followingTargetEvenIfNotSeen || this.mob.m_21574_().m_148306_((Entity)livingentity)) && this.ticksUntilNextPathRecalculation <= 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || livingentity.m_20275_(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.mob.m_217043_().m_188501_() < 0.05f)) {
                    this.pathedTargetX = livingentity.m_20185_();
                    this.pathedTargetY = livingentity.m_20186_();
                    this.pathedTargetZ = livingentity.m_20189_();
                    this.ticksUntilNextPathRecalculation = 4 + this.mob.m_217043_().m_188503_(7);
                    if (this.canPenalize) {
                        Node finalPathPoint;
                        this.ticksUntilNextPathRecalculation += this.failedPathFindingPenalty;
                        this.failedPathFindingPenalty = this.mob.m_21573_().m_26570_() != null ? ((finalPathPoint = this.mob.m_21573_().m_26570_().m_77395_()) != null && livingentity.m_20275_((double)finalPathPoint.f_77271_, (double)finalPathPoint.f_77272_, (double)finalPathPoint.f_77273_) < 1.0 ? 0 : (this.failedPathFindingPenalty += 10)) : (this.failedPathFindingPenalty += 10);
                    }
                    if (d0 > 1024.0) {
                        this.ticksUntilNextPathRecalculation += 10;
                    } else if (d0 > 256.0) {
                        this.ticksUntilNextPathRecalculation += 5;
                    }
                    if (!this.mob.m_21573_().m_5624_((Entity)livingentity, this.speedModifier)) {
                        this.ticksUntilNextPathRecalculation += 15;
                    }
                    this.ticksUntilNextPathRecalculation = this.m_183277_(this.ticksUntilNextPathRecalculation);
                }
                this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
                this.checkAndPerformAttack(livingentity, d0);
            }
        }

        protected void checkAndPerformAttack(LivingEntity pEnemy, double pDistToEnemySqr) {
            double d0 = this.getAttackReachSqr(pEnemy);
            if (pDistToEnemySqr <= d0 && this.ticksUntilNextAttack <= 0) {
                this.resetAttackCooldown();
                this.mob.m_6674_(InteractionHand.MAIN_HAND);
                this.mob.m_7327_((Entity)pEnemy);
            }
        }

        protected void resetAttackCooldown() {
            this.ticksUntilNextAttack = this.m_183277_(this.attackRate);
        }

        protected boolean isTimeToAttack() {
            return this.ticksUntilNextAttack <= 0;
        }

        protected int getTicksUntilNextAttack() {
            return this.ticksUntilNextAttack;
        }

        protected int getAttackInterval() {
            return this.m_183277_(this.attackRate);
        }

        protected double getAttackReachSqr(LivingEntity pAttackTarget) {
            return (this.mob.m_20205_() * 2.0f * this.mob.m_20205_() * 2.0f + pAttackTarget.m_20205_()) * this.reachMultiplier;
        }
    }

    public class CastSpellAtTargetGoal
    extends Goal {
        private final double moveSpeedAmp;
        private final float maxAttackDistance;
        private final float minAttackDistance;
        private final int attackCooldown;
        private int seeTime;
        private boolean strafingClockwise;
        private boolean strafingBackwards;
        private int strafingTime = -1;
        private ItemStack spell;
        private final int actionId;
        private Predicate<BossMonster<?>> additionalUsePredicate;
        private Predicate<LivingEntity> targetPredicate;
        private boolean interruptable = true;
        private int maximumChannelTime = -1;
        private final boolean randomThreatTarget;
        private LivingEntity target;
        private boolean isWaitingOnAnim = false;
        private final int effectDelayTicks;
        private final int resetTicks;
        private final Runnable startCallback;
        private final Runnable resetCallback;
        private final Predicate<BossMonster<?>> precastCallback;

        public CastSpellAtTargetGoal(ItemStack spell, double moveSpeedAmpIn, int attackCooldownIn, float maxAttackDistanceIn, float minAttackDistanceIn, boolean randomTargetFromThreatTable, int cooldownId, int delayTicks, int resetTicks, Runnable startCallback, Runnable resetCallback, Predicate<BossMonster<?>> precastCallback) {
            this.moveSpeedAmp = moveSpeedAmpIn;
            this.maxAttackDistance = maxAttackDistanceIn * maxAttackDistanceIn;
            this.minAttackDistance = minAttackDistanceIn * minAttackDistanceIn;
            this.spell = spell;
            this.actionId = cooldownId;
            this.attackCooldown = attackCooldownIn;
            this.effectDelayTicks = delayTicks;
            this.resetTicks = resetTicks;
            this.resetCallback = resetCallback;
            this.startCallback = startCallback;
            this.precastCallback = precastCallback;
            this.randomThreatTarget = randomTargetFromThreatTable;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public CastSpellAtTargetGoal setUsePredicate(Predicate<BossMonster<?>> predicate) {
            this.additionalUsePredicate = predicate;
            return this;
        }

        public CastSpellAtTargetGoal setTargetPredicate(Predicate<LivingEntity> targetPredicate) {
            this.targetPredicate = targetPredicate;
            return this;
        }

        public CastSpellAtTargetGoal setUninterruptable() {
            this.interruptable = false;
            return this;
        }

        public CastSpellAtTargetGoal setChannelTime(int ticks) {
            this.maximumChannelTime = ticks;
            return this;
        }

        public boolean m_6767_() {
            return this.interruptable;
        }

        public boolean m_8036_() {
            boolean hasTarget = BossMonster.this.m_5448_() != null;
            boolean notOnCooldown = !BossMonster.this.isOnCooldown(this.actionId) && !BossMonster.this.isOnCooldown(1);
            boolean closeEnough = hasTarget && BossMonster.this.m_5448_().m_20280_((Entity)BossMonster.this) >= (double)this.minAttackDistance;
            return notOnCooldown && closeEnough && (this.additionalUsePredicate == null || this.additionalUsePredicate.test(BossMonster.this));
        }

        public boolean m_8045_() {
            if (this.target == null || this.target.m_21224_() || this.target.m_20182_().m_82557_(BossMonster.this.m_20182_()) > BossMonster.this.m_21133_(Attributes.f_22277_)) {
                return false;
            }
            if (BossMonster.this.m_6117_()) {
                return BossMonster.this.m_21212_() > 0;
            }
            if (this.isWaitingOnAnim) {
                return true;
            }
            if (!BossMonster.this.isOnCooldown(this.actionId)) {
                return false;
            }
            return this.m_8036_() || !BossMonster.this.m_21573_().m_26571_();
        }

        public void m_8056_() {
            super.m_8056_();
            this.target = null;
            if (this.randomThreatTarget) {
                for (int i = 0; i < 5; ++i) {
                    this.target = BossMonster.this.getRandomThreatTableTarget(BossMonster.this.m_21133_(Attributes.f_22277_), this.targetPredicate);
                }
            }
            if (this.target == null) {
                this.target = BossMonster.this.m_5448_();
            }
            if (this.startCallback != null) {
                this.startCallback.run();
            }
        }

        public void m_8041_() {
            super.m_8041_();
            this.target = null;
            BossMonster.this.setCooldown(this.actionId, this.attackCooldown);
            this.seeTime = 0;
            this.isWaitingOnAnim = false;
            BossMonster.this.m_5810_();
        }

        public void m_8037_() {
            if (this.target == null) {
                this.m_8041_();
                return;
            }
            if (this.isWaitingOnAnim || this.maximumChannelTime > -1 && BossMonster.this.m_6117_()) {
                BossMonster.this.f_21344_.m_26573_();
                if (this.target != null) {
                    BossMonster.this.m_7618_(EntityAnchorArgument.Anchor.FEET, this.target.m_20182_());
                }
                return;
            }
            LivingEntity livingentity = BossMonster.this.m_5448_();
            if (livingentity != null) {
                boolean positiveSeeTime;
                double d0 = BossMonster.this.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
                boolean canSee = BossMonster.this.m_21574_().m_148306_((Entity)livingentity);
                boolean bl = positiveSeeTime = this.seeTime > 0;
                if (canSee != positiveSeeTime) {
                    this.seeTime = 0;
                }
                this.seeTime = canSee ? ++this.seeTime : --this.seeTime;
                if (!(d0 > (double)this.maxAttackDistance) && this.seeTime >= 20) {
                    BossMonster.this.m_21573_().m_26573_();
                    ++this.strafingTime;
                } else {
                    BossMonster.this.m_21573_().m_5624_((Entity)livingentity, this.moveSpeedAmp);
                    this.strafingTime = -1;
                }
                if (this.strafingTime >= 20) {
                    if ((double)BossMonster.this.m_217043_().m_188501_() < 0.3) {
                        boolean bl2 = this.strafingClockwise = !this.strafingClockwise;
                    }
                    if ((double)BossMonster.this.m_217043_().m_188501_() < 0.3) {
                        this.strafingBackwards = !this.strafingBackwards;
                    }
                    this.strafingTime = 0;
                }
                if (this.strafingTime > -1) {
                    if (d0 > (double)(this.maxAttackDistance * 0.75f)) {
                        this.strafingBackwards = false;
                    } else if (d0 < (double)(this.maxAttackDistance * 0.25f)) {
                        this.strafingBackwards = true;
                    }
                    BossMonster.this.m_21566_().m_24988_(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
                    BossMonster.this.m_21391_((Entity)livingentity, 30.0f, 30.0f);
                } else {
                    BossMonster.this.m_21563_().m_24960_((Entity)livingentity, 30.0f, 30.0f);
                }
                if (!canSee && this.seeTime < -60) {
                    this.m_8041_();
                } else if (canSee) {
                    LivingEntity cachedTarget = this.target;
                    boolean runDelay = true;
                    if (this.precastCallback != null) {
                        runDelay = this.precastCallback.test(BossMonster.this);
                    }
                    BossMonster.this.f_21344_.m_26573_();
                    if (runDelay) {
                        BossMonster.this.setTimer("cast", this.effectDelayTicks, () -> {
                            SpellRecipe recipe = SpellRecipe.fromNBT(this.spell.m_41783_());
                            if (!recipe.isValid() || cachedTarget == null) {
                                return;
                            }
                            Vec3 origin = BossMonster.this.m_20182_().m_82520_(0.0, (double)BossMonster.this.m_20192_(), 0.0);
                            Vec3 targetPos = cachedTarget.m_20182_().m_82520_(0.0, (double)cachedTarget.m_20192_(), 0.0);
                            Vec3 targetVelocity = cachedTarget.m_20182_().m_82492_(cachedTarget.f_19790_, cachedTarget.f_19791_, cachedTarget.f_19792_);
                            targetVelocity = targetVelocity.m_82492_(0.0, cachedTarget.m_21051_((net.minecraft.world.entity.ai.attributes.Attribute)ForgeMod.ENTITY_GRAVITY.get()).m_22135_(), 0.0);
                            if (cachedTarget.m_20096_()) {
                                targetVelocity = targetVelocity.m_82520_(0.0, -targetVelocity.f_82480_, 0.0);
                            }
                            double distance = origin.m_82554_(targetPos);
                            double speed = ((ModifiedSpellPart)recipe.getShape()).getValue(Attribute.SPEED);
                            int ticksToArrive = (int)Math.round(distance / speed);
                            if (recipe.isChanneled()) {
                                BossMonster.this.m_21008_(InteractionHand.MAIN_HAND, this.spell.m_41777_());
                                BossMonster.this.m_6672_(InteractionHand.MAIN_HAND);
                            }
                            Vec3 adjustedTargetPos = targetPos.m_82549_(targetVelocity.m_82490_((double)ticksToArrive));
                            Vec3 delta = adjustedTargetPos.m_82546_(origin).m_82541_();
                            SpellTarget targetHint = new SpellTarget((Entity)cachedTarget);
                            SpellCaster.Affect(this.spell, SpellRecipe.fromNBT(this.spell.m_41783_()), BossMonster.this.m_9236_(), new SpellSource((LivingEntity)BossMonster.this, InteractionHand.MAIN_HAND, origin, delta), targetHint);
                        });
                    }
                    BossMonster.this.setTimer("reset", this.resetTicks, () -> {
                        this.isWaitingOnAnim = false;
                        if (this.resetCallback != null) {
                            this.resetCallback.run();
                        }
                    });
                    this.isWaitingOnAnim = true;
                }
            }
        }
    }

    public class ThreatTableHurtByTargetGoal
    extends TargetGoal {
        private boolean alertSameType;
        private int timestamp;
        private final Class<?>[] toIgnoreDamage;
        private Class<?>[] toIgnoreAlert;

        public ThreatTableHurtByTargetGoal(PathfinderMob owner, Class<?> ... ignoreDamageFrom) {
            super((Mob)owner, true);
            this.toIgnoreDamage = ignoreDamageFrom;
            this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
        }

        public boolean m_8036_() {
            int i = this.f_26135_.m_21213_();
            LivingEntity livingentity = this.f_26135_.m_21188_();
            if (i != this.timestamp && livingentity != null) {
                if (livingentity.m_6095_() == EntityType.f_20532_ && this.f_26135_.m_9236_().m_46469_().m_46207_(GameRules.f_46127_)) {
                    return false;
                }
                for (Class<?> oclass : this.toIgnoreDamage) {
                    if (!oclass.isAssignableFrom(livingentity.getClass())) continue;
                    return false;
                }
                if (this.m_26150_(livingentity, HURT_BY_TARGETING)) {
                    return BossMonster.this.threat.shouldSwitchTarget(BossMonster.this.m_5448_(), livingentity);
                }
            }
            return false;
        }

        public ThreatTableHurtByTargetGoal setAlertOthers(Class<?> ... p_220794_1_) {
            this.alertSameType = true;
            this.toIgnoreAlert = p_220794_1_;
            return this;
        }

        public void m_8056_() {
            this.f_26135_.m_6710_(this.f_26135_.m_21188_());
            this.f_26137_ = this.f_26135_.m_5448_();
            this.timestamp = this.f_26135_.m_21213_();
            this.f_26138_ = 300;
            if (this.alertSameType) {
                this.alertOthers();
            }
            super.m_8056_();
        }

        protected void alertOthers() {
            double d0 = this.m_7623_();
            AABB axisalignedbb = AABB.m_82333_((Vec3)this.f_26135_.m_20182_()).m_82377_(d0, 10.0, d0);
            List list = this.f_26135_.m_9236_().m_45976_(this.f_26135_.getClass(), axisalignedbb);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Mob mobentity = (Mob)iterator.next();
                if (this.f_26135_ == mobentity || mobentity.m_5448_() != null || this.f_26135_ instanceof TamableAnimal && ((TamableAnimal)this.f_26135_).m_269323_() != ((TamableAnimal)mobentity).m_269323_() || mobentity.m_7307_((Entity)this.f_26135_.m_21188_())) continue;
                if (this.toIgnoreAlert != null) {
                    boolean flag = false;
                    for (Class<?> oclass : this.toIgnoreAlert) {
                        if (mobentity.getClass() != oclass) continue;
                        flag = true;
                        break;
                    }
                    if (flag) continue;
                }
                this.alertOther(mobentity, this.f_26135_.m_21188_());
            }
            return;
        }

        protected void alertOther(Mob other, LivingEntity target) {
            other.m_6710_(target);
        }
    }

    class DoNothingGoal
    extends Goal {
        private final int actionId;

        public DoNothingGoal() {
            this(-1);
        }

        public DoNothingGoal(int actionId) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
            this.actionId = actionId;
        }

        public boolean m_8036_() {
            return this.actionId == -1 ? BossMonster.this.getInvulnerableTicks() > 0 : BossMonster.this.flagSet(this.actionId);
        }
    }
}

