/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.boss;

import com.mna.api.capabilities.IPlayerProgression;
import com.mna.api.entities.IFactionEnemy;
import com.mna.api.entities.ai.CastSpellOnSelfGoal;
import com.mna.api.faction.IFaction;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.api.sound.SFX;
import com.mna.api.spells.attributes.Attribute;
import com.mna.api.spells.collections.Components;
import com.mna.api.spells.collections.Shapes;
import com.mna.api.tools.RLoc;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.mna.effects.EffectInit;
import com.mna.entities.EntityInit;
import com.mna.entities.ai.ThreatTable;
import com.mna.entities.boss.BossMonster;
import com.mna.entities.boss.attacks.IllusionCreeper;
import com.mna.factions.Factions;
import com.mna.items.ItemInit;
import com.mna.particles.types.movers.ParticleOrbitMover;
import com.mna.spells.crafting.SpellRecipe;
import com.mna.tools.EntityUtil;
import com.mna.tools.ParticleConfigurations;
import com.mna.tools.SummonUtils;
import com.mna.tools.math.MathUtils;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class FaerieQueen
extends BossMonster<FaerieQueen>
implements IFactionEnemy<FaerieQueen> {
    public final Predicate<Entity> AURA_SELECTOR = e -> !(!e.m_6084_() || !(e instanceof LivingEntity) || e instanceof FaerieQueen || e instanceof IFactionEnemy && ((IFactionEnemy)e).getFaction() == Factions.FEY || SummonUtils.isSummon(e) && SummonUtils.isTargetFriendly(e, (LivingEntity)this) || e instanceof Player && (((Player)e).m_7500_() || ((Player)e).m_5833_()));
    private final ServerBossEvent bossEventSummer = (ServerBossEvent)new ServerBossEvent((Component)Component.m_237115_((String)"entity.mna.faerie_queen.summer"), BossEvent.BossBarColor.PINK, BossEvent.BossBarOverlay.NOTCHED_20).m_7003_(true);
    private final ServerBossEvent bossEventWinter = (ServerBossEvent)new ServerBossEvent((Component)Component.m_237115_((String)"entity.mna.faerie_queen.winter"), BossEvent.BossBarColor.BLUE, BossEvent.BossBarOverlay.NOTCHED_20).m_7003_(true);
    protected static final EntityDataAccessor<Byte> SEASON = SynchedEntityData.m_135353_(FaerieQueen.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected static final EntityDataAccessor<String> SUMMONER_UUID = SynchedEntityData.m_135353_(FaerieQueen.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    protected static final EntityDataAccessor<Boolean> IS_JOINING = SynchedEntityData.m_135353_(FaerieQueen.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private Player summonedBy;
    public int faerieDeathTime;
    private int globalSpellCooldown = 0;
    private static final int COOLDOWN_FLING_ID = 1025;
    private static final int COOLDOWN_HEAL_ID = 1026;
    private static final int COOLDOWN_DISJUNCTION_ID = 1027;
    private static final int COOLDOWN_MINDCONTROL_ID = 1028;
    private static final int COOLDOWN_ILLUSIONCREEPER_ID = 1029;
    private static final int COOLDOWN_WINTERICE_ID = 1030;
    private static final int COOLDOWN_CHILL_ID = 1031;
    private static final int COOLDOWN_ICESPIKE_ID = 1032;
    private static final int COOLDOWN_FRAILTY_ID = 1033;
    private static final int COOLDOWN_SUMMERFIRE_ID = 1034;
    private static final int COOLDOWN_HEATWAVE_ID = 1035;
    private static final int COOLDOWN_SUNDER_ID = 1036;
    private static final float LIFT_SPEED = 0.055f;

    public FaerieQueen(EntityType<? extends Monster> type, Level world) {
        super(type, world);
        this.setSeason(Math.random() < 0.5);
        this.m_20242_(true);
        this.f_21342_ = new MoveHelperController(this);
        this.setCooldown(1029, (int)(100.0 + Math.random() * 300.0));
        SummonUtils.setBonusSummons((LivingEntity)this, 99);
        this.threat = new ThreatTable(e -> {
            if (e == this) {
                return false;
            }
            if (e instanceof Player && (((Player)e).m_7500_() || ((Player)e).m_5833_())) {
                return false;
            }
            return !(e instanceof FaerieQueen);
        });
    }

    public FaerieQueen(Level world, Vec3 pos, boolean winter) {
        this((EntityType<? extends Monster>)((EntityType)EntityInit.FAERIE_QUEEN.get()), world);
        this.setSeason(winter);
        this.m_146884_(pos);
    }

    @Override
    public void m_8119_() {
        if (this.globalSpellCooldown > 0) {
            --this.globalSpellCooldown;
        }
        if (this.m_5448_() instanceof FaerieQueen) {
            this.threat.remove(this.m_5448_());
            this.m_6710_(null);
        }
        if (this.m_21023_((MobEffect)EffectInit.GRAVITY_WELL.get())) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.2, 0.0));
        }
        this.m_20242_(true);
        super.m_8119_();
        if (this.m_5448_() instanceof FaerieQueen) {
            this.m_6710_(null);
        }
        if (!this.isNaturalSpawn()) {
            if (this.getSummonedBy() == null) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
                return;
            }
            boolean remove = false;
            this.m_7618_(EntityAnchorArgument.Anchor.FEET, this.getSummonedBy().m_146892_());
            if (this.getSummonedBy().m_21224_() || this.getSummonedBy().m_20280_((Entity)this) > 256.0) {
                remove = true;
            } else {
                boolean bl = remove = this.f_19797_ > 700;
            }
            if (remove && !this.m_9236_().m_5776_()) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        } else {
            this.tickAuras();
        }
    }

    private void tickAuras() {
        if (this.m_9236_().m_5776_() || this.m_9236_().m_46467_() % 60L != 0L) {
            return;
        }
        this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82400_(16.0), this.AURA_SELECTOR).stream().map(e -> (LivingEntity)e).forEach(e -> {
            if (this.isWinter()) {
                if (!e.m_21023_((MobEffect)EffectInit.SOAKED.get())) {
                    e.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 100, 2));
                } else {
                    e.m_146917_(e.m_146888_() + 20);
                }
                e.m_7292_(new MobEffectInstance((MobEffect)EffectInit.SNOWBLIND.get(), 100, 2));
            } else if (!e.m_20070_() && !e.m_21023_((MobEffect)EffectInit.SOAKED.get())) {
                e.m_20254_(5);
            }
        });
    }

    private void lockTargetInPlace(LivingEntity target, boolean raise) {
        int duration = 200;
        target.m_21195_((MobEffect)EffectInit.LIFT.get());
        target.m_7292_(new MobEffectInstance((MobEffect)EffectInit.LIFT.get(), duration, raise ? 1 : 0));
        if (raise && target instanceof Player) {
            EntityUtil.SetLiftSpeed((Player)target, 0.055f);
        }
    }

    protected void m_8099_() {
        double moveSpeed = this.m_21133_(Attributes.f_22279_);
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new FaerieQueenFly());
        ItemStack flingSpell = new SpellRecipe(Shapes.PROJECTILE, Components.FLING).setShapeModifier(Attribute.SPEED, 3.0f).setComponentModifier(0, Attribute.SPEED, 3.0f).createAsSpell();
        ItemStack healSpell = new SpellRecipe(Shapes.SELF, Components.HEAL).setComponentModifier(0, Attribute.MAGNITUDE, 20.0f).createAsSpell();
        ItemStack disjunctionSpell = new SpellRecipe(Shapes.SELF, Components.DISJUNCTION).setComponentModifier(0, Attribute.MAGNITUDE, 20.0f).createAsSpell();
        ItemStack mindControlSpell = new SpellRecipe(Shapes.BOLT, Components.MIND_CONTROL).setShapeModifier(Attribute.RANGE, 32.0f).setComponentModifier(0, Attribute.DURATION, 15.0f).createAsSpell();
        ItemStack winterIceSpell = new SpellRecipe(Shapes.PROJECTILE, Components.FROST_DAMAGE).setShapeModifier(Attribute.RADIUS, 2.0f).setShapeModifier(Attribute.SPEED, 2.0f).setComponentModifier(0, Attribute.DAMAGE, 10.0f).createAsSpell();
        ItemStack chillSpell = new SpellRecipe(Shapes.BOLT, Components.CHILL).setShapeModifier(Attribute.RANGE, 32.0f).setComponentModifier(0, Attribute.MAGNITUDE, 2.0f).setComponentModifier(0, Attribute.DURATION, 20.0f).setComponentModifier(0, Attribute.DAMAGE, 20.0f).setComponentModifier(0, Attribute.RADIUS, 10.0f).createAsSpell();
        ItemStack iceSpikeSpell = new SpellRecipe(Shapes.PROJECTILE, Components.ICE_SPIKE).setShapeModifier(Attribute.RADIUS, 3.0f).setShapeModifier(Attribute.SPEED, 2.0f).setComponentModifier(0, Attribute.DAMAGE, 20.0f).setComponentModifier(0, Attribute.DURATION, 20.0f).createAsSpell();
        ItemStack frailtySpell = new SpellRecipe(Shapes.CHAIN, Components.FRAILTY).setShapeModifier(Attribute.RANGE, 32.0f).setShapeModifier(Attribute.MAGNITUDE, 100.0f).setShapeModifier(Attribute.RADIUS, 5.0f).setComponentModifier(0, Attribute.DURATION, 10.0f).setComponentModifier(0, Attribute.MAGNITUDE, 3.0f).createAsSpell();
        ItemStack summerFireSpell = new SpellRecipe(Shapes.PROJECTILE, Components.FIRE_DAMAGE).setShapeModifier(Attribute.RADIUS, 2.0f).setShapeModifier(Attribute.SPEED, 2.0f).setComponentModifier(0, Attribute.DAMAGE, 10.0f).setComponentModifier(0, Attribute.PRECISION, 1.0f).createAsSpell();
        ItemStack heatwaveSpell = new SpellRecipe(Shapes.BOLT, Components.HEATWAVE).setShapeModifier(Attribute.RANGE, 32.0f).setComponentModifier(0, Attribute.MAGNITUDE, 2.0f).setComponentModifier(0, Attribute.DURATION, 20.0f).setComponentModifier(0, Attribute.DAMAGE, 20.0f).setComponentModifier(0, Attribute.RADIUS, 10.0f).createAsSpell();
        ItemStack sunderSpell = new SpellRecipe(Shapes.CHAIN, Components.SUNDER).setShapeModifier(Attribute.RANGE, 32.0f).setShapeModifier(Attribute.MAGNITUDE, 100.0f).setShapeModifier(Attribute.RADIUS, 5.0f).setComponentModifier(0, Attribute.DURATION, 10.0f).setComponentModifier(0, Attribute.MAGNITUDE, 3.0f).createAsSpell();
        this.f_21345_.m_25352_(1, new CastSpellOnSelfGoal<FaerieQueen>(this, healSpell, this::shouldHealSelf, this::snapSpellCastPrecast, me -> {
            this.spellCastReset();
            this.setCooldown(1026, 100);
        }, 21));
        this.f_21345_.m_25352_(1, (Goal)new FaerieQueenSummonIllusions());
        this.f_21345_.m_25352_(1, (Goal)new BossMonster.CastSpellAtTargetGoal(flingSpell, moveSpeed, 100, 10.0f, 0.0f, true, 1025, 8, 12, null, this::spellCastReset, this::simpleSpellCastPrecast).setUsePredicate(this::shouldFlingTarget));
        this.f_21345_.m_25352_(2, (Goal)new BossMonster.CastSpellAtTargetGoal(disjunctionSpell, moveSpeed, 400, 28.0f, 0.0f, true, 1027, 20, 28, null, this::spellCastReset, this::snapSpellCastPrecast).setUsePredicate(this::spellCastPredicate));
        this.f_21345_.m_25352_(2, (Goal)new BossMonster.CastSpellAtTargetGoal(mindControlSpell, moveSpeed, 500, 28.0f, 0.0f, true, 1028, 20, 28, null, this::spellCastReset, this::snapSpellCastPrecast).setUsePredicate(this::shouldMindControlTarget));
        if (this.isWinter()) {
            this.f_21345_.m_25352_(1, (Goal)new BossMonster.CastSpellAtTargetGoal(chillSpell, moveSpeed, 300, 28.0f, 0.0f, true, 1031, 5, 13, null, this::spellCastReset, this::spinSpellCastPrecast).setUsePredicate(this::shouldHighPriorityChillTarget));
            this.f_21345_.m_25352_(1, (Goal)new BossMonster.CastSpellAtTargetGoal(frailtySpell, moveSpeed, 500, 28.0f, 0.0f, true, 1033, 20, 28, null, this::spellCastReset, this::snapSpellCastPrecast).setUsePredicate(this::shouldHighPriorityFrailtyTarget));
            this.f_21345_.m_25352_(5, (Goal)new BossMonster.CastSpellAtTargetGoal(chillSpell, moveSpeed, 300, 28.0f, 0.0f, true, 1031, 5, 13, null, this::spellCastReset, this::spinSpellCastPrecast).setUsePredicate(this::spellCastPredicate));
            this.f_21345_.m_25352_(5, (Goal)new BossMonster.CastSpellAtTargetGoal(frailtySpell, moveSpeed, 500, 28.0f, 0.0f, true, 1033, 20, 28, null, this::spellCastReset, this::snapSpellCastPrecast).setUsePredicate(this::spellCastPredicate));
            this.f_21345_.m_25352_(5, (Goal)new BossMonster.CastSpellAtTargetGoal(iceSpikeSpell, moveSpeed, 300, 28.0f, 0.0f, true, 1032, 5, 13, null, this::spellCastReset, this::simpleSpellCastPrecast).setUsePredicate(this::spellCastPredicate));
            this.f_21345_.m_25352_(6, (Goal)new BossMonster.CastSpellAtTargetGoal(winterIceSpell, moveSpeed, 0, 28.0f, 0.0f, true, 1030, 5, 13, null, this::spellCastReset, this::simpleSpellCastPrecast).setUsePredicate(this::spellCastPredicate));
        } else {
            this.f_21345_.m_25352_(1, (Goal)new BossMonster.CastSpellAtTargetGoal(heatwaveSpell, moveSpeed, 300, 28.0f, 0.0f, true, 1035, 5, 13, null, this::spellCastReset, this::spinSpellCastPrecast).setUsePredicate(this::shouldHighPriorityHeatwaveTarget));
            this.f_21345_.m_25352_(5, (Goal)new BossMonster.CastSpellAtTargetGoal(heatwaveSpell, moveSpeed, 300, 28.0f, 0.0f, true, 1035, 5, 13, null, this::spellCastReset, this::spinSpellCastPrecast).setUsePredicate(this::spellCastPredicate));
            this.f_21345_.m_25352_(5, (Goal)new BossMonster.CastSpellAtTargetGoal(sunderSpell, moveSpeed, 500, 28.0f, 0.0f, true, 1036, 20, 28, null, this::spellCastReset, this::snapSpellCastPrecast).setUsePredicate(this::spellCastPredicate));
            this.f_21345_.m_25352_(6, (Goal)new BossMonster.CastSpellAtTargetGoal(summerFireSpell, moveSpeed, 0, 28.0f, 0.0f, true, 1034, 5, 13, null, this::spellCastReset, this::simpleSpellCastPrecast).setUsePredicate(this::spellCastPredicate));
        }
        if (this.f_21346_.f_25345_.size() == 0) {
            this.f_21346_.m_25352_(1, (Goal)new BossMonster.ThreatTableHurtByTargetGoal((PathfinderMob)this, FaerieQueen.class));
            this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, le -> true));
            this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 10, true, false, e -> e instanceof IFactionEnemy && ((IFactionEnemy)e).getFaction() != this.getFaction()));
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SEASON, (Object)0);
        this.f_19804_.m_135372_(SUMMONER_UUID, (Object)"");
        this.f_19804_.m_135372_(IS_JOINING, (Object)false);
    }

    @Override
    public void m_6667_(DamageSource pCause) {
        if (pCause.m_276093_(DamageTypes.f_268724_)) {
            super.m_6667_(pCause);
            return;
        }
        this.setAction(Action.DEATH);
        this.m_21219_();
        super.m_6667_(pCause);
    }

    protected void m_6153_() {
        ++this.faerieDeathTime;
        if (!this.m_9236_().m_5776_()) {
            if (this.faerieDeathTime == 30) {
                this.m_5496_(SFX.Event.Ritual.FAERIE_BLOW_KISS, 1.0f, 1.0f);
            } else if (this.faerieDeathTime == 61) {
                this.m_142687_(Entity.RemovalReason.KILLED);
            }
        }
        if (this.faerieDeathTime >= 60 && this.m_9236_().m_5776_()) {
            ParticleConfigurations.ArcaneParticleBurst(this.m_9236_(), this.m_146892_());
        }
    }

    protected boolean m_6125_() {
        return this.m_9236_().m_45976_(FaerieQueen.class, this.m_20191_().m_82400_(32.0)).size() <= 1;
    }

    public static AttributeSupplier.Builder getGlobalAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 675.0).m_22268_(Attributes.f_22279_, (double)0.7f).m_22268_(Attributes.f_22277_, 40.0).m_22268_(Attributes.f_22284_, 14.0).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22278_, 0.5);
    }

    public InteractionResult m_7111_(Player player, Vec3 vec, InteractionHand hand) {
        if (this.isNaturalSpawn()) {
            return InteractionResult.FAIL;
        }
        if (player != this.getSummonedBy()) {
            return InteractionResult.FAIL;
        }
        if (this.getAction() == Action.FJ_WAITING_ITEM && player.m_21120_(hand).m_41720_() == ItemInit.MOTE_AIR.get()) {
            EntityUtil.SetLiftSpeed(player, 0.055f);
            if (!this.m_9236_().m_5776_()) {
                player.m_21211_().m_41774_(1);
                this.setAction(Action.FJ_IMBUING);
                this.m_9236_().m_5594_(null, this.m_20183_(), SFX.Event.Ritual.FAERIE_IMBUE, SoundSource.PLAYERS, 1.0f, 1.0f);
                this.lockTargetInPlace((LivingEntity)player, false);
                this.setTimer("raise", 10, () -> this.lockTargetInPlace((LivingEntity)player, true));
                this.setTimer("kiss", 52, () -> {
                    this.m_9236_().m_5594_(null, this.m_20183_(), SFX.Event.Ritual.FAERIE_BLOW_KISS, SoundSource.PLAYERS, 1.0f, 1.0f);
                    this.lockTargetInPlace((LivingEntity)player, false);
                });
                this.setTimer("leave_sound", 100, () -> this.m_9236_().m_5594_(null, this.m_20183_(), SFX.Event.Ritual.FAERIE_LEAVE, SoundSource.PLAYERS, 1.0f, 1.0f));
                this.setTimer("advance", 120, () -> {
                    IPlayerProgression progression = (IPlayerProgression)player.getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
                    if (progression != null && progression.getTier() < 5) {
                        if (progression.getAlliedFaction() == null) {
                            progression.setAlliedFaction(Factions.FEY, player);
                            player.m_213846_((Component)Component.m_237115_((String)"event.mna.faction_ally_fey"));
                        }
                        if (progression.getAlliedFaction() == Factions.FEY) {
                            progression.setTier(progression.getTier() + 1, player);
                            player.m_213846_((Component)Component.m_237110_((String)"mna:progresscondition.advanced", (Object[])new Object[]{progression.getTier()}));
                        }
                    }
                    player.m_21195_((MobEffect)EffectInit.LIFT.get());
                });
                this.setTimer("despawn", 165, () -> this.m_146870_());
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    private UUID getSummonerGuid() {
        try {
            return UUID.fromString((String)this.f_19804_.m_135370_(SUMMONER_UUID));
        }
        catch (Throwable t) {
            return null;
        }
    }

    private Action getAction() {
        int ordinal = (this.getStateFlag() & 0x7F8) >> 3 & 0xFF;
        if (ordinal >= Action.values().length) {
            return Action.IDLE;
        }
        return Action.values()[ordinal];
    }

    private AttackAction getAttackAction() {
        int ordinal = (this.getStateFlag() & 0xFFFF) >> 12 & 0xF;
        if (ordinal >= AttackAction.values().length) {
            return AttackAction.NONE;
        }
        return AttackAction.values()[ordinal];
    }

    private Player getSummonedBy() {
        if (this.summonedBy == null && this.getSummonerGuid() != null) {
            this.summonedBy = this.m_9236_().m_46003_(this.getSummonerGuid());
        }
        return this.summonedBy;
    }

    public boolean isExiting() {
        return this.isNaturalSpawn() && this.getAction() == Action.DEATH;
    }

    public boolean isWinter() {
        return (Byte)this.f_19804_.m_135370_(SEASON) == 0;
    }

    public boolean isNaturalSpawn() {
        return (Boolean)this.f_19804_.m_135370_(IS_JOINING) == false;
    }

    public FaerieQueen setSeason(boolean winter) {
        if (this.isWinter() == winter) {
            return this;
        }
        this.f_19804_.m_135381_(SEASON, (Object)(winter ? (byte)0 : 1));
        this.f_21345_.m_262460_(g -> true);
        this.m_8099_();
        return this;
    }

    public void setSummoner(Player player) {
        if (player == null || player.m_36316_() == null) {
            return;
        }
        this.f_19804_.m_135381_(SUMMONER_UUID, (Object)player.m_36316_().getId().toString());
        this.f_19804_.m_135381_(IS_JOINING, (Object)true);
        this.hideBossBar();
        this.summonedBy = player;
        this.m_20331_(true);
        this.f_21345_.f_25345_.clear();
        this.f_21346_.f_25345_.clear();
        this.setAction(Action.FJ_WAITING_ITEM);
    }

    private void setAction(Action action) {
        byte ordinal = (byte)((action.ordinal() & 0xFF) << 3);
        int flag = this.getStateFlag();
        flag &= 0xFFFFF807;
        this.setState(flag |= ordinal);
    }

    private void setAttackAction(AttackAction action) {
        int ordinal = (action.ordinal() & 0xF) << 12;
        int flag = this.getStateFlag();
        flag &= 0xFFFF0FFF;
        this.setState(flag |= ordinal);
    }

    @Override
    protected ServerBossEvent getBossEvent() {
        return this.isWinter() ? this.bossEventWinter : this.bossEventSummer;
    }

    @Override
    public void setupSpawn() {
    }

    @Override
    protected void spawnParticles() {
        if (this.getAction() == Action.DEATH) {
            return;
        }
        int numAuraParticles = 3;
        int numWingParticles = 2;
        Vec3 forward = this.m_20156_().m_82541_();
        Vec3 side = forward.m_82537_(new Vec3(0.0, 1.0, 0.0)).m_82541_();
        forward = forward.m_82490_(-0.5);
        if (this.isWinter()) {
            int i;
            for (i = 0; i < numAuraParticles; ++i) {
                Vec3 pos = new Vec3(this.m_20185_() - 0.2 + Math.random() * 0.4, this.m_20186_() + Math.random() * 0.5, this.m_20189_() - 0.2 + Math.random() * 0.4);
                this.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FROST.get())).setMover(new ParticleOrbitMover(pos.f_82479_, pos.f_82480_, pos.f_82481_, (double)0.01f + Math.random() * (double)0.01f, (double)0.01f + Math.random() * (double)0.01f, 1.0 + Math.random() * 3.0)), pos.f_82479_, pos.f_82480_, pos.f_82481_, 0.0, 0.0, 0.0);
            }
            for (i = 0; i < numWingParticles; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.BLUE_SPARKLE_GRAVITY.get())).setColor(148, 242, 244), this.m_20185_() - side.f_82479_ + forward.f_82479_ + forward.f_82479_ * Math.random() + Math.random() * side.f_82479_ * 2.0, this.m_20186_() + Math.random() * (double)this.m_20192_(), this.m_20189_() - side.f_82481_ + forward.f_82481_ + forward.f_82481_ * Math.random() + Math.random() * side.f_82481_ * 2.0, 0.0, 0.0, 0.0);
            }
        } else {
            int i;
            for (i = 0; i < numAuraParticles; ++i) {
                Vec3 pos = new Vec3(this.m_20185_() - 0.2 + Math.random() * 0.4, this.m_20186_() + Math.random() * 0.5, this.m_20189_() - 0.2 + Math.random() * 0.4);
                this.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FLAME.get())).setMover(new ParticleOrbitMover(pos.f_82479_, pos.f_82480_, pos.f_82481_, (double)0.01f + Math.random() * (double)0.01f, (double)0.01f + Math.random() * (double)0.01f, 1.0 + Math.random() * 3.0)), pos.f_82479_, pos.f_82480_, pos.f_82481_, 0.0, 0.0, 0.0);
            }
            for (i = 0; i < numWingParticles; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.BLUE_SPARKLE_GRAVITY.get())).setColor(229, 220, 84), this.m_20185_() - side.f_82479_ + forward.f_82479_ + forward.f_82479_ * Math.random() + Math.random() * side.f_82479_ * 2.0, this.m_20186_() + Math.random() * (double)this.m_20192_(), this.m_20189_() - side.f_82481_ + forward.f_82481_ + forward.f_82481_ * Math.random() + Math.random() * side.f_82481_ * 2.0, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public ResourceLocation getArenaStructureID() {
        return RLoc.create("faction/boss/fey_tree");
    }

    @Override
    public int getArenaStructureSegment() {
        return 2;
    }

    @Override
    public HashMap<String, Integer> getDamageResists() {
        return new HashMap<String, Integer>();
    }

    @Override
    public IFaction getFaction() {
        return Factions.FEY;
    }

    @Override
    public Player getRaidTarget() {
        return null;
    }

    @Override
    public int getTier() {
        return 3;
    }

    @Override
    public void setRaidTarget(Player player) {
    }

    @Override
    public void setTier(int tier) {
    }

    @Override
    protected PlayState handleAnimState(AnimationState<? extends BossMonster<?>> state) {
        RawAnimation builder = RawAnimation.begin();
        block0 : switch (this.getAction()) {
            case DEATH: {
                builder.thenPlay("animation.fey_queen.blow_kiss");
                break;
            }
            case FJ_WAITING_ITEM: {
                builder.thenLoop("animation.fey_queen.wait_gift");
                break;
            }
            case FJ_IMBUING: {
                builder.thenPlay("animation.fey_queen.infuse");
                break;
            }
            case ATTACKING: {
                switch (this.getAttackAction()) {
                    case CAST_2H_UP: {
                        builder.thenPlay("animation.fey_queen.cast_5");
                        break block0;
                    }
                    case CAST_SIMPLE_LEFT: {
                        builder.thenPlay("animation.fey_queen.cast_2");
                        break block0;
                    }
                    case CAST_SIMPLE_RIGHT: {
                        builder.thenPlay("animation.fey_queen.cast_1");
                        break block0;
                    }
                    case CAST_SNAP_LEFT: {
                        builder.thenPlay("animation.fey_queen.cast_4");
                        break block0;
                    }
                    case CAST_SNAP_RIGHT: {
                        builder.thenPlay("animation.fey_queen.cast_3");
                        break block0;
                    }
                    case CAST_SPIN_LEFT: {
                        builder.thenPlay("animation.fey_queen.cast_7");
                        break block0;
                    }
                    case CAST_SPIN_RIGHT: {
                        builder.thenPlay("animation.fey_queen.cast_6");
                        break block0;
                    }
                }
                break;
            }
            default: {
                double movementSpeed = this.m_20184_().m_82520_(0.0, -this.m_20184_().f_82480_, 0.0).m_82553_();
                if (movementSpeed > 0.1) {
                    builder.thenLoop("animation.fey_queen.moving");
                    break;
                }
                builder.thenLoop("animation.fey_queen.idle");
            }
        }
        return state.setAndContinue(builder);
    }

    private void spellCastReset() {
        this.setAttackAction(AttackAction.NONE);
        this.setAction(Action.IDLE);
        this.globalSpellCooldown = 10 + (int)(Math.random() * 20.0);
    }

    private boolean simpleSpellCastPrecast(BossMonster<?> me) {
        this.setAction(Action.ATTACKING);
        this.setAttackAction(Math.random() < 0.5 ? AttackAction.CAST_SIMPLE_LEFT : AttackAction.CAST_SIMPLE_RIGHT);
        return true;
    }

    private boolean spinSpellCastPrecast(BossMonster<?> me) {
        this.setAction(Action.ATTACKING);
        this.setAttackAction(Math.random() < 0.5 ? AttackAction.CAST_SPIN_LEFT : AttackAction.CAST_SPIN_RIGHT);
        return true;
    }

    private boolean snapSpellCastPrecast(BossMonster<?> me) {
        this.setAction(Action.ATTACKING);
        this.setAttackAction(Math.random() < 0.5 ? AttackAction.CAST_SNAP_LEFT : AttackAction.CAST_SNAP_RIGHT);
        return true;
    }

    private boolean shouldFlingTarget(Entity target) {
        return this.spellCastPredicate(target) && target.m_20270_((Entity)this) < 4.0f;
    }

    private boolean shouldHighPriorityFrailtyTarget(Entity target) {
        return this.spellCastPredicate(target) && target instanceof LivingEntity && ((LivingEntity)target).m_21023_(MobEffects.f_19606_);
    }

    private boolean shouldHighPriorityHeatwaveTarget(Entity target) {
        return this.spellCastPredicate(target) && target instanceof LivingEntity && ((LivingEntity)target).m_21023_((MobEffect)EffectInit.CHILL.get());
    }

    private boolean shouldHighPriorityChillTarget(Entity target) {
        return this.spellCastPredicate(target) && target instanceof LivingEntity && ((LivingEntity)target).m_21023_((MobEffect)EffectInit.HEATWAVE.get());
    }

    private boolean shouldMindControlTarget(Entity target) {
        return this.spellCastPredicate(target) && SummonUtils.isSummon(target) && !SummonUtils.isTargetFriendly(target, (LivingEntity)this);
    }

    private boolean spellCastPredicate(Entity target) {
        return this.getAction() == Action.IDLE && this.globalSpellCooldown == 0 && this.m_5448_() != null && this.m_5448_().m_6084_();
    }

    private boolean shouldHealSelf(FaerieQueen me) {
        return this.getAction() == Action.IDLE && this.globalSpellCooldown == 0 && this.m_21223_() <= this.m_21233_() / 2.0f && !this.isOnCooldown(1026);
    }

    static class MoveHelperController
    extends MoveControl {
        private final FaerieQueen parentEntity;
        private int courseChangeCooldown;

        public MoveHelperController(FaerieQueen queen) {
            super((Mob)queen);
            this.parentEntity = queen;
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                float minMoveSpeed = 0.1f;
                float maxMoveSpeed = 0.6f;
                Vec3 v = new Vec3(this.f_24975_, this.f_24976_, this.f_24977_);
                double distSqr = v.m_82557_(this.parentEntity.m_20182_());
                if (distSqr < 16.0) {
                    double pct = distSqr / 16.0;
                    this.f_24978_ = MathUtils.lerpf(minMoveSpeed, maxMoveSpeed, (float)pct);
                    this.parentEntity.m_20256_(this.parentEntity.m_20184_().m_82490_(pct));
                    if (this.parentEntity.m_5448_() != null) {
                        this.parentEntity.m_7618_(EntityAnchorArgument.Anchor.FEET, this.parentEntity.m_5448_().m_146892_());
                    }
                } else {
                    this.f_24978_ = maxMoveSpeed;
                }
                if (this.courseChangeCooldown-- <= 0) {
                    this.courseChangeCooldown += this.parentEntity.m_217043_().m_188503_(5) + 2;
                    Vec3 vector3d = new Vec3(this.f_24975_ - this.parentEntity.m_20185_(), this.f_24976_ - this.parentEntity.m_20186_(), this.f_24977_ - this.parentEntity.m_20189_());
                    double d0 = vector3d.m_82553_();
                    if (this.isCollided(vector3d = vector3d.m_82541_(), Mth.m_14165_((double)d0))) {
                        this.parentEntity.m_20256_(this.parentEntity.m_20184_().m_82549_(vector3d.m_82490_(0.1)));
                    } else {
                        this.f_24981_ = MoveControl.Operation.WAIT;
                    }
                }
            }
        }

        private boolean isCollided(Vec3 p_220673_1_, int p_220673_2_) {
            AABB axisalignedbb = this.parentEntity.m_20191_();
            for (int i = 1; i < p_220673_2_; ++i) {
                axisalignedbb = axisalignedbb.m_82383_(p_220673_1_);
                if (this.parentEntity.m_9236_().m_45756_((Entity)this.parentEntity, axisalignedbb)) continue;
                return false;
            }
            return true;
        }
    }

    class FaerieQueenFly
    extends Goal {
        public FaerieQueenFly() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            MoveControl movementcontroller = FaerieQueen.this.m_21566_();
            if (!movementcontroller.m_24995_()) {
                return true;
            }
            if (FaerieQueen.this.m_5448_() == null) {
                double d2;
                double d1;
                double d0 = movementcontroller.m_25000_() - FaerieQueen.this.m_20185_();
                double d3 = d0 * d0 + (d1 = movementcontroller.m_25001_() - FaerieQueen.this.m_20186_()) * d1 + (d2 = movementcontroller.m_25002_() - FaerieQueen.this.m_20189_()) * d2;
                return d3 < 4.0 || d3 > 3600.0;
            }
            double dist = FaerieQueen.this.m_5448_().m_20280_((Entity)FaerieQueen.this);
            return !FaerieQueen.this.m_21574_().m_148306_((Entity)FaerieQueen.this.m_5448_()) || dist > 400.0 || FaerieQueen.this.m_9236_().m_46467_() % 100L == 0L;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8056_() {
            if (FaerieQueen.this.m_5448_() != null) {
                Vec3 direction = FaerieQueen.this.m_20182_().m_82546_(FaerieQueen.this.m_5448_().m_20182_()).m_82541_();
                direction = direction.m_82520_(0.0, -direction.f_82480_ - 1.0 + Math.random() * 2.0, 0.0);
                Vec3 offset = direction.m_82490_(8.0 + Math.random() * 4.0);
                offset = offset.m_82520_(-2.0 + Math.random() * 4.0, 0.0, -2.0 + Math.random() * 4.0);
                Vec3 target = FaerieQueen.this.m_5448_().m_20182_().m_82549_(offset);
                if (FaerieQueen.this.m_5448_().m_20096_()) {
                    target = target.m_82520_(0.0, 1.5, 0.0);
                }
                BlockPos pos = BlockPos.m_274561_((double)target.f_82479_, (double)target.f_82480_, (double)target.f_82481_);
                int count = 0;
                while (FaerieQueen.this.m_9236_().m_46859_(pos) && count < 16) {
                    ++count;
                    pos = pos.m_7495_();
                }
                if (count >= 16) {
                    target = target.m_82520_(0.0, -10.0, 0.0);
                }
                FaerieQueen.this.m_21566_().m_6849_(target.f_82479_, target.f_82480_, target.f_82481_, 1.0);
            }
        }
    }

    class FaerieQueenSummonIllusions
    extends Goal {
        private static final int DURATION = 42;
        private static final int SUMMON_AT = 30;
        private int tickCount = 0;

        FaerieQueenSummonIllusions() {
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8036_() {
            boolean hasTarget = FaerieQueen.this.m_5448_() != null;
            boolean noSummons = FaerieQueen.this.m_9236_().m_45976_(IllusionCreeper.class, FaerieQueen.this.m_20191_().m_82400_(32.0)).size() == 0;
            boolean offCooldown = !FaerieQueen.this.isOnCooldown(1029);
            boolean isIdle = FaerieQueen.this.getAction() == Action.IDLE || FaerieQueen.this.getAction() == Action.ATTACKING && FaerieQueen.this.getAttackAction() == AttackAction.CAST_2H_UP;
            return hasTarget && noSummons && offCooldown && isIdle;
        }

        public boolean m_6767_() {
            return false;
        }

        public boolean m_8045_() {
            return FaerieQueen.this.getAction() == Action.ATTACKING && FaerieQueen.this.getAttackAction() == AttackAction.CAST_2H_UP && this.tickCount < 42;
        }

        public void m_8056_() {
            FaerieQueen.this.setAction(Action.ATTACKING);
            FaerieQueen.this.setAttackAction(AttackAction.CAST_2H_UP);
            FaerieQueen.this.m_5496_(SFX.Entity.WitherLich.SUMMON, 1.0f, 1.0f);
        }

        public void m_8041_() {
            FaerieQueen.this.setCooldown(1029, 600);
            FaerieQueen.this.setAttackAction(AttackAction.NONE);
            FaerieQueen.this.setAction(Action.IDLE);
            this.tickCount = 0;
        }

        public void m_8037_() {
            ++this.tickCount;
            if (this.tickCount == 30) {
                for (int i = 0; i < 10; ++i) {
                    this.summonCreeper(true);
                }
                this.summonCreeper(false);
            }
            if (this.tickCount >= 42) {
                this.m_8041_();
            }
        }

        private void summonCreeper(boolean illusion) {
            Vec3 pos = FaerieQueen.this.m_20182_();
            pos = pos.m_82520_(-5.0 + Math.random() * 10.0, 0.0, -5.0 + Math.random() * 10.0);
            IllusionCreeper c = illusion ? new IllusionCreeper(FaerieQueen.this.m_9236_()) : new Creeper(EntityType.f_20558_, FaerieQueen.this.m_9236_());
            c.m_146884_(pos);
            c.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 60));
            SummonUtils.setSummon((Mob)c, (LivingEntity)FaerieQueen.this, 400);
            FaerieQueen.this.m_9236_().m_7967_((Entity)c);
        }
    }

    public static enum Action {
        IDLE,
        FJ_WAITING_ITEM,
        FJ_IMBUING,
        ATTACKING,
        ENRAGING,
        DEATH;

    }

    public static enum AttackAction {
        NONE(0, 0),
        CAST_SIMPLE_RIGHT(13, 17),
        CAST_SIMPLE_LEFT(13, 17),
        CAST_SNAP_RIGHT(28, 32),
        CAST_SNAP_LEFT(28, 32),
        CAST_2H_UP(28, 32),
        CAST_SPIN_RIGHT(13, 17),
        CAST_SPIN_LEFT(13, 17);

        public final int animLength;
        public final int resetTime;

        private AttackAction(int animLength, int resetTime) {
            this.animLength = animLength;
            this.resetTime = resetTime;
        }
    }
}

