/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.boss;

import com.mna.api.sound.SFX;
import com.mna.entities.EntityInit;
import com.mna.entities.boss.BossMonster;
import com.mna.entities.boss.attacks.OrangeChickenProjectile;
import com.mna.tools.math.MathUtils;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeMod;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class PigDragon
extends BossMonster<PigDragon> {
    private final ServerBossEvent bossEvent = (ServerBossEvent)new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.PINK, BossEvent.BossBarOverlay.NOTCHED_20).m_7003_(true);
    private static final int COOLDOWN_SHOOT_CHICKEN = 0;
    private static final int COOLDOWN_DIVEBOMB = 0;
    private int spawnTicks = 90;
    private int flapCount = 0;
    private Vec3 targetPosition;

    public PigDragon(EntityType<PigDragon> type, Level world) {
        super(type, world);
        this.m_20242_(true);
        this.f_19794_ = true;
        this.setAction(Action.SUMMON);
    }

    public PigDragon(Level world) {
        this((EntityType<PigDragon>)((EntityType)EntityInit.PIG_DRAGON.get()), world);
        this.setAction(Action.SUMMON);
    }

    @Override
    protected PlayState handleAnimState(AnimationState<? extends BossMonster<?>> state) {
        RawAnimation builder = RawAnimation.begin();
        switch (this.getAction()) {
            case DIVEBOMBING: {
                builder.thenLoop("animation.PigDragon.dive");
                break;
            }
            case SHOOTING: {
                builder.thenPlay("animation.PigDragon.fly_breath");
                break;
            }
            case SUMMON: {
                builder.thenPlay("animation.PigDragon.summon");
                break;
            }
            default: {
                if (this.flapCount > 0) {
                    builder.thenLoop("animation.PigDragon.fly");
                    break;
                }
                builder.thenLoop("animation.PigDragon.glide_gentle");
            }
        }
        return state.setAndContinue(builder);
    }

    @Override
    protected ServerBossEvent getBossEvent() {
        return this.bossEvent;
    }

    @Override
    public void setupSpawn() {
    }

    private double distSqToTarget() {
        if (this.targetPosition == null) {
            return 0.0;
        }
        return this.targetPosition.m_82557_(this.m_20182_());
    }

    protected void m_8099_() {
        this.f_21346_.m_25352_(1, (Goal)new ShootChicken());
        this.f_21346_.m_25352_(2, (Goal)new DiveBomb());
        this.f_21346_.m_25352_(3, (Goal)new PigDragonFly());
        this.f_21346_.m_25352_(1, (Goal)new BossMonster.ThreatTableHurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, le -> true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, BossMonster.class, 10, true, false, le -> le != this));
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.targetPosition != null) {
            Vec3 myPos = this.m_20182_();
            if (this.m_20184_().f_82479_ == 0.0 && this.m_20184_().f_82480_ == 0.0 && this.m_20184_().f_82481_ == 0.0) {
                this.m_20334_(Math.random(), Math.random(), Math.random());
            }
            float tickTheta = 5.135f;
            Vec3 desiredHeading = this.targetPosition.m_82546_(myPos).m_82541_();
            Vec3 calculatedHeading = MathUtils.rotateTowards(this.m_20184_(), desiredHeading, tickTheta).m_82541_().m_82490_((double)0.35f);
            this.m_20256_(calculatedHeading);
        }
        if (this.m_20184_().m_82553_() > (double)0.1f) {
            Vec3 target = this.m_20182_().m_82549_(this.m_20184_().m_82541_().m_82490_(30.0));
            Vec3 vec3 = EntityAnchorArgument.Anchor.FEET.m_90377_((Entity)this);
            double d0 = target.f_82479_ - vec3.f_82479_;
            double d1 = target.f_82480_ - vec3.f_82480_;
            double d2 = target.f_82481_ - vec3.f_82481_;
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            this.m_146926_(Mth.m_14177_((float)((float)(-(Mth.m_14136_((double)d1, (double)d3) * 57.2957763671875)))));
            this.m_146922_(Mth.m_14177_((float)((float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f)));
            this.m_5616_(this.m_146908_());
        }
        if (this.m_9236_().m_5776_()) {
            if (this.flapCount > 0) {
                --this.flapCount;
                if (this.flapCount == 0) {
                    this.flapCount = -((int)(60.0 + Math.random() * 100.0));
                }
            } else if (this.flapCount <= 0) {
                ++this.flapCount;
                if (this.flapCount == 0) {
                    this.flapCount = (int)(60.0 + Math.random() * 100.0);
                }
            }
        } else if (this.spawnTicks > 0) {
            this.m_21557_(true);
            --this.spawnTicks;
            this.m_6478_(MoverType.SELF, new Vec3(0.0, 0.25, 0.0));
            this.setAction(Action.SUMMON);
            this.m_20256_(Vec3.f_82478_);
            if (this.spawnTicks == 0) {
                this.m_21557_(false);
                this.setAction(Action.IDLE);
            }
        }
    }

    @Override
    public boolean m_6469_(DamageSource type, float amount) {
        if (type.m_269533_(DamageTypeTags.f_268415_)) {
            return false;
        }
        return super.m_6469_(type, amount);
    }

    @Override
    protected void m_8024_() {
        super.m_8024_();
        this.checkWalls(this.m_20191_());
        if (!this.m_9236_().m_5776_() && this.f_20916_ == 0) {
            this.knockBack(this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82377_(4.0, 2.0, 4.0).m_82386_(0.0, -2.0, 0.0), EntitySelector.f_20406_));
            this.hurtNearby(this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82400_(1.0), EntitySelector.f_20406_));
        }
    }

    private void setAction(Action action) {
        byte ordinal = (byte)((action.ordinal() & 0xFF) << 3);
        int flag = this.getStateFlag();
        flag &= 0xFFFFF807;
        this.setState(flag |= ordinal);
    }

    private Action getAction() {
        int ordinal = (this.getStateFlag() & 0x7F8) >> 3 & 0xFF;
        if (ordinal >= Action.values().length) {
            return Action.IDLE;
        }
        return Action.values()[ordinal];
    }

    @Override
    public ResourceLocation getArenaStructureID() {
        return null;
    }

    @Override
    public int getArenaStructureSegment() {
        return -1;
    }

    private void hurtNearby(List<Entity> pEntities) {
        for (Entity entity : pEntities) {
            if (!(entity instanceof LivingEntity)) continue;
            entity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)this.m_21051_(Attributes.f_22281_).m_22135_());
            this.m_19970_((LivingEntity)this, entity);
        }
    }

    private void knockBack(List<Entity> pEntities) {
        double d0 = (this.m_20191_().f_82288_ + this.m_20191_().f_82291_) / 2.0;
        double d1 = (this.m_20191_().f_82290_ + this.m_20191_().f_82293_) / 2.0;
        for (Entity entity : pEntities) {
            if (!(entity instanceof LivingEntity)) continue;
            double d2 = entity.m_20185_() - d0;
            double d3 = entity.m_20189_() - d1;
            double d4 = Math.max(d2 * d2 + d3 * d3, 0.1);
            entity.m_5997_(d2 / d4 * 4.0, (double)0.2f, d3 / d4 * 4.0);
            if (((LivingEntity)entity).m_21213_() >= entity.f_19797_ - 2) continue;
            entity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 5.0f);
            this.m_19970_((LivingEntity)this, entity);
        }
    }

    private boolean checkWalls(AABB pArea) {
        int i = Mth.m_14107_((double)pArea.f_82288_);
        int j = Mth.m_14107_((double)pArea.f_82289_);
        int k = Mth.m_14107_((double)pArea.f_82290_);
        int l = Mth.m_14107_((double)pArea.f_82291_);
        int i1 = Mth.m_14107_((double)pArea.f_82292_);
        int j1 = Mth.m_14107_((double)pArea.f_82293_);
        boolean flag = false;
        boolean flag1 = false;
        for (int k1 = i; k1 <= l; ++k1) {
            for (int l1 = j; l1 <= i1; ++l1) {
                for (int i2 = k; i2 <= j1; ++i2) {
                    BlockPos blockpos = new BlockPos(k1, l1, i2);
                    BlockState blockstate = this.m_9236_().m_8055_(blockpos);
                    if (blockstate.m_60795_() || blockstate.m_204336_(BlockTags.f_215822_)) continue;
                    if (ForgeHooks.canEntityDestroy((Level)this.m_9236_(), (BlockPos)blockpos, (LivingEntity)this) && !blockstate.m_204336_(BlockTags.f_13069_)) {
                        flag1 = this.m_9236_().m_7471_(blockpos, false) || flag1;
                        continue;
                    }
                    flag = true;
                }
            }
        }
        if (flag1) {
            BlockPos blockpos1 = new BlockPos(i + this.f_19796_.m_188503_(l - i + 1), j + this.f_19796_.m_188503_(i1 - j + 1), k + this.f_19796_.m_188503_(j1 - k + 1));
            this.m_9236_().m_46796_(2008, blockpos1, 0);
        }
        return flag;
    }

    public SoundSource m_5720_() {
        return SoundSource.HOSTILE;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_11890_;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_11895_;
    }

    protected SoundEvent m_5592_() {
        return SFX.Entity.Oink.OINK;
    }

    protected float m_6121_() {
        return 5.0f;
    }

    public static AttributeSupplier.Builder getGlobalAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 600.0).m_22268_(Attributes.f_22279_, (double)0.7f).m_22268_(Attributes.f_22277_, 40.0).m_22268_(Attributes.f_22284_, 14.0).m_22268_(Attributes.f_22281_, 20.0).m_22268_((Attribute)ForgeMod.ENTITY_GRAVITY.get(), 0.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    public static enum Action {
        IDLE,
        SHOOTING,
        DIVEBOMBING,
        SUMMON;

    }

    private class ShootChicken
    extends Goal {
        int tickCount = 0;

        private ShootChicken() {
        }

        public boolean m_8036_() {
            return !PigDragon.this.isOnCooldown(0) && PigDragon.this.m_5448_() != null;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8056_() {
            PigDragon.this.setAction(Action.SHOOTING);
            Vec3 delta = PigDragon.this.m_5448_().m_20182_().m_82546_(PigDragon.this.m_20182_());
            Vec3 target = PigDragon.this.m_20182_().m_82549_(delta.m_82490_(2.0));
            PigDragon.this.targetPosition = new Vec3(target.f_82479_, PigDragon.this.m_20182_().f_82480_, target.f_82481_);
            this.tickCount = 0;
        }

        public void m_8041_() {
            PigDragon.this.setCooldown(0, 40);
            PigDragon.this.setAction(Action.IDLE);
        }

        public boolean m_8045_() {
            return this.tickCount <= 40 && this.m_8036_();
        }

        public void m_8037_() {
            if (this.tickCount++ % 20 == 0 && PigDragon.this.m_5448_() != null) {
                PigDragon.this.m_9236_().m_6269_(null, (Entity)PigDragon.this.m_5448_(), SoundEvents.f_11753_, PigDragon.this.m_5720_(), 1.0f, (float)(0.9 + Math.random() * 0.2));
                Vec3 delta = PigDragon.this.m_5448_().m_20182_().m_82546_(PigDragon.this.m_20182_()).m_82541_();
                OrangeChickenProjectile proj = new OrangeChickenProjectile(PigDragon.this.m_9236_(), PigDragon.this.m_5448_());
                proj.m_146884_(PigDragon.this.m_20182_().m_82549_(PigDragon.this.m_20184_().m_82541_()));
                proj.m_6686_(delta.f_82479_, delta.f_82480_, delta.f_82481_, 0.5f, 0.0f);
                PigDragon.this.m_9236_().m_7967_((Entity)proj);
            }
        }
    }

    private class DiveBomb
    extends Goal {
        private static final AttributeModifier DIVE_BONUS = new AttributeModifier(UUID.fromString("22b8d8eb-16a3-4ee3-80b7-73b19b8e9006"), "dive bonus", 1.0, AttributeModifier.Operation.ADDITION);

        private DiveBomb() {
        }

        public boolean m_8036_() {
            return !PigDragon.this.isOnCooldown(0) && PigDragon.this.m_5448_() != null;
        }

        public void m_8056_() {
            PigDragon.this.setAction(Action.DIVEBOMBING);
            PigDragon.this.m_21051_(Attributes.f_22279_).m_22118_(DIVE_BONUS);
            PigDragon.this.targetPosition = PigDragon.this.m_5448_().m_146892_();
        }

        public void m_8041_() {
            PigDragon.this.setCooldown(0, 300);
            PigDragon.this.m_21051_(Attributes.f_22279_).m_22130_(DIVE_BONUS);
            PigDragon.this.setAction(Action.IDLE);
        }

        public boolean m_8045_() {
            return PigDragon.this.distSqToTarget() >= 4.0;
        }
    }

    class PigDragonFly
    extends Goal {
        public PigDragonFly() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            Action action = PigDragon.this.getAction();
            if (action == Action.SHOOTING || action == Action.DIVEBOMBING) {
                return false;
            }
            return PigDragon.this.distSqToTarget() < 2.0;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8056_() {
            RandomSource random = PigDragon.this.m_217043_();
            double d0 = PigDragon.this.m_20185_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 16.0f);
            double d1 = PigDragon.this.m_20186_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 16.0f);
            double d2 = PigDragon.this.m_20189_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 16.0f);
            int y = (int)d1;
            for (int adjustments = 0; adjustments < 32; ++adjustments) {
                BlockPos bpTestPos = BlockPos.m_274561_((double)d0, (double)y, (double)d2);
                if (!PigDragon.this.m_9236_().m_46859_(bpTestPos)) break;
                --y;
            }
            d1 = y + 16;
            PigDragon.this.targetPosition = new Vec3(d0, d1, d2);
        }
    }
}

