/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.boss;

import com.google.common.collect.Maps;
import com.mna.api.affinity.Affinity;
import com.mna.api.entities.DamageHelper;
import com.mna.api.entities.IFactionEnemy;
import com.mna.api.faction.IFaction;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.api.sound.SFX;
import com.mna.api.spells.SpellCastingResult;
import com.mna.api.spells.attributes.Attribute;
import com.mna.api.spells.collections.Components;
import com.mna.api.spells.collections.Shapes;
import com.mna.api.spells.targeting.SpellSource;
import com.mna.api.spells.targeting.SpellTarget;
import com.mna.api.tools.RLoc;
import com.mna.effects.EffectInit;
import com.mna.entities.EntityInit;
import com.mna.entities.boss.BossMonster;
import com.mna.entities.summon.InsectSwarm;
import com.mna.factions.Factions;
import com.mna.items.ItemInit;
import com.mna.spells.SpellCaster;
import com.mna.spells.crafting.ModifiedSpellPart;
import com.mna.spells.crafting.SpellRecipe;
import com.mna.tools.EntityUtil;
import com.mna.tools.SummonUtils;
import com.mna.tools.math.MathUtils;
import com.mna.tools.math.Vector3;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class WitherLich
extends BossMonster<WitherLich>
implements IFactionEnemy<WitherLich> {
    private final SpellRecipe meleeSpell = new SpellRecipe();
    private final ItemStack melee;
    private final ServerBossEvent bossEvent = (ServerBossEvent)new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.YELLOW, BossEvent.BossBarOverlay.NOTCHED_20).m_7003_(true);
    private final ServerBossEvent powerWordDeathBar = (ServerBossEvent)new ServerBossEvent((Component)Component.m_237115_((String)"entity.mna.wither_lich.power_word_death"), BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.PROGRESS).m_7003_(true);
    protected static final EntityDataAccessor<Byte> SHIELD_COUNT = SynchedEntityData.m_135353_(WitherLich.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected static final EntityDataAccessor<Byte> TEXTURE_VARIANT = SynchedEntityData.m_135353_(WitherLich.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Optional<UUID>> FACTION_JOIN_PLAYER = SynchedEntityData.m_135353_(WitherLich.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    protected static final EntityDataAccessor<Boolean> IS_JOINING = SynchedEntityData.m_135353_(WitherLich.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> REACHING = SynchedEntityData.m_135353_(WitherLich.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private Vector3 start;
    private Vector3 end;
    private int lerpTicks;
    private int lerpCount = 0;
    private int finishTicks = 55;
    private Player cachedPlayer;
    private int powerWordDeathTicks = 0;
    private int numSummons = 0;
    private int lichDeathTime;
    ArrayList<EntityType<? extends Mob>> summonQueue = new ArrayList();
    private static final int COOLDOWN_SUMMON_ID = 1024;
    private static final int COOLDOWN_FROSTBOLT_ID = 1025;
    private static final int COOLDOWN_WITHERBOLT_ID = 1026;
    private static final int COOLDOWN_FOSSILIZE_BOLT_ID = 1027;
    private static final int COOLDOWN_INSECT_SWARM_BREATH_ID = 1028;
    private static final int COOLDOWN_FROST_BREATH_ID = 1029;
    private boolean shouldShieldedStrike = false;
    private int globalSpellCooldown = 0;

    public WitherLich(EntityType<? extends WitherLich> type, Level worldIn) {
        super(type, worldIn);
        this.melee = new ItemStack((ItemLike)ItemInit.SPELL.get());
        this.meleeSpell.setOverrideAffinity(Affinity.ICE);
        this.meleeSpell.setShape(Shapes.TOUCH);
        ((ModifiedSpellPart)this.meleeSpell.getShape()).setValue(Attribute.RANGE, 8.0f);
        this.meleeSpell.addComponent(Components.LACERATE);
        this.meleeSpell.addComponent(Components.IMPALE);
        this.meleeSpell.addComponent(Components.LIFE_TAP);
        ((ModifiedSpellPart)this.meleeSpell.getComponent(0)).setValue(Attribute.DURATION, 5.0f);
        ((ModifiedSpellPart)this.meleeSpell.getComponent(0)).setValue(Attribute.MAGNITUDE, 3.0f);
        ((ModifiedSpellPart)this.meleeSpell.getComponent(1)).setValue(Attribute.DAMAGE, 15.0f);
        ((ModifiedSpellPart)this.meleeSpell.getComponent(2)).setValue(Attribute.DURATION, 15.0f);
        ((ModifiedSpellPart)this.meleeSpell.getComponent(2)).setValue(Attribute.LESSER_MAGNITUDE, 4.0f);
        this.meleeSpell.writeToNBT(this.melee.m_41784_());
        SummonUtils.setBonusSummons((LivingEntity)this, 99);
        this.m_20242_(true);
        this.f_21342_ = new MoveHelperController(this);
        this.getPersistentData().m_128350_("life_tap_pct", 0.25f);
        this.f_19804_.m_135381_(SHIELD_COUNT, (Object)5);
        this.setCooldown(1024, 0);
        this.powerWordDeathTicks = 1;
    }

    public WitherLich(Level worldIn) {
        this((EntityType<? extends WitherLich>)((EntityType)EntityInit.LICH.get()), worldIn);
    }

    public WitherLich(Level level, Vec3 position) {
        this(level);
        this.m_146884_(position);
    }

    private Player getFactionJoinPlayer() {
        if (this.cachedPlayer == null && ((Optional)this.f_19804_.m_135370_(FACTION_JOIN_PLAYER)).isPresent()) {
            this.cachedPlayer = this.m_9236_().m_46003_((UUID)((Optional)this.f_19804_.m_135370_(FACTION_JOIN_PLAYER)).get());
        }
        return this.cachedPlayer;
    }

    private int getDesiredSummonPower() {
        int baseline = 2;
        byte shields = (Byte)this.f_19804_.m_135370_(SHIELD_COUNT);
        baseline *= Math.max(5 - shields, 1);
        return baseline *= Math.min(Math.max(this.threat.size(), 1), 10);
    }

    private void buildSummonList() {
        SummonCandidate next;
        this.summonQueue.clear();
        int desiredSummonPower = this.getDesiredSummonPower();
        ArrayList<SummonCandidate> summonPool = new ArrayList<SummonCandidate>();
        summonPool.add(new SummonCandidate((EntityType<? extends Mob>)EntityType.f_20501_, 1));
        summonPool.add(new SummonCandidate((EntityType<? extends Mob>)EntityType.f_20524_, 1));
        summonPool.add(new SummonCandidate((EntityType<? extends Mob>)EntityType.f_20530_, 2));
        summonPool.add(new SummonCandidate((EntityType<? extends Mob>)EntityType.f_20562_, 2));
        summonPool.add(new SummonCandidate((EntityType<? extends Mob>)EntityType.f_20481_, 2));
        summonPool.add(new SummonCandidate((EntityType<? extends Mob>)EntityType.f_20497_, 3));
        summonPool.add(new SummonCandidate((EntityType<? extends Mob>)EntityType.f_20531_, 2));
        summonPool.add(new SummonCandidate((EntityType<? extends Mob>)((EntityType)EntityInit.SKELETON_ASSASSIN.get()), 5));
        summonPool.add(new SummonCandidate((EntityType<? extends Mob>)((EntityType)EntityInit.HULKING_ZOMBIE.get()), 10));
        for (int summonPower = 0; summonPower < desiredSummonPower; summonPower += next.weight) {
            int delta = desiredSummonPower - summonPower;
            List filtered = summonPool.stream().filter(s -> s.weight <= delta).sorted((a, b) -> a.weight - b.weight).collect(Collectors.toList());
            if (filtered.size() == 0) break;
            next = (SummonCandidate)filtered.get(filtered.size() - 1);
            this.summonQueue.add(next.type);
        }
    }

    private void createSummon() {
        if (this.summonQueue.size() == 0) {
            return;
        }
        BlockPos center = this.m_20183_();
        boolean found = false;
        int yCount = 0;
        while (!found) {
            while (yCount < 10 && this.m_9236_().m_46859_(center)) {
                center = center.m_7495_();
                ++yCount;
            }
            center = center.m_7494_();
            if (this.m_9236_().m_46859_(center)) {
                found = true;
                continue;
            }
            center = this.m_20183_().m_7918_(-5 + (int)(Math.random() * 10.0), 0, -5 + (int)(Math.random() * 10.0));
        }
        if (!found) {
            center = this.m_20183_();
        }
        EntityType<? extends Mob> type = this.summonQueue.get(0);
        this.summonQueue.remove(0);
        Mob summon = (Mob)type.m_20615_(this.m_9236_());
        SummonUtils.setSummon(summon, (LivingEntity)this, Integer.MAX_VALUE);
        byte phase = (Byte)this.f_19804_.m_135370_(SHIELD_COUNT);
        float pctHealthBoost = 1.0f + Math.abs(0.2f * (float)(5 - phase));
        float armorBoost = 2 + 2 * (5 - phase);
        summon.m_21051_(Attributes.f_22284_).m_22125_(new AttributeModifier("wither_lich_summon_armorboost", (double)armorBoost, AttributeModifier.Operation.ADDITION));
        summon.m_21051_(Attributes.f_22276_).m_22125_(new AttributeModifier("wither_lich_summon_healthboost", (double)pctHealthBoost, AttributeModifier.Operation.MULTIPLY_TOTAL));
        summon.m_21153_(summon.m_21233_());
        switch (phase) {
            case 4: {
                summon.m_7292_(new MobEffectInstance(MobEffects.f_19606_, Integer.MAX_VALUE));
                break;
            }
            case 3: {
                summon.m_7292_(new MobEffectInstance(MobEffects.f_19606_, Integer.MAX_VALUE));
                summon.m_7292_(new MobEffectInstance(MobEffects.f_19605_, Integer.MAX_VALUE));
                break;
            }
            case 2: {
                summon.m_7292_(new MobEffectInstance(MobEffects.f_19606_, Integer.MAX_VALUE, 1));
                summon.m_7292_(new MobEffectInstance(MobEffects.f_19605_, Integer.MAX_VALUE));
                break;
            }
            case 0: 
            case 1: {
                summon.m_7292_(new MobEffectInstance(MobEffects.f_19606_, Integer.MAX_VALUE, 2));
                summon.m_7292_(new MobEffectInstance(MobEffects.f_19605_, Integer.MAX_VALUE, 1));
                summon.m_7292_(new MobEffectInstance(MobEffects.f_19600_, Integer.MAX_VALUE));
            }
        }
        summon.m_146884_(Vec3.m_82539_((Vec3i)center));
        this.m_9236_().m_7967_((Entity)summon);
        SummonUtils.addTrackedEntity((LivingEntity)this, (Entity)summon);
        ++this.numSummons;
    }

    private void decrementShield() {
        this.shouldShieldedStrike = false;
        this.f_19804_.m_135381_(SHIELD_COUNT, (Object)((byte)MathUtils.clamp((Byte)this.f_19804_.m_135370_(SHIELD_COUNT) - 1, 0, 5)));
        this.setCooldown(1024, 0);
    }

    public boolean damageEntity(Entity entityIn) {
        SpellCastingResult success = SpellCaster.Affect(this.melee, this.meleeSpell, this.m_9236_(), new SpellSource((LivingEntity)this, InteractionHand.MAIN_HAND), new SpellTarget(entityIn));
        if (success.getCode().isConsideredSuccess()) {
            if (this.f_19796_.m_188501_() < 0.4f && entityIn instanceof Mob) {
                ((Mob)entityIn).m_6710_((LivingEntity)this);
            }
            return true;
        }
        return false;
    }

    private void spellCastReset() {
        this.setAttackAction(AttackAction.NONE);
        this.setAction(Action.IDLE);
        this.globalSpellCooldown = 10 + (int)(Math.random() * 30.0);
    }

    private boolean spellCastPrecast(BossMonster<?> me) {
        this.setAction(Action.ATTACKING);
        this.setAttackAction(Math.random() < 0.5 ? AttackAction.CAST_1_LEFT : AttackAction.CAST_1_RIGHT);
        this.m_5496_(SFX.Entity.WitherLich.CAST, 1.0f, 0.8f + (float)(Math.random() * 0.4));
        return true;
    }

    private boolean spellCastPredicate(Entity target) {
        return this.getAction() == Action.IDLE && this.globalSpellCooldown == 0 && this.m_5448_() != null && this.m_5448_().m_6084_();
    }

    public void decrementSummons() {
        --this.numSummons;
        if (this.numSummons <= 0) {
            this.shouldShieldedStrike = true;
            this.numSummons = 0;
        }
    }

    public Vec3 getLookVector() {
        return Vec3.m_82498_((float)this.m_146909_(), (float)this.m_6080_()).m_82541_();
    }

    private int getPowerWordDeathTime() {
        return 1200 * Math.max(((Byte)this.f_19804_.m_135370_(SHIELD_COUNT)).byteValue(), 1);
    }

    private Action getAction() {
        int ordinal = (this.getStateFlag() & 0x7F8) >> 3 & 0xFF;
        if (ordinal >= Action.values().length) {
            return Action.IDLE;
        }
        return Action.values()[ordinal];
    }

    private AttackAction getAttackAction() {
        int ordinal = (this.getStateFlag() & 0xFFFF) >> 12 & 0xF;
        if (ordinal >= AttackAction.values().length) {
            return AttackAction.NONE;
        }
        return AttackAction.values()[ordinal];
    }

    public int getTextureVariant() {
        return ((Byte)this.f_19804_.m_135370_(TEXTURE_VARIANT)).byteValue();
    }

    public WitherLich setFactionJoin(Player player, Vec3 start, Vec3 end, int lerpTicks) {
        this.cachedPlayer = player;
        this.f_19804_.m_135381_(FACTION_JOIN_PLAYER, Optional.of(player.m_36316_().getId()));
        this.f_19804_.m_135381_(IS_JOINING, (Object)true);
        this.hideBossBar();
        this.setAction(Action.FJ_CONVERTING);
        this.start = new Vector3(start.f_82479_, start.f_82480_, start.f_82481_);
        this.end = new Vector3(end.f_82479_, end.f_82480_, end.f_82481_);
        this.lerpTicks = lerpTicks;
        this.powerWordDeathTicks = 0;
        return this;
    }

    private void setAction(Action action) {
        byte ordinal = (byte)((action.ordinal() & 0xFF) << 3);
        int flag = this.getStateFlag();
        flag &= 0xFFFFF807;
        this.setState(flag |= ordinal);
    }

    private void setAttackAction(AttackAction action) {
        int ordinal = (action.ordinal() & 0xF) << 12;
        int flag = this.getStateFlag();
        flag &= 0xFFFF0FFF;
        this.setState(flag |= ordinal);
    }

    @Override
    public void m_8119_() {
        if (!this.m_6084_()) {
            this.setAction(Action.DEATH);
        }
        if (this.powerWordDeathTicks > 0 && this.powerWordDeathTicks < this.getPowerWordDeathTime()) {
            ++this.powerWordDeathTicks;
        }
        if (this.globalSpellCooldown > 0) {
            --this.globalSpellCooldown;
        }
        this.m_20242_(true);
        super.m_8119_();
        if (!this.m_9236_().m_5776_() && this.getAction() == Action.FJ_CONVERTING) {
            if (this.getFactionJoinPlayer() == null) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
                return;
            }
            ++this.lerpCount;
            if (this.lerpCount <= this.lerpTicks) {
                float pct = (float)this.lerpCount / (float)this.lerpTicks;
                Vector3 pos = Vector3.lerp(this.start, this.end, pct);
                this.m_6034_(pos.x, pos.y, pos.z);
                if (this.lerpCount < 20) {
                    this.m_7618_(EntityAnchorArgument.Anchor.FEET, this.end.toVec3D());
                }
            } else {
                this.f_19804_.m_135381_(REACHING, (Object)true);
                if (this.lerpCount - this.lerpTicks > this.finishTicks) {
                    this.m_142687_(Entity.RemovalReason.DISCARDED);
                }
            }
            return;
        }
        float pctHeal = 0.2f * (float)((Byte)this.f_19804_.m_135370_(SHIELD_COUNT)).byteValue();
        if (pctHeal > 0.0f && this.m_21223_() < this.m_21233_() * pctHeal) {
            this.m_5634_(2.5f);
        }
        if (!this.m_9236_().m_5776_() && this.m_9236_().m_46467_() % 100L == 0L && this.getAction() != Action.SUMMON) {
            int summons = (int)SummonUtils.getSummons((LivingEntity)this).stream().filter(e -> !(e instanceof InsectSwarm)).count();
            while (this.numSummons > summons) {
                this.decrementSummons();
            }
            this.numSummons = summons;
            if (this.numSummons == 0) {
                this.setCooldown(1024, 0);
            }
        }
        if (this.m_5448_() != null && !this.m_5448_().m_6084_()) {
            this.m_6710_(null);
        }
    }

    protected void m_8099_() {
        double moveSpeed = this.m_21133_(Attributes.f_22279_);
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new WitherLichFly());
        this.f_21345_.m_25352_(1, (Goal)new ShieldedStrikeGoal());
        this.f_21345_.m_25352_(2, (Goal)new SummonMinionsGoal());
        this.f_21345_.m_25352_(2, (Goal)new PowerWordDeathGoal());
        ItemStack frostBolt = new ItemStack((ItemLike)ItemInit.SPELL.get());
        SpellRecipe frostBoltSpell = new SpellRecipe();
        frostBoltSpell.setShape(Shapes.PROJECTILE);
        frostBoltSpell.addComponent(Components.FROST_DAMAGE);
        ((ModifiedSpellPart)frostBoltSpell.getComponent(0)).setValue(Attribute.DAMAGE, 20.0f);
        frostBoltSpell.addComponent(Components.SLOW);
        ((ModifiedSpellPart)frostBoltSpell.getComponent(1)).setValue(Attribute.DURATION, 10.0f);
        ((ModifiedSpellPart)frostBoltSpell.getComponent(1)).setValue(Attribute.MAGNITUDE, 2.0f);
        frostBoltSpell.writeToNBT(frostBolt.m_41784_());
        ItemStack witherBolt = new ItemStack((ItemLike)ItemInit.SPELL.get());
        SpellRecipe witherBoltSpell = new SpellRecipe();
        witherBoltSpell.setShape(Shapes.BOLT);
        ((ModifiedSpellPart)witherBoltSpell.getShape()).setValue(Attribute.RANGE, 24.0f);
        witherBoltSpell.addComponent(Components.WITHER);
        ((ModifiedSpellPart)witherBoltSpell.getComponent(0)).setValue(Attribute.DURATION, 10.0f);
        ((ModifiedSpellPart)witherBoltSpell.getComponent(0)).setValue(Attribute.MAGNITUDE, 3.0f);
        witherBoltSpell.writeToNBT(witherBolt.m_41784_());
        ItemStack fossilizeBolt = new ItemStack((ItemLike)ItemInit.SPELL.get());
        SpellRecipe fossilizeSpell = new SpellRecipe();
        fossilizeSpell.setShape(Shapes.CHAIN);
        ((ModifiedSpellPart)fossilizeSpell.getShape()).setValue(Attribute.RANGE, 32.0f);
        ((ModifiedSpellPart)fossilizeSpell.getShape()).setValue(Attribute.RADIUS, 10.0f);
        ((ModifiedSpellPart)fossilizeSpell.getShape()).setValue(Attribute.MAGNITUDE, 100.0f);
        fossilizeSpell.addComponent(Components.FOSSILIZE);
        ((ModifiedSpellPart)fossilizeSpell.getComponent(0)).setValue(Attribute.DURATION, 10.0f);
        fossilizeSpell.writeToNBT(fossilizeBolt.m_41784_());
        ItemStack insectSwarm = new ItemStack((ItemLike)ItemInit.SPELL.get());
        SpellRecipe insectSwarmSpell = new SpellRecipe();
        insectSwarmSpell.setShape(Shapes.SELF);
        insectSwarmSpell.addComponent(Components.INSECT_SWARM);
        insectSwarmSpell.writeToNBT(insectSwarm.m_41784_());
        this.f_21345_.m_25352_(4, (Goal)new BossMonster.CastSpellAtTargetGoal(witherBolt, moveSpeed, 400, 20.0f, 0.0f, true, 1026, 8, 12, null, this::spellCastReset, this::spellCastPrecast).setUsePredicate(this::spellCastPredicate));
        this.f_21345_.m_25352_(4, (Goal)new BossMonster.CastSpellAtTargetGoal(fossilizeBolt, moveSpeed, 400, 26.0f, 0.0f, true, 1027, 8, 12, null, this::spellCastReset, this::spellCastPrecast).setUsePredicate(this::spellCastPredicate));
        this.f_21345_.m_25352_(5, (Goal)new BossMonster.CastSpellAtTargetGoal(frostBolt, moveSpeed, 60, 64.0f, 0.0f, true, 1025, 8, 12, null, this::spellCastReset, this::spellCastPrecast).setUsePredicate(this::spellCastPredicate));
        this.f_21345_.m_25352_(3, (Goal)new BossMonster.CastSpellAtTargetGoal(insectSwarm, moveSpeed, 800, 20.0f, 0.0f, false, 1028, 20, 55, null, this::spellCastReset, me -> {
            this.setAction(Action.ATTACKING);
            this.setAttackAction(AttackAction.BREATH_INSECTS);
            this.m_5496_(SFX.Entity.WitherLich.BREATH_ATTACK, 1.0f, 0.8f + (float)(Math.random() * 0.4));
            return true;
        }).setUninterruptable().setUsePredicate(this::spellCastPredicate));
        this.f_21345_.m_25352_(3, (Goal)new BossMonster.CastSpellAtTargetGoal(frostBolt, moveSpeed, 600, 20.0f, 0.0f, false, 1029, 20, 55, null, this::spellCastReset, me -> {
            this.setAction(Action.ATTACKING);
            this.setAttackAction(AttackAction.BREATH_FROST);
            this.m_5496_(SFX.Entity.WitherLich.BREATH_ATTACK, 1.0f, 0.8f + (float)(Math.random() * 0.4));
            int initialDelay = 10;
            int interval = 20;
            for (int i = 0; i < 3; ++i) {
                int delay = initialDelay + i * interval;
                this.setTimer("frost_breath", delay, () -> EntityUtil.getEntitiesWithinCone(this.m_9236_(), this.m_20182_(), this.getLookVector(), 20.0f, -60.0f, 60.0f, e -> e != this && (!SummonUtils.isSummon((Entity)e) || SummonUtils.getSummoner(e) != this)).forEach(e -> e.m_6469_(DamageHelper.createSourcedType(DamageHelper.FROST, this.m_9236_().m_9598_(), (Entity)this), 15.0f)));
            }
            return false;
        }).setUninterruptable().setUsePredicate(this::spellCastPredicate));
        this.f_21345_.m_25352_(7, (Goal)new MeleeAttackGoal((PathfinderMob)this, moveSpeed, true));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new BossMonster.ThreatTableHurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, le -> true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 10, true, false, e -> e instanceof IFactionEnemy && ((IFactionEnemy)e).getFaction() != this.getFaction()));
    }

    @Override
    public boolean m_6469_(DamageSource type, float amount) {
        float healthTarget;
        if (type.m_269533_(DamageTypeTags.f_268419_) || type.m_269533_(DamageTypeTags.f_268549_) || type.m_276093_(DamageTypes.f_268441_) || type.m_276093_(DamageTypes.f_268493_) || type.m_276093_(DamageTypes.f_268612_) || type.m_276093_(DamageTypes.f_268576_)) {
            return false;
        }
        if (!type.m_276093_(DamageTypes.f_268724_) && (healthTarget = 0.2f * (float)((Byte)this.f_19804_.m_135370_(SHIELD_COUNT) - 1)) > 0.0f && this.m_21223_() - amount < this.m_21233_() * healthTarget) {
            if (this.numSummons == 0) {
                this.setCooldown(1024, 0);
            } else {
                amount = this.m_21223_() - healthTarget;
            }
        }
        return super.m_6469_(type, amount);
    }

    @Override
    public void m_6667_(DamageSource pCause) {
        if (!pCause.m_276093_(DamageTypes.f_268724_) && (Byte)this.f_19804_.m_135370_(SHIELD_COUNT) > 0) {
            this.m_21153_(1.0f);
            return;
        }
        this.m_20334_(0.0, 0.0, 0.0);
        this.setAction(Action.DEATH);
        this.setAttackAction(AttackAction.NONE);
        this.m_21219_();
        super.m_6667_(pCause);
    }

    protected void m_6153_() {
        ++this.lichDeathTime;
        if (this.lichDeathTime == 107) {
            if (!this.m_9236_().m_5776_()) {
                this.m_7292_(new MobEffectInstance((MobEffect)EffectInit.MIST_FORM.get(), 200));
            }
            this.f_19794_ = true;
        } else if (this.lichDeathTime > 120 && this.lichDeathTime <= 150) {
            this.m_20334_(0.0, 0.5, 0.0);
        } else if (this.lichDeathTime > 150) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHIELD_COUNT, (Object)5);
        this.f_19804_.m_135372_(TEXTURE_VARIANT, (Object)((byte)(Math.random() * 4.0)));
        this.f_19804_.m_135372_(FACTION_JOIN_PLAYER, Optional.empty());
        this.f_19804_.m_135372_(REACHING, (Object)false);
        this.f_19804_.m_135372_(IS_JOINING, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128344_("shieldCount", ((Byte)this.f_19804_.m_135370_(SHIELD_COUNT)).byteValue());
        nbt.m_128344_("textureVariant", ((Byte)this.f_19804_.m_135370_(TEXTURE_VARIANT)).byteValue());
        nbt.m_128405_("power_word_death", this.powerWordDeathTicks);
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128441_("shieldCount")) {
            this.f_19804_.m_135381_(SHIELD_COUNT, (Object)nbt.m_128445_("shieldCount"));
        }
        if (nbt.m_128441_("textureVariant")) {
            this.f_19804_.m_135381_(TEXTURE_VARIANT, (Object)nbt.m_128445_("textureVariant"));
        }
        if (nbt.m_128441_("power_word_death")) {
            this.powerWordDeathTicks = nbt.m_128451_("power_word_death");
        }
        this.setAction(Action.IDLE);
        this.setAttackAction(AttackAction.NONE);
    }

    @Override
    protected void m_8024_() {
        super.m_8024_();
        if (this.powerWordDeathTicks > 0) {
            this.powerWordDeathBar.m_142711_((float)this.powerWordDeathTicks / (float)this.getPowerWordDeathTime());
        } else {
            this.powerWordDeathBar.m_8321_(false);
        }
    }

    @Override
    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        if (this.shouldShowBossBar()) {
            this.powerWordDeathBar.m_6543_(player);
        }
    }

    @Override
    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        if (this.shouldShowBossBar()) {
            this.powerWordDeathBar.m_6539_(player);
        }
    }

    public boolean m_7327_(Entity entityIn) {
        if (this.isOnCooldown(1) || this.getAction() != Action.IDLE) {
            return true;
        }
        ArrayList<AttackAction> actionPool = new ArrayList<AttackAction>();
        actionPool.add(AttackAction.SWING_LEFT);
        actionPool.add(AttackAction.SWING_RIGHT);
        AttackAction selected = (AttackAction)((Object)actionPool.get((int)((double)actionPool.size() * Math.random())));
        this.setAction(Action.ATTACKING);
        this.setAttackAction(selected);
        this.m_5496_(SFX.Entity.Odin.ATTACK, 1.0f, (float)(0.6 + Math.random() * 0.8));
        this.m_5496_(SFX.Entity.WitherLich.ATTACK, 1.0f, (float)(0.6 + Math.random() * 0.8));
        this.setTimer("", selected.animLength, () -> this.damageEntity(entityIn));
        this.setTimer("resetattack", selected.resetTime, () -> {
            this.setAttackAction(AttackAction.NONE);
            this.setAction(Action.IDLE);
            this.setCooldown(1, 20);
        });
        return true;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SFX.Entity.WitherLich.HIT;
    }

    protected SoundEvent m_5592_() {
        return SFX.Entity.WitherLich.DEATH;
    }

    protected SoundEvent m_7515_() {
        return SFX.Entity.WitherLich.IDLE;
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    @Override
    protected PlayState handleAnimState(AnimationState<? extends BossMonster<?>> state) {
        RawAnimation builder = RawAnimation.begin();
        if (this.getAction() == Action.FJ_CONVERTING) {
            if (!((Boolean)this.f_19804_.m_135370_(REACHING)).booleanValue()) {
                builder.thenLoop("animation.WitherLich.move");
            } else {
                builder.thenPlay("animation.WitherLich.reach");
            }
            return state.setAndContinue(builder);
        }
        if (this.getAction() == Action.DEATH) {
            builder.thenPlay("animation.WitherLich.death");
        } else if (this.getAction() == Action.SHIELDED_STRIKE) {
            builder.thenPlay("animation.WitherLich.shielded_strike");
        } else if (this.getAction() == Action.POWER_WORD_DEATH) {
            builder.thenPlay("animation.WitherLich.point");
        } else if (this.getAction() == Action.SUMMON) {
            builder.thenPlay("animation.WitherLich.cast_2h_raise");
        } else if (this.getAction() == Action.ATTACKING) {
            switch (this.getAttackAction()) {
                case BREATH_FROST: 
                case BREATH_INSECTS: {
                    builder.thenLoop("animation.WitherLich.breath_attack");
                    break;
                }
                case CAST_1_LEFT: {
                    builder.thenPlay("animation.WitherLich.cast_1_left");
                    break;
                }
                case CAST_1_RIGHT: {
                    builder.thenPlay("animation.WitherLich.cast_1_right");
                    break;
                }
                case SWING_LEFT: {
                    builder.thenPlay("animation.WitherLich.cast_2_left");
                    break;
                }
                case SWING_RIGHT: {
                    builder.thenPlay("animation.WitherLich.cast_2_right");
                    break;
                }
                default: {
                    builder.thenLoop("animation.WitherLich.idle");
                    break;
                }
            }
        } else {
            double movementSpeed = this.m_20184_().m_82520_(0.0, -this.m_20184_().f_82480_, 0.0).m_82553_();
            if (movementSpeed > 0.2) {
                builder.thenLoop("animation.WitherLich.move");
            } else {
                builder.thenLoop("animation.WitherLich.idle");
            }
        }
        return state.setAndContinue(builder);
    }

    public static AttributeSupplier.Builder getGlobalAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 850.0).m_22268_(Attributes.f_22279_, (double)0.7f).m_22268_(Attributes.f_22277_, 40.0).m_22268_(Attributes.f_22284_, 14.0).m_22268_(Attributes.f_22281_, 20.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    @Override
    protected ServerBossEvent getBossEvent() {
        return this.bossEvent;
    }

    @Override
    public void setupSpawn() {
        this.setInvulnerableTicks(80);
        this.m_21153_(this.m_21233_() / 3.0f);
    }

    @Override
    protected void spawnParticles() {
        if (this.getAttackAction() == AttackAction.BREATH_FROST) {
            this.spawnConeParticles(new MAParticleType(((MAParticleType)((Object)ParticleInit.FROST.get())).setScale(0.2f)), 25);
        } else if (this.getAttackAction() == AttackAction.BREATH_INSECTS) {
            this.spawnConeParticles(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.BLUE_SPARKLE_VELOCITY.get())).setColor(69, 66, 30), 10);
        }
    }

    private void spawnConeParticles(MAParticleType particle, int count) {
        Vec3 forward = Vec3.m_82498_((float)this.m_146909_(), (float)this.m_6080_()).m_82490_(0.25);
        Vec3 origin = this.m_20182_().m_82520_(forward.f_82479_, forward.f_82480_ + 1.5, forward.f_82481_);
        for (int i = 0; i < count; ++i) {
            Vector3f direction = new Vector3f((float)forward.f_82479_, (float)forward.f_82480_, (float)forward.f_82481_);
            direction.rotate((Quaternionfc)Axis.f_252436_.m_252977_((float)(-15 + (int)(Math.random() * 30.0))));
            direction.rotate((Quaternionfc)Axis.f_252393_.m_252977_((float)(-15 + (int)(Math.random() * 30.0))));
            direction.normalize();
            direction.mul((float)(0.5 + Math.random()));
            this.m_9236_().m_7106_((ParticleOptions)particle, origin.f_82479_ + (double)direction.x(), origin.f_82480_ + (double)direction.y(), origin.f_82481_ + (double)direction.z(), (double)direction.x(), (double)direction.y(), (double)direction.z());
        }
    }

    @Override
    public ResourceLocation getArenaStructureID() {
        return RLoc.create("faction/boss/cathedral");
    }

    @Override
    public int getArenaStructureSegment() {
        return 2;
    }

    @Override
    public HashMap<String, Integer> getDamageResists() {
        return Maps.newHashMap();
    }

    @Override
    public IFaction getFaction() {
        return Factions.UNDEAD;
    }

    @Override
    public Player getRaidTarget() {
        return null;
    }

    @Override
    public int getTier() {
        return 3;
    }

    @Override
    public void setRaidTarget(Player player) {
    }

    @Override
    public void setTier(int tier) {
    }

    static class MoveHelperController
    extends MoveControl {
        private final WitherLich parentEntity;
        private int courseChangeCooldown;

        public MoveHelperController(WitherLich lich) {
            super((Mob)lich);
            this.parentEntity = lich;
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                float minMoveSpeed = 0.1f;
                float maxMoveSpeed = 0.6f;
                Vec3 v = new Vec3(this.f_24975_, this.f_24976_, this.f_24977_);
                double distSqr = v.m_82557_(this.parentEntity.m_20182_());
                if (distSqr < 16.0) {
                    double pct = distSqr / 16.0;
                    this.f_24978_ = MathUtils.lerpf(minMoveSpeed, maxMoveSpeed, (float)pct);
                    this.parentEntity.m_20256_(this.parentEntity.m_20184_().m_82490_(pct));
                    if (this.parentEntity.m_5448_() != null) {
                        this.parentEntity.m_7618_(EntityAnchorArgument.Anchor.FEET, this.parentEntity.m_5448_().m_146892_());
                    }
                } else {
                    this.f_24978_ = maxMoveSpeed;
                }
                if (this.courseChangeCooldown-- <= 0) {
                    this.courseChangeCooldown += this.parentEntity.m_217043_().m_188503_(5) + 2;
                    Vec3 vector3d = new Vec3(this.f_24975_ - this.parentEntity.m_20185_(), this.f_24976_ - this.parentEntity.m_20186_(), this.f_24977_ - this.parentEntity.m_20189_());
                    double d0 = vector3d.m_82553_();
                    if (this.isCollided(vector3d = vector3d.m_82541_(), Mth.m_14165_((double)d0))) {
                        this.parentEntity.m_20256_(this.parentEntity.m_20184_().m_82549_(vector3d.m_82490_(0.1)));
                    } else {
                        this.f_24981_ = MoveControl.Operation.WAIT;
                    }
                }
            }
        }

        private boolean isCollided(Vec3 p_220673_1_, int p_220673_2_) {
            AABB axisalignedbb = this.parentEntity.m_20191_();
            for (int i = 1; i < p_220673_2_; ++i) {
                axisalignedbb = axisalignedbb.m_82383_(p_220673_1_);
                if (this.parentEntity.m_9236_().m_45756_((Entity)this.parentEntity, axisalignedbb)) continue;
                return false;
            }
            return true;
        }
    }

    class SummonCandidate {
        public final EntityType<? extends Mob> type;
        public final int weight;

        public SummonCandidate(EntityType<? extends Mob> type, int weight) {
            this.type = type;
            this.weight = weight;
        }
    }

    public static enum AttackAction {
        NONE(0, 0),
        CAST_1_LEFT(10, 14),
        CAST_1_RIGHT(10, 14),
        SWING_LEFT(4, 8),
        SWING_RIGHT(4, 8),
        BREATH_FROST(48, 54),
        BREATH_INSECTS(48, 54);

        public final int animLength;
        public final int resetTime;

        private AttackAction(int animLength, int resetTime) {
            this.animLength = animLength;
            this.resetTime = resetTime;
        }
    }

    public static enum Action {
        IDLE,
        FJ_CONVERTING,
        ATTACKING,
        POWER_WORD_DEATH,
        SUMMON,
        SHIELDED_STRIKE,
        DEATH;

    }

    class WitherLichFly
    extends Goal {
        public WitherLichFly() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            MoveControl movementcontroller = WitherLich.this.m_21566_();
            if (!movementcontroller.m_24995_()) {
                return true;
            }
            if (WitherLich.this.m_5448_() == null) {
                double d2;
                double d1;
                double d0 = movementcontroller.m_25000_() - WitherLich.this.m_20185_();
                double d3 = d0 * d0 + (d1 = movementcontroller.m_25001_() - WitherLich.this.m_20186_()) * d1 + (d2 = movementcontroller.m_25002_() - WitherLich.this.m_20189_()) * d2;
                return d3 < 4.0 || d3 > 3600.0;
            }
            double dist = WitherLich.this.m_5448_().m_20280_((Entity)WitherLich.this);
            return !WitherLich.this.m_21574_().m_148306_((Entity)WitherLich.this.m_5448_()) || dist > 400.0;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8056_() {
            if (WitherLich.this.m_5448_() != null) {
                Vec3 direction = WitherLich.this.m_20182_().m_82546_(WitherLich.this.m_5448_().m_20182_()).m_82541_();
                direction = direction.m_82520_(0.0, -direction.f_82480_, 0.0);
                Vec3 offset = direction.m_82490_(10.0);
                Vec3 target = WitherLich.this.m_5448_().m_20182_().m_82549_(offset);
                if (WitherLich.this.m_5448_().m_20096_()) {
                    target = target.m_82520_(0.0, 1.5, 0.0);
                }
                WitherLich.this.m_21566_().m_6849_(target.f_82479_, target.f_82480_, target.f_82481_, 1.0);
            }
        }
    }

    class ShieldedStrikeGoal
    extends Goal {
        private int tickCount = 0;

        ShieldedStrikeGoal() {
        }

        public boolean m_8036_() {
            return WitherLich.this.shouldShieldedStrike || WitherLich.this.getAction() == Action.SHIELDED_STRIKE;
        }

        public boolean m_8045_() {
            return this.m_8036_() && this.tickCount < 33;
        }

        public boolean m_6767_() {
            return false;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8056_() {
            this.tickCount = 0;
            WitherLich.this.setAction(Action.SHIELDED_STRIKE);
        }

        public void m_8041_() {
            WitherLich.this.setAttackAction(AttackAction.NONE);
            WitherLich.this.setAction(Action.IDLE);
            WitherLich.this.powerWordDeathTicks = 1;
        }

        public void m_8037_() {
            ++this.tickCount;
            if (this.tickCount == 5) {
                WitherLich.this.decrementShield();
            }
        }
    }

    class SummonMinionsGoal
    extends Goal {
        private static final int DURATION = 62;
        private int tickCount = 0;
        private int summonInterval = 1;

        SummonMinionsGoal() {
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8036_() {
            boolean noSummons = WitherLich.this.numSummons == 0;
            boolean offCooldown = !WitherLich.this.isOnCooldown(1024);
            boolean isIdle = WitherLich.this.getAction() == Action.IDLE || WitherLich.this.getAction() == Action.SUMMON;
            return noSummons && offCooldown && isIdle;
        }

        public boolean m_6767_() {
            return false;
        }

        public boolean m_8045_() {
            return WitherLich.this.getAction() == Action.SUMMON || this.tickCount < 62;
        }

        public void m_8056_() {
            WitherLich.this.setAction(Action.SUMMON);
            WitherLich.this.buildSummonList();
            this.summonInterval = Math.max(62 / WitherLich.this.summonQueue.size(), 1);
            WitherLich.this.m_5496_(SFX.Entity.WitherLich.SUMMON, 1.0f, 1.0f);
        }

        public void m_8041_() {
            WitherLich.this.setCooldown(1024, Integer.MAX_VALUE);
            WitherLich.this.setAttackAction(AttackAction.NONE);
            WitherLich.this.setAction(Action.IDLE);
            this.tickCount = 0;
        }

        public void m_8037_() {
            ++this.tickCount;
            if (this.tickCount % this.summonInterval == 0) {
                WitherLich.this.createSummon();
            }
            if (this.tickCount > 62) {
                this.m_8041_();
            }
        }
    }

    class PowerWordDeathGoal
    extends Goal {
        private int tickCount = 0;
        private LivingEntity target = null;

        public PowerWordDeathGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_6767_() {
            return false;
        }

        public boolean m_8036_() {
            return WitherLich.this.powerWordDeathTicks >= WitherLich.this.getPowerWordDeathTime() && WitherLich.this.m_5448_() != null;
        }

        public boolean m_8045_() {
            boolean hasTarget = this.target != null;
            boolean timer = this.tickCount < 80;
            return hasTarget && timer;
        }

        public void m_8056_() {
            WitherLich.this.m_21573_().m_26573_();
            WitherLich.this.setAction(Action.POWER_WORD_DEATH);
            this.target = WitherLich.this.m_5448_();
            WitherLich.this.m_5496_(SFX.Entity.WitherLich.PW_DEATH, 1.0f, 1.0f);
        }

        public void m_8041_() {
            this.tickCount = 1;
            WitherLich.this.powerWordDeathTicks = 1;
            WitherLich.this.setAction(Action.IDLE);
            WitherLich.this.setAttackAction(AttackAction.NONE);
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            ++this.tickCount;
            WitherLich.this.setAction(Action.POWER_WORD_DEATH);
            WitherLich.this.m_7618_(EntityAnchorArgument.Anchor.FEET, this.target.m_146892_());
            if (this.tickCount == 44) {
                this.target.m_6469_(DamageHelper.createSourcedType((ResourceKey<DamageType>)DamageTypes.f_268724_, WitherLich.this.m_9236_().m_9598_(), (Entity)WitherLich.this), this.target.m_21233_() * 0.9f);
            }
        }
    }
}

