/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.boss.attacks;

import com.mna.api.capabilities.IPlayerProgression;
import com.mna.api.entities.DamageHelper;
import com.mna.api.entities.IFactionEnemy;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.api.sound.SFX;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.mna.entities.EntityInit;
import com.mna.entities.boss.Odin;
import com.mna.entities.boss.attacks.ThrownWeapon;
import com.mna.items.ItemInit;
import com.mna.tools.InventoryUtilities;
import com.mna.tools.SummonUtils;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class ThrownAllfatherAxe
extends ThrownWeapon {
    private static final EntityDataAccessor<Byte> IS_RETURNING = SynchedEntityData.m_135353_(ThrownAllfatherAxe.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    public static final ItemStack renderStack = new ItemStack((ItemLike)ItemInit.ALLFATHER_AXE.get());
    private CompoundTag itemData;

    public ThrownAllfatherAxe(EntityType<? extends AbstractHurtingProjectile> type, Level world) {
        super(type, world);
        this.setRenderStack(renderStack);
        this.setTrailParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FROST.get())).setMaxAge(0));
    }

    public ThrownAllfatherAxe(LivingEntity shooter, Level worldIn, CompoundTag data) {
        this(worldIn, shooter.m_20185_(), shooter.m_20188_() - (double)0.1f, shooter.m_20189_());
        this.m_5602_((Entity)shooter);
        this.itemData = data;
    }

    public ThrownAllfatherAxe(Level worldIn, double x, double y, double z) {
        super((EntityType<? extends AbstractHurtingProjectile>)((EntityType)EntityInit.ALLFATHER_AXE.get()), worldIn);
        this.m_6034_(x, y, z);
        this.m_20242_(true);
        this.setRenderStack(renderStack);
        this.setTrailParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FROST.get())).setMaxAge(0));
    }

    @Override
    public void m_6686_(double x, double y, double z, float velocity, float inaccuracy) {
        Vec3 Vector3d = new Vec3(x, y, z).m_82541_().m_82490_((double)velocity);
        this.m_20256_(Vector3d);
        double f = Vector3d.m_165924_();
        this.m_146922_((float)(Mth.m_14136_((double)Vector3d.f_82479_, (double)Vector3d.f_82481_) * 57.2957763671875));
        this.m_146926_((float)(Mth.m_14136_((double)Vector3d.f_82480_, (double)f) * 57.2957763671875));
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
    }

    public void m_7334_(Entity pEntity) {
        if (pEntity == this.m_19749_()) {
            this.handleHitOwner((LivingEntity)pEntity);
        }
        super.m_7334_(pEntity);
    }

    @Override
    protected void m_5790_(EntityHitResult ray) {
        Entity hitEntity = ray.m_82443_();
        if (!this.isValidEntity(hitEntity)) {
            return;
        }
        LivingEntity livingHit = (LivingEntity)hitEntity;
        Entity eOwner = this.m_19749_();
        if (!(eOwner instanceof LivingEntity)) {
            return;
        }
        if (livingHit == eOwner) {
            this.handleHitOwner(livingHit);
            return;
        }
        livingHit.m_6469_(DamageHelper.createSourcedType(DamageHelper.FROST, this.m_9236_().m_9598_(), this.m_19749_()), 15.0f);
        livingHit.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 2, 100));
    }

    private boolean handleHitOwner(LivingEntity livingHit) {
        if (this.m_9236_().m_5776_() || !this.isReturning()) {
            return false;
        }
        ItemStack returnStack = new ItemStack((ItemLike)ItemInit.ALLFATHER_AXE.get());
        returnStack.m_41751_(this.itemData);
        if (livingHit instanceof Player) {
            InventoryUtilities.removeItemFromInventory(new ItemStack((ItemLike)ItemInit.ALLFATHER_AXE_CONTROL.get()), true, false, (IItemHandler)new InvWrapper((Container)((Player)livingHit).m_150109_()));
            if (((Player)livingHit).m_36356_(returnStack)) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            } else {
                this.drop();
            }
        } else if (livingHit instanceof Odin) {
            ((Odin)livingHit).showAxe();
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        } else {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        return true;
    }

    @Override
    protected void m_8060_(BlockHitResult ray) {
    }

    protected void m_6763_(BlockState state) {
        BlockState blockstate = this.m_9236_().m_8055_(this.m_20183_());
        if (blockstate.m_60734_() == Blocks.f_49990_) {
            this.m_9236_().m_7731_(this.m_20183_(), Blocks.f_50126_.m_49966_(), 3);
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(IS_RETURNING, (Object)0);
    }

    @Override
    public void m_8119_() {
        int returnTicks;
        Entity owner = this.m_19749_();
        if (owner == null || !owner.m_6084_()) {
            this.drop();
            return;
        }
        int n = returnTicks = owner instanceof Player ? 40 : 20;
        if (this.f_19797_ >= returnTicks && !this.isReturning()) {
            this.setReturning();
        }
        if (this.isReturning()) {
            this.m_20256_(owner.m_20182_().m_82520_(0.0, 1.0, 0.0).m_82546_(this.m_20182_()).m_82541_());
        }
        if (this.m_9236_().m_5776_()) {
            Vec3 dm = this.m_20184_();
            this.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FROST.get())).setScale(0.05f).setGravity(0.01f).setPhysics(true), this.m_20185_() + Math.random() * dm.f_82479_, this.m_20186_() + Math.random() * dm.f_82480_, this.m_20189_() + Math.random() * dm.f_82481_, 0.0, 0.0, 0.0);
        }
        if (this.f_19803_) {
            this.m_5496_(SFX.Spell.Cast.ICE, 0.05f, 1.0f);
            this.m_5496_(SFX.Entity.SkeletonAssassin.BOLO_THROW, 0.75f, 0.5f);
        }
        super.m_8119_();
    }

    @Override
    protected float m_6884_() {
        return 0.95f;
    }

    @Override
    public boolean m_6469_(DamageSource p_70097_1_, float p_70097_2_) {
        return false;
    }

    private void drop() {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        ItemEntity ie = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack((ItemLike)ItemInit.ALLFATHER_AXE.get()));
        ie.m_20256_(this.m_20184_());
        this.m_9236_().m_7967_((Entity)ie);
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    public boolean isReturning() {
        return (Byte)this.f_19804_.m_135370_(IS_RETURNING) == 1;
    }

    public void setReturning() {
        this.f_19804_.m_135381_(IS_RETURNING, (Object)1);
        this.f_36813_ = -this.f_36813_;
        this.f_36814_ = -this.f_36814_;
        this.f_36815_ = -this.f_36815_;
    }

    private boolean isValidEntity(Entity e) {
        LazyOptional op;
        if (!(e instanceof LivingEntity)) {
            return false;
        }
        Entity shooter = this.m_19749_();
        if (shooter == null) {
            return false;
        }
        if (!(shooter instanceof Player)) {
            return true;
        }
        Player player = (Player)shooter;
        if (SummonUtils.isSummon(e) && SummonUtils.getSummoner((LivingEntity)e) == player) {
            return false;
        }
        return !(e instanceof IFactionEnemy) || !(op = player.getCapability(PlayerProgressionProvider.PROGRESSION)).isPresent() || ((IFactionEnemy)e).getFaction() != ((IPlayerProgression)op.resolve().get()).getAlliedFaction();
    }

    @Override
    public void writeSpawnData(FriendlyByteBuf buffer) {
        super.writeSpawnData(buffer);
        if (this.m_19749_() != null) {
            buffer.writeInt(this.m_19749_().m_19879_());
        } else {
            buffer.writeInt(-1);
        }
    }

    @Override
    public void readSpawnData(FriendlyByteBuf additionalData) {
        super.readSpawnData(additionalData);
        int ownerID = additionalData.readInt();
        if (ownerID > -1) {
            Entity owner = this.m_9236_().m_6815_(ownerID);
            this.m_5602_(owner);
        }
    }

    @Override
    public boolean m_6087_() {
        return false;
    }

    public boolean m_20223_(CompoundTag nbt) {
        if (this.itemData != null) {
            nbt.m_128365_("itemData", (Tag)this.itemData);
        }
        return super.m_20223_(nbt);
    }

    public void m_20258_(CompoundTag nbt) {
        super.m_20258_(nbt);
        if (nbt.m_128441_("itemData")) {
            this.itemData = nbt.m_128469_("itemData");
        }
    }
}

