/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.constructs.ai;

import com.mna.Registries;
import com.mna.api.entities.construct.IConstruct;
import com.mna.api.entities.construct.ai.ConstructAITask;
import com.mna.blocks.BlockInit;
import com.mna.blocks.tileentities.ConstructWorkbenchTile;
import com.mna.entities.constructs.ai.base.ConstructTasks;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.AbstractGolem;

public class ConstructCommandReturnToTable
extends ConstructAITask<ConstructCommandReturnToTable> {
    public ConstructCommandReturnToTable(IConstruct<?> construct, ResourceLocation guiIcon) {
        super(construct, guiIcon);
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    @Override
    public boolean m_8036_() {
        AbstractGolem c = this.getConstructAsEntity();
        return this.hasMoveTarget() && this.construct != null && c.m_9236_().m_46749_(this.getMoveBlockTarget()) && c.m_9236_().m_8055_(this.getMoveBlockTarget()).m_60734_() == BlockInit.CONSTRUCT_WORKBENCH.get();
    }

    @Override
    public void m_8037_() {
        super.m_8037_();
        AbstractGolem c = this.getConstructAsEntity();
        if (c.m_20183_().m_123314_((Vec3i)this.getMoveBlockTarget(), 4.0)) {
            if (!c.m_9236_().m_5776_() && !this.construct.asEntity().m_213877_()) {
                ConstructWorkbenchTile table = (ConstructWorkbenchTile)c.m_9236_().m_7702_(this.getMoveBlockTarget());
                if (table != null) {
                    if (!table.getIsCrafting() && table.isEmpty()) {
                        this.construct.dropAllItems();
                        table.setConstructData(this.construct.getConstructData(), c.m_8077_() ? c.m_7770_().getString() : null);
                        c.m_142687_(Entity.RemovalReason.DISCARDED);
                    } else {
                        this.construct.setCurrentCommand(this.owner, ConstructTasks.STAY.instantiateTask(this.construct));
                        this.pushDiagnosticMessage(this.translate("mna.constructs.feedback.return_to_workbench_not_empty", new Object[0]));
                    }
                } else {
                    this.construct.setCurrentCommand(this.owner, ConstructTasks.STAY.instantiateTask(this.construct));
                    this.pushDiagnosticMessage(this.translate("mna.constructs.feedback.return_to_workbench_invalid", new Object[0]));
                }
            }
        } else {
            this.doMove();
        }
    }

    @Override
    public void m_8056_() {
        super.m_8056_();
        this.pushDiagnosticMessage(this.translate("mna.constructs.feedback.return_to_workbench", new Object[0]));
    }

    public void setTablePos(BlockPos pos) {
        this.setMoveTarget(pos);
    }

    @Override
    public ResourceLocation getType() {
        return Registries.ConstructTasks.get().getKey((Object)ConstructTasks.MODIFY);
    }

    @Override
    public ConstructCommandReturnToTable copyFrom(ConstructAITask<?> other) {
        if (other instanceof ConstructCommandReturnToTable) {
            this.setMoveTarget(((ConstructCommandReturnToTable)other).getMoveBlockTarget());
        }
        return this;
    }

    @Override
    public ConstructCommandReturnToTable duplicate() {
        return new ConstructCommandReturnToTable(this.construct, this.guiIcon).copyFrom((ConstructAITask)this);
    }

    @Override
    public void readNBT(CompoundTag nbt) {
        if (nbt.m_128441_("tablePos")) {
            this.setMoveTarget(NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("tablePos")));
        }
    }

    @Override
    public CompoundTag writeInternal(CompoundTag nbt) {
        if (this.getMoveBlockTarget() != null) {
            nbt.m_128365_("tablePos", (Tag)NbtUtils.m_129224_((BlockPos)this.getMoveBlockTarget()));
        }
        return nbt;
    }

    @Override
    public void inflateParameters() {
    }

    @Override
    public boolean isFullyConfigured() {
        return true;
    }
}

