/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.constructs.ai;

import com.mna.Registries;
import com.mna.api.entities.construct.IConstruct;
import com.mna.api.entities.construct.IConstructDiagnostics;
import com.mna.api.entities.construct.ai.ConstructAITask;
import com.mna.api.entities.construct.ai.parameter.ConstructAITaskParameter;
import com.mna.api.entities.construct.ai.parameter.ConstructTaskAreaParameter;
import com.mna.api.tools.MATags;
import com.mna.api.tools.RLoc;
import com.mna.entities.constructs.ai.base.ConstructTasks;
import com.mna.tools.math.MathUtils;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class ConstructWaterCrops
extends ConstructAITask<ConstructWaterCrops> {
    private static final int MAX_SIZE = 9;
    private static final int WAIT_TIME_PER_BLOCK = 5;
    private AABB waterArea = null;
    private boolean tooBig = false;
    private int waitTicks = 0;

    public ConstructWaterCrops(IConstruct<?> construct, ResourceLocation guiIcon) {
        super(construct, guiIcon);
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    @Override
    public boolean m_8036_() {
        if (this.tooBig) {
            this.pushDiagnosticMessage(this.translate("mna.constructs.feedback.area_too_big", 9, this.waterArea.m_82362_(), this.waterArea.m_82376_(), this.waterArea.m_82385_()), false);
            return false;
        }
        int blocks = this.AABBBlocks();
        int mbUsed = blocks * 100;
        if (this.construct.getStoredFluidAmount() < mbUsed) {
            this.pushDiagnosticMessage(this.translate("mna.constructs.feedback.not_enough_water", new Object[0]), false);
            return false;
        }
        return super.m_8036_();
    }

    @Override
    public void m_8056_() {
        super.m_8056_();
        this.waitTicks = 0;
    }

    @Override
    public void m_8041_() {
        super.m_8041_();
        this.waitTicks = 0;
        this.construct.resetActions();
    }

    @Override
    public void m_8037_() {
        super.m_8037_();
        if (this.waterArea == null) {
            this.pushDiagnosticMessage(this.translate("mna.constructs.feedback.water_crops_fail", new Object[0]), false);
            this.construct.resetActions();
            this.exitCode = 1;
            return;
        }
        this.construct.getDiagnostics().pushTaskUpdate(this.getId(), this.guiIcon, IConstructDiagnostics.Status.RUNNING, this.waterArea.m_82399_());
        this.setMoveTarget(BlockPos.m_274446_((Position)this.waterArea.m_82399_()));
        if (this.doMove()) {
            this.construct.setWatering();
            if (this.waitTicks++ > this.AABBBlocks() * 5) {
                this.completeTask();
                this.exitCode = 0;
            }
            return;
        }
    }

    private void completeTask() {
        AbstractGolem c = this.getConstructAsEntity();
        if (!c.m_9236_().m_46749_(BlockPos.m_274446_((Position)this.waterArea.m_82399_()))) {
            return;
        }
        int blocks = this.AABBBlocks();
        int mbUsed = blocks * 100;
        this.construct.drain(mbUsed, IFluidHandler.FluidAction.EXECUTE);
        for (int i = (int)this.waterArea.f_82288_; i <= (int)this.waterArea.f_82291_; ++i) {
            for (int j = (int)this.waterArea.f_82289_; j <= (int)this.waterArea.f_82292_; ++j) {
                for (int k = (int)this.waterArea.f_82290_; k <= (int)this.waterArea.f_82293_; ++k) {
                    boolean valid;
                    BlockPos pos = new BlockPos(i, j, k);
                    BlockState state = c.m_9236_().m_8055_(pos);
                    boolean no_age = MATags.isBlockIn(state.m_60734_(), RLoc.create("construct_harvestables_no_age"));
                    boolean bl = valid = no_age || MATags.isBlockIn(state.m_60734_(), RLoc.create("construct_harvestables"));
                    if (!valid) continue;
                    if (state.m_60734_().m_6724_(state)) {
                        state.m_60734_().m_213898_(state, (ServerLevel)c.m_9236_(), pos, c.m_9236_().m_213780_());
                    }
                    c.m_9236_().m_186460_(pos, state.m_60734_(), 1);
                }
            }
        }
        this.pushDiagnosticMessage(this.translate("mna.constructs.feedback.water_crops_success", new Object[0]), false);
        this.construct.resetActions();
    }

    @Override
    public ResourceLocation getType() {
        return Registries.ConstructTasks.get().getKey((Object)ConstructTasks.WATER);
    }

    @Override
    public ConstructWaterCrops duplicate() {
        return new ConstructWaterCrops(this.construct, this.guiIcon).copyFrom((ConstructAITask)this);
    }

    @Override
    public ConstructWaterCrops copyFrom(ConstructAITask<?> other) {
        if (other instanceof ConstructWaterCrops) {
            this.waterArea = ((ConstructWaterCrops)other).waterArea;
        }
        return this;
    }

    @Override
    public CompoundTag writeInternal(CompoundTag nbt) {
        if (this.waterArea != null) {
            nbt.m_128365_("blockPos1", (Tag)NbtUtils.m_129224_((BlockPos)BlockPos.m_274561_((double)this.waterArea.f_82288_, (double)this.waterArea.f_82289_, (double)this.waterArea.f_82290_)));
            nbt.m_128365_("blockPos2", (Tag)NbtUtils.m_129224_((BlockPos)BlockPos.m_274561_((double)this.waterArea.f_82291_, (double)this.waterArea.f_82292_, (double)this.waterArea.f_82293_)));
        }
        return nbt;
    }

    @Override
    public void readNBT(CompoundTag nbt) {
        if (nbt.m_128441_("blockPos1") && nbt.m_128441_("blockPos2")) {
            BlockPos blockPos1 = NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("blockPos1"));
            BlockPos blockPos2 = NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("blockPos2"));
            this.createBoundsFromCornerPositions(blockPos1, blockPos2);
        }
    }

    @Override
    public void inflateParameters() {
        this.getParameter("water_crops.area").ifPresent(param -> {
            if (param instanceof ConstructTaskAreaParameter) {
                this.waterArea = ((ConstructTaskAreaParameter)param).getArea();
            }
            if (this.waterArea == null || this.waterArea.m_82362_() > 9.0 || this.waterArea.m_82376_() > 9.0 || this.waterArea.m_82385_() > 9.0) {
                this.tooBig = true;
            }
        });
    }

    @Override
    protected List<ConstructAITaskParameter> instantiateParameters() {
        List<ConstructAITaskParameter> parameters = super.instantiateParameters();
        parameters.add(new ConstructTaskAreaParameter("water_crops.area"));
        return parameters;
    }

    private void createBoundsFromCornerPositions(BlockPos a, BlockPos b) {
        if (a != null && b != null) {
            this.waterArea = MathUtils.createInclusiveBB(a, b);
            if (this.waterArea.m_82362_() > 9.0 || this.waterArea.m_82376_() > 9.0 || this.waterArea.m_82385_() > 9.0) {
                this.tooBig = true;
            }
        }
    }

    private int AABBBlocks() {
        return (int)(this.waterArea.m_82362_() * this.waterArea.m_82385_()) - 1;
    }

    @Override
    public boolean isFullyConfigured() {
        return this.waterArea != null;
    }
}

