/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.constructs.ai.base;

import com.mna.api.entities.construct.IConstruct;
import com.mna.api.entities.construct.IConstructDiagnostics;
import com.mna.api.entities.construct.ai.ConstructAITask;
import com.mna.api.entities.construct.ai.parameter.ConstructAITaskParameter;
import com.mna.api.entities.construct.ai.parameter.ConstructTaskPointParameter;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public abstract class ConstructCommandBlockInteract<V extends ConstructAITask<?>>
extends ConstructAITask<ConstructCommandBlockInteract<V>> {
    protected BlockPos blockPos;
    protected Direction side;
    private Vec3 lastConstructPos;
    private float stuckPosThreshold = 0.25f;
    private int stuckCount = 0;
    private Direction[] offsetDirections = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST};

    public ConstructCommandBlockInteract(IConstruct<?> construct, ResourceLocation guiIcon) {
        super(construct, guiIcon);
    }

    @Override
    public boolean m_8036_() {
        AbstractGolem c = this.getConstructAsEntity();
        return super.m_8036_() && this.blockPos != null && c.m_9236_().m_46749_(this.blockPos);
    }

    @Override
    public boolean m_8045_() {
        AbstractGolem c = this.getConstructAsEntity();
        return super.m_8045_() && this.blockPos != null && c.m_9236_().m_46749_(this.blockPos);
    }

    @Override
    public boolean doMove() {
        AbstractGolem c = this.getConstructAsEntity();
        Vec3 invPos = Vec3.m_82512_((Vec3i)this.blockPos);
        this.construct.getDiagnostics().pushTaskUpdate(this.getId(), this.guiIcon, IConstructDiagnostics.Status.RUNNING, invPos);
        double dist = c.m_20238_(invPos);
        if (dist > 2.5) {
            if (this.moveCooldown == 0) {
                Vec3 constructPos = c.m_20182_();
                if (this.lastConstructPos != null) {
                    if (constructPos.m_82557_(this.lastConstructPos) < (double)(this.stuckPosThreshold * this.stuckPosThreshold)) {
                        ++this.stuckCount;
                        if (this.stuckCount >= 2) {
                            Direction dir = this.offsetDirections[(int)(Math.random() * (double)this.offsetDirections.length)];
                            c.m_21573_().m_26573_();
                            if (c.m_21573_().m_26519_(c.m_20185_() + (double)(dir.m_122429_() * 3), c.m_20186_() + (double)(dir.m_122430_() * 3), c.m_20189_() + (double)(dir.m_122431_() * 3), c.m_21133_(Attributes.f_22279_))) {
                                this.pushDiagnosticMessage(this.translate("mna.constructs.feedback.move_success", invPos.f_82479_, invPos.f_82480_, invPos.f_82481_), false);
                            } else {
                                this.pushDiagnosticMessage(this.translate("mna.constructs.feedback.move_fail", invPos.f_82479_, invPos.f_82480_, invPos.f_82481_), false);
                            }
                            this.moveCooldown = 20;
                            this.stuckCount = 0;
                            return false;
                        }
                    } else {
                        this.stuckCount = 0;
                    }
                }
                this.lastConstructPos = constructPos;
                this.setPathToXYZ(invPos, 1.0f);
                this.moveCooldown = 20;
            }
        } else {
            c.m_21573_().m_26573_();
            this.faceBlockPos(this.blockPos);
            return true;
        }
        return false;
    }

    @Override
    public void inflateParameters() {
        this.getParameter(this.getPointIdentifier()).ifPresent(param -> {
            if (param instanceof ConstructTaskPointParameter) {
                this.blockPos = ((ConstructTaskPointParameter)param).getPosition();
                this.side = ((ConstructTaskPointParameter)param).getDirection();
            }
        });
    }

    @Nullable
    protected BlockState getBlockState() {
        if (this.construct.asEntity().m_9236_().m_46749_(this.blockPos)) {
            return this.construct.asEntity().m_9236_().m_8055_(this.blockPos);
        }
        return null;
    }

    @Override
    public ConstructCommandBlockInteract<V> copyFrom(ConstructAITask<?> other) {
        if (other instanceof ConstructCommandBlockInteract) {
            this.side = ((ConstructCommandBlockInteract)other).side;
            this.blockPos = ((ConstructCommandBlockInteract)other).blockPos;
        }
        return this;
    }

    @Override
    public CompoundTag writeInternal(CompoundTag nbt) {
        if (this.blockPos != null) {
            nbt.m_128365_("blockPos", (Tag)NbtUtils.m_129224_((BlockPos)this.blockPos));
        }
        if (this.side != null) {
            nbt.m_128405_("direction", this.side.m_122411_());
        }
        return nbt;
    }

    @Override
    public void readNBT(CompoundTag nbt) {
        if (nbt.m_128441_("blockPos")) {
            this.blockPos = NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("blockPos"));
        }
        if (nbt.m_128441_("direction")) {
            this.side = Direction.m_122376_((int)nbt.m_128451_("direction"));
        }
    }

    @Override
    protected List<ConstructAITaskParameter> instantiateParameters() {
        List<ConstructAITaskParameter> parameters = super.instantiateParameters();
        parameters.add(new ConstructTaskPointParameter(this.getPointIdentifier()));
        return parameters;
    }

    protected String getPointIdentifier() {
        return "teinteract.point";
    }

    @Override
    public boolean isFullyConfigured() {
        return this.blockPos != null && this.side != null;
    }
}

