/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.constructs.ai.conditionals;

import com.mna.Registries;
import com.mna.api.blocks.DirectionalPoint;
import com.mna.api.entities.construct.IConstruct;
import com.mna.api.entities.construct.IConstructDiagnostics;
import com.mna.api.entities.construct.ai.ConstructAITask;
import com.mna.api.entities.construct.ai.parameter.ConstructAITaskParameter;
import com.mna.api.entities.construct.ai.parameter.ConstructTaskBooleanParameter;
import com.mna.api.entities.construct.ai.parameter.ConstructTaskFilterParameter;
import com.mna.api.entities.construct.ai.parameter.ConstructTaskIntegerParameter;
import com.mna.api.entities.construct.ai.parameter.ConstructTaskPointParameter;
import com.mna.api.items.DynamicItemFilter;
import com.mna.entities.constructs.ai.base.ConstructTasks;
import com.mna.entities.constructs.ai.conditionals.ConstructConditional;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class ConstructIsItemInContainer
extends ConstructConditional<ConstructIsItemInContainer> {
    private DirectionalPoint pos;
    private DynamicItemFilter filter = new DynamicItemFilter();
    private int minimum;
    private boolean individual_items = false;

    public ConstructIsItemInContainer(IConstruct<?> construct, ResourceLocation guiIcon) {
        super(construct, guiIcon);
    }

    @Override
    protected boolean evaluate() {
        if (this.pos == null) {
            return false;
        }
        Level world = this.construct.asEntity().m_9236_();
        if (!world.m_46749_(this.pos.getPosition())) {
            return false;
        }
        BlockEntity be = world.m_7702_(this.pos.getPosition());
        if (be == null) {
            this.construct.getDiagnostics().pushTaskUpdate(this.getId(), this.guiIcon, IConstructDiagnostics.Status.FAILURE, Vec3.m_82512_((Vec3i)this.pos.getPosition()));
            return false;
        }
        LazyOptional handler = be.getCapability(ForgeCapabilities.ITEM_HANDLER, this.pos.getDirection());
        if (!handler.isPresent()) {
            this.construct.getDiagnostics().pushTaskUpdate(this.getId(), this.guiIcon, IConstructDiagnostics.Status.FAILURE, Vec3.m_82512_((Vec3i)this.pos.getPosition()));
            return false;
        }
        HashMap<Integer, Integer> hashCount = new HashMap<Integer, Integer>();
        IItemHandler inv = (IItemHandler)handler.resolve().get();
        int slots = inv.getSlots();
        int total = 0;
        for (int i = 0; i < slots; ++i) {
            ItemStack invStack = inv.getStackInSlot(i);
            if (!this.filter.matches(invStack)) continue;
            int stackHash = this.filter.hashStack(invStack);
            hashCount.compute(stackHash, (k, v) -> {
                int count = invStack.m_41613_();
                return v == null ? count : v + count;
            });
            if (this.individual_items || (total += invStack.m_41613_()) < this.minimum) continue;
            this.construct.getDiagnostics().pushTaskUpdate(this.getId(), this.guiIcon, IConstructDiagnostics.Status.SUCCESS, Vec3.m_82512_((Vec3i)this.pos.getPosition()));
            return true;
        }
        MutableBoolean individualCount = new MutableBoolean(false);
        if (this.individual_items) {
            hashCount.forEach((k, v) -> {
                if (v >= this.minimum) {
                    individualCount.setTrue();
                }
            });
        }
        if (individualCount.booleanValue()) {
            this.construct.getDiagnostics().pushTaskUpdate(this.getId(), this.guiIcon, IConstructDiagnostics.Status.SUCCESS, Vec3.m_82512_((Vec3i)this.pos.getPosition()));
            return true;
        }
        this.construct.getDiagnostics().pushTaskUpdate(this.getId(), this.guiIcon, IConstructDiagnostics.Status.FAILURE, Vec3.m_82512_((Vec3i)this.pos.getPosition()));
        return false;
    }

    @Override
    public void inflateParameters() {
        this.getParameter("item_in_container.amount").ifPresent(param -> {
            if (param instanceof ConstructTaskIntegerParameter) {
                this.minimum = ((ConstructTaskIntegerParameter)param).getValue();
            }
        });
        Optional<ConstructAITaskParameter> filterParam = this.getParameter("item_in_container.filter");
        if (filterParam.isPresent() && filterParam.get() instanceof ConstructTaskFilterParameter) {
            this.filter = ((ConstructTaskFilterParameter)filterParam.get()).getValue();
        } else {
            InteractionHand[] carryingHands;
            this.filter = new DynamicItemFilter();
            for (InteractionHand hand : carryingHands = this.construct.getCarryingHands()) {
                ItemStack stack = this.construct.asEntity().m_21120_(hand);
                ItemStack copied = stack.m_41777_();
                copied.m_41764_(Math.max(1, this.minimum));
                this.filter.getWhiteList().add((Object)copied);
            }
        }
        this.getParameter("item_in_container.pos").ifPresent(param -> {
            if (param instanceof ConstructTaskPointParameter) {
                this.pos = ((ConstructTaskPointParameter)param).getPoint();
            }
        });
        this.getParameter("item_in_container.individual").ifPresent(param -> {
            if (param instanceof ConstructTaskBooleanParameter) {
                this.individual_items = ((ConstructTaskBooleanParameter)param).getValue();
            }
        });
    }

    @Override
    protected List<ConstructAITaskParameter> instantiateParameters() {
        ArrayList<ConstructAITaskParameter> output = new ArrayList<ConstructAITaskParameter>();
        output.add(new ConstructTaskFilterParameter("item_in_container.filter"));
        output.add(new ConstructTaskPointParameter("item_in_container.pos"));
        output.add(new ConstructTaskIntegerParameter("item_in_container.amount", 1, 128, 1, 1));
        output.add(new ConstructTaskBooleanParameter("item_in_container.individual"));
        return output;
    }

    @Override
    public ResourceLocation getType() {
        return Registries.ConstructTasks.get().getKey((Object)ConstructTasks.Conditions.CONTAINER_FIND);
    }

    @Override
    public ConstructIsItemInContainer copyFrom(ConstructAITask<?> other) {
        if (other instanceof ConstructIsItemInContainer) {
            this.pos = ((ConstructIsItemInContainer)other).pos;
            this.filter.copyFrom(((ConstructIsItemInContainer)other).filter);
            this.minimum = ((ConstructIsItemInContainer)other).minimum;
            this.individual_items = ((ConstructIsItemInContainer)other).individual_items;
        }
        return this;
    }

    @Override
    public ConstructIsItemInContainer duplicate() {
        ConstructIsItemInContainer output = new ConstructIsItemInContainer(this.construct, this.guiIcon);
        output.copyFrom((ConstructAITask)this);
        return output;
    }

    @Override
    public boolean isFullyConfigured() {
        return this.pos != null && this.pos.isValid();
    }
}

