/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.constructs.movement;

import com.mna.entities.constructs.animated.Construct;
import com.mna.tools.math.MathUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidType;

public class ConstructMoveControl
extends MoveControl {
    private final Construct construct;
    private final boolean applyGravity;
    private float inWaterSpeedModifier;
    private int maxTurnX;
    private float outsideWaterSpeedModifier;
    private float maxTurnY;

    public ConstructMoveControl(Construct construct, int pMaxTurnX, int pMaxTurnY, float pInWaterSpeedModifier, float pOutsideWaterSpeedModifier, boolean pApplyGravity) {
        super((Mob)construct);
        this.construct = construct;
        this.maxTurnX = pMaxTurnX;
        this.maxTurnY = pMaxTurnY;
        this.inWaterSpeedModifier = pInWaterSpeedModifier;
        this.outsideWaterSpeedModifier = pOutsideWaterSpeedModifier;
        this.applyGravity = pApplyGravity;
    }

    public void m_8126_() {
        if (this.construct.isInFluidType()) {
            FluidType fluidType = this.construct.getMaxHeightFluidType();
            if (fluidType != null && this.construct.canSwimInFluidType(fluidType)) {
                this.swimTick();
            } else {
                super.m_8126_();
            }
        } else if (this.construct.canFly()) {
            this.flyTick();
        } else {
            super.m_8126_();
        }
    }

    private void swimTick() {
        if (this.applyGravity && this.f_24974_.m_20069_()) {
            this.f_24974_.m_20256_(this.f_24974_.m_20184_().m_82520_(0.0, 0.005, 0.0));
        }
        if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !this.f_24974_.m_21573_().m_26571_()) {
            double d2;
            double d1;
            double d0 = this.f_24975_ - this.f_24974_.m_20185_();
            double d3 = d0 * d0 + (d1 = this.f_24976_ - this.f_24974_.m_20186_()) * d1 + (d2 = this.f_24977_ - this.f_24974_.m_20189_()) * d2;
            if (d3 < 2.500000277905201E-7) {
                this.f_24974_.m_21564_(0.0f);
            } else {
                float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.f_24974_.m_146922_(this.m_24991_(this.f_24974_.m_146908_(), f, this.maxTurnY));
                this.f_24974_.f_20883_ = this.f_24974_.m_146908_();
                this.f_24974_.f_20885_ = this.f_24974_.m_146908_();
                float f1 = (float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_));
                if (this.f_24974_.m_20069_()) {
                    this.f_24974_.m_7910_(f1 * this.inWaterSpeedModifier);
                    double d4 = Math.sqrt(d0 * d0 + d2 * d2);
                    if (Math.abs(d1) > (double)1.0E-5f || Math.abs(d4) > (double)1.0E-5f) {
                        float f3 = -((float)(Mth.m_14136_((double)d1, (double)d4) * 57.2957763671875));
                        f3 = Mth.m_14036_((float)Mth.m_14177_((float)f3), (float)(-this.maxTurnX), (float)this.maxTurnX);
                        this.f_24974_.m_146926_(this.m_24991_(this.f_24974_.m_146909_(), f3, 5.0f));
                    }
                    float f6 = Mth.m_14089_((float)(this.f_24974_.m_146909_() * ((float)Math.PI / 180)));
                    float f4 = Mth.m_14031_((float)(this.f_24974_.m_146909_() * ((float)Math.PI / 180)));
                    this.f_24974_.f_20902_ = f6 * f1;
                    this.f_24974_.f_20901_ = -f4 * f1;
                } else {
                    float f5 = Math.abs(Mth.m_14177_((float)(this.f_24974_.m_146908_() - f)));
                    float f2 = ConstructMoveControl.getTurningSpeedFactor(f5);
                    this.f_24974_.m_7910_(f1 * this.outsideWaterSpeedModifier * f2);
                }
            }
        } else {
            this.f_24974_.m_7910_(0.0f);
            this.f_24974_.m_21570_(0.0f);
            this.f_24974_.m_21567_(0.0f);
            this.f_24974_.m_21564_(0.0f);
        }
    }

    private void flyTick() {
        if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
            this.f_24981_ = MoveControl.Operation.WAIT;
            Vec3 wanted = new Vec3(this.f_24975_, this.f_24976_, this.f_24977_);
            Vec3 pos = this.construct.m_20182_();
            Vec3 delta = wanted.m_82546_(pos);
            if (delta.m_82556_() < 2.500000277905201E-7) {
                this.f_24974_.m_21567_(0.0f);
                this.f_24974_.m_21564_(0.0f);
                return;
            }
            float angleToWanted = (float)(Mth.m_14136_((double)delta.f_82481_, (double)delta.f_82479_) * 57.2957763671875) - 90.0f;
            this.f_24974_.m_146922_(this.m_24991_(this.f_24974_.m_146908_(), angleToWanted, 90.0f));
            float speed = this.f_24974_.m_20096_() ? (float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_)) : (float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22280_));
            this.f_24974_.m_7910_(speed);
            double horizontalDistance = Math.sqrt(delta.f_82479_ * delta.f_82479_ + delta.f_82481_ * delta.f_82481_);
            if (Math.abs(delta.f_82480_) > (double)1.0E-5f || Math.abs(horizontalDistance) > (double)1.0E-5f) {
                float targetYaw = (float)(-(Mth.m_14136_((double)delta.f_82480_, (double)horizontalDistance) * 57.2957763671875));
                this.f_24974_.m_146926_(this.m_24991_(this.f_24974_.m_146909_(), targetYaw, (float)this.maxTurnX / 4.0f));
                if (Math.abs(this.construct.m_20186_() - (double)this.construct.m_21573_().m_26567_().m_123342_()) > 0.5) {
                    float verticalSpeedPercent = (float)MathUtils.clamp01(Math.abs(delta.f_82480_) / 4.0);
                    float verticalSpeed = (delta.f_82480_ > 0.0 ? speed : -speed) * verticalSpeedPercent;
                    this.f_24974_.m_21567_(verticalSpeed);
                    if (!this.construct.m_20072_()) {
                        this.f_24974_.m_20242_(true);
                    } else {
                        this.f_24974_.m_20242_(false);
                    }
                }
            } else if (Math.abs(this.construct.m_20186_() - (double)this.construct.m_21573_().m_26567_().m_123342_()) < 1.5) {
                BlockPos cBPos = this.construct.m_20183_();
                if (this.construct.m_9236_().m_8055_(cBPos).m_60634_((BlockGetter)this.construct.m_9236_(), cBPos, (Entity)this.construct) || this.construct.m_9236_().m_8055_(cBPos.m_7495_()).m_60634_((BlockGetter)this.construct.m_9236_(), cBPos.m_7495_(), (Entity)this.construct)) {
                    this.f_24974_.m_20242_(false);
                }
            }
        } else {
            BlockPos cBPos = this.construct.m_20183_();
            if (this.construct.m_9236_().m_8055_(cBPos).m_60634_((BlockGetter)this.construct.m_9236_(), cBPos, (Entity)this.construct) || this.construct.m_9236_().m_8055_(cBPos.m_7495_()).m_60634_((BlockGetter)this.construct.m_9236_(), cBPos.m_7495_(), (Entity)this.construct)) {
                this.f_24974_.m_20242_(false);
            }
            this.f_24974_.m_21567_(0.0f);
            this.f_24974_.m_21564_(0.0f);
        }
    }

    private static float getTurningSpeedFactor(float p_249853_) {
        return 1.0f - Mth.m_14036_((float)((p_249853_ - 10.0f) / 50.0f), (float)0.0f, (float)1.0f);
    }
}

