/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.constructs.movement;

import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.pathfinder.Target;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ConstructNodeEvaluator
extends NodeEvaluator {
    public static final double SPACE_BETWEEN_WALL_POSTS = 0.5;
    protected float oldWaterCost;
    private float oldWalkableCost;
    private float oldWaterBorderCost;
    private boolean amphibious = true;
    private boolean flying = false;
    private boolean isInWater = false;
    private final Long2ObjectMap<BlockPathTypes> pathTypeByPosCache = new Long2ObjectOpenHashMap();
    private final Object2BooleanMap<AABB> collisionCache = new Object2BooleanOpenHashMap();

    public void m_6028_(PathNavigationRegion region, Mob mob) {
        super.m_6028_(region, mob);
        this.isInWater = mob.m_20069_();
        if (this.flying && !this.isInWater) {
            this.prepare_flying(mob);
        } else {
            this.prepare_ground(mob);
        }
    }

    public void m_6802_() {
        this.f_77313_.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
        this.f_77313_.m_21441_(BlockPathTypes.WALKABLE, this.oldWalkableCost);
        this.f_77313_.m_21441_(BlockPathTypes.WATER_BORDER, this.oldWaterBorderCost);
        this.pathTypeByPosCache.clear();
        this.collisionCache.clear();
        super.m_6802_();
    }

    @Nullable
    protected Node m_5676_(int x, int y, int z) {
        if (this.flying && !this.isInWater) {
            Node node = null;
            BlockPathTypes pathType = this.getCachedBlockPathType(x, y, z);
            float f = this.f_77313_.m_21439_(pathType);
            if (f >= 0.0f) {
                node = super.m_5676_(x, y, z);
                node.f_77282_ = pathType;
                node.f_77281_ = Math.max(node.f_77281_, f);
                if (pathType == BlockPathTypes.WALKABLE) {
                    node.f_77281_ += 1.0f;
                }
            }
            return node;
        }
        return super.m_5676_(x, y, z);
    }

    public Node m_7171_() {
        if (this.flying && !this.isInWater) {
            return this.getStart_flying();
        }
        return this.getStart_ground();
    }

    public Target m_7568_(double x, double y, double z) {
        if (this.flying && !this.isInWater) {
            return new Target(super.m_5676_(Mth.m_14107_((double)x), Mth.m_14107_((double)y), Mth.m_14107_((double)z)));
        }
        return new Target(this.m_5676_(Mth.m_14107_((double)x), Mth.m_14107_((double)y), Mth.m_14107_((double)z)));
    }

    public int m_6065_(Node[] p_77640_, Node current) {
        if (this.flying && !this.isInWater) {
            return this.getNeighbors_flying(p_77640_, current);
        }
        return this.getNeighbors_ground(p_77640_, current);
    }

    public BlockPathTypes m_7209_(BlockGetter blockGetter, int x, int y, int z, Mob mob) {
        if (this.flying && !this.isInWater) {
            return this.getBlockPathType_flying(blockGetter, x, y, z, mob);
        }
        return this.getBlockPathType_ground(blockGetter, x, y, z, mob);
    }

    public BlockPathTypes m_8086_(BlockGetter blockGetter, int x, int y, int z) {
        if (this.flying && !this.isInWater) {
            return this.getBlockPathType_flying(blockGetter, x, y, z, this.f_77313_);
        }
        return ConstructNodeEvaluator.getBlockPathTypeStatic(blockGetter, new BlockPos.MutableBlockPos(x, y, z), this.f_77313_);
    }

    public void setFlying(boolean flying) {
        this.flying = flying;
    }

    public void setAmphibious(boolean amphibious) {
        this.amphibious = amphibious;
    }

    private boolean hasPositiveMalus(BlockPos pos) {
        BlockPathTypes blockpathtypes = this.getBlockPathType(this.f_77313_, pos);
        return this.f_77313_.m_21439_(blockpathtypes) >= 0.0f;
    }

    protected boolean isNeighborValid(@Nullable Node neighbor, Node current) {
        return neighbor != null && !neighbor.f_77279_ && (neighbor.f_77281_ >= 0.0f || current.f_77281_ < 0.0f);
    }

    private boolean hasMalus(@Nullable Node node) {
        return node != null && node.f_77281_ >= 0.0f;
    }

    private boolean isOpen(@Nullable Node node) {
        return node != null && !node.f_77279_;
    }

    protected boolean isDiagonalValid(Node current, @Nullable Node xOffsetNode, @Nullable Node zOffsetNode, @Nullable Node diagonalNode) {
        if (diagonalNode != null && zOffsetNode != null && xOffsetNode != null) {
            if (diagonalNode.f_77279_) {
                return false;
            }
            if (zOffsetNode.f_77272_ <= current.f_77272_ && xOffsetNode.f_77272_ <= current.f_77272_ && xOffsetNode.f_77282_ != BlockPathTypes.WALKABLE_DOOR && zOffsetNode.f_77282_ != BlockPathTypes.WALKABLE_DOOR && diagonalNode.f_77282_ != BlockPathTypes.WALKABLE_DOOR) {
                boolean canFitThrough = zOffsetNode.f_77282_ == BlockPathTypes.FENCE && xOffsetNode.f_77282_ == BlockPathTypes.FENCE && (double)this.f_77313_.m_20205_() < 0.5;
                return diagonalNode.f_77281_ >= 0.0f && (zOffsetNode.f_77272_ < current.f_77272_ || zOffsetNode.f_77281_ >= 0.0f || canFitThrough) && (xOffsetNode.f_77272_ < current.f_77272_ || xOffsetNode.f_77281_ >= 0.0f || canFitThrough);
            }
        }
        return false;
    }

    private boolean canReachWithoutCollision(Node target) {
        Vec3 delta = new Vec3((double)target.f_77271_ - this.f_77313_.m_20185_(), (double)target.f_77272_ - this.f_77313_.m_20186_(), (double)target.f_77273_ - this.f_77313_.m_20189_());
        AABB mobBB = this.f_77313_.m_20191_();
        int i = Mth.m_14165_((double)(delta.m_82553_() / mobBB.m_82309_()));
        delta = delta.m_82490_((double)(1.0f / (float)i));
        for (int j = 1; j <= i; ++j) {
            if (!this.hasCollisions(mobBB = mobBB.m_82383_(delta))) continue;
            return false;
        }
        return true;
    }

    protected double getFloorLevel(BlockPos pos) {
        return ConstructNodeEvaluator.getFloorLevel((BlockGetter)this.f_77312_, pos);
    }

    protected boolean isAmphibious() {
        return this.amphibious;
    }

    @Nullable
    protected Node findAcceptedNode(int x, int y, int z, int stepUpHeight, double floorLevel, Direction direction, BlockPathTypes pathType) {
        Node node = null;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        double positionFloorLevel = this.getFloorLevel((BlockPos)pos.m_122178_(x, y, z));
        if (positionFloorLevel - floorLevel > 1.125) {
            return null;
        }
        BlockPathTypes xyzPathType = this.getCachedBlockType(this.f_77313_, x, y, z);
        float pathfindingMalus = this.f_77313_.m_21439_(xyzPathType);
        double halfMobWidth = (double)this.f_77313_.m_20205_() / 2.0;
        if (pathfindingMalus >= 0.0f) {
            node = this.m_5676_(x, y, z);
            node.f_77282_ = xyzPathType;
            node.f_77281_ = Math.max(node.f_77281_, pathfindingMalus);
        }
        if (pathType == BlockPathTypes.FENCE && node != null && node.f_77281_ >= 0.0f && !this.canReachWithoutCollision(node)) {
            node = null;
        }
        if (!(xyzPathType == BlockPathTypes.WALKABLE || this.isAmphibious() && xyzPathType == BlockPathTypes.WATER)) {
            double deltaZ;
            double deltaX;
            AABB aabb;
            if ((node == null || node.f_77281_ < 0.0f) && stepUpHeight > 0 && xyzPathType != BlockPathTypes.FENCE && xyzPathType != BlockPathTypes.UNPASSABLE_RAIL && xyzPathType != BlockPathTypes.TRAPDOOR && xyzPathType != BlockPathTypes.POWDER_SNOW && (node = this.findAcceptedNode(x, y + 1, z, stepUpHeight - 1, floorLevel, direction, pathType)) != null && (node.f_77282_ == BlockPathTypes.OPEN || node.f_77282_ == BlockPathTypes.WALKABLE) && this.f_77313_.m_20205_() < 1.0f && this.hasCollisions(aabb = new AABB((deltaX = (double)(x - direction.m_122429_()) + 0.5) - halfMobWidth, ConstructNodeEvaluator.getFloorLevel((BlockGetter)this.f_77312_, (BlockPos)pos.m_122169_(deltaX, (double)(y + 1), deltaZ = (double)(z - direction.m_122431_()) + 0.5)) + 0.001, deltaZ - halfMobWidth, deltaX + halfMobWidth, (double)this.f_77313_.m_20206_() + ConstructNodeEvaluator.getFloorLevel((BlockGetter)this.f_77312_, (BlockPos)pos.m_122169_((double)node.f_77271_, (double)node.f_77272_, (double)node.f_77273_)) - 0.002, deltaZ + halfMobWidth))) {
                node = null;
            }
            if (!this.isAmphibious() && xyzPathType == BlockPathTypes.WATER && !this.m_77361_()) {
                if (this.getCachedBlockType(this.f_77313_, x, y - 1, z) != BlockPathTypes.WATER) {
                    return node;
                }
                while (y > this.f_77313_.m_9236_().m_141937_()) {
                    if ((xyzPathType = this.getCachedBlockType(this.f_77313_, x, --y, z)) != BlockPathTypes.WATER) {
                        return node;
                    }
                    node = this.m_5676_(x, y, z);
                    node.f_77282_ = xyzPathType;
                    node.f_77281_ = Math.max(node.f_77281_, this.f_77313_.m_21439_(xyzPathType));
                }
            }
            if (xyzPathType == BlockPathTypes.OPEN) {
                int j = 0;
                int i = y;
                while (xyzPathType == BlockPathTypes.OPEN) {
                    if (--y < this.f_77313_.m_9236_().m_141937_()) {
                        Node originalNode = this.m_5676_(x, i, z);
                        originalNode.f_77282_ = BlockPathTypes.BLOCKED;
                        originalNode.f_77281_ = -1.0f;
                        return originalNode;
                    }
                    if (j++ >= this.f_77313_.m_6056_()) {
                        Node offsetNode = this.m_5676_(x, y, z);
                        offsetNode.f_77282_ = BlockPathTypes.BLOCKED;
                        offsetNode.f_77281_ = -1.0f;
                        return offsetNode;
                    }
                    xyzPathType = this.getCachedBlockType(this.f_77313_, x, y, z);
                    pathfindingMalus = this.f_77313_.m_21439_(xyzPathType);
                    if (xyzPathType != BlockPathTypes.OPEN && pathfindingMalus >= 0.0f) {
                        node = this.m_5676_(x, y, z);
                        node.f_77282_ = xyzPathType;
                        node.f_77281_ = Math.max(node.f_77281_, pathfindingMalus);
                        break;
                    }
                    if (!(pathfindingMalus < 0.0f)) continue;
                    Node offsetNode = this.m_5676_(x, y, z);
                    offsetNode.f_77282_ = BlockPathTypes.BLOCKED;
                    offsetNode.f_77281_ = -1.0f;
                    return offsetNode;
                }
            }
            if (xyzPathType == BlockPathTypes.FENCE) {
                node = this.m_5676_(x, y, z);
                node.f_77279_ = true;
                node.f_77282_ = xyzPathType;
                node.f_77281_ = xyzPathType.m_77124_();
            }
            return node;
        }
        return node;
    }

    private boolean hasCollisions(AABB boundingBox) {
        return this.collisionCache.computeIfAbsent((Object)boundingBox, value -> !this.f_77312_.m_45756_((Entity)this.f_77313_, boundingBox));
    }

    public BlockPathTypes getBlockPathTypes(BlockGetter pLevel, int pXOffset, int pYOffset, int pZOffset, EnumSet<BlockPathTypes> pOutput, BlockPathTypes pFallbackPathType, BlockPos pPos) {
        for (int i = 0; i < this.f_77315_; ++i) {
            for (int j = 0; j < this.f_77316_; ++j) {
                for (int k = 0; k < this.f_77317_; ++k) {
                    int l = i + pXOffset;
                    int i1 = j + pYOffset;
                    int j1 = k + pZOffset;
                    BlockPathTypes blockpathtypes = ConstructNodeEvaluator.getBlockPathTypeStatic(pLevel, new BlockPos.MutableBlockPos(l, i1, j1), this.f_77313_);
                    blockpathtypes = this.evaluateBlockPathType(pLevel, pPos, blockpathtypes);
                    if (i == 0 && j == 0 && k == 0) {
                        pFallbackPathType = blockpathtypes;
                    }
                    pOutput.add(blockpathtypes);
                }
            }
        }
        return pFallbackPathType;
    }

    protected BlockPathTypes evaluateBlockPathType(BlockGetter pLevel, BlockPos pPos, BlockPathTypes pPathTypes) {
        boolean flag = this.m_77357_();
        if (pPathTypes == BlockPathTypes.DOOR_WOOD_CLOSED && this.m_77360_() && flag) {
            pPathTypes = BlockPathTypes.WALKABLE_DOOR;
        }
        if (pPathTypes == BlockPathTypes.DOOR_OPEN && !flag) {
            pPathTypes = BlockPathTypes.BLOCKED;
        }
        if (pPathTypes == BlockPathTypes.RAIL && !(pLevel.m_8055_(pPos).m_60734_() instanceof BaseRailBlock) && !(pLevel.m_8055_(pPos.m_7495_()).m_60734_() instanceof BaseRailBlock)) {
            pPathTypes = BlockPathTypes.UNPASSABLE_RAIL;
        }
        return pPathTypes;
    }

    private BlockPathTypes getBlockPathType(Mob mob, BlockPos position) {
        return this.getCachedBlockType(mob, position.m_123341_(), position.m_123342_(), position.m_123343_());
    }

    private BlockPathTypes getCachedBlockPathType(int pX, int pY, int pZ) {
        return (BlockPathTypes)this.pathTypeByPosCache.computeIfAbsent(BlockPos.m_121882_((int)pX, (int)pY, (int)pZ), p_265010_ -> this.m_7209_((BlockGetter)this.f_77312_, pX, pY, pZ, this.f_77313_));
    }

    protected BlockPathTypes getCachedBlockType(Mob pEntity, int pX, int pY, int pZ) {
        return (BlockPathTypes)this.pathTypeByPosCache.computeIfAbsent(BlockPos.m_121882_((int)pX, (int)pY, (int)pZ), p_265015_ -> this.m_7209_((BlockGetter)this.f_77312_, pX, pY, pZ, pEntity));
    }

    protected void prepare_ground(Mob mob) {
        this.oldWaterCost = mob.m_21439_(BlockPathTypes.WATER);
        mob.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.oldWalkableCost = mob.m_21439_(BlockPathTypes.WALKABLE);
        mob.m_21441_(BlockPathTypes.WALKABLE, 6.0f);
        this.oldWaterBorderCost = mob.m_21439_(BlockPathTypes.WATER_BORDER);
        mob.m_21441_(BlockPathTypes.WATER_BORDER, 4.0f);
    }

    protected void prepare_flying(Mob mob) {
        this.pathTypeByPosCache.clear();
        this.oldWaterCost = mob.m_21439_(BlockPathTypes.WATER);
    }

    protected Node getStart_ground() {
        int i;
        BlockPos.MutableBlockPos blockpos$mutableblockpos;
        block11: {
            blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            i = this.f_77313_.m_146904_();
            BlockState blockstate = this.f_77312_.m_8055_((BlockPos)blockpos$mutableblockpos.m_122169_(this.f_77313_.m_20185_(), (double)i, this.f_77313_.m_20189_()));
            if (!this.f_77313_.m_203441_(blockstate.m_60819_())) {
                if (this.m_77361_() && this.f_77313_.m_20069_()) {
                    while (true) {
                        if (!blockstate.m_60713_(Blocks.f_49990_) && blockstate.m_60819_() != Fluids.f_76193_.m_76068_(false)) {
                            --i;
                            break block11;
                        }
                        blockstate = this.f_77312_.m_8055_((BlockPos)blockpos$mutableblockpos.m_122169_(this.f_77313_.m_20185_(), (double)(++i), this.f_77313_.m_20189_()));
                    }
                }
                if (this.f_77313_.m_20096_()) {
                    i = Mth.m_14107_((double)(this.f_77313_.m_20186_() + 0.5));
                } else {
                    BlockPos blockpos = this.f_77313_.m_20183_();
                    while ((this.f_77312_.m_8055_(blockpos).m_60795_() || this.f_77312_.m_8055_(blockpos).m_60647_((BlockGetter)this.f_77312_, blockpos, PathComputationType.LAND)) && blockpos.m_123342_() > this.f_77313_.m_9236_().m_141937_()) {
                        blockpos = blockpos.m_7495_();
                    }
                    i = blockpos.m_7494_().m_123342_();
                }
            } else {
                while (this.f_77313_.m_203441_(blockstate.m_60819_())) {
                    blockstate = this.f_77312_.m_8055_((BlockPos)blockpos$mutableblockpos.m_122169_(this.f_77313_.m_20185_(), (double)(++i), this.f_77313_.m_20189_()));
                }
                --i;
            }
        }
        BlockPos blockpos1 = this.f_77313_.m_20183_();
        BlockPathTypes blockpathtypes = this.getCachedBlockType(this.f_77313_, blockpos1.m_123341_(), i, blockpos1.m_123343_());
        if (this.f_77313_.m_21439_(blockpathtypes) < 0.0f) {
            AABB aabb = this.f_77313_.m_20191_();
            if (this.hasPositiveMalus((BlockPos)blockpos$mutableblockpos.m_122169_(aabb.f_82288_, (double)i, aabb.f_82290_)) || this.hasPositiveMalus((BlockPos)blockpos$mutableblockpos.m_122169_(aabb.f_82288_, (double)i, aabb.f_82293_)) || this.hasPositiveMalus((BlockPos)blockpos$mutableblockpos.m_122169_(aabb.f_82291_, (double)i, aabb.f_82290_)) || this.hasPositiveMalus((BlockPos)blockpos$mutableblockpos.m_122169_(aabb.f_82291_, (double)i, aabb.f_82293_))) {
                Node node = this.m_77349_((BlockPos)blockpos$mutableblockpos);
                node.f_77282_ = this.getBlockPathType(this.f_77313_, node.m_77288_());
                node.f_77281_ = this.f_77313_.m_21439_(node.f_77282_);
                return node;
            }
        }
        Node node1 = this.m_5676_(blockpos1.m_123341_(), i, blockpos1.m_123343_());
        node1.f_77282_ = this.getBlockPathType(this.f_77313_, node1.m_77288_());
        node1.f_77281_ = this.f_77313_.m_21439_(node1.f_77282_);
        return node1;
    }

    protected Node getStart_flying() {
        BlockPos blockpos1;
        BlockPathTypes blockpathtypes1;
        int i;
        if (this.m_77361_() && this.f_77313_.m_20069_()) {
            i = this.f_77313_.m_146904_();
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(this.f_77313_.m_20185_(), (double)i, this.f_77313_.m_20189_());
            BlockState blockstate = this.f_77312_.m_8055_((BlockPos)blockpos$mutableblockpos);
            while (blockstate.m_60713_(Blocks.f_49990_)) {
                blockpos$mutableblockpos.m_122169_(this.f_77313_.m_20185_(), (double)(++i), this.f_77313_.m_20189_());
                blockstate = this.f_77312_.m_8055_((BlockPos)blockpos$mutableblockpos);
            }
        } else {
            i = Mth.m_14107_((double)(this.f_77313_.m_20186_() + 0.5));
        }
        if (this.f_77313_.m_21439_(blockpathtypes1 = this.getCachedBlockPathType((blockpos1 = this.f_77313_.m_20183_()).m_123341_(), i, blockpos1.m_123343_())) < 0.0f) {
            for (BlockPos blockpos : ImmutableSet.of((Object)BlockPos.m_274561_((double)this.f_77313_.m_20191_().f_82288_, (double)i, (double)this.f_77313_.m_20191_().f_82290_), (Object)BlockPos.m_274561_((double)this.f_77313_.m_20191_().f_82288_, (double)i, (double)this.f_77313_.m_20191_().f_82293_), (Object)BlockPos.m_274561_((double)this.f_77313_.m_20191_().f_82291_, (double)i, (double)this.f_77313_.m_20191_().f_82290_), (Object)BlockPos.m_274561_((double)this.f_77313_.m_20191_().f_82291_, (double)i, (double)this.f_77313_.m_20191_().f_82293_))) {
                BlockPathTypes blockpathtypes = this.getCachedBlockPathType(blockpos1.m_123341_(), i, blockpos1.m_123343_());
                if (!(this.f_77313_.m_21439_(blockpathtypes) >= 0.0f)) continue;
                return super.m_5676_(blockpos.m_123341_(), blockpos.m_123342_(), blockpos.m_123343_());
            }
        }
        return super.m_5676_(blockpos1.m_123341_(), i, blockpos1.m_123343_());
    }

    protected int getNeighbors_ground(Node[] neighbors, Node current) {
        Node xPosZPos;
        Node xNegZPos;
        Node xPosZNeg;
        Node xNegZNeg;
        Node zNeg;
        Node xPos;
        Node xNeg;
        double floorLevel;
        Node zPos;
        int numOpenNeighbors = 0;
        int stepUpHeight = 0;
        BlockPathTypes pathTypeAbove = this.getCachedBlockType(this.f_77313_, current.f_77271_, current.f_77272_ + 1, current.f_77273_);
        BlockPathTypes pathTypeCurrent = this.getCachedBlockType(this.f_77313_, current.f_77271_, current.f_77272_, current.f_77273_);
        if (this.f_77313_.m_21439_(pathTypeAbove) >= 0.0f && pathTypeCurrent != BlockPathTypes.STICKY_HONEY) {
            stepUpHeight = Mth.m_14143_((float)Math.max(1.0f, this.f_77313_.getStepHeight()));
        }
        if (this.isNeighborValid(zPos = this.findAcceptedNode(current.f_77271_, current.f_77272_, current.f_77273_ + 1, stepUpHeight, floorLevel = this.getFloorLevel(new BlockPos(current.f_77271_, current.f_77272_, current.f_77273_)), Direction.SOUTH, pathTypeCurrent), current)) {
            neighbors[numOpenNeighbors++] = zPos;
        }
        if (this.isNeighborValid(xNeg = this.findAcceptedNode(current.f_77271_ - 1, current.f_77272_, current.f_77273_, stepUpHeight, floorLevel, Direction.WEST, pathTypeCurrent), current)) {
            neighbors[numOpenNeighbors++] = xNeg;
        }
        if (this.isNeighborValid(xPos = this.findAcceptedNode(current.f_77271_ + 1, current.f_77272_, current.f_77273_, stepUpHeight, floorLevel, Direction.EAST, pathTypeCurrent), current)) {
            neighbors[numOpenNeighbors++] = xPos;
        }
        if (this.isNeighborValid(zNeg = this.findAcceptedNode(current.f_77271_, current.f_77272_, current.f_77273_ - 1, stepUpHeight, floorLevel, Direction.NORTH, pathTypeCurrent), current)) {
            neighbors[numOpenNeighbors++] = zNeg;
        }
        if (this.isDiagonalValid(current, xNeg, zNeg, xNegZNeg = this.findAcceptedNode(current.f_77271_ - 1, current.f_77272_, current.f_77273_ - 1, stepUpHeight, floorLevel, Direction.NORTH, pathTypeCurrent))) {
            neighbors[numOpenNeighbors++] = xNegZNeg;
        }
        if (this.isDiagonalValid(current, xPos, zNeg, xPosZNeg = this.findAcceptedNode(current.f_77271_ + 1, current.f_77272_, current.f_77273_ - 1, stepUpHeight, floorLevel, Direction.NORTH, pathTypeCurrent))) {
            neighbors[numOpenNeighbors++] = xPosZNeg;
        }
        if (this.isDiagonalValid(current, xNeg, zPos, xNegZPos = this.findAcceptedNode(current.f_77271_ - 1, current.f_77272_, current.f_77273_ + 1, stepUpHeight, floorLevel, Direction.SOUTH, pathTypeCurrent))) {
            neighbors[numOpenNeighbors++] = xNegZPos;
        }
        if (this.isDiagonalValid(current, xPos, zPos, xPosZPos = this.findAcceptedNode(current.f_77271_ + 1, current.f_77272_, current.f_77273_ + 1, stepUpHeight, floorLevel, Direction.SOUTH, pathTypeCurrent))) {
            neighbors[numOpenNeighbors++] = xPosZPos;
        }
        return numOpenNeighbors;
    }

    protected int getNeighbors_flying(Node[] neighbors, Node current) {
        Node xNegYNegZPos;
        Node xNegYNegZNeg;
        Node xPosYNegZPos;
        Node xPosYNegZNeg;
        Node xNegYPosZPos;
        Node xNegYPosZNeg;
        Node xPosYPosZPos;
        Node xposYPosZNeg;
        Node xNegZPos;
        Node xNegZNeg;
        Node xPosZPos;
        Node xPosZNeg;
        Node yNegZNeg;
        Node xPosYNeg;
        Node xNegYNeg;
        Node yNegZPos;
        Node yPosZNeg;
        Node xPosYPos;
        Node xNegYPos;
        Node yPoszPos;
        Node yNeg;
        Node yPos;
        Node zNeg;
        Node xPos;
        Node xNeg;
        int numOpenNeighbors = 0;
        Node zPos = this.m_5676_(current.f_77271_, current.f_77272_, current.f_77273_ + 1);
        if (this.isOpen(zPos)) {
            neighbors[numOpenNeighbors++] = zPos;
        }
        if (this.isOpen(xNeg = this.m_5676_(current.f_77271_ - 1, current.f_77272_, current.f_77273_))) {
            neighbors[numOpenNeighbors++] = xNeg;
        }
        if (this.isOpen(xPos = this.m_5676_(current.f_77271_ + 1, current.f_77272_, current.f_77273_))) {
            neighbors[numOpenNeighbors++] = xPos;
        }
        if (this.isOpen(zNeg = this.m_5676_(current.f_77271_, current.f_77272_, current.f_77273_ - 1))) {
            neighbors[numOpenNeighbors++] = zNeg;
        }
        if (this.isOpen(yPos = this.m_5676_(current.f_77271_, current.f_77272_ + 1, current.f_77273_))) {
            neighbors[numOpenNeighbors++] = yPos;
        }
        if (this.isOpen(yNeg = this.m_5676_(current.f_77271_, current.f_77272_ - 1, current.f_77273_))) {
            neighbors[numOpenNeighbors++] = yNeg;
        }
        if (this.isOpen(yPoszPos = this.m_5676_(current.f_77271_, current.f_77272_ + 1, current.f_77273_ + 1)) && this.hasMalus(zPos) && this.hasMalus(yPos)) {
            neighbors[numOpenNeighbors++] = yPoszPos;
        }
        if (this.isOpen(xNegYPos = this.m_5676_(current.f_77271_ - 1, current.f_77272_ + 1, current.f_77273_)) && this.hasMalus(xNeg) && this.hasMalus(yPos)) {
            neighbors[numOpenNeighbors++] = xNegYPos;
        }
        if (this.isOpen(xPosYPos = this.m_5676_(current.f_77271_ + 1, current.f_77272_ + 1, current.f_77273_)) && this.hasMalus(xPos) && this.hasMalus(yPos)) {
            neighbors[numOpenNeighbors++] = xPosYPos;
        }
        if (this.isOpen(yPosZNeg = this.m_5676_(current.f_77271_, current.f_77272_ + 1, current.f_77273_ - 1)) && this.hasMalus(zNeg) && this.hasMalus(yPos)) {
            neighbors[numOpenNeighbors++] = yPosZNeg;
        }
        if (this.isOpen(yNegZPos = this.m_5676_(current.f_77271_, current.f_77272_ - 1, current.f_77273_ + 1)) && this.hasMalus(zPos) && this.hasMalus(yNeg)) {
            neighbors[numOpenNeighbors++] = yNegZPos;
        }
        if (this.isOpen(xNegYNeg = this.m_5676_(current.f_77271_ - 1, current.f_77272_ - 1, current.f_77273_)) && this.hasMalus(xNeg) && this.hasMalus(yNeg)) {
            neighbors[numOpenNeighbors++] = xNegYNeg;
        }
        if (this.isOpen(xPosYNeg = this.m_5676_(current.f_77271_ + 1, current.f_77272_ - 1, current.f_77273_)) && this.hasMalus(xPos) && this.hasMalus(yNeg)) {
            neighbors[numOpenNeighbors++] = xPosYNeg;
        }
        if (this.isOpen(yNegZNeg = this.m_5676_(current.f_77271_, current.f_77272_ - 1, current.f_77273_ - 1)) && this.hasMalus(zNeg) && this.hasMalus(yNeg)) {
            neighbors[numOpenNeighbors++] = yNegZNeg;
        }
        if (this.isOpen(xPosZNeg = this.m_5676_(current.f_77271_ + 1, current.f_77272_, current.f_77273_ - 1)) && this.hasMalus(zNeg) && this.hasMalus(xPos)) {
            neighbors[numOpenNeighbors++] = xPosZNeg;
        }
        if (this.isOpen(xPosZPos = this.m_5676_(current.f_77271_ + 1, current.f_77272_, current.f_77273_ + 1)) && this.hasMalus(zPos) && this.hasMalus(xPos)) {
            neighbors[numOpenNeighbors++] = xPosZPos;
        }
        if (this.isOpen(xNegZNeg = this.m_5676_(current.f_77271_ - 1, current.f_77272_, current.f_77273_ - 1)) && this.hasMalus(zNeg) && this.hasMalus(xNeg)) {
            neighbors[numOpenNeighbors++] = xNegZNeg;
        }
        if (this.isOpen(xNegZPos = this.m_5676_(current.f_77271_ - 1, current.f_77272_, current.f_77273_ + 1)) && this.hasMalus(zPos) && this.hasMalus(xNeg)) {
            neighbors[numOpenNeighbors++] = xNegZPos;
        }
        if (this.isOpen(xposYPosZNeg = this.m_5676_(current.f_77271_ + 1, current.f_77272_ + 1, current.f_77273_ - 1)) && this.hasMalus(xPosZNeg) && this.hasMalus(zNeg) && this.hasMalus(xPos) && this.hasMalus(yPos) && this.hasMalus(yPosZNeg) && this.hasMalus(xPosYPos)) {
            neighbors[numOpenNeighbors++] = xposYPosZNeg;
        }
        if (this.isOpen(xPosYPosZPos = this.m_5676_(current.f_77271_ + 1, current.f_77272_ + 1, current.f_77273_ + 1)) && this.hasMalus(xPosZPos) && this.hasMalus(zPos) && this.hasMalus(xPos) && this.hasMalus(yPos) && this.hasMalus(yPoszPos) && this.hasMalus(xPosYPos)) {
            neighbors[numOpenNeighbors++] = xPosYPosZPos;
        }
        if (this.isOpen(xNegYPosZNeg = this.m_5676_(current.f_77271_ - 1, current.f_77272_ + 1, current.f_77273_ - 1)) && this.hasMalus(xNegZNeg) && this.hasMalus(zNeg) && this.hasMalus(xNeg) && this.hasMalus(yPos) && this.hasMalus(yPosZNeg) && this.hasMalus(xNegYPos)) {
            neighbors[numOpenNeighbors++] = xNegYPosZNeg;
        }
        if (this.isOpen(xNegYPosZPos = this.m_5676_(current.f_77271_ - 1, current.f_77272_ + 1, current.f_77273_ + 1)) && this.hasMalus(xNegZPos) && this.hasMalus(zPos) && this.hasMalus(xNeg) && this.hasMalus(yPos) && this.hasMalus(yPoszPos) && this.hasMalus(xNegYPos)) {
            neighbors[numOpenNeighbors++] = xNegYPosZPos;
        }
        if (this.isOpen(xPosYNegZNeg = this.m_5676_(current.f_77271_ + 1, current.f_77272_ - 1, current.f_77273_ - 1)) && this.hasMalus(xPosZNeg) && this.hasMalus(zNeg) && this.hasMalus(xPos) && this.hasMalus(yNeg) && this.hasMalus(yNegZNeg) && this.hasMalus(xPosYNeg)) {
            neighbors[numOpenNeighbors++] = xPosYNegZNeg;
        }
        if (this.isOpen(xPosYNegZPos = this.m_5676_(current.f_77271_ + 1, current.f_77272_ - 1, current.f_77273_ + 1)) && this.hasMalus(xPosZPos) && this.hasMalus(zPos) && this.hasMalus(xPos) && this.hasMalus(yNeg) && this.hasMalus(yNegZPos) && this.hasMalus(xPosYNeg)) {
            neighbors[numOpenNeighbors++] = xPosYNegZPos;
        }
        if (this.isOpen(xNegYNegZNeg = this.m_5676_(current.f_77271_ - 1, current.f_77272_ - 1, current.f_77273_ - 1)) && this.hasMalus(xNegZNeg) && this.hasMalus(zNeg) && this.hasMalus(xNeg) && this.hasMalus(yNeg) && this.hasMalus(yNegZNeg) && this.hasMalus(xNegYNeg)) {
            neighbors[numOpenNeighbors++] = xNegYNegZNeg;
        }
        if (this.isOpen(xNegYNegZPos = this.m_5676_(current.f_77271_ - 1, current.f_77272_ - 1, current.f_77273_ + 1)) && this.hasMalus(xNegZPos) && this.hasMalus(zPos) && this.hasMalus(xNeg) && this.hasMalus(yNeg) && this.hasMalus(yNegZPos) && this.hasMalus(xNegYNeg)) {
            neighbors[numOpenNeighbors++] = xNegYNegZPos;
        }
        return numOpenNeighbors;
    }

    protected BlockPathTypes getBlockPathType_ground(BlockGetter blockGetter, int x, int y, int z, Mob mob) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        BlockPathTypes blockpathtypes = ConstructNodeEvaluator.getBlockPathTypeRaw(blockGetter, (BlockPos)blockpos$mutableblockpos.m_122178_(x, y, z));
        if (blockpathtypes == BlockPathTypes.WATER) {
            for (Direction direction : Direction.values()) {
                BlockPathTypes blockpathtypes1 = ConstructNodeEvaluator.getBlockPathTypeRaw(blockGetter, (BlockPos)blockpos$mutableblockpos.m_122178_(x, y, z).m_122173_(direction));
                if (blockpathtypes1 != BlockPathTypes.BLOCKED) continue;
                return BlockPathTypes.WATER_BORDER;
            }
            return BlockPathTypes.WATER;
        }
        return WalkNodeEvaluator.m_77604_((BlockGetter)blockGetter, (BlockPos.MutableBlockPos)blockpos$mutableblockpos);
    }

    protected BlockPathTypes getBlockPathType_flying(BlockGetter pLevel, int pX, int pY, int pZ, Mob pMob) {
        EnumSet<BlockPathTypes> enumset = EnumSet.noneOf(BlockPathTypes.class);
        BlockPathTypes blockpathtypes = BlockPathTypes.BLOCKED;
        BlockPos blockpos = pMob.m_20183_();
        blockpathtypes = this.getBlockPathTypes(pLevel, pX, pY, pZ, enumset, blockpathtypes, blockpos);
        if (enumset.contains(BlockPathTypes.FENCE)) {
            return BlockPathTypes.FENCE;
        }
        BlockPathTypes blockpathtypes1 = BlockPathTypes.BLOCKED;
        for (BlockPathTypes blockpathtypes2 : enumset) {
            if (pMob.m_21439_(blockpathtypes2) < 0.0f) {
                return blockpathtypes2;
            }
            if (!(pMob.m_21439_(blockpathtypes2) >= pMob.m_21439_(blockpathtypes1))) continue;
            blockpathtypes1 = blockpathtypes2;
        }
        return blockpathtypes == BlockPathTypes.OPEN && pMob.m_21439_(blockpathtypes1) == 0.0f ? BlockPathTypes.OPEN : blockpathtypes1;
    }

    public static BlockPathTypes getBlockPathTypeStatic(BlockGetter getter, BlockPos.MutableBlockPos position, Mob mob) {
        int x = position.m_123341_();
        int y = position.m_123342_();
        int z = position.m_123343_();
        BlockPathTypes pathType = ConstructNodeEvaluator.getBlockPathTypeRaw(getter, (BlockPos)position);
        if (pathType == BlockPathTypes.OPEN && y >= getter.m_141937_() + 1) {
            BlockPathTypes pathTypeBelow = ConstructNodeEvaluator.getBlockPathTypeRaw(getter, (BlockPos)position.m_122178_(x, y - 1, z));
            BlockPathTypes blockPathTypes = pathType = pathTypeBelow != BlockPathTypes.WALKABLE && pathTypeBelow != BlockPathTypes.OPEN && pathTypeBelow != BlockPathTypes.WATER && pathTypeBelow != BlockPathTypes.LAVA ? BlockPathTypes.WALKABLE : BlockPathTypes.OPEN;
            if (pathTypeBelow == BlockPathTypes.DAMAGE_FIRE) {
                pathType = BlockPathTypes.DAMAGE_FIRE;
            }
            if (pathTypeBelow == BlockPathTypes.DAMAGE_CAUTIOUS) {
                pathType = BlockPathTypes.DAMAGE_CAUTIOUS;
            }
            if (pathTypeBelow == BlockPathTypes.DAMAGE_OTHER) {
                pathType = BlockPathTypes.DAMAGE_OTHER;
            }
            if (pathTypeBelow == BlockPathTypes.STICKY_HONEY) {
                pathType = BlockPathTypes.STICKY_HONEY;
            }
        }
        if (pathType == BlockPathTypes.WALKABLE) {
            pathType = ConstructNodeEvaluator.checkNeighbourBlocks(getter, position.m_122178_(x, y, z), pathType);
        }
        return pathType;
    }

    public static BlockPathTypes checkNeighbourBlocks(BlockGetter getter, BlockPos.MutableBlockPos position, BlockPathTypes pathType) {
        int x = position.m_123341_();
        int y = position.m_123342_();
        int z = position.m_123343_();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    if (i == 0 && k == 0) continue;
                    position.m_122178_(x + i, y + j, z + k);
                    BlockState blockstate = getter.m_8055_((BlockPos)position);
                    if (blockstate.m_60713_(Blocks.f_50128_)) {
                        return BlockPathTypes.DAMAGE_CAUTIOUS;
                    }
                    if (blockstate.m_60713_(Blocks.f_50685_)) {
                        return BlockPathTypes.DANGER_OTHER;
                    }
                    if (ConstructNodeEvaluator.isBurningBlock(blockstate)) {
                        return BlockPathTypes.DANGER_FIRE;
                    }
                    if (!getter.m_6425_((BlockPos)position).m_205070_(FluidTags.f_13131_)) continue;
                    return BlockPathTypes.WATER_BORDER;
                }
            }
        }
        return pathType;
    }

    protected static BlockPathTypes getBlockPathTypeRaw(BlockGetter pLevel, BlockPos pPos) {
        BlockState blockstate = pLevel.m_8055_(pPos);
        BlockPathTypes type = blockstate.getBlockPathType(pLevel, pPos, null);
        if (type != null) {
            return type;
        }
        Block block = blockstate.m_60734_();
        if (blockstate.m_60795_()) {
            return BlockPathTypes.OPEN;
        }
        if (!(blockstate.m_204336_(BlockTags.f_13036_) || blockstate.m_60713_(Blocks.f_50196_) || blockstate.m_60713_(Blocks.f_152545_))) {
            if (blockstate.m_60713_(Blocks.f_152499_)) {
                return BlockPathTypes.POWDER_SNOW;
            }
            if (!blockstate.m_60713_(Blocks.f_50128_) && !blockstate.m_60713_(Blocks.f_50685_)) {
                if (blockstate.m_60713_(Blocks.f_50719_)) {
                    return BlockPathTypes.STICKY_HONEY;
                }
                if (blockstate.m_60713_(Blocks.f_50262_)) {
                    return BlockPathTypes.COCOA;
                }
                if (!blockstate.m_60713_(Blocks.f_50070_) && !blockstate.m_60713_(Blocks.f_152588_)) {
                    FluidState fluidstate = pLevel.m_6425_(pPos);
                    BlockPathTypes nonLoggableFluidPathType = fluidstate.getBlockPathType(pLevel, pPos, null, false);
                    if (nonLoggableFluidPathType != null) {
                        return nonLoggableFluidPathType;
                    }
                    if (fluidstate.m_205070_(FluidTags.f_13132_)) {
                        return BlockPathTypes.LAVA;
                    }
                    if (ConstructNodeEvaluator.isBurningBlock(blockstate)) {
                        return BlockPathTypes.DAMAGE_FIRE;
                    }
                    if (block instanceof DoorBlock) {
                        DoorBlock doorblock = (DoorBlock)block;
                        if (((Boolean)blockstate.m_61143_((Property)DoorBlock.f_52727_)).booleanValue()) {
                            return BlockPathTypes.DOOR_OPEN;
                        }
                        return doorblock.m_278711_().f_278463_() ? BlockPathTypes.DOOR_WOOD_CLOSED : BlockPathTypes.DOOR_IRON_CLOSED;
                    }
                    if (block instanceof BaseRailBlock) {
                        return BlockPathTypes.RAIL;
                    }
                    if (block instanceof LeavesBlock) {
                        return BlockPathTypes.LEAVES;
                    }
                    if (!(blockstate.m_204336_(BlockTags.f_13039_) || blockstate.m_204336_(BlockTags.f_13032_) || block instanceof FenceGateBlock && !((Boolean)blockstate.m_61143_((Property)FenceGateBlock.f_53341_)).booleanValue())) {
                        if (!blockstate.m_60647_(pLevel, pPos, PathComputationType.LAND)) {
                            return BlockPathTypes.BLOCKED;
                        }
                        BlockPathTypes loggableFluidPathType = fluidstate.getBlockPathType(pLevel, pPos, null, true);
                        if (loggableFluidPathType != null) {
                            return loggableFluidPathType;
                        }
                        return fluidstate.m_205070_(FluidTags.f_13131_) ? BlockPathTypes.WATER : BlockPathTypes.OPEN;
                    }
                    return BlockPathTypes.FENCE;
                }
                return BlockPathTypes.DAMAGE_CAUTIOUS;
            }
            return BlockPathTypes.DAMAGE_OTHER;
        }
        return BlockPathTypes.TRAPDOOR;
    }

    public static boolean isBurningBlock(BlockState state) {
        return state.m_204336_(BlockTags.f_13076_) || state.m_60713_(Blocks.f_49991_) || state.m_60713_(Blocks.f_50450_) || CampfireBlock.m_51319_((BlockState)state) || state.m_60713_(Blocks.f_152477_);
    }

    public static double getFloorLevel(BlockGetter blockGetter, BlockPos pos) {
        BlockPos below = pos.m_7495_();
        VoxelShape voxelshape = blockGetter.m_8055_(below).m_60812_(blockGetter, below);
        return (double)below.m_123342_() + (voxelshape.m_83281_() ? 0.0 : voxelshape.m_83297_(Direction.Axis.Y));
    }
}

