/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.faction;

import com.google.common.collect.ImmutableList;
import com.mna.Registries;
import com.mna.api.events.BrokerSelectingTradesEvent;
import com.mna.api.faction.IFaction;
import com.mna.api.items.IFactionSpecific;
import com.mna.api.items.IRelic;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.api.sound.SFX;
import com.mna.api.tools.MATags;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.mna.entities.EntityInit;
import com.mna.items.ItemInit;
import com.mna.items.ritual.ItemThaumaturgicLink;
import com.mna.items.sorcery.ItemTornJournalPage;
import com.mna.recipes.RecipeInit;
import com.mna.recipes.eldrin.EldrinAltarRecipe;
import com.mna.recipes.manaweaving.ManaweavingRecipe;
import com.mna.spells.components.ComponentFling;
import com.mna.tools.BiomeUtils;
import com.mna.tools.StructureUtils;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.LookAtTradingPlayerGoal;
import net.minecraft.world.entity.ai.goal.TradeWithPlayerGoal;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Broker
extends WanderingTrader
implements GeoEntity {
    private static List<Item> allFactionItems;
    private MerchantOffers customerLimitedOffers;
    private AnimatableInstanceCache animCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final int NUM_FRAGMENTS = 5;
    private static final EntityDataAccessor<Boolean> DESPAWNING;
    private static final EntityDataAccessor<Boolean> DESPAWNING_HOSTILE;

    public Broker(EntityType<? extends WanderingTrader> type, Level worldIn) {
        super(type, worldIn);
    }

    public Broker(Level world) {
        this((EntityType<? extends WanderingTrader>)((EntityType)EntityInit.BROKER.get()), world);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new TradeWithPlayerGoal((AbstractVillager)this));
        this.f_21345_.m_25352_(1, (Goal)new LookAtTradingPlayerGoal((AbstractVillager)this));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
    }

    protected SoundEvent m_7515_() {
        return null;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return null;
    }

    protected SoundEvent m_5592_() {
        return null;
    }

    public SoundEvent m_7596_() {
        return SFX.Entity.Broker.DEAL;
    }

    protected SoundEvent m_6068_(boolean getYesSound) {
        if (getYesSound) {
            return SFX.Entity.Broker.DEAL;
        }
        return null;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DESPAWNING, (Object)false);
        this.f_19804_.m_135372_(DESPAWNING_HOSTILE, (Object)false);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!((Boolean)this.f_19804_.m_135370_(DESPAWNING)).booleanValue() && this.m_35876_() == 1) {
            this.m_35891_(10);
            this.f_19804_.m_135381_(DESPAWNING, (Object)true);
        }
    }

    public void onRemovedFromWorld() {
        super.onRemovedFromWorld();
        if (this.m_9236_().m_5776_()) {
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SFX.Spell.Impact.AoE.ARCANE, SoundSource.NEUTRAL, 1.0f, 1.0f, true);
            for (int i = 0; i < 200; ++i) {
                int type = (int)Math.floor(Math.random() * 4.0);
                if (type != 2) {
                    this.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)(type == 0 ? (ParticleType)ParticleInit.ARCANE.get() : (type == 2 ? (ParticleType)ParticleInit.DUST.get() : (ParticleType)ParticleInit.FLAME.get()))), this.m_20185_() + Math.random() * 2.0 - 1.0, this.m_20186_() + Math.random() * 2.5, this.m_20189_() + Math.random() * 2.0 - 1.0, Math.random() * 0.2 - 0.1, Math.random() * 0.2 - 0.1, Math.random() * 0.2 - 0.1);
                    continue;
                }
                this.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.EARTH.get())), this.m_20185_() + Math.random() * 2.0 - 1.0, this.m_20186_() + Math.random() * 2.5, this.m_20189_() + Math.random() * 2.0 - 1.0, 0.18, 0.3, 0.03);
            }
            if (((Boolean)this.f_19804_.m_135370_(DESPAWNING_HOSTILE)).booleanValue()) {
                int count = 180;
                double angleRads = 0.0;
                double step = Math.PI * 2 / (double)count;
                double radius = 6.0;
                for (int i = 0; i < count; ++i) {
                    Vec3 dir = new Vec3(Math.cos(angleRads += step), Math.random() * 0.1, Math.sin(angleRads)).m_82541_();
                    Vec3 vel = dir.m_82490_((double)0.3f * radius);
                    dir = dir.m_82490_(0.2);
                    this.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.AIR_VELOCITY.get())).setScale(0.2f).setColor(10, 10, 10), this.m_20185_() + dir.f_82479_, this.m_20186_() + Math.random(), this.m_20189_() + dir.f_82481_, vel.f_82479_, vel.f_82480_, vel.f_82481_);
                }
            }
        } else if (((Boolean)this.f_19804_.m_135370_(DESPAWNING_HOSTILE)).booleanValue()) {
            Vec3 bEyepos = this.m_20182_();
            this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82400_(6.0), e -> e instanceof LivingEntity && e.m_6084_() && e.isAddedToWorld()).stream().map(e -> (LivingEntity)e).forEach(e -> {
                Vec3 direction = e.m_146892_().m_82546_(bEyepos);
                ComponentFling.flingTarget(e, direction, 6.0f, 3.0f, 0.0f);
            });
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_276093_(DamageTypes.f_268724_)) {
            return super.m_6469_(source, amount);
        }
        if (!((Boolean)this.f_19804_.m_135370_(DESPAWNING)).booleanValue()) {
            this.m_35891_(10);
            this.f_19804_.m_135381_(DESPAWNING, (Object)true);
            this.f_19804_.m_135381_(DESPAWNING_HOSTILE, (Object)true);
        }
        return false;
    }

    public static AttributeSupplier.Builder getGlobalAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 120.0).m_22268_(Attributes.f_22281_, 5.0);
    }

    public void m_7713_(ItemStack stack) {
    }

    public void m_6996_(MerchantOffer offer) {
        this.f_35261_.stream().filter(o -> o.m_45355_(offer.m_45358_(), offer.m_45364_())).findFirst().ifPresent(o -> o.m_45374_());
        this.m_5496_(this.m_6068_(true), this.m_6121_(), this.m_6100_());
        super.m_6996_(offer);
    }

    protected void m_35277_(MerchantOffers givenMerchantOffers, VillagerTrades.ItemListing[] newTrades, int maxNumbers) {
        ItemStack output;
        if (this.m_9236_().m_5776_()) {
            return;
        }
        givenMerchantOffers.clear();
        if (allFactionItems == null) {
            allFactionItems = ForgeRegistries.ITEMS.getValues().stream().filter(i -> i instanceof IFactionSpecific).collect(Collectors.toList());
        }
        Random rand = new Random();
        ServerLevel serverLevel = (ServerLevel)this.m_9236_();
        for (Item factionItem : allFactionItems) {
            IFaction thisFaction = ((IFactionSpecific)factionItem).getFaction();
            if (thisFaction == null) continue;
            output = new ItemStack((ItemLike)factionItem);
            List opposingFactionItems = allFactionItems.stream().filter(i -> ((IFactionSpecific)i).getFaction() != null && ((IFactionSpecific)i).getFaction() != thisFaction).collect(Collectors.toList());
            ItemStack opposingItemPrice = new ItemStack((ItemLike)opposingFactionItems.get(rand.nextInt(opposingFactionItems.size())));
            ItemStack tokenPrice = this.getRandomOpposingToken(thisFaction);
            if (tokenPrice.m_41619_() || opposingItemPrice.m_41619_()) continue;
            tokenPrice.m_41764_(32 + rand.nextInt(32));
            MerchantOffer offer = new MerchantOffer(opposingItemPrice, tokenPrice, output, 1, 0, 1.0f);
            givenMerchantOffers.add((Object)offer);
        }
        List all_factions = Registries.Factions.get().getValues().stream().toList();
        for (int i2 = 0; i2 < 5; ++i2) {
            IFaction selected = (IFaction)all_factions.get(rand.nextInt(all_factions.size()));
            output = ItemTornJournalPage.getRandomPage(rand, selected);
            if (output.m_41619_()) continue;
            ItemStack fragmentPrice = new ItemStack((ItemLike)ItemInit.ENTITY_ENTRAPMENT_CRYSTAL.get());
            MerchantOffer offer = new MerchantOffer(fragmentPrice, ItemStack.f_41583_, output, 1, 1, 1.0f);
            givenMerchantOffers.add((Object)offer);
        }
        ItemStack costItem = new ItemStack((ItemLike)ItemInit.SPELL_PART_THESIS.get());
        ItemStack costItemB = new ItemStack((ItemLike)ItemInit.SPELL_PART_THESIS.get());
        StructureUtils.getAllStructures(serverLevel).forEach(structureFeature -> {
            if (!structureFeature.m_203656_(MATags.Structures.BROKER_STRUCTURES)) {
                return;
            }
            ItemStack stack = new ItemStack((ItemLike)ItemInit.THAUMATURGIC_LINK.get());
            ItemThaumaturgicLink.setStructureKey(serverLevel, stack, (Holder<Structure>)structureFeature);
            MerchantOffer offer = new MerchantOffer(costItem.m_41777_(), costItemB.m_41777_(), stack, 1, 0, 1.0f);
            givenMerchantOffers.add((Object)offer);
        });
        BiomeUtils.getAllBiomes(serverLevel).forEach(biome -> {
            if (!biome.m_203656_(MATags.Biomes.BROKER_BIOMES)) {
                return;
            }
            ItemStack stack = new ItemStack((ItemLike)ItemInit.THAUMATURGIC_LINK.get());
            ItemThaumaturgicLink.setBiomeKey(serverLevel, stack, (Holder<Biome>)biome);
            MerchantOffer offer = new MerchantOffer(costItem.m_41777_(), costItemB.m_41777_(), stack, 1, 0, 1.0f);
            givenMerchantOffers.add((Object)offer);
        });
        MinecraftForge.EVENT_BUS.post((Event)new BrokerSelectingTradesEvent((Merchant)this, givenMerchantOffers, newTrades, maxNumbers, (ImmutableList<Item>)ImmutableList.copyOf(allFactionItems)));
    }

    private ItemStack getRandomOpposingToken(IFaction faction) {
        List<IFaction> enemies = faction.getEnemyFactions();
        if (enemies.size() == 0) {
            return ItemStack.f_41583_;
        }
        IFaction selected = enemies.get((int)(Math.random() * (double)enemies.size()));
        if (selected.getTokenItem() == null) {
            return ItemStack.f_41583_;
        }
        return new ItemStack((ItemLike)selected.getTokenItem());
    }

    protected void m_7604_() {
        MerchantOffers merchantoffers = this.m_6616_();
        this.m_35277_(merchantoffers, null, 5);
    }

    public MerchantOffers m_6616_() {
        if (this.f_35261_ == null) {
            this.f_35261_ = new MerchantOffers();
            this.m_7604_();
        }
        return this.customerLimitedOffers != null ? this.customerLimitedOffers : this.f_35261_;
    }

    public void m_7189_(Player player) {
        super.m_7189_(player);
        if (player != null) {
            this.m_6616_();
            this.customerLimitedOffers = new MerchantOffers(this.f_35261_.m_45388_());
            player.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> {
                for (int i = 0; i < this.customerLimitedOffers.size(); ++i) {
                    MerchantOffer offer = (MerchantOffer)this.customerLimitedOffers.get(i);
                    Item output = offer.m_45370_().m_41720_();
                    if (output == ItemInit.TORN_JOURNAL_PAGE.get() || output instanceof IRelic) continue;
                    int requiredTier = 0;
                    Optional<ManaweavingRecipe> recipe = this.m_9236_().m_7465_().m_44013_((RecipeType)RecipeInit.MANAWEAVING_RECIPE_TYPE.get()).stream().filter(r -> r.getResultItem().m_41720_() == output).findFirst();
                    if (recipe.isPresent()) {
                        requiredTier = recipe.get().getTier();
                    } else {
                        Optional<EldrinAltarRecipe> altar_recipe = this.m_9236_().m_7465_().m_44013_((RecipeType)RecipeInit.ELDRIN_ALTAR_TYPE.get()).stream().filter(r -> r.getResultItem().m_41720_() == output).findFirst();
                        if (altar_recipe.isPresent()) {
                            requiredTier = altar_recipe.get().getTier();
                        }
                    }
                    if (requiredTier <= p.getTier()) continue;
                    offer.m_45381_();
                }
            });
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean m_5801_() {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6072_() {
        return false;
    }

    public boolean m_6573_(Player player) {
        return false;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar registrar) {
        registrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, state -> {
            if (!((Boolean)this.f_19804_.m_135370_(DESPAWNING)).booleanValue()) {
                return state.setAndContinue(RawAnimation.begin().thenLoop("animation.model.idle"));
            }
            return state.setAndContinue(RawAnimation.begin().thenLoop("animation.model.slam"));
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animCache;
    }

    static {
        DESPAWNING = SynchedEntityData.m_135353_(Broker.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        DESPAWNING_HOSTILE = SynchedEntityData.m_135353_(Broker.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    }
}

