/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.faction;

import com.mna.api.capabilities.IPlayerProgression;
import com.mna.api.faction.IFaction;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.api.sound.SFX;
import com.mna.capabilities.playerdata.magic.PlayerMagicProvider;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.mna.effects.EffectInit;
import com.mna.entities.faction.base.BaseFlyingFactionMob;
import com.mna.factions.Factions;
import com.mna.network.ServerMessageDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class LivingWard
extends BaseFlyingFactionMob<LivingWard> {
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(LivingWard.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DETONATING = SynchedEntityData.m_135353_(LivingWard.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public LivingWard(EntityType<LivingWard> mobType, Level world) {
        super(mobType, world);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            this.spawnParticles();
        }
    }

    private void spawnParticles() {
        int numParticles = 2;
        for (int i = 0; i < numParticles; ++i) {
            this.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.BLUE_SPARKLE_GRAVITY.get())), this.m_20185_() - 0.3 + Math.random() * 0.6, this.m_20186_() + Math.random() * 1.2, this.m_20189_() - 0.3 + Math.random() * 0.6, 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(4, (Goal)new DetonateGoal(this));
        this.f_21345_.m_25352_(7, (Goal)new BoltAttackGoal(this));
    }

    public void setAttacking(boolean attacking) {
        this.f_19804_.m_135381_(ATTACKING, (Object)attacking);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACKING, (Object)false);
        this.f_19804_.m_135372_(DETONATING, (Object)false);
    }

    @Override
    public void m_6667_(DamageSource cause) {
        super.m_6667_(cause);
        if (cause.m_276093_(DamageTypes.f_268724_) && this.m_9236_().m_5776_() && ((Boolean)this.f_19804_.m_135370_(DETONATING)).booleanValue() && this.m_9236_().m_5776_() && ((Boolean)this.f_19804_.m_135370_(DETONATING)).booleanValue()) {
            for (int i = 0; i < 150; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.BLUE_SPARKLE_VELOCITY.get())), this.m_20185_(), this.m_20186_(), this.m_20189_(), -0.5 + Math.random(), -0.5 + Math.random(), -0.5 + Math.random());
            }
        }
    }

    @Override
    public IFaction getFaction() {
        return Factions.COUNCIL;
    }

    @Override
    public CompoundTag getPacketData() {
        return new CompoundTag();
    }

    @Override
    public void handlePacketData(CompoundTag nbt) {
    }

    @Override
    protected PlayState handleAnimState(AnimationState<? extends BaseFlyingFactionMob<?>> state) {
        return state.setAndContinue(RawAnimation.begin().thenLoop("animation.arcane_eye.idle"));
    }

    public static AttributeSupplier.Builder getGlobalAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 5.0).m_22268_(Attributes.f_22279_, (double)0.6f).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22283_, 40.0).m_22268_(Attributes.f_22282_, 0.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22278_, 0.0);
    }

    public static boolean canSpawnPredicate(EntityType<LivingWard> type, ServerLevelAccessor worldIn, MobSpawnType reason, BlockPos pos, RandomSource randomIn) {
        return worldIn.m_46791_() != Difficulty.PEACEFUL && Monster.m_219009_((ServerLevelAccessor)worldIn, (BlockPos)pos, (RandomSource)randomIn) && LivingWard.m_217057_(type, (LevelAccessor)worldIn, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)randomIn);
    }

    static class DetonateGoal
    extends Goal {
        private final LivingWard parentEntity;
        private int updateCount = 0;

        public DetonateGoal(LivingWard ward) {
            this.parentEntity = ward;
        }

        public boolean m_8036_() {
            return this.parentEntity.m_5448_() != null && this.parentEntity.m_21223_() < this.parentEntity.m_21223_() * 0.35f;
        }

        public boolean m_8045_() {
            return this.parentEntity.m_5448_() != null;
        }

        public void m_8056_() {
            this.parentEntity.f_19804_.m_135381_(DETONATING, (Object)true);
        }

        public void m_8037_() {
            if (this.parentEntity.m_5448_() == null) {
                return;
            }
            if (++this.updateCount > 10) {
                this.updateCount = 0;
                this.parentEntity.m_20219_(this.parentEntity.m_146892_());
            }
            if (this.parentEntity.m_20270_((Entity)this.parentEntity.m_5448_()) < 5.0f) {
                this.parentEntity.m_9236_().m_6249_((Entity)this.parentEntity, this.parentEntity.m_20191_().m_82400_(7.5), e -> {
                    if (!(e instanceof Player) || !e.m_6084_()) {
                        return false;
                    }
                    IPlayerProgression progression = (IPlayerProgression)((Player)e).getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
                    return progression != null && progression.getAlliedFaction() != null && progression.getAlliedFaction() != Factions.COUNCIL;
                }).stream().map(e -> (Player)e).forEach(p -> p.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> m.getCastingResource().consume((LivingEntity)p, m.getCastingResource().getMaxAmount() * 0.1f)));
                this.parentEntity.m_6469_(this.parentEntity.m_269291_().m_269341_(), 50000.0f);
            }
        }
    }

    static class BoltAttackGoal
    extends Goal {
        private final LivingWard parentEntity;
        public int attackTimer;

        public BoltAttackGoal(LivingWard ward) {
            this.parentEntity = ward;
        }

        public boolean m_8036_() {
            return this.parentEntity.m_5448_() != null;
        }

        public void m_8056_() {
            this.attackTimer = 0;
        }

        public void m_8041_() {
            this.parentEntity.setAttacking(false);
        }

        public boolean m_8045_() {
            return this.parentEntity.m_5448_() != null && this.parentEntity.m_5448_().m_6084_();
        }

        public void m_8037_() {
            LivingEntity livingentity = this.parentEntity.m_5448_();
            if (livingentity == null) {
                return;
            }
            if (livingentity.m_20280_((Entity)this.parentEntity) < 144.0 && this.parentEntity.m_21574_().m_148306_((Entity)livingentity)) {
                ++this.attackTimer;
                if (this.attackTimer == 40) {
                    this.parentEntity.setAttacking(true);
                }
                if (this.attackTimer == 42) {
                    if (!this.parentEntity.m_20067_()) {
                        this.parentEntity.m_5496_(SFX.Spell.Cast.ARCANE, 1.0f, (float)((double)0.9f + Math.random() * (double)0.2f));
                    }
                    boolean isMiss = Math.random() > (double)(0.3f + (float)this.parentEntity.getTier() * 0.5f);
                    Vec3 offset = new Vec3(0.0, 0.0, 0.0);
                    if (isMiss) {
                        offset = new Vec3(Math.random() - 0.5, Math.random() - 0.5, Math.random() * 0.5);
                    }
                    int color = -10545027;
                    ServerMessageDispatcher.sendParticleSpawn(this.parentEntity.m_20185_(), this.parentEntity.m_20186_(), this.parentEntity.m_20189_(), this.parentEntity.m_5448_().m_20185_() + offset.m_7096_(), this.parentEntity.m_5448_().m_20186_() + (double)this.parentEntity.m_5448_().m_20192_() + offset.m_7098_(), this.parentEntity.m_5448_().m_20189_() + offset.m_7094_(), color, 64.0f, (ResourceKey<Level>)this.parentEntity.m_9236_().m_46472_(), (MAParticleType)((Object)ParticleInit.LIGHTNING_BOLT.get()));
                    if (!isMiss) {
                        if (!this.parentEntity.m_5448_().m_20096_() && this.parentEntity.m_5448_().m_21124_((MobEffect)EffectInit.DAMPEN_MAGIC.get()) == null) {
                            this.parentEntity.m_5448_().m_7292_(new MobEffectInstance((MobEffect)EffectInit.DAMPEN_MAGIC.get(), 100));
                        }
                        this.parentEntity.m_5448_().m_6469_(this.parentEntity.m_269291_().m_269333_((LivingEntity)this.parentEntity), 4.0f);
                    }
                } else if (this.attackTimer >= 62) {
                    this.parentEntity.setAttacking(false);
                    this.attackTimer = 0;
                }
            } else if (this.attackTimer > 0) {
                --this.attackTimer;
            }
        }
    }
}

