/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.projectile;

import com.mna.api.capabilities.IPlayerProgression;
import com.mna.api.entities.IFactionEnemy;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.mna.entities.EntityInit;
import com.mna.factions.Factions;
import com.mna.tools.math.MathUtils;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;

public class WitchhunterTrickshot
extends Entity {
    protected static final EntityDataAccessor<String> EFFECT_ID = SynchedEntityData.m_135353_(WitchhunterTrickshot.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    protected static final EntityDataAccessor<CompoundTag> LERPDATA = SynchedEntityData.m_135353_(WitchhunterTrickshot.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    private static final int maxAge = 20;
    private static final float arrowSpawnAge = 10.0f;
    private static final float radius = 4.0f;
    private int effectDuration;
    private int effectMagnitude;
    private Vec3 cachedOffset;
    private MobEffect cachedEffect;
    private Vec3 potion_control_1;
    private Vec3 potion_control_2;

    public WitchhunterTrickshot(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    public WitchhunterTrickshot(Level world, Vec3 initialPosition, Vec3 destPos, MobEffect effect) {
        this(world, initialPosition, destPos, effect, 200, 0);
    }

    public WitchhunterTrickshot(Level world, Vec3 initialPosition, Vec3 destPos, MobEffect effect, int duration, int magnitude) {
        super((EntityType)EntityInit.WITCH_HUNTER_TRICKSHOT.get(), world);
        this.m_6021_(initialPosition.f_82479_, initialPosition.f_82480_, initialPosition.f_82481_);
        this.setDestinationPoint(destPos);
        this.setEffect(effect);
        this.effectDuration = duration;
        this.effectMagnitude = magnitude;
    }

    public void m_8119_() {
        ++this.f_19797_;
        if (this.m_9236_().m_5776_() && (float)this.f_19797_ == 10.0f) {
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11847_, SoundSource.HOSTILE, 1.0f, (float)(0.9 + Math.random() * 0.2), false);
        }
        if (this.f_19797_ >= 20) {
            if (!this.m_9236_().m_5776_()) {
                this.applyEffect();
            }
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public void onRemovedFromWorld() {
        super.onRemovedFromWorld();
        if (this.m_9236_().m_5776_() && this.getEffect() != null) {
            this.m_9236_().m_46796_(2002, BlockPos.m_274446_((Position)this.getDestination()), this.getEffect().m_19484_());
        }
    }

    public boolean renderArrow() {
        return (float)this.f_19797_ > 10.0f;
    }

    public Vec3 getPotionPosition(float partialTicks) {
        if (!this.calculateControlPoints()) {
            return this.m_20182_();
        }
        float f = ((float)this.f_19797_ + partialTicks) / 20.0f;
        return MathUtils.bezierVector3d(this.m_20182_(), this.getDestination(), this.potion_control_1, this.potion_control_2, f);
    }

    public Vec3 getArrowPosition(float partialTicks) {
        float f = MathUtils.clamp01(((float)this.f_19797_ + partialTicks - 10.0f) / 10.0f);
        return MathUtils.lerpVector3d(this.m_20182_(), this.getDestination(), f);
    }

    @Nullable
    public MobEffect getEffect() {
        if (this.cachedEffect == null) {
            ResourceLocation effectID = new ResourceLocation((String)this.f_19804_.m_135370_(EFFECT_ID));
            this.cachedEffect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(effectID);
        }
        return this.cachedEffect;
    }

    private void applyEffect() {
        MobEffect effect = this.getEffect();
        if (effect == null) {
            return;
        }
        List targets = this.m_9236_().m_6249_((Entity)this, new AABB(BlockPos.m_274446_((Position)this.getDestination())).m_82400_(4.0), e -> {
            if (!e.m_6084_()) {
                return false;
            }
            if (e instanceof Player) {
                Player p = (Player)e;
                IPlayerProgression prog = (IPlayerProgression)p.getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
                if (prog == null) {
                    return false;
                }
                return prog.getAlliedFaction() != null && prog.getAlliedFaction() != Factions.COUNCIL;
            }
            if (e instanceof IFactionEnemy) {
                return ((IFactionEnemy)e).getFaction() != null && ((IFactionEnemy)e).getFaction() != Factions.COUNCIL;
            }
            return false;
        }).stream().map(e -> (LivingEntity)e).collect(Collectors.toList());
        for (LivingEntity e2 : targets) {
            e2.m_7292_(new MobEffectInstance(effect, this.effectDuration, this.effectMagnitude));
        }
    }

    public void setEffect(MobEffect effect) {
        this.f_19804_.m_135381_(EFFECT_ID, (Object)ForgeRegistries.MOB_EFFECTS.getKey((Object)effect).toString());
    }

    public void setDestinationPoint(Vec3 dest) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128347_("x", dest.f_82479_);
        nbt.m_128347_("y", dest.f_82480_);
        nbt.m_128347_("z", dest.f_82481_);
        this.f_19804_.m_135381_(LERPDATA, (Object)nbt);
        Vec3 vector3d = dest.m_82546_(this.m_20182_()).m_82541_();
        double f = vector3d.m_165924_();
        this.m_146922_((float)(Mth.m_14136_((double)vector3d.f_82479_, (double)vector3d.f_82481_) * 57.2957763671875));
        this.m_146926_((float)(Mth.m_14136_((double)vector3d.f_82480_, (double)f) * 57.2957763671875));
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
    }

    private boolean calculateControlPoints() {
        if (this.potion_control_1 != null && this.potion_control_2 != null) {
            return true;
        }
        Vec3 start = this.m_20182_();
        Vec3 end = this.getDestination();
        if (start == null || end == null) {
            return false;
        }
        this.potion_control_1 = start.m_82549_(end.m_82546_(start).m_82490_(0.3)).m_82520_(0.0, 1.0, 0.0);
        this.potion_control_2 = start.m_82549_(end.m_82546_(start).m_82490_(0.6)).m_82520_(0.0, 1.0, 0.0);
        return true;
    }

    public AABB m_6921_() {
        return this.m_20191_().m_82400_(16.0);
    }

    @Nullable
    public Vec3 getDestination() {
        if (this.cachedOffset == null) {
            CompoundTag nbt = (CompoundTag)this.f_19804_.m_135370_(LERPDATA);
            if (!(nbt != null && nbt.m_128441_("x") && nbt.m_128441_("y") && nbt.m_128441_("z"))) {
                return null;
            }
            this.cachedOffset = new Vec3(nbt.m_128459_("x"), nbt.m_128459_("y"), nbt.m_128459_("z"));
        }
        return this.cachedOffset;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(EFFECT_ID, (Object)ForgeRegistries.MOB_EFFECTS.getKey((Object)MobEffects.f_19597_).toString());
        this.f_19804_.m_135372_(LERPDATA, (Object)new CompoundTag());
    }

    protected void m_7378_(CompoundTag compound) {
        if (compound.m_128441_("effect")) {
            this.f_19804_.m_135381_(EFFECT_ID, (Object)compound.m_128423_("effect").m_7916_());
        }
        if (compound.m_128441_("lerpdata")) {
            this.f_19804_.m_135381_(LERPDATA, (Object)((CompoundTag)compound.m_128423_("lerpdata")));
        }
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128359_("effect", (String)this.f_19804_.m_135370_(EFFECT_ID));
        compound.m_128365_("lerpdata", (Tag)this.f_19804_.m_135370_(LERPDATA));
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

