/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.renderers.boss.effects;

import com.mna.entities.boss.effects.DemonReturnPortal;
import com.mna.tools.render.MARenderTypes;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class DemonReturnPortalRenderer
extends EntityRenderer<DemonReturnPortal> {
    private static final int[] color = new int[]{217, 72, 0};

    public DemonReturnPortalRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(DemonReturnPortal entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        float spawnPct = (float)Math.min(entityIn.getAge(), 20) / 20.0f;
        if (entityIn.getAge() > 160) {
            spawnPct = (float)Math.max(180 - entityIn.getAge(), 0) / 20.0f;
        }
        float scaleFactor = 8.0f * spawnPct;
        float portalSpinDegrees = entityIn.getAge() * 3 % 360;
        VertexConsumer vertexBuilder = bufferIn.m_6299_(MARenderTypes.PORTAL_RENDER);
        matrixStackIn.m_85836_();
        matrixStackIn.m_85841_(scaleFactor, scaleFactor, scaleFactor);
        matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(portalSpinDegrees));
        matrixStackIn.m_252880_(0.0f, -0.25f, 0.0f);
        PoseStack.Pose matrixstack$entry = matrixStackIn.m_85850_();
        Matrix4f renderMatrix = matrixstack$entry.m_252922_();
        Matrix3f normalMatrix = matrixstack$entry.m_252943_();
        float nrmV = (float)Math.cos((double)portalSpinDegrees * Math.PI / 180.0);
        float nrmH = (float)Math.cos((double)(portalSpinDegrees - 90.0f) * Math.PI / 180.0);
        DemonReturnPortalRenderer.addVertex(vertexBuilder, renderMatrix, normalMatrix, packedLightIn, 0.0f, 0.0f, 0.0f, 1.0f, nrmH, nrmV, color);
        DemonReturnPortalRenderer.addVertex(vertexBuilder, renderMatrix, normalMatrix, packedLightIn, 1.0f, 0.0f, 1.0f, 1.0f, nrmH, nrmV, color);
        DemonReturnPortalRenderer.addVertex(vertexBuilder, renderMatrix, normalMatrix, packedLightIn, 1.0f, 1.0f, 1.0f, 0.0f, nrmH, nrmV, color);
        DemonReturnPortalRenderer.addVertex(vertexBuilder, renderMatrix, normalMatrix, packedLightIn, 0.0f, 1.0f, 0.0f, 0.0f, nrmH, nrmV, color);
        matrixStackIn.m_85849_();
        matrixStackIn.m_85836_();
        matrixStackIn.m_85841_(scaleFactor, scaleFactor, scaleFactor);
        matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(-portalSpinDegrees));
        matrixStackIn.m_252880_(0.0f, -0.25f, 0.001f);
        matrixstack$entry = matrixStackIn.m_85850_();
        renderMatrix = matrixstack$entry.m_252922_();
        normalMatrix = matrixstack$entry.m_252943_();
        nrmH = (float)Math.cos((double)(portalSpinDegrees + 90.0f) * Math.PI / 180.0);
        DemonReturnPortalRenderer.addVertex(vertexBuilder, renderMatrix, normalMatrix, packedLightIn, 0.0f, 0.0f, 0.0f, 1.0f, nrmH, nrmV, color);
        DemonReturnPortalRenderer.addVertex(vertexBuilder, renderMatrix, normalMatrix, packedLightIn, 1.0f, 0.0f, 1.0f, 1.0f, nrmH, nrmV, color);
        DemonReturnPortalRenderer.addVertex(vertexBuilder, renderMatrix, normalMatrix, packedLightIn, 1.0f, 1.0f, 1.0f, 0.0f, nrmH, nrmV, color);
        DemonReturnPortalRenderer.addVertex(vertexBuilder, renderMatrix, normalMatrix, packedLightIn, 0.0f, 1.0f, 0.0f, 0.0f, nrmH, nrmV, color);
        matrixStackIn.m_85849_();
        super.m_7392_((Entity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    private static void addVertex(VertexConsumer vertexBuilder_, Matrix4f renderMatrix, Matrix3f normalMatrix, int packedLight, float x, float y, float u, float v, float nrmH, float nrmV, int[] rgb) {
        vertexBuilder_.m_252986_(renderMatrix, x - 0.5f, y - 0.25f, 0.0f).m_6122_(rgb[0], rgb[1], rgb[2], 230).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normalMatrix, nrmH, nrmV, nrmH).m_5752_();
    }

    public ResourceLocation getTextureLocation(DemonReturnPortal entity) {
        return MARenderTypes.PORTAL_TEXTURE;
    }
}

