/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.renderers.player;

import com.mna.api.affinity.Affinity;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.api.spells.adjusters.SpellAdjustingContext;
import com.mna.api.spells.adjusters.SpellCastStage;
import com.mna.items.sorcery.ItemBangle;
import com.mna.items.sorcery.ItemSpell;
import com.mna.items.sorcery.ItemSpellBook;
import com.mna.items.sorcery.ItemStaff;
import com.mna.spells.SpellAdjusters;
import com.mna.spells.crafting.SpellRecipe;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class HandParticleLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    public HandParticleLayer(RenderLayerParent<T, M> rendererIn) {
        super(rendererIn);
    }

    public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, T entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack leftHandItem;
        if (entitylivingbaseIn.m_20145_()) {
            return;
        }
        boolean playerIsRightHanded = entitylivingbaseIn.m_5737_() == HumanoidArm.RIGHT;
        boolean itemIsInUse = entitylivingbaseIn.m_21212_() > 0;
        InteractionHand activeHand = entitylivingbaseIn.m_7655_();
        ItemStack rightHandItem = playerIsRightHanded ? entitylivingbaseIn.m_21206_() : entitylivingbaseIn.m_21205_();
        ItemStack itemStack = leftHandItem = playerIsRightHanded ? entitylivingbaseIn.m_21205_() : entitylivingbaseIn.m_21206_();
        if (!rightHandItem.m_41619_() || !leftHandItem.m_41619_()) {
            matrixStackIn.m_85836_();
            if (this.m_117386_().f_102610_) {
                matrixStackIn.m_85837_(0.0, 0.75, 0.0);
                matrixStackIn.m_85841_(0.5f, 0.5f, 0.5f);
            }
            if (!itemIsInUse || playerIsRightHanded && activeHand == InteractionHand.OFF_HAND || !playerIsRightHanded && activeHand == InteractionHand.MAIN_HAND) {
                this.renderHandParticle((LivingEntity)entitylivingbaseIn, leftHandItem, ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, HumanoidArm.RIGHT, matrixStackIn, bufferIn, packedLightIn);
            }
            if (!itemIsInUse || !playerIsRightHanded && activeHand == InteractionHand.OFF_HAND || playerIsRightHanded && activeHand == InteractionHand.MAIN_HAND) {
                this.renderHandParticle((LivingEntity)entitylivingbaseIn, rightHandItem, ItemDisplayContext.THIRD_PERSON_LEFT_HAND, HumanoidArm.LEFT, matrixStackIn, bufferIn, packedLightIn);
            }
            matrixStackIn.m_85849_();
        }
    }

    private void renderHandParticle(LivingEntity living, ItemStack stack, ItemDisplayContext ItemDisplayContext2, HumanoidArm side, PoseStack matrixStack, MultiBufferSource buffer, int packedLight) {
        if (Minecraft.m_91087_().m_91104_()) {
            return;
        }
        if (!stack.m_41619_() && stack.m_41720_() instanceof ItemSpell) {
            boolean leftHand;
            matrixStack.m_85836_();
            CompoundTag nbt = ((ItemSpell)stack.m_41720_()).getSpellCompound(stack, living instanceof Player ? (Player)living : null);
            SpellRecipe recipe = SpellRecipe.fromNBT(nbt);
            Matrix4f curMatrix = matrixStack.m_85850_().m_252922_();
            Matrix4f inverted = curMatrix.invert();
            curMatrix.mul((Matrix4fc)inverted);
            matrixStack.m_252781_(Axis.f_252436_.m_252977_(-living.f_20883_));
            matrixStack.m_252781_(Axis.f_252495_.m_252977_(-90.0f));
            ((ArmedModel)this.m_117386_()).m_6002_(side, matrixStack);
            if (stack.m_41720_() instanceof ItemStaff && !(stack.m_41720_() instanceof ItemBangle)) {
                matrixStack.m_85837_(0.0, 1.5, 0.0);
            } else if (stack.m_41720_() instanceof ItemSpellBook && ((ItemSpellBook)stack.m_41720_()).renderBookModel) {
                matrixStack.m_85837_(0.0, 0.5, -0.55);
            }
            boolean bl = leftHand = side == HumanoidArm.LEFT;
            if (leftHand) {
                matrixStack.m_85837_(0.225, 0.65, -0.95);
            } else {
                matrixStack.m_85837_(-0.225, 0.65, -0.95);
            }
            if (living instanceof Player && SpellAdjusters.checkHellfireStaff(new SpellAdjustingContext(stack, recipe, living, SpellCastStage.CASTING))) {
                SpellAdjusters.modifyHellfireStaff(recipe, living);
            }
            Affinity[] affs = recipe.getAffinity().keySet().toArray(new Affinity[0]);
            this.spawnParticleFromMatrix(affs[(int)(Math.random() * (double)affs.length)], recipe, matrixStack, living, ItemDisplayContext2);
            matrixStack.m_85849_();
        }
    }

    private void spawnParticleFromMatrix(Affinity affinity, SpellRecipe recipe, PoseStack matrixStackIn, LivingEntity entitylivingbaseIn, ItemDisplayContext type) {
        Vec3 playerPos = entitylivingbaseIn.m_20182_();
        Matrix4f curMatrix = matrixStackIn.m_85850_().m_252922_();
        Vec3 particlePos = playerPos.m_82549_(new Vec3((double)curMatrix.m03(), (double)curMatrix.m13(), (double)curMatrix.m23()));
        switch (affinity) {
            case ARCANE: {
                Vec3 origin = new Vec3(particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_);
                Vec3 offset = new Vec3(entitylivingbaseIn.m_9236_().f_46441_.m_188583_(), entitylivingbaseIn.m_9236_().f_46441_.m_188583_(), entitylivingbaseIn.m_9236_().f_46441_.m_188583_()).m_82541_().m_82490_((double)0.3f);
                origin = origin.m_82549_(offset);
                entitylivingbaseIn.m_9236_().m_7106_((ParticleOptions)recipe.colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ARCANE_LERP.get())), (Entity)entitylivingbaseIn), origin.f_82479_, origin.f_82480_, origin.f_82481_, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_);
                break;
            }
            case EARTH: {
                entitylivingbaseIn.m_9236_().m_7106_((ParticleOptions)recipe.colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.DUST.get())), (Entity)entitylivingbaseIn), particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, (double)-0.005f + Math.random() * (double)0.01f, (double)0.03f, (double)-0.005f + Math.random() * (double)0.01f);
                break;
            }
            case ENDER: {
                Vec3 origin = new Vec3(particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_);
                Vec3 offset = new Vec3(entitylivingbaseIn.m_9236_().f_46441_.m_188583_(), entitylivingbaseIn.m_9236_().f_46441_.m_188583_(), entitylivingbaseIn.m_9236_().f_46441_.m_188583_()).m_82541_().m_82490_((double)0.3f);
                origin = origin.m_82549_(offset);
                entitylivingbaseIn.m_9236_().m_7106_((ParticleOptions)recipe.colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ENDER.get())), (Entity)entitylivingbaseIn), origin.f_82479_, origin.f_82480_, origin.f_82481_, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_);
                break;
            }
            case FIRE: {
                entitylivingbaseIn.m_9236_().m_7106_((ParticleOptions)recipe.colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FLAME.get())), (Entity)entitylivingbaseIn), particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 0.0, 0.0, 0.0);
                break;
            }
            case HELLFIRE: {
                entitylivingbaseIn.m_9236_().m_7106_((ParticleOptions)recipe.colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.HELLFIRE.get())), (Entity)entitylivingbaseIn), particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 0.0, 0.0, 0.0);
                break;
            }
            case LIGHTNING: {
                entitylivingbaseIn.m_9236_().m_7106_((ParticleOptions)recipe.colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.LIGHTNING_BOLT.get())), (Entity)entitylivingbaseIn), particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, particlePos.f_82479_ - (double)0.4f + Math.random() * (double)0.8f, particlePos.f_82480_ - (double)0.4f + Math.random() * (double)0.8f, particlePos.f_82481_ - (double)0.4f + Math.random() * (double)0.8f);
                break;
            }
            case WATER: {
                entitylivingbaseIn.m_9236_().m_7106_((ParticleOptions)recipe.colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.WATER.get())), (Entity)entitylivingbaseIn), particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, -0.05 * Math.random() * 0.1, Math.random() * 0.05, -0.05 * Math.random() * 0.1);
                break;
            }
            case ICE: {
                entitylivingbaseIn.m_9236_().m_7106_((ParticleOptions)recipe.colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FROST.get())), (Entity)entitylivingbaseIn), particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 0.0, 0.0, 0.0);
                break;
            }
            case WIND: {
                entitylivingbaseIn.m_9236_().m_7106_((ParticleOptions)recipe.colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.AIR_ORBIT.get())).setScale(0.05f).setColor(10, 10, 10), (Entity)entitylivingbaseIn), particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, (double)0.3f, (double)0.01f, (double)0.05f);
                break;
            }
        }
    }
}

