/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.rituals;

import com.mna.ManaAndArtifice;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.api.sound.SFX;
import com.mna.entities.boss.DemonLord;
import com.mna.sound.EntityAliveLoopingSound;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;

public class DemonStone
extends Entity {
    protected int age = 0;
    private static final EntityDataAccessor<String> CASTER_UUID = SynchedEntityData.m_135353_(DemonStone.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private boolean summonAsHostile = false;

    public DemonStone(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    public DemonStone setSummonAsHostile() {
        this.summonAsHostile = true;
        return this;
    }

    public void m_8119_() {
        ++this.age;
        if (this.m_9236_().m_5776_()) {
            this.playSounds();
            this.spawnParticles();
        }
        if (this.age > 200 && !this.m_9236_().m_5776_()) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            DemonLord edl = new DemonLord(this.m_9236_());
            edl.m_146884_(this.m_20182_());
            this.m_9236_().m_7967_((Entity)edl);
            if (!this.summonAsHostile) {
                UUID casterUUID = this.getCasterUUID();
                Player player = null;
                if (casterUUID != null) {
                    player = this.m_9236_().m_46003_(casterUUID);
                }
                edl.setSummoner(player);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void playSounds() {
        if (this.age == 1) {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new EntityAliveLoopingSound(SFX.Loops.DEMON_SUMMON, this));
        } else if (this.age == 120) {
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SFX.Event.Ritual.DEMON_SUMMON_END, SoundSource.PLAYERS, 1.0f, 1.0f, false);
        }
    }

    private void spawnParticles() {
        int i;
        for (i = 0; i < 5; ++i) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123802_, this.m_20185_() - 1.5 + Math.random() * 3.0, this.m_20186_(), this.m_20189_() - 1.5 + Math.random() * 3.0, 0.0, (double)0.05f, 0.0);
        }
        if (this.age < 150) {
            for (i = 0; i < 5; ++i) {
                boolean xAxis = Math.random() > 0.5;
                boolean positive = Math.random() > 0.5;
                this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50197_.m_49966_()), xAxis ? (positive ? this.m_20185_() + 2.5 - Math.random() * 0.5 : this.m_20185_() - 2.5 + Math.random() * 0.5) : this.m_20185_() + 2.5 - Math.random() * 5.0, this.m_20186_(), !xAxis ? (positive ? this.m_20189_() + 2.5 - Math.random() * 0.5 : this.m_20189_() - 2.5 + Math.random() * 0.5) : this.m_20189_() + 2.5 - Math.random() * 5.0, 0.0, (double)0.05f, 0.0);
            }
        }
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123756_, this.m_20185_() - 0.5 + Math.random() * 1.0, this.m_20186_(), this.m_20189_() - 0.5 + Math.random() * 1.0, 0.0, (double)0.05f, 0.0);
        if (this.age > 160) {
            for (i = 0; i < 25; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.HELLFIRE.get())), this.m_20185_() - 0.25 + Math.random() * 0.5, this.m_20186_(), this.m_20189_() - 0.25 + Math.random() * 0.5, 0.0, (double)0.15f, 0.0);
            }
        }
        if (this.age == 199) {
            for (i = 0; i < 100; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50197_.m_49966_()), this.m_20185_() - 1.5 + Math.random() * 3.0, this.m_20186_() + 1.5, this.m_20189_() - 1.5 + Math.random() * 3.0, -0.5 + Math.random(), 0.0, -0.5 + Math.random());
            }
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123812_, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), 0.0, 0.0, 0.0);
        }
    }

    public int getAge() {
        return this.age;
    }

    public boolean m_6097_() {
        return false;
    }

    public boolean m_6087_() {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(CASTER_UUID, (Object)"");
    }

    protected void m_7378_(CompoundTag compound) {
        if (compound.m_128441_("age")) {
            this.age = compound.m_128451_("age");
        }
        if (compound.m_128441_("caster")) {
            this.f_19804_.m_135381_(CASTER_UUID, (Object)compound.m_128461_("caster"));
        }
        if (compound.m_128441_("summonHostile")) {
            this.summonAsHostile = compound.m_128471_("summonHostile");
        }
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128405_("age", this.age);
        compound.m_128359_("caster", (String)this.f_19804_.m_135370_(CASTER_UUID));
        compound.m_128379_("summonHostile", this.summonAsHostile);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public UUID getCasterUUID() {
        try {
            UUID uUID = UUID.fromString((String)this.f_19804_.m_135370_(CASTER_UUID));
            return uUID;
        }
        catch (Exception exception) {
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        return null;
    }

    public void setCasterUUID(UUID casterUUID) {
        if (casterUUID != null) {
            this.f_19804_.m_135381_(CASTER_UUID, (Object)casterUUID.toString());
        } else {
            ManaAndArtifice.LOGGER.error("Received null UUID for ritual caster.  Some effects may not apply!");
        }
    }
}

