/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.rituals;

import com.mna.Registries;
import com.mna.api.capabilities.IPlayerMagic;
import com.mna.api.config.GeneralConfigValues;
import com.mna.api.faction.IFaction;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.capabilities.playerdata.magic.PlayerMagicProvider;
import com.mna.items.ItemInit;
import com.mna.tools.TeleportHelper;
import com.mojang.datafixers.util.Pair;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.NetworkHooks;

public class Portal
extends Entity {
    private static final String KEY_AGE = "age";
    private static final String KEY_PERMANENT = "permanent";
    private static final String KEY_RTP = "rtp";
    private static final String KEY_COLOR = "color";
    private static final String KEY_FACTION_ID = "faction_id";
    private static final String KEY_FACTION_IDX = "faction_idx";
    private static final String KEY_TP_X = "teleport_pos_x";
    private static final String KEY_TP_Y = "teleport_pos_y";
    private static final String KEY_TP_Z = "teleport_pos_z";
    private static final String KEY_TP_DIM_KEYTYPE = "dimension_key_type";
    private static final String KEY_TP_DIM_KEY = "dimension_key";
    private static final EntityDataAccessor<BlockPos> TELEPORT_POS = SynchedEntityData.m_135353_(Portal.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private static final EntityDataAccessor<Integer> DYE_COLOR = SynchedEntityData.m_135353_(Portal.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> RTP = SynchedEntityData.m_135353_(Portal.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<String> FACTION_ID = SynchedEntityData.m_135353_(Portal.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Byte> FACTION_IDX = SynchedEntityData.m_135353_(Portal.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private ResourceKey<Level> dimension;
    private int age = 0;
    private int maxAge = 200;
    private boolean permanent = false;
    private Pair<IFaction, Byte> _renderData = null;

    public Portal(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    public void m_8119_() {
        ++this.age;
        this.m_9236_().m_6249_((Entity)this, this.m_20191_(), e -> e.m_6084_() && e instanceof ItemEntity).stream().map(e -> (ItemEntity)e).forEach(e -> {
            ItemStack stack = e.m_32055_();
            if (stack.m_41720_() == ItemInit.RUNE_MARKING.get()) {
                if (this.m_9236_().m_5776_()) {
                    this.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.SPARKLE_GRAVITY.get())), e.m_20185_(), e.m_20186_(), e.m_20189_(), 0.0, 0.0, 0.0);
                } else {
                    this.maxAge = this.age + 20;
                    this.permanent = false;
                    e.m_142687_(Entity.RemovalReason.DISCARDED);
                }
            }
        });
        if (!this.m_9236_().m_5776_() && !this.permanent && this.getAge() >= this.maxAge) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public void m_6075_() {
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(TELEPORT_POS, (Object)BlockPos.f_121853_);
        this.f_19804_.m_135372_(DYE_COLOR, (Object)-1);
        this.f_19804_.m_135372_(RTP, (Object)false);
        this.f_19804_.m_135372_(FACTION_ID, (Object)"");
        this.f_19804_.m_135372_(FACTION_IDX, (Object)0);
    }

    protected void m_7378_(CompoundTag compound) {
        if (compound.m_128441_(KEY_AGE)) {
            this.age = compound.m_128451_(KEY_AGE);
        }
        if (compound.m_128441_(KEY_TP_X) && compound.m_128441_(KEY_TP_Y) && compound.m_128441_(KEY_TP_Z) && compound.m_128441_(KEY_TP_DIM_KEY) && compound.m_128441_(KEY_TP_DIM_KEYTYPE)) {
            this.setTeleportBlockPos(new BlockPos(compound.m_128451_(KEY_TP_X), compound.m_128451_(KEY_TP_Y), compound.m_128451_(KEY_TP_Z)), (ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)net.minecraft.core.registries.Registries.f_256858_, (ResourceLocation)new ResourceLocation(compound.m_128461_(KEY_TP_DIM_KEYTYPE))));
        }
        if (compound.m_128441_(KEY_PERMANENT)) {
            this.permanent = compound.m_128471_(KEY_PERMANENT);
        }
        if (compound.m_128441_(KEY_RTP)) {
            this.f_19804_.m_135381_(RTP, (Object)compound.m_128471_(KEY_RTP));
        }
        if (compound.m_128441_(KEY_COLOR)) {
            this.f_19804_.m_135381_(DYE_COLOR, (Object)compound.m_128451_(KEY_COLOR));
        }
        if (compound.m_128441_(KEY_FACTION_ID)) {
            this.f_19804_.m_135381_(FACTION_ID, (Object)compound.m_128461_(KEY_FACTION_ID));
        }
        if (compound.m_128441_(KEY_FACTION_IDX)) {
            this.f_19804_.m_135381_(FACTION_IDX, (Object)compound.m_128445_(KEY_FACTION_IDX));
        }
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128405_(KEY_AGE, this.getAge());
        compound.m_128379_(KEY_PERMANENT, this.permanent);
        compound.m_128379_(KEY_RTP, ((Boolean)this.f_19804_.m_135370_(RTP)).booleanValue());
        compound.m_128405_(KEY_COLOR, ((Integer)this.f_19804_.m_135370_(DYE_COLOR)).intValue());
        compound.m_128359_(KEY_FACTION_ID, (String)this.f_19804_.m_135370_(FACTION_ID));
        compound.m_128344_(KEY_FACTION_IDX, ((Byte)this.f_19804_.m_135370_(FACTION_IDX)).byteValue());
        compound.m_128405_(KEY_TP_X, this.getTeleportBlockPos().m_123341_());
        compound.m_128405_(KEY_TP_Y, this.getTeleportBlockPos().m_123342_());
        compound.m_128405_(KEY_TP_Z, this.getTeleportBlockPos().m_123343_());
        if (this.dimension != null) {
            compound.m_128359_(KEY_TP_DIM_KEY, this.dimension.m_211136_().toString());
            compound.m_128359_(KEY_TP_DIM_KEYTYPE, this.dimension.m_135782_().toString());
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean m_6097_() {
        return false;
    }

    public boolean m_6087_() {
        return false;
    }

    public void setTeleportBlockPos(BlockPos pos, ResourceKey<Level> dimension) {
        this.f_19804_.m_135381_(TELEPORT_POS, (Object)pos);
        this.dimension = dimension;
    }

    public BlockPos getTeleportBlockPos() {
        return (BlockPos)this.f_19804_.m_135370_(TELEPORT_POS);
    }

    public ResourceKey<Level> getDimension() {
        return this.dimension;
    }

    public void m_6123_(Player entityIn) {
        if (this.getAge() < 40) {
            return;
        }
        if (entityIn.m_6144_()) {
            return;
        }
        LazyOptional magicContainer = entityIn.getCapability(PlayerMagicProvider.MAGIC);
        if (!magicContainer.isPresent()) {
            return;
        }
        if (((IPlayerMagic)magicContainer.orElse(null)).getPortalCooldown() > 0) {
            return;
        }
        if (((Boolean)this.f_19804_.m_135370_(RTP)).booleanValue()) {
            if (!this.m_9236_().m_5776_() && !TeleportHelper.randomTeleport((LivingEntity)entityIn, GeneralConfigValues.RTPDistance, 10)) {
                entityIn.m_213846_((Component)Component.m_237115_((String)"gui.mna.portal.rtp_failed"));
            }
            ((IPlayerMagic)magicContainer.orElse(null)).setPortalCooldown(100);
            return;
        }
        BlockPos tpPos = this.getTeleportBlockPos();
        if (tpPos == BlockPos.f_121853_) {
            return;
        }
        if (!entityIn.m_9236_().m_5776_()) {
            entityIn.m_20194_().m_129785_().iterator().forEachRemaining(sw -> {
                if (this.dimension.toString().equals(sw.m_46472_().toString())) {
                    this.dimension = sw.m_46472_();
                }
            });
            TeleportHelper.teleportEntity((Entity)entityIn, this.dimension, new Vec3((double)((float)tpPos.m_123341_() + 0.5f), (double)((float)tpPos.m_123342_() + 0.5f), (double)((float)tpPos.m_123343_() + 0.5f)));
        } else {
            for (int i = 0; i < 10; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.SPARKLE_RANDOM.get())), entityIn.m_20185_() - 1.0 + Math.random() * 2.0, entityIn.m_20186_() + Math.random() * 2.0, entityIn.m_20189_() - 1.0 + Math.random() * 2.0, (double)0.1f, (double)0.1f, (double)0.1f);
            }
        }
        ((IPlayerMagic)magicContainer.orElse(null)).setPortalCooldown(100);
    }

    public int getAge() {
        return this.age;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    @Nullable
    public DyeColor getDyeColor() {
        int color = (Integer)this.f_19804_.m_135370_(DYE_COLOR);
        if (color == -1) {
            return null;
        }
        return DyeColor.m_41053_((int)color);
    }

    public void setDyeColor(DyeColor color) {
        this.f_19804_.m_135381_(DYE_COLOR, (Object)color.m_41060_());
    }

    public void setPermanent() {
        this.permanent = true;
    }

    public void setRTP() {
        this.f_19804_.m_135381_(RTP, (Object)true);
    }

    public boolean isRTP() {
        return (Boolean)this.f_19804_.m_135370_(RTP);
    }

    public Pair<IFaction, Byte> getRenderData() {
        if (this._renderData == null) {
            this._renderData = new Pair((Object)((IFaction)Registries.Factions.get().getValue(new ResourceLocation((String)this.f_19804_.m_135370_(FACTION_ID)))), (Object)((Byte)this.f_19804_.m_135370_(FACTION_IDX)));
        }
        return this._renderData;
    }

    public void setRenderData(IFaction faction, byte idx) {
        ResourceLocation key = faction == null ? null : Registries.Factions.get().getKey((Object)faction);
        this.f_19804_.m_135381_(FACTION_ID, (Object)(key == null ? null : key.toString()));
        this.f_19804_.m_135381_(FACTION_IDX, (Object)idx);
    }
}

