/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.sorcery.targeting;

import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.api.spells.attributes.Attribute;
import com.mna.api.spells.base.ISpellDefinition;
import com.mna.api.spells.parts.SpellEffect;
import com.mna.api.spells.targeting.SpellContext;
import com.mna.api.spells.targeting.SpellSource;
import com.mna.api.spells.targeting.SpellTarget;
import com.mna.entities.EntityInit;
import com.mna.entities.sorcery.base.ChanneledSpellEntity;
import com.mna.particles.types.movers.ParticleLerpMover;
import com.mna.spells.SpellCaster;
import com.mna.spells.crafting.SpellRecipe;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class SpellEmanation
extends ChanneledSpellEntity {
    public SpellEmanation(EntityType<? extends SpellEmanation> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    public SpellEmanation(LivingEntity caster, ISpellDefinition spell, Level world) {
        super((EntityType<? extends ChanneledSpellEntity>)((EntityType)EntityInit.SPELL_EMANATION.get()), caster, spell, world);
        this.m_6034_(caster.m_20185_(), caster.m_20186_(), caster.m_20189_());
    }

    @Override
    public void m_8119_() {
        if (this.getCaster() != null) {
            this.m_6034_(this.getCaster().m_20185_(), this.getCaster().m_20186_() + (double)0.1f, this.getCaster().m_20189_());
        }
        super.m_8119_();
    }

    @Override
    protected void applyEffect(ItemStack stack, SpellRecipe recipe, LivingEntity caster, ServerLevel world) {
        boolean below;
        if (caster == null) {
            return;
        }
        float radius_h = this.getShapeAttributeByAge(Attribute.WIDTH);
        float radius_v = this.getShapeAttributeByAge(Attribute.HEIGHT);
        SpellSource source = new SpellSource(caster, caster.m_7655_());
        SpellContext context = new SpellContext((Level)world, recipe, this);
        if (recipe.getComponents().stream().anyMatch(c -> ((SpellEffect)c.getPart()).targetsEntities())) {
            AABB bb = new AABB(this.m_20185_() - (double)radius_h, this.m_20186_(), this.m_20189_() - (double)radius_h, this.m_20185_() + (double)radius_h, this.m_20186_() + (double)radius_v, this.m_20189_() + (double)radius_h);
            List entities = world.m_45933_((Entity)caster, bb);
            for (Entity e : entities) {
                if (!this.losCheck(e)) continue;
                SpellCaster.ApplyComponents(recipe, source, new SpellTarget(e), context);
            }
        }
        boolean bl = below = this.getCaster() != null && this.getCaster().m_6047_();
        if (recipe.getComponents().stream().anyMatch(c -> ((SpellEffect)c.getPart()).targetsBlocks())) {
            BlockPos origin = this.m_20183_();
            int i = -((int)radius_h);
            while ((float)i <= radius_h) {
                int j = 0;
                while ((float)j < radius_v) {
                    int k = -((int)radius_h);
                    while ((float)k <= radius_h) {
                        BlockPos adjusted = origin.m_7918_(i, j - (below ? 1 : 0), k);
                        if (below && (double)adjusted.m_123342_() < this.m_20186_() || this.losCheck(adjusted)) {
                            SpellCaster.ApplyComponents(recipe, source, new SpellTarget(adjusted, Direction.UP).doNotOffsetFace(), context);
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    @Override
    protected void spawnAirParticles(SpellRecipe recipe) {
        Vec3 me = this.m_20182_();
        float radius = this.getShapeAttributeByAge(Attribute.WIDTH);
        float particle_spread = 0.0f;
        for (int i = 0; i < 20; ++i) {
            this.m_9236_().m_7106_((ParticleOptions)recipe.colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.AIR_ORBIT.get())).setScale(0.2f).setColor(10, 10, 10), (Entity)this.getCaster()), me.f_82479_ + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), me.f_82480_ + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), me.f_82481_ + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), (double)0.2f, (double)0.15f, (double)radius);
        }
    }

    @Override
    protected void spawnEarthParticles(SpellRecipe recipe) {
        Vec3 me = this.m_20182_();
        float radius = this.getShapeAttributeByAge(Attribute.WIDTH);
        for (int i = 0; i < 50; ++i) {
            double angle = Math.random() * 2.0 * Math.PI;
            Vec3 offset = new Vec3(Math.cos(angle) * (double)radius, 0.0, Math.sin(angle) * (double)radius);
            Vec3 pos = me.m_82549_(offset);
            this.m_9236_().m_7106_((ParticleOptions)recipe.colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.DUST.get())), (Entity)this.getCaster()), pos.f_82479_, pos.f_82480_, pos.f_82481_, 0.0, 0.1, 0.0);
        }
    }

    @Override
    protected void spawnFireParticles(SpellRecipe recipe, boolean hellfire, boolean lightning) {
        Vec3 me = this.m_20182_();
        float radius = this.getShapeAttributeByAge(Attribute.WIDTH);
        if (!lightning) {
            for (int i = 0; i < 50; ++i) {
                double angle = Math.random() * 2.0 * Math.PI;
                Vec3 offset = new Vec3(Math.cos(angle) * (double)radius, 0.0, Math.sin(angle) * (double)radius);
                Vec3 pos = me.m_82549_(offset);
                this.m_9236_().m_7106_((ParticleOptions)recipe.colorParticle(new MAParticleType((ParticleType<MAParticleType>)(hellfire ? (ParticleType)ParticleInit.HELLFIRE.get() : (ParticleType)ParticleInit.FLAME.get())), (Entity)this.getCaster()), pos.f_82479_, pos.f_82480_, pos.f_82481_, 0.0, 0.1, 0.0);
            }
        } else {
            Vec3 offset = new Vec3((double)(-radius) + Math.random() * (double)radius * 2.0, (double)(-radius) + Math.random() * (double)radius * 2.0, (double)(-radius) + Math.random() * (double)radius * 2.0);
            Vec3 pos = me.m_82549_(offset);
            this.m_9236_().m_7106_((ParticleOptions)recipe.colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.LIGHTNING_BOLT.get())), (Entity)this.getCaster()), me.f_82479_, me.f_82480_, me.f_82481_, pos.f_82479_, pos.f_82480_, pos.f_82481_);
        }
    }

    @Override
    protected void spawnWaterParticles(SpellRecipe recipe, boolean frost) {
        Vec3 me = this.m_20182_();
        float radius = this.getShapeAttributeByAge(Attribute.WIDTH);
        for (int i = 0; i < 50; ++i) {
            double angle = Math.random() * 2.0 * Math.PI;
            Vec3 offset = new Vec3(Math.cos(angle) * (double)radius, 0.0, Math.sin(angle) * (double)radius);
            Vec3 pos = me.m_82549_(offset);
            this.m_9236_().m_7106_((ParticleOptions)recipe.colorParticle(new MAParticleType((ParticleType<MAParticleType>)(frost ? (ParticleType)ParticleInit.FROST.get() : (ParticleType)ParticleInit.WATER.get())), (Entity)this.getCaster()), pos.f_82479_, pos.f_82480_, pos.f_82481_, 0.0, 0.1, 0.0);
        }
    }

    @Override
    protected void spawnEnderParticles(SpellRecipe recipe) {
        Vec3 me = this.m_20182_();
        float radius = this.getShapeAttributeByAge(Attribute.WIDTH);
        for (int i = 0; i < 50; ++i) {
            double angle = Math.random() * 2.0 * Math.PI;
            Vec3 offset = new Vec3(Math.cos(angle) * (double)radius, (double)0.1f, Math.sin(angle) * (double)radius);
            Vec3 pos = me.m_82549_(offset);
            this.m_9236_().m_7106_((ParticleOptions)recipe.colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ENDER.get())), (Entity)this.getCaster()), me.f_82479_, pos.f_82480_, me.f_82481_, pos.f_82479_, pos.f_82480_, pos.f_82481_);
        }
    }

    @Override
    protected void spawnArcaneParticles(SpellRecipe recipe) {
        Vec3 me = this.m_20182_();
        float radius = this.getShapeAttributeByAge(Attribute.WIDTH);
        for (int i = 0; i < 50; ++i) {
            double angle = Math.random() * 2.0 * Math.PI;
            Vec3 offset = new Vec3(Math.cos(angle) * (double)radius, (double)0.1f + Math.abs(Math.sin((float)this.f_19797_ / 0.02f)) * 0.75, -Math.sin(angle) * (double)radius);
            Vec3 pos = me.m_82549_(offset);
            this.m_9236_().m_7106_((ParticleOptions)recipe.colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ARCANE.get())), (Entity)this.getCaster()).setMaxAge(10 + (int)radius * 2).setMover(new ParticleLerpMover(me.f_82479_, pos.f_82480_, me.f_82481_, pos.f_82479_, pos.f_82480_, pos.f_82481_)), me.f_82479_, pos.f_82480_, me.f_82481_, 0.0, 0.0, 0.0);
        }
    }
}

