/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.summon;

import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.api.tools.MATags;
import com.mna.capabilities.playerdata.magic.PlayerMagicProvider;
import com.mna.effects.EffectInit;
import com.mna.entities.EntityInit;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.network.NetworkHooks;

public class AnimusBlock
extends Mob
implements Enemy,
PlayerRideableJumping {
    protected static final EntityDataAccessor<BlockPos> ORIGIN = SynchedEntityData.m_135353_(AnimusBlock.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    protected static final EntityDataAccessor<Integer> BLOCK_STATE_ID = SynchedEntityData.m_135353_(AnimusBlock.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Integer> DURATION = SynchedEntityData.m_135353_(AnimusBlock.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Float> RIDER_OFFSET_HEIGHT = SynchedEntityData.m_135353_(AnimusBlock.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Boolean> RIDER_SIT = SynchedEntityData.m_135353_(AnimusBlock.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Boolean> CAN_FLY = SynchedEntityData.m_135353_(AnimusBlock.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public float squishAmount;
    public float squishFactor;
    public float prevSquishFactor;
    private boolean wasOnGround;
    private boolean fireImmune = false;
    protected float jumpPower;
    private boolean clearOrigin = true;
    private BlockState fallTile = Blocks.f_49992_.m_49966_();

    public AnimusBlock(EntityType<? extends Mob> type, Level worldIn) {
        super(type, worldIn);
        this.f_21342_ = new MoveHelperController(this);
    }

    public AnimusBlock(Level worldIn, BlockState state, BlockPos pos, int duration) {
        this((EntityType<? extends Mob>)((EntityType)EntityInit.ANIMUS_BLOCK.get()), worldIn);
        this.m_6034_((float)pos.m_123341_() + 0.5f, pos.m_123342_(), (float)pos.m_123343_() + 0.5f);
        this.fallTile = state;
        this.f_19850_ = true;
        if (!this.m_9236_().m_5776_()) {
            VoxelShape collisionShape = state.m_60808_((BlockGetter)this.m_9236_(), pos);
            this.f_19804_.m_135381_(RIDER_OFFSET_HEIGHT, (Object)Float.valueOf((float)collisionShape.m_83297_(Direction.Axis.Y)));
            this.f_19804_.m_135381_(RIDER_SIT, (Object)state.m_60838_((BlockGetter)this.m_9236_(), pos));
            this.f_19804_.m_135381_(BLOCK_STATE_ID, (Object)Block.m_49956_((BlockState)this.fallTile));
            this.f_19804_.m_135381_(DURATION, (Object)duration);
            this.f_19804_.m_135381_(ORIGIN, (Object)pos);
            if (MATags.isBlockIn(state.m_60734_(), MATags.Blocks.ANIMUS_FLYING)) {
                this.f_19804_.m_135381_(CAN_FLY, (Object)true);
            }
        }
        this.fireImmune = this.fallTile.getFireSpreadSpeed((BlockGetter)worldIn, pos, Direction.DOWN) == 0;
    }

    public boolean m_5825_() {
        return this.fireImmune;
    }

    public AnimusBlock doNotClearOrigin() {
        this.clearOrigin = false;
        return this;
    }

    public void m_8119_() {
        if (this.f_19797_ == 1 && this.clearOrigin && !this.m_9236_().m_5776_()) {
            BlockPos origin = (BlockPos)this.f_19804_.m_135370_(ORIGIN);
            if (!this.m_9236_().m_46859_(origin)) {
                this.m_9236_().m_7731_(origin, Blocks.f_50016_.m_49966_(), 3);
            }
        }
        this.squishFactor += (this.squishAmount - this.squishFactor) * 0.5f;
        this.prevSquishFactor = this.squishFactor;
        super.m_8119_();
        if (this.m_20096_() && !this.wasOnGround && this.m_6688_() == null) {
            int i = 1;
            for (int j = 0; j < i * 8; ++j) {
                float f = this.f_19796_.m_188501_() * ((float)Math.PI * 2);
                float f1 = this.f_19796_.m_188501_() * 0.5f + 0.5f;
                float f2 = Mth.m_14031_((float)f) * (float)i * 0.5f * f1;
                float f3 = Mth.m_14089_((float)f) * (float)i * 0.5f * f1;
                this.m_9236_().m_7106_(this.getSquishParticle(), this.m_20185_() + (double)f2, this.m_20186_(), this.m_20189_() + (double)f3, 0.0, 0.0, 0.0);
            }
            this.m_5496_(this.getSquishSound(), this.m_6121_(), ((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f) / 0.8f);
            this.squishAmount = -0.5f;
        } else if (!this.m_20096_() && this.wasOnGround) {
            this.squishAmount = 1.0f;
        }
        this.wasOnGround = this.m_20096_();
        this.alterSquishAmount();
        if (!this.m_9236_().m_5776_()) {
            LivingEntity j;
            if (this.m_20068_() && (j = this.m_6688_()) instanceof Player) {
                Player player = (Player)j;
                this.m_183634_();
                if (this.m_20072_() || this.m_21023_((MobEffect)EffectInit.GRAVITY_WELL.get())) {
                    this.m_20153_();
                    this.m_20242_(false);
                } else {
                    player.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> {
                        float amount = 2.0f;
                        if (!m.getCastingResource().hasEnough((LivingEntity)player, amount)) {
                            this.m_20153_();
                            this.m_20242_(false);
                        } else {
                            m.getCastingResource().consume((LivingEntity)player, amount);
                        }
                    });
                }
            }
            if (this.f_19797_ >= (Integer)this.f_19804_.m_135370_(DURATION) && this.m_20197_().size() == 0 && (this.m_20096_() || this.m_20072_())) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
                BlockState target = this.m_9236_().m_8055_(this.m_20183_());
                FakePlayer player = FakePlayerFactory.getMinecraft((ServerLevel)((ServerLevel)this.m_9236_()));
                ItemStack stack = new ItemStack((ItemLike)this.m_146900_().m_60734_());
                if (this.m_9236_().m_46859_(this.m_20183_()) || target.m_60629_(new BlockPlaceContext((Player)player, InteractionHand.MAIN_HAND, stack, new BlockHitResult(this.m_20182_(), this.m_6374_(), this.m_20183_(), true)))) {
                    this.m_9236_().m_46597_(this.m_20183_(), this.m_146900_());
                    this.m_146900_().m_60734_().m_6402_(this.m_9236_(), this.m_20183_(), this.m_146900_(), (LivingEntity)this, stack);
                } else {
                    this.m_19983_(stack);
                }
            }
        }
        if (this.m_9236_().m_5776_()) {
            int numParticles = this.m_6688_() != null && this.m_20068_() ? 10 : 2;
            for (int i = 0; i < numParticles; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.BLUE_SPARKLE_VELOCITY.get())).setColor(255, 215, 0), this.m_20185_() - 0.5 + Math.random(), this.m_20186_() + Math.random() * (double)((Float)this.f_19804_.m_135370_(RIDER_OFFSET_HEIGHT)).floatValue(), this.m_20189_() - 0.5 + Math.random(), 0.0, 0.0, 0.0);
            }
        }
    }

    protected void m_142540_(MobEffectInstance pEffectInstance, Entity pEntity) {
        super.m_142540_(pEffectInstance, pEntity);
        MobEffect effect = pEffectInstance.m_19544_();
        if (effect == EffectInit.LEVITATION.get() || effect == MobEffects.f_19620_ || effect == EffectInit.SOAR.get()) {
            this.m_20242_(true);
        }
    }

    protected void m_7285_(MobEffectInstance pEffectInstance) {
        super.m_7285_(pEffectInstance);
        MobEffect effect = pEffectInstance.m_19544_();
        if (!(effect != EffectInit.LEVITATION.get() && effect != MobEffects.f_19620_ && effect != EffectInit.SOAR.get() || this.fallTile != null && MATags.isBlockIn(this.fallTile.m_60734_(), MATags.Blocks.ANIMUS_FLYING))) {
            this.m_20242_(false);
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ORIGIN, (Object)BlockPos.f_121853_);
        this.f_19804_.m_135372_(BLOCK_STATE_ID, (Object)Block.m_49956_((BlockState)Blocks.f_49992_.m_49966_()));
        this.f_19804_.m_135372_(DURATION, (Object)10);
        this.f_19804_.m_135372_(RIDER_OFFSET_HEIGHT, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(RIDER_SIT, (Object)true);
        this.f_19804_.m_135372_(CAN_FLY, (Object)false);
    }

    public void setOrigin(BlockPos origin) {
        this.f_19804_.m_135381_(ORIGIN, (Object)origin);
    }

    @OnlyIn(value=Dist.CLIENT)
    public BlockPos getOrigin() {
        return (BlockPos)this.f_19804_.m_135370_(ORIGIN);
    }

    protected void alterSquishAmount() {
        this.squishAmount *= 0.6f;
    }

    protected SoundEvent getSquishSound() {
        return this.m_146900_().m_60827_().m_56777_();
    }

    protected SoundEvent getJumpSound() {
        return this.m_146900_().m_60827_().m_56775_();
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public BlockState m_146900_() {
        return Block.m_49803_((int)((Integer)this.f_19804_.m_135370_(BLOCK_STATE_ID)));
    }

    public void m_7378_(CompoundTag compound) {
        this.fallTile = NbtUtils.m_247651_((HolderGetter)this.m_9236_().m_246945_(Registries.f_256747_), (CompoundTag)compound.m_128469_("BlockState"));
        if (this.fallTile.m_60795_()) {
            this.fallTile = Blocks.f_49992_.m_49966_();
        }
        if (compound.m_128441_("Origin")) {
            this.f_19804_.m_135381_(ORIGIN, (Object)NbtUtils.m_129239_((CompoundTag)compound.m_128469_("Origin")));
        }
        if (compound.m_128441_("StateID")) {
            this.f_19804_.m_135381_(BLOCK_STATE_ID, (Object)compound.m_128451_("StateID"));
        }
        if (compound.m_128441_("Duration")) {
            this.f_19804_.m_135381_(DURATION, (Object)compound.m_128451_("Duration"));
        }
        super.m_7378_(compound);
    }

    public void m_7380_(CompoundTag compound) {
        compound.m_128365_("BlockState", (Tag)NbtUtils.m_129202_((BlockState)this.fallTile));
        compound.m_128365_("Origin", (Tag)NbtUtils.m_129224_((BlockPos)((BlockPos)this.f_19804_.m_135370_(ORIGIN))));
        compound.m_128405_("StateID", ((Integer)this.f_19804_.m_135370_(BLOCK_STATE_ID)).intValue());
        compound.m_128405_("Duration", ((Integer)this.f_19804_.m_135370_(DURATION)).intValue());
        super.m_7380_(compound);
    }

    protected ParticleOptions getSquishParticle() {
        return new BlockParticleOption(ParticleTypes.f_123794_, this.m_146900_());
    }

    protected int getJumpDelay() {
        return this.f_19796_.m_188503_(20) + 10;
    }

    public static AttributeSupplier.Builder getGlobalAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22281_, 5.0);
    }

    public void m_7334_(Entity entityIn) {
        super.m_7334_(entityIn);
        if (entityIn == this.m_5448_()) {
            if (!this.m_9236_().m_5776_()) {
                if (this.m_146900_() == Blocks.f_50077_.m_49966_()) {
                    this.m_142687_(Entity.RemovalReason.DISCARDED);
                    this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 4.0f, Level.ExplosionInteraction.TNT);
                    return;
                }
                if (this.m_146900_().m_60734_() instanceof FireBlock) {
                    this.m_142687_(Entity.RemovalReason.DISCARDED);
                    entityIn.m_6469_(entityIn.m_269291_().m_269549_(), 5.0f);
                    entityIn.m_20254_(10);
                    return;
                }
            }
            if (MATags.isBlockIn(this.m_146900_().m_60734_(), MATags.Blocks.ANIMUS_TANGLES)) {
                ((LivingEntity)entityIn).m_7292_(new MobEffectInstance((MobEffect)EffectInit.ENTANGLE.get(), 100, 0));
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            } else if (MATags.isBlockIn(this.m_146900_().m_60734_(), MATags.Blocks.ANIMUS_POISONCLOUD)) {
                AreaEffectCloud areaeffectcloud = new AreaEffectCloud(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
                areaeffectcloud.m_19712_(3.0f);
                areaeffectcloud.m_19732_(-0.5f);
                areaeffectcloud.m_19740_(10);
                areaeffectcloud.m_19738_(-areaeffectcloud.m_19743_() / (float)areaeffectcloud.m_19748_());
                areaeffectcloud.m_19722_(new Potion(new MobEffectInstance[]{new MobEffectInstance(MobEffects.f_19614_, 1200, 0)}));
                this.m_9236_().m_7967_((Entity)areaeffectcloud);
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            } else {
                this.dealDamage((LivingEntity)entityIn);
                if (MATags.isBlockIn(this.m_146900_().m_60734_(), MATags.Blocks.ANIMUS_GLOW)) {
                    ((LivingEntity)entityIn).m_7292_(new MobEffectInstance(MobEffects.f_19619_, 600, 0));
                }
                if (MATags.isBlockIn(this.m_146900_().m_60734_(), MATags.Blocks.ANIMUS_SLOWS)) {
                    ((LivingEntity)entityIn).m_7292_(new MobEffectInstance(MobEffects.f_19597_, 200, 2));
                }
                if (MATags.isBlockIn(this.m_146900_().m_60734_(), MATags.Blocks.ANIMUS_KNOCKBACK)) {
                    float mX = (float)(this.m_20185_() - entityIn.m_20185_());
                    float mZ = (float)(this.m_20189_() - entityIn.m_20189_());
                    ((LivingEntity)entityIn).m_147240_(0.5, (double)mX, (double)mZ);
                }
            }
        }
    }

    protected void dealDamage(LivingEntity entityIn) {
        if (this.m_6084_()) {
            int i = 3;
            if (this.m_20280_((Entity)entityIn) < 0.6 * (double)i * 0.6 * (double)i && this.m_21574_().m_148306_((Entity)entityIn) && entityIn.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), this.getAttackDamage())) {
                this.m_5496_(SoundEvents.f_12384_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
                this.m_19970_((LivingEntity)this, (Entity)entityIn);
            }
        }
    }

    public void m_6862_(boolean jumping) {
        this.f_20899_ = jumping;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7888_(int jumpPowerIn) {
        if (jumpPowerIn < 0) {
            jumpPowerIn = 0;
        }
        MobEffectInstance effect = this.m_21124_(MobEffects.f_19603_);
        this.jumpPower = jumpPowerIn >= 90 ? 1.0f : 0.4f + 0.4f * (float)jumpPowerIn / 90.0f;
        if (effect != null) {
            this.jumpPower = (float)((double)this.jumpPower + 0.15 * (double)effect.m_19564_());
        }
    }

    public boolean m_7132_() {
        return !this.m_20068_();
    }

    public void m_7199_(int pJumpPower) {
    }

    public void m_8012_() {
    }

    public boolean canRiderInteract() {
        return true;
    }

    public LivingEntity m_6688_() {
        Entity entity = this.m_146895_();
        if (entity instanceof Player) {
            return (Player)entity;
        }
        return null;
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.m_6084_()) {
            LivingEntity livingentity = this.m_6688_();
            if (this.m_20160_() && this.canRiderInteract() && livingentity != null) {
                boolean jump;
                this.m_146922_(livingentity.m_146908_());
                this.f_19859_ = this.m_146908_();
                this.m_146926_(livingentity.m_146909_() * 0.5f);
                this.m_19915_(this.m_146908_(), this.m_146909_());
                this.f_20885_ = this.f_20883_ = this.m_146908_();
                float f = livingentity.f_20900_ * 0.5f;
                float f1 = livingentity.f_20902_;
                if (f1 <= 0.0f) {
                    f1 *= 0.25f;
                }
                boolean bl = jump = this.jumpPower > 0.0f && !this.f_20899_ && this.m_20096_();
                if (jump) {
                    double d0 = this.jumpPower * this.m_20098_();
                    double d1 = this.m_21023_(MobEffects.f_19603_) ? d0 + (double)((float)(this.m_21124_(MobEffects.f_19603_).m_19564_() + 1) * 0.1f) : d0;
                    float horizontalScale = 3.0f;
                    Vec3 vector3d = this.m_20184_();
                    this.m_20334_(vector3d.f_82479_ * (double)horizontalScale, d1, vector3d.f_82481_ * (double)horizontalScale);
                    this.m_6862_(true);
                    this.f_19812_ = true;
                    ForgeHooks.onLivingJump((LivingEntity)this);
                    if (f1 > 0.0f) {
                        float f2 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)));
                        float f3 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)));
                        this.m_20256_(this.m_20184_().m_82520_((double)(-0.4f * f2 * this.jumpPower), 0.0, (double)(0.4f * f3 * this.jumpPower)));
                    }
                    this.jumpPower = 0.0f;
                } else if (this.m_20096_()) {
                    f = 0.0f;
                    f1 = 0.0f;
                }
                if (this.m_20068_()) {
                    travelVector = livingentity.m_20156_().m_82541_().m_82490_(travelVector.m_82553_());
                }
                if (this.m_6109_() && (!this.m_20096_() || jump || this.m_20068_())) {
                    this.m_7910_((float)this.m_21133_(Attributes.f_22279_));
                    super.m_7023_(new Vec3((double)f, travelVector.f_82480_ * (double)livingentity.f_20902_, (double)f1));
                } else if (livingentity instanceof Player) {
                    this.m_20256_(Vec3.f_82478_);
                }
                if (this.m_20096_()) {
                    this.jumpPower = 0.0f;
                    this.m_6862_(false);
                }
                this.m_267651_(false);
            } else {
                this.jumpPower = 0.02f;
                super.m_7023_(travelVector);
            }
        }
    }

    public boolean m_6109_() {
        LivingEntity livingentity = this.m_6688_();
        if (livingentity instanceof Player) {
            Player player = (Player)livingentity;
            return player.m_7578_() && (player.f_20900_ > 0.0f || player.f_20902_ > 0.0f || !this.m_20096_() || this.f_20899_);
        }
        return this.m_21515_();
    }

    public void m_8107_() {
        LivingEntity livingentity;
        if (this.f_20954_ > 0) {
            --this.f_20954_;
        }
        if (this.m_6109_()) {
            this.f_20903_ = 0;
            this.m_217006_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        }
        if (this.f_20903_ > 0) {
            double d0 = this.m_20185_() + (this.f_20904_ - this.m_20185_()) / (double)this.f_20903_;
            double d2 = this.m_20186_() + (this.f_20905_ - this.m_20186_()) / (double)this.f_20903_;
            double d4 = this.m_20189_() + (this.f_20906_ - this.m_20189_()) / (double)this.f_20903_;
            double d6 = Mth.m_14175_((double)(this.f_20907_ - (double)this.m_146908_()));
            this.m_146922_(this.m_146908_() + (float)d6 / (float)this.f_20903_);
            this.m_146926_(this.m_146909_() + (float)(this.f_20908_ - (double)this.m_146909_()) / (float)this.f_20903_);
            --this.f_20903_;
            this.m_6034_(d0, d2, d4);
            this.m_19915_(this.m_146908_(), this.m_146909_());
        } else if (!this.m_21515_()) {
            this.m_20256_(this.m_20184_().m_82490_(0.98));
        }
        if (this.f_20934_ > 0) {
            this.f_20885_ += (float)Mth.m_14175_((double)(this.f_20933_ - (double)this.f_20885_)) / (float)this.f_20934_;
            --this.f_20934_;
        }
        Vec3 vec31 = this.m_20184_();
        double d1 = vec31.f_82479_;
        double d3 = vec31.f_82480_;
        double d5 = vec31.f_82481_;
        if (Math.abs(vec31.f_82479_) < 0.003) {
            d1 = 0.0;
        }
        if (Math.abs(vec31.f_82480_) < 0.003) {
            d3 = 0.0;
        }
        if (Math.abs(vec31.f_82481_) < 0.003) {
            d5 = 0.0;
        }
        this.m_20334_(d1, d3, d5);
        this.m_9236_().m_46473_().m_6180_("ai");
        if (this.m_6107_()) {
            this.f_20899_ = false;
            this.f_20900_ = 0.0f;
            this.f_20902_ = 0.0f;
        } else if (this.m_21515_()) {
            this.m_9236_().m_46473_().m_6180_("newAi");
            this.m_6140_();
            this.m_9236_().m_46473_().m_7238_();
        }
        this.m_9236_().m_46473_().m_7238_();
        this.m_9236_().m_46473_().m_6180_("jump");
        if (this.f_20899_ && this.m_6129_()) {
            FluidType fluidType = this.getMaxHeightFluidType();
            double d7 = !fluidType.isAir() ? this.getFluidTypeHeight(fluidType) : (this.m_20077_() ? this.m_204036_(FluidTags.f_13132_) : this.m_204036_(FluidTags.f_13131_));
            boolean flag = this.m_20069_() && d7 > 0.0;
            double d8 = this.m_20204_();
            if (!flag || this.m_20096_() && !(d7 > d8)) {
                if (!this.m_20077_() || this.m_20096_() && !(d7 > d8)) {
                    if (fluidType.isAir() || this.m_20096_() && !(d7 > d8)) {
                        if ((this.m_20096_() || flag && d7 <= d8) && this.f_20954_ == 0) {
                            this.m_6135_();
                            this.f_20954_ = 10;
                        }
                    } else {
                        this.jumpInFluid(fluidType);
                    }
                } else {
                    this.jumpInFluid((FluidType)ForgeMod.LAVA_TYPE.get());
                }
            } else {
                this.jumpInFluid((FluidType)ForgeMod.WATER_TYPE.get());
            }
        } else {
            this.f_20954_ = 0;
        }
        this.m_9236_().m_46473_().m_7238_();
        this.m_9236_().m_46473_().m_6180_("travel");
        this.f_20900_ *= 0.98f;
        this.f_20902_ *= 0.98f;
        this.m_21323_();
        AABB aabb = this.m_20191_();
        Vec3 vec3 = new Vec3((double)this.f_20900_, (double)this.f_20901_, (double)this.f_20902_);
        if (this.m_21023_(MobEffects.f_19591_) || this.m_21023_(MobEffects.f_19620_)) {
            this.m_183634_();
        }
        if ((livingentity = this.m_6688_()) instanceof Player) {
            Player player = (Player)livingentity;
            if (this.m_6084_()) {
                this.m_274466_(player, vec3);
            }
        } else {
            this.m_7023_(vec3);
        }
        this.m_9236_().m_46473_().m_7238_();
        this.m_9236_().m_46473_().m_6180_("freezing");
        if (!this.m_9236_().m_5776_() && !this.m_21224_()) {
            int i = this.m_146888_();
            if (this.f_146808_ && this.m_142079_()) {
                this.m_146917_(Math.min(this.m_146891_(), i + 1));
            } else {
                this.m_146917_(Math.max(0, i - 2));
            }
        }
        this.m_147225_();
        this.m_147226_();
        if (!this.m_9236_().m_5776_() && this.f_19797_ % 40 == 0 && this.m_146890_() && this.m_142079_()) {
            this.m_6469_(this.m_269291_().m_269109_(), 1.0f);
        }
        this.m_9236_().m_46473_().m_7238_();
        this.m_9236_().m_46473_().m_6180_("push");
        if (this.f_20938_ > 0) {
            --this.f_20938_;
            this.m_21071_(aabb, this.m_20191_());
        }
        this.m_6138_();
        this.m_9236_().m_46473_().m_7238_();
        if (!this.m_9236_().m_5776_() && this.m_6126_() && this.m_20071_()) {
            this.m_6469_(this.m_269291_().m_269063_(), 1.0f);
        }
    }

    private void m_274466_(Player pPlayer, Vec3 pTravelVector) {
        Vec3 vec3 = this.m_274312_(pPlayer, pTravelVector);
        this.m_274498_(pPlayer, vec3);
        if (this.m_6109_()) {
            this.m_7910_(this.m_245547_(pPlayer));
            this.m_7023_(vec3);
        } else {
            this.m_7023_(vec3);
        }
    }

    private void m_21323_() {
        ItemStack itemstack;
        boolean flag = this.m_20291_(7);
        flag = flag && !this.m_20096_() && !this.m_20159_() && !this.m_21023_(MobEffects.f_19620_) ? (itemstack = this.m_6844_(EquipmentSlot.CHEST)).canElytraFly((LivingEntity)this) && itemstack.elytraFlightTick((LivingEntity)this, this.f_20937_) : false;
        if (!this.m_9236_().m_5776_()) {
            this.m_20115_(7, flag);
        }
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (this.m_7310_((Entity)player)) {
            this.mountTo(player);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected void mountTo(Player player) {
        if (!this.m_9236_().m_5776_()) {
            player.m_146926_(this.m_146909_());
            player.m_146922_(this.m_146908_());
            player.m_20329_((Entity)this);
            if (((Boolean)this.f_19804_.m_135370_(CAN_FLY)).booleanValue()) {
                this.m_20242_(true);
            }
        }
    }

    protected void m_20351_(Entity pPassenger) {
        super.m_20351_(pPassenger);
        if (!this.m_217005_()) {
            this.m_20242_(false);
        }
    }

    public boolean shouldRiderSit() {
        return (Boolean)this.f_19804_.m_135370_(RIDER_SIT);
    }

    public boolean shouldRiderFaceForward(Player player) {
        return true;
    }

    public double m_6048_() {
        if (((Boolean)this.f_19804_.m_135370_(RIDER_SIT)).booleanValue()) {
            return (double)((Float)this.f_19804_.m_135370_(RIDER_OFFSET_HEIGHT)).floatValue() * 0.75;
        }
        return (double)((Float)this.f_19804_.m_135370_(RIDER_OFFSET_HEIGHT)).floatValue() + 0.35;
    }

    protected void m_8022_() {
        boolean flag = !(this.m_6688_() instanceof Mob);
        boolean flag1 = !(this.m_20202_() instanceof Boat);
        this.f_21345_.m_25360_(Goal.Flag.MOVE, flag);
        this.f_21345_.m_25360_(Goal.Flag.JUMP, flag && flag1);
        this.f_21345_.m_25360_(Goal.Flag.LOOK, flag);
    }

    protected float getAttackDamage() {
        float amt = (float)this.m_21133_(Attributes.f_22281_);
        if (MATags.isBlockIn(this.m_146900_().m_60734_(), MATags.Blocks.ANIMUS_DAMAGEBOOST)) {
            amt += 2.0f;
        }
        return amt;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new AttackGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new FaceRandomGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new HopGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 10, true, false, e -> !(e instanceof AnimusBlock) && e instanceof Enemy && Math.abs(e.m_20186_() - this.m_20186_()) <= 4.0));
    }

    static class MoveHelperController
    extends MoveControl {
        private float yRot;
        private int jumpDelay;
        private final AnimusBlock slime;
        private boolean isAggressive;

        public MoveHelperController(AnimusBlock slimeIn) {
            super((Mob)slimeIn);
            this.slime = slimeIn;
            this.yRot = 180.0f * slimeIn.m_146908_() / (float)Math.PI;
        }

        public void setDirection(float yRotIn, boolean aggressive) {
            this.yRot = yRotIn;
            this.isAggressive = aggressive;
        }

        public void setSpeed(double speedIn) {
            this.f_24978_ = speedIn;
            this.f_24981_ = MoveControl.Operation.MOVE_TO;
        }

        public void m_8126_() {
            this.f_24974_.m_146922_(this.m_24991_(this.f_24974_.m_146908_(), this.yRot, 90.0f));
            this.f_24974_.f_20885_ = this.f_24974_.m_146908_();
            this.f_24974_.f_20883_ = this.f_24974_.m_146908_();
            if (this.f_24981_ != MoveControl.Operation.MOVE_TO) {
                this.f_24974_.m_21564_(0.0f);
            } else {
                this.f_24981_ = MoveControl.Operation.WAIT;
                if (this.f_24974_.m_20096_()) {
                    this.f_24974_.m_7910_((float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_)));
                    if (this.jumpDelay-- <= 0) {
                        this.jumpDelay = this.slime.getJumpDelay();
                        if (this.isAggressive) {
                            this.jumpDelay /= 3;
                        }
                        this.slime.m_21569_().m_24901_();
                        this.slime.m_5496_(this.slime.getJumpSound(), this.slime.m_6121_(), 1.0f);
                    } else {
                        this.slime.f_20900_ = 0.0f;
                        this.slime.f_20902_ = 0.0f;
                        this.f_24974_.m_7910_(0.0f);
                    }
                } else {
                    this.f_24974_.m_7910_((float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_)));
                }
            }
        }
    }

    static class FloatGoal
    extends Goal {
        private final AnimusBlock slime;

        public FloatGoal(AnimusBlock slimeIn) {
            this.slime = slimeIn;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
            slimeIn.m_21573_().m_7008_(true);
        }

        public boolean m_8036_() {
            return (this.slime.m_20069_() || this.slime.m_20077_()) && this.slime.m_21566_() instanceof MoveHelperController;
        }

        public void m_8037_() {
            if (this.slime.m_217043_().m_188501_() < 0.8f) {
                this.slime.m_21569_().m_24901_();
            }
            ((MoveHelperController)this.slime.m_21566_()).setSpeed(1.2);
        }
    }

    static class AttackGoal
    extends Goal {
        private final AnimusBlock slime;
        private int growTieredTimer;

        public AttackGoal(AnimusBlock slimeIn) {
            this.slime = slimeIn;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.slime.m_5448_();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.m_6084_()) {
                return false;
            }
            return livingentity instanceof Player && ((Player)livingentity).m_150110_().f_35934_ ? false : this.slime.m_21566_() instanceof MoveHelperController;
        }

        public void m_8056_() {
            this.growTieredTimer = 300;
            super.m_8056_();
        }

        public boolean m_8045_() {
            LivingEntity livingentity = this.slime.m_5448_();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.m_6084_()) {
                return false;
            }
            if (livingentity instanceof Player && ((Player)livingentity).m_150110_().f_35934_) {
                return false;
            }
            return --this.growTieredTimer > 0;
        }

        public void m_8037_() {
            this.slime.m_21391_((Entity)this.slime.m_5448_(), 10.0f, 10.0f);
            ((MoveHelperController)this.slime.m_21566_()).setDirection(this.slime.m_146908_(), true);
        }
    }

    static class FaceRandomGoal
    extends Goal {
        private final AnimusBlock slime;
        private float chosenDegrees;
        private int nextRandomizeTime;

        public FaceRandomGoal(AnimusBlock slimeIn) {
            this.slime = slimeIn;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return this.slime.m_5448_() == null && (this.slime.m_20096_() || this.slime.m_20069_() || this.slime.m_20077_() || this.slime.m_21023_(MobEffects.f_19620_)) && this.slime.m_21566_() instanceof MoveHelperController;
        }

        public void m_8037_() {
            if (--this.nextRandomizeTime <= 0) {
                this.nextRandomizeTime = 40 + this.slime.m_217043_().m_188503_(60);
                this.chosenDegrees = this.slime.m_217043_().m_188503_(360);
            }
            ((MoveHelperController)this.slime.m_21566_()).setDirection(this.chosenDegrees, false);
        }
    }

    static class HopGoal
    extends Goal {
        private final AnimusBlock slime;

        public HopGoal(AnimusBlock slimeIn) {
            this.slime = slimeIn;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return !this.slime.m_20159_();
        }

        public void m_8037_() {
            ((MoveHelperController)this.slime.m_21566_()).setSpeed(1.0);
        }
    }
}

