/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.summon;

import com.google.common.collect.Multimap;
import com.mna.api.ManaAndArtificeMod;
import com.mna.api.entities.ai.CastSpellAtTargetGoal;
import com.mna.api.spells.base.ISpellDefinition;
import com.mna.api.tools.MATags;
import com.mna.enchantments.framework.EnchantmentInit;
import com.mna.entities.EntityInit;
import com.mna.spells.crafting.SpellRecipe;
import com.mna.tools.InventoryUtilities;
import com.mna.tools.SummonUtils;
import java.util.Arrays;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.goal.RangedCrossbowAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;

public class GreaterAnimus
extends Monster
implements IEntityAdditionalSpawnData,
Enemy,
RangedAttackMob,
CrossbowAttackMob {
    private final RangedAttackGoal genericRangedGoal = new RangedAttackGoal((RangedAttackMob)this, 1.0, 20, 15.0f);
    private final RangedBowAttackGoal<GreaterAnimus> bowGoal = new RangedBowAttackGoal((Mob)this, 1.0, 20, 15.0f);
    private final RangedCrossbowAttackGoal<GreaterAnimus> crossbowGoal = new RangedCrossbowAttackGoal((Monster)this, 1.0, 20.0f);
    private final MeleeAttackGoal meleeGoal = new MeleeAttackGoal((PathfinderMob)this, 1.2, false);
    private final CastSpellAtTargetGoal<GreaterAnimus> spellGoal = new CastSpellAtTargetGoal<GreaterAnimus>(this, ItemStack.f_41583_, 0.0, -1, 16.0f, false){

        @Override
        public void onSpellCast(ISpellDefinition spell) {
            ((GreaterAnimus)((Object)this.getEntity())).consumeMana(spell);
        }

        @Override
        public void m_8056_() {
            super.m_8056_();
            ISpellDefinition recipe = ManaAndArtificeMod.getSpellHelper().parseSpellDefinition(this.spell);
            this.attackTime = this.attackCooldown == -1 ? recipe.getCooldown(null) : this.attackCooldown;
        }
    };
    private static final EntityDataAccessor<Boolean> IS_CHARGING_CROSSBOW = SynchedEntityData.m_135353_(GreaterAnimus.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final String NBT_HELDITEM = "held";
    private static final String NBT_MANA = "mana";
    private ItemStack heldItem = ItemStack.f_41583_;
    private float mana;
    private boolean isSpellCaster = false;

    public GreaterAnimus(EntityType<? extends Monster> type, Level world) {
        super(type, world);
    }

    public GreaterAnimus(Level world, ItemStack stack, float mana) {
        this((EntityType<? extends Monster>)((EntityType)EntityInit.GREATER_ANIMUS.get()), world);
        this.heldItem = stack;
        this.mana = mana;
        this.reassessLifeGoals();
    }

    public void reassessLifeGoals() {
        if (this.m_9236_() != null && !this.m_9236_().m_5776_()) {
            this.f_21345_.m_25363_((Goal)this.meleeGoal);
            this.f_21345_.m_25363_(this.bowGoal);
            this.f_21345_.m_25363_(this.spellGoal);
            if (SpellRecipe.stackContainsSpell(this.heldItem)) {
                this.spellGoal.setSpell(this.heldItem);
                this.f_21345_.m_25352_(2, this.spellGoal);
                this.isSpellCaster = true;
            } else if (this.heldItem.m_150930_(Items.f_42411_)) {
                int i = 20;
                this.bowGoal.m_25797_(i);
                this.f_21345_.m_25352_(4, this.bowGoal);
            } else if (this.heldItem.m_150930_(Items.f_42717_)) {
                this.f_21345_.m_25352_(4, this.crossbowGoal);
            } else if (MATags.isItemIn(this.heldItem.m_41720_(), MATags.Items.ANIMUS_BOWS)) {
                this.f_21345_.m_25352_(4, (Goal)this.genericRangedGoal);
            } else {
                Multimap attrs = this.heldItem.m_41720_().getAttributeModifiers(EquipmentSlot.MAINHAND, this.heldItem);
                attrs.forEach((a, m) -> {
                    try {
                        AttributeInstance ai = this.m_21051_((Attribute)a);
                        if (ai != null) {
                            ai.m_22125_(m);
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                });
                this.f_21345_.m_25352_(4, (Goal)this.meleeGoal);
            }
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 35.0).m_22268_(Attributes.f_22279_, (double)0.33f).m_22268_(Attributes.f_22281_, 3.0);
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (pSource.m_276093_(DamageTypes.f_268585_) || pSource.m_276093_(DamageTypes.f_268722_) || pSource.m_276093_(DamageTypes.f_268752_) || pSource.m_276093_(DamageTypes.f_268671_) || pSource.m_276093_(DamageTypes.f_268434_) || pSource.m_276093_(DamageTypes.f_268441_) || pSource.m_276093_(DamageTypes.f_268469_)) {
            return false;
        }
        return super.m_6469_(pSource, pAmount);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_CHARGING_CROSSBOW, (Object)false);
    }

    protected void m_8099_() {
        this.f_21346_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public Iterable<ItemStack> m_6168_() {
        return Arrays.asList(new ItemStack[0]);
    }

    public ItemStack m_6844_(EquipmentSlot pSlot) {
        if (pSlot != EquipmentSlot.MAINHAND) {
            return ItemStack.f_41583_;
        }
        return this.heldItem;
    }

    public void m_8061_(EquipmentSlot pSlot, ItemStack pStack) {
        if (pSlot != EquipmentSlot.MAINHAND) {
            return;
        }
        this.heldItem = pStack.m_41777_();
    }

    public HumanoidArm m_5737_() {
        return HumanoidArm.LEFT;
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeItemStack(this.heldItem, false);
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        this.heldItem = additionalData.m_130267_();
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128350_(NBT_MANA, this.mana);
        if (!this.heldItem.m_41619_()) {
            pCompound.m_128365_(NBT_HELDITEM, (Tag)this.heldItem.m_41739_(new CompoundTag()));
        }
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.mana = pCompound.m_128457_(NBT_MANA);
        if (pCompound.m_128441_(NBT_HELDITEM)) {
            this.heldItem = ItemStack.m_41712_((CompoundTag)pCompound.m_128469_(NBT_HELDITEM));
        }
    }

    protected void m_6668_(DamageSource pDamageSource) {
        LivingEntity summoner = SummonUtils.getSummoner((LivingEntity)this);
        if (!this.heldItem.m_41619_() && summoner != null && summoner instanceof Player) {
            ItemStack dropStack = this.heldItem.m_41777_();
            Map enchants = EnchantmentHelper.m_44831_((ItemStack)dropStack);
            if ((enchants.containsKey(Enchantments.f_44955_) || enchants.containsKey(EnchantmentInit.RETURNING.get())) && summoner.m_6084_()) {
                dropStack = InventoryUtilities.mergeToPlayerInvPrioritizeOffhand((Player)summoner, dropStack);
            }
            if (!dropStack.m_41619_()) {
                ItemEntity entityItem = new ItemEntity(this.m_9236_(), this.m_20182_().f_82479_, this.m_20182_().f_82480_, this.m_20182_().f_82481_, dropStack);
                this.m_9236_().m_7967_((Entity)entityItem);
            }
        }
    }

    public void m_6504_(LivingEntity pTarget, float pDistanceFactor) {
        ItemStack itemstack = this.m_6298_(this.m_21120_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof BowItem)));
        AbstractArrow abstractarrow = this.getArrow(itemstack, pDistanceFactor);
        if (this.m_21205_().m_41720_() instanceof BowItem) {
            abstractarrow = ((BowItem)this.m_21205_().m_41720_()).customArrow(abstractarrow);
        }
        double d0 = pTarget.m_20185_() - this.m_20185_();
        double d1 = pTarget.m_20227_(0.3333333333333333) - abstractarrow.m_20186_();
        double d2 = pTarget.m_20189_() - this.m_20189_();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        abstractarrow.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.m_9236_().m_46791_().m_19028_() * 4));
        this.m_5496_(SoundEvents.f_12382_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.m_9236_().m_7967_((Entity)abstractarrow);
    }

    protected AbstractArrow getArrow(ItemStack pArrowStack, float pDistanceFactor) {
        return ProjectileUtil.m_37300_((LivingEntity)this, (ItemStack)pArrowStack, (float)pDistanceFactor);
    }

    public void consumeMana(ISpellDefinition spell) {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        this.mana -= spell.getManaCost();
        if (this.mana <= 0.0f) {
            this.m_6668_(this.m_269291_().m_269341_());
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public void m_6136_(boolean pIsCharging) {
        this.f_19804_.m_135381_(IS_CHARGING_CROSSBOW, (Object)pIsCharging);
    }

    public boolean isChargingCrossbow() {
        return (Boolean)this.f_19804_.m_135370_(IS_CHARGING_CROSSBOW);
    }

    public AbstractIllager.IllagerArmPose getArmPose() {
        if (this.isChargingCrossbow()) {
            return AbstractIllager.IllagerArmPose.CROSSBOW_CHARGE;
        }
        if (this.m_21093_(is -> is.m_41720_() instanceof CrossbowItem)) {
            return AbstractIllager.IllagerArmPose.CROSSBOW_HOLD;
        }
        if (this.m_5912_()) {
            if (this.isSpellCaster) {
                return AbstractIllager.IllagerArmPose.SPELLCASTING;
            }
            if (this.m_21093_(is -> is.m_41720_() instanceof BowItem)) {
                return AbstractIllager.IllagerArmPose.BOW_AND_ARROW;
            }
            return AbstractIllager.IllagerArmPose.ATTACKING;
        }
        return AbstractIllager.IllagerArmPose.NEUTRAL;
    }

    public void m_5811_(LivingEntity p_33275_, ItemStack p_33276_, Projectile p_33277_, float p_33278_) {
        this.m_32322_((LivingEntity)this, p_33275_, p_33277_, p_33278_, 1.6f);
    }

    public void m_5847_() {
    }
}

