/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.summon;

import com.mna.ManaAndArtifice;
import com.mna.api.entities.ISummonTargetPredicate;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.entities.ai.RetaliateOnAttackGoal;
import com.mna.tools.SummonUtils;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class InsectSwarm
extends FlyingMob
implements ISummonTargetPredicate {
    public InsectSwarm(EntityType<? extends FlyingMob> type, Level world) {
        super(type, world);
        this.f_21342_ = new MoveHelperController(this);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_()) {
            LivingEntity owner;
            if (this.m_5448_() != null && (this.m_5448_().m_21023_(MobEffects.f_19614_) || !this.m_5448_().m_6084_())) {
                this.m_6710_(null);
            }
            if ((owner = SummonUtils.getSummoner((LivingEntity)this)) == null || !owner.m_6084_()) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    public boolean m_5829_() {
        return false;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(5, (Goal)new SwarmFlyGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new RetaliateOnAttackGoal((Mob)this, new Class[0]));
    }

    public boolean m_7301_(MobEffectInstance pPotioneffect) {
        if (pPotioneffect.m_19544_() == MobEffects.f_19614_ || pPotioneffect.m_19544_() == MobEffects.f_19615_) {
            return false;
        }
        return super.m_7301_(pPotioneffect);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    public boolean m_7327_(Entity pEntity) {
        if (pEntity instanceof LivingEntity) {
            ((LivingEntity)pEntity).m_7292_(new MobEffectInstance(MobEffects.f_19614_, 120, 1));
        }
        return true;
    }

    public void spawnParticle() {
        if (ManaAndArtifice.instance.proxy.isGamePaused()) {
            return;
        }
        float height = this.m_6095_().m_20679_();
        float width = this.m_6095_().m_20678_();
        float offsetAvg = (height + width) / 2.0f;
        float halfOffsetAvg = offsetAvg / 2.0f;
        for (int i = 0; i < 2; ++i) {
            Vec3 pos = new Vec3(this.m_20185_() - (double)halfOffsetAvg + Math.random() * (double)offsetAvg, this.m_20186_() + Math.random() * (double)offsetAvg, this.m_20189_() - (double)halfOffsetAvg + Math.random() * (double)offsetAvg);
            Vec3 vel = pos.m_82546_(this.m_20182_()).m_82492_(0.0, (double)height * Math.random(), 0.0).m_82541_().m_82490_((double)-0.05f);
            this.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.BLUE_SPARKLE_VELOCITY.get())).setColor(69, 66, 30), pos.f_82479_, pos.f_82480_, pos.f_82481_, vel.f_82479_, vel.f_82480_, vel.f_82481_);
        }
    }

    @Override
    public boolean shouldSummonTarget(Entity candidate, boolean isFriendly) {
        if (isFriendly || !(candidate instanceof LivingEntity)) {
            return false;
        }
        return ((LivingEntity)candidate).m_7301_(new MobEffectInstance(MobEffects.f_19614_)) && !((LivingEntity)candidate).m_21023_(MobEffects.f_19614_);
    }

    static class MoveHelperController
    extends MoveControl {
        private final InsectSwarm parentEntity;
        private int courseChangeCooldown;

        public MoveHelperController(InsectSwarm parent) {
            super((Mob)parent);
            this.parentEntity = parent;
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && this.courseChangeCooldown-- <= 0) {
                this.courseChangeCooldown += this.parentEntity.m_217043_().m_188503_(5) + 2;
                Vec3 vector3d = new Vec3(this.f_24975_ - this.parentEntity.m_20185_(), this.f_24976_ - this.parentEntity.m_20186_(), this.f_24977_ - this.parentEntity.m_20189_());
                double d0 = vector3d.m_82553_();
                if (this.isCollided(vector3d = vector3d.m_82541_(), Mth.m_14165_((double)d0))) {
                    this.parentEntity.m_20256_(this.parentEntity.m_20184_().m_82549_(vector3d.m_82490_(0.1)));
                } else {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                }
            }
        }

        private boolean isCollided(Vec3 p_220673_1_, int p_220673_2_) {
            AABB axisalignedbb = this.parentEntity.m_20191_();
            for (int i = 1; i < p_220673_2_; ++i) {
                axisalignedbb = axisalignedbb.m_82383_(p_220673_1_);
                if (this.parentEntity.m_9236_().m_45756_((Entity)this.parentEntity, axisalignedbb)) continue;
                return false;
            }
            return true;
        }
    }

    static class SwarmFlyGoal
    extends Goal {
        private final InsectSwarm parentEntity;

        public SwarmFlyGoal(InsectSwarm pixie) {
            this.parentEntity = pixie;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            MoveControl movementcontroller = this.parentEntity.m_21566_();
            if (!movementcontroller.m_24995_()) {
                return true;
            }
            if (this.parentEntity.m_5448_() == null) {
                double d2;
                double d1;
                double d0 = movementcontroller.m_25000_() - this.parentEntity.m_20185_();
                double d3 = d0 * d0 + (d1 = movementcontroller.m_25001_() - this.parentEntity.m_20186_()) * d1 + (d2 = movementcontroller.m_25002_() - this.parentEntity.m_20189_()) * d2;
                return d3 < 4.0 || d3 > 3600.0;
            }
            double dist = this.parentEntity.m_5448_().m_20280_((Entity)this.parentEntity);
            return !this.parentEntity.m_21574_().m_148306_((Entity)this.parentEntity.m_5448_()) || dist > 25.0 || dist < 4.0;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8056_() {
            if (this.parentEntity.m_5448_() == null) {
                LivingEntity summoner;
                boolean setRandom = true;
                if (SummonUtils.isSummon((Entity)this.parentEntity) && (summoner = SummonUtils.getSummoner((LivingEntity)this.parentEntity)) != null && summoner.m_20270_((Entity)this.parentEntity) > 16.0f) {
                    setRandom = false;
                    this.parentEntity.m_21566_().m_6849_(summoner.m_20185_(), summoner.m_20188_(), summoner.m_20189_(), this.parentEntity.m_21133_(Attributes.f_22279_));
                }
                if (setRandom) {
                    RandomSource random = this.parentEntity.m_217043_();
                    double d0 = this.parentEntity.m_20185_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 16.0f);
                    double d1 = this.parentEntity.m_20186_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 16.0f);
                    double d2 = this.parentEntity.m_20189_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 16.0f);
                    int count = 0;
                    int y = (int)d1;
                    boolean ground = false;
                    while (count < 16) {
                        BlockPos bpTestPos = BlockPos.m_274561_((double)d0, (double)y, (double)d2);
                        if (this.parentEntity.m_9236_().m_46859_(bpTestPos)) {
                            ++count;
                            --y;
                            continue;
                        }
                        if (this.parentEntity.m_9236_().m_46801_(bpTestPos)) {
                            ++count;
                            ++y;
                            ground = true;
                            continue;
                        }
                        ground = true;
                        break;
                    }
                    if (!ground) {
                        d1 -= 16.0;
                    }
                    this.parentEntity.m_21566_().m_6849_(d0, d1, d2, 1.0);
                }
            } else {
                Vec3 target = this.parentEntity.m_5448_().m_146892_();
                this.parentEntity.m_21566_().m_6849_(target.f_82479_, target.f_82480_, target.f_82481_, 1.0);
            }
        }
    }
}

