/*
 * Decompiled with CFR 0.152.
 */
package com.mna.events;

import com.mna.KeybindInit;
import com.mna.ManaAndArtifice;
import com.mna.api.affinity.Affinity;
import com.mna.api.blocks.DirectionalPoint;
import com.mna.api.capabilities.IPlayerMagic;
import com.mna.api.capabilities.WellspringNode;
import com.mna.api.config.GeneralConfigValues;
import com.mna.api.items.IPositionalItem;
import com.mna.api.items.IRelic;
import com.mna.api.items.ITieredItem;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.api.spells.ICanContainSpell;
import com.mna.api.spells.attributes.Attribute;
import com.mna.api.spells.base.ISpellDefinition;
import com.mna.api.tools.MATags;
import com.mna.capabilities.playerdata.magic.PlayerMagicProvider;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.mna.capabilities.worlddata.WorldMagicProvider;
import com.mna.effects.EffectHelper;
import com.mna.effects.EffectInit;
import com.mna.effects.interfaces.IDoubleTapEndEarly;
import com.mna.effects.interfaces.IInputDisable;
import com.mna.enchantments.framework.EnchantmentInit;
import com.mna.entities.constructs.BubbleBoat;
import com.mna.entities.constructs.animated.Construct;
import com.mna.entities.constructs.animated.ConstructDiagnostics;
import com.mna.events.InputDisabler;
import com.mna.factions.Factions;
import com.mna.gui.GuiTextures;
import com.mna.gui.HUDOverlayRenderer;
import com.mna.gui.radial.BellOfBiddingRadialSelect;
import com.mna.gui.radial.EnderDiscPatternRadialSelect;
import com.mna.gui.radial.ItemstackRadialSelect;
import com.mna.gui.radial.ManaweavingWandRadialSelect;
import com.mna.gui.radial.ModifierRadialSelect;
import com.mna.gui.radial.RitualKitRadialSelect;
import com.mna.gui.radial.SpellRadialSelect;
import com.mna.gui.widgets.PlayerInventoryButton;
import com.mna.interop.CuriosInterop;
import com.mna.items.ItemInit;
import com.mna.items.armor.DemonArmorItem;
import com.mna.items.base.IRadialInventorySelect;
import com.mna.items.constructs.BellOfBidding;
import com.mna.items.manaweaving.ItemManaweaverWand;
import com.mna.items.ritual.ItemPractitionersPouch;
import com.mna.items.sorcery.ItemSpellBook;
import com.mna.network.ClientMessageDispatcher;
import com.mna.network.messages.to_server.PossessionInputMessage;
import com.mna.particles.types.movers.ParticleBezierMover;
import com.mna.particles.types.movers.ParticleOrbitMover;
import com.mna.spells.crafting.SpellRecipe;
import com.mna.tools.DidYouKnowHelper;
import com.mna.tools.PossessionHelper;
import com.mna.tools.math.MathUtils;
import com.mna.tools.render.MARenderTypes;
import com.mna.tools.render.MultiblockRenderer;
import com.mna.tools.render.WorldRenderUtils;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.MovementInputUpdateEvent;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.client.event.RenderBlockScreenEffectEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.lwjgl.glfw.GLFW;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotTypePreset;

public class ClientEventHandler {
    private static boolean toolMenuKeyWasDown;
    private static boolean uiModifierKeyWasDown;
    private static boolean spellChordModifierKeyWasUp;
    private static boolean[] slotKeysWereDown;
    public static boolean shiftPressed;
    private static float fogAmount;
    private static float fogDecay;
    public static int decrementFog;
    public static float[] fogColor;
    private static long spaceTapTimer;
    private static boolean lastTickJump;
    private static Entity cachedRenderEntity;
    private static final ResourceLocation oredict_ores;

    public static void setFogAmount(float amount) {
        fogAmount = amount;
        decrementFog = 20;
    }

    public static float getFogAmount() {
        return fogAmount;
    }

    public static void wipeOpen() {
        while (((KeyMapping)KeybindInit.RadialMenuOpen.get()).m_90859_()) {
        }
    }

    @SubscribeEvent
    public static void handleKeys(TickEvent.ClientTickEvent ev) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91080_ == null) {
            ClientEventHandler.handleRadialKeyDown();
            ClientEventHandler.handleUIModifierKeyDown();
            ClientEventHandler.handleSpellBookChordsKeyDown();
        } else {
            toolMenuKeyWasDown = true;
            uiModifierKeyWasDown = true;
            spellChordModifierKeyWasUp = true;
            for (int i = 0; i < slotKeysWereDown.length; ++i) {
                ClientEventHandler.slotKeysWereDown[i] = true;
            }
        }
    }

    private static void handleSpellBookChordsKeyDown() {
        Minecraft mc = Minecraft.m_91087_();
        boolean spellChordModifierKeyIsDown = ((KeyMapping)KeybindInit.SpellBookChord.get()).m_90857_();
        if (spellChordModifierKeyIsDown) {
            if (spellChordModifierKeyWasUp) {
                HUDOverlayRenderer.instance.isRenderingSpellBookChords = !HUDOverlayRenderer.instance.isRenderingSpellBookChords;
                spellChordModifierKeyWasUp = false;
            }
        } else {
            spellChordModifierKeyWasUp = true;
        }
        if (HUDOverlayRenderer.instance.isRenderingSpellBookChords) {
            KeyMapping[] slotKeyBinds = mc.f_91066_.f_92056_;
            for (int i = 0; i < slotKeyBinds.length; ++i) {
                boolean slotKeyDown = slotKeyBinds[i].m_90857_();
                if (slotKeyDown != slotKeysWereDown[i]) {
                    while (slotKeyBinds[i].m_90859_()) {
                    }
                    ItemStack mainHandItem = mc.f_91074_.m_21205_();
                    ItemStack offHandItem = mc.f_91074_.m_21206_();
                    boolean offhand = false;
                    ItemStack inHand = ItemStack.f_41583_;
                    if (mainHandItem.m_41720_() instanceof ItemSpellBook) {
                        inHand = mainHandItem;
                    } else if (offHandItem.m_41720_() instanceof ItemSpellBook) {
                        inHand = offHandItem;
                        offhand = true;
                    }
                    if (!inHand.m_41619_()) {
                        ItemSpellBook.setSlot((Player)mc.f_91074_, inHand, i, offhand, true);
                    }
                    HUDOverlayRenderer.instance.isRenderingSpellBookChords = false;
                    spellChordModifierKeyWasUp = true;
                }
                ClientEventHandler.slotKeysWereDown[i] = slotKeyDown;
            }
        }
    }

    private static void handleUIModifierKeyDown() {
        Minecraft mc = Minecraft.m_91087_();
        boolean uiModifierKeyIsDown = ((KeyMapping)KeybindInit.InventoryItemOpen.get()).m_90857_();
        if (uiModifierKeyIsDown != uiModifierKeyWasDown) {
            ClientMessageDispatcher.sendItemUIOpenMessage(uiModifierKeyIsDown);
            mc.f_91074_.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> m.setModifierPressed(uiModifierKeyIsDown));
        }
        uiModifierKeyWasDown = uiModifierKeyIsDown;
    }

    private static void handleRadialKeyDown() {
        Minecraft mc = Minecraft.m_91087_();
        boolean toolMenuKeyIsDown = ((KeyMapping)KeybindInit.RadialMenuOpen.get()).m_90857_();
        if (toolMenuKeyIsDown && !toolMenuKeyWasDown) {
            while (((KeyMapping)KeybindInit.RadialMenuOpen.get()).m_90859_()) {
                if (mc.f_91080_ != null) continue;
                ItemStack inHand = mc.f_91074_.m_21205_();
                boolean checkOffhand = true;
                if (inHand.m_41720_() instanceof ItemSpellBook) {
                    mc.m_91152_((Screen)new SpellRadialSelect(false));
                    checkOffhand = false;
                } else if (inHand.m_41720_() == ItemInit.MODIFIER_BOOK.get()) {
                    mc.m_91152_((Screen)new ModifierRadialSelect(false));
                    checkOffhand = false;
                } else if (inHand.m_41720_() == ItemInit.ENDER_DISK.get()) {
                    mc.m_91152_((Screen)new EnderDiscPatternRadialSelect(false));
                    checkOffhand = false;
                } else if (inHand.m_41720_() instanceof ItemPractitionersPouch) {
                    mc.m_91152_((Screen)new RitualKitRadialSelect(false));
                    checkOffhand = false;
                } else if (inHand.m_41720_() instanceof BellOfBidding) {
                    mc.m_91152_((Screen)new BellOfBiddingRadialSelect(false));
                    checkOffhand = false;
                } else if (inHand.m_41720_() instanceof ItemManaweaverWand) {
                    mc.m_91152_((Screen)new ManaweavingWandRadialSelect(false));
                    checkOffhand = false;
                } else if (inHand.m_41720_() instanceof IRadialInventorySelect) {
                    mc.m_91152_((Screen)new ItemstackRadialSelect(false).setOverrideStackCount(((IRadialInventorySelect)inHand.m_41720_()).capacity()));
                    checkOffhand = false;
                }
                if (!checkOffhand) continue;
                inHand = mc.f_91074_.m_21206_();
                if (inHand.m_41720_() instanceof ItemSpellBook) {
                    mc.m_91152_((Screen)new SpellRadialSelect(true));
                    continue;
                }
                if (inHand.m_41720_() == ItemInit.MODIFIER_BOOK.get()) {
                    mc.m_91152_((Screen)new ModifierRadialSelect(true));
                    continue;
                }
                if (inHand.m_41720_() == ItemInit.ENDER_DISK.get()) {
                    mc.m_91152_((Screen)new EnderDiscPatternRadialSelect(true));
                    continue;
                }
                if (inHand.m_41720_() instanceof ItemPractitionersPouch) {
                    mc.m_91152_((Screen)new RitualKitRadialSelect(true));
                    continue;
                }
                if (inHand.m_41720_() instanceof BellOfBidding) {
                    mc.m_91152_((Screen)new BellOfBiddingRadialSelect(true));
                    checkOffhand = false;
                    continue;
                }
                if (inHand.m_41720_() instanceof ItemManaweaverWand) {
                    mc.m_91152_((Screen)new ManaweavingWandRadialSelect(true));
                    checkOffhand = false;
                    continue;
                }
                if (!(inHand.m_41720_() instanceof IRadialInventorySelect)) continue;
                mc.m_91152_((Screen)new ItemstackRadialSelect(true).setOverrideStackCount(((IRadialInventorySelect)inHand.m_41720_()).capacity()));
            }
        }
        toolMenuKeyWasDown = toolMenuKeyIsDown;
    }

    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent event) {
        Level world;
        if (Minecraft.m_91087_().m_91104_()) {
            return;
        }
        Player player = ManaAndArtifice.instance.proxy.getClientPlayer();
        if (player != null) {
            DidYouKnowHelper.CheckAndShowDidYouKnow(player, "helptip.mna.pretty_models");
            world = ManaAndArtifice.instance.proxy.getClientWorld();
            ClientEventHandler.renderWellsprings(world, player);
            if (player.m_21023_((MobEffect)EffectInit.SNOWBLIND.get())) {
                double amount;
                double dist;
                fogDecay = 0.01f;
                if (fogAmount < fogDecay * 2.0f) {
                    fogAmount = fogDecay * 2.0f;
                }
                Vec3 pos = player.m_20182_();
                Vec3 lastPos = ManaAndArtifice.instance.proxy.getClientLastTickPosition();
                lastPos = new Vec3(lastPos.f_82479_, 0.0, lastPos.f_82481_);
                pos = new Vec3(pos.f_82479_, 0.0, pos.f_82481_);
                if (lastPos != Vec3.f_82478_ && (dist = pos.m_82557_(lastPos)) > 0.078 && (double)fogAmount < (amount = (dist - 0.078) * 10.0)) {
                    fogAmount = (float)amount;
                }
                if (fogAmount > 2.0f) {
                    fogAmount = 2.0f;
                }
            } else {
                fogDecay = 0.01f;
            }
        }
        if (fogAmount > 0.0f && decrementFog-- < 0) {
            fogAmount -= fogDecay;
        }
        ManaAndArtifice.instance.proxy.incrementTick();
        if (player != null && player.m_21023_((MobEffect)EffectInit.CHOOSING_WELLSPRING.get())) {
            world = ManaAndArtifice.instance.proxy.getClientWorld();
            world.getCapability(WorldMagicProvider.MAGIC).ifPresent(m -> {
                int dist = GeneralConfigValues.WellspringDistance;
                int halfDist = dist / 2;
                HashMap<BlockPos, WellspringNode> nodes = m.getWellspringRegistry().getNearbyNodes(player.m_20183_(), 50, dist + halfDist);
                Vec3 start = player.m_20182_();
                for (Map.Entry<BlockPos, WellspringNode> entry : nodes.entrySet()) {
                    BlockPos targetPos = entry.getKey();
                    Vec3 targetVec3d = new Vec3((double)targetPos.m_123341_(), player.m_20186_() + 1.0, (double)targetPos.m_123343_());
                    Vec3 dir = targetVec3d.m_82546_(start).m_82541_();
                    WellspringNode node = entry.getValue();
                    MAParticleType particle = null;
                    if (node.isClaimed()) {
                        int[] color = node.getAffinity().getShiftAffinity().getColor();
                        particle = new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.SPARKLE_VELOCITY.get())).setColor(color[0], color[1], color[2]);
                    } else {
                        particle = new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.SPARKLE_VELOCITY.get())).setColor(255, 255, 255);
                    }
                    particle.setScale(0.05f);
                    world.m_7106_((ParticleOptions)particle, player.m_20185_() + dir.m_7096_() + Math.random() * 0.2 - 0.1, player.m_20186_() + 1.0 + dir.m_7098_() + Math.random() * 0.2 - 0.1, player.m_20189_() + dir.m_7094_() + Math.random() * 0.2 - 0.1, dir.f_82479_, dir.f_82480_, dir.f_82481_);
                }
            });
        }
        if (player != null && player.m_21023_((MobEffect)EffectInit.COLD_DARK.get())) {
            fogAmount = 0.95f;
            ClientEventHandler.fogColor[0] = 0.05f;
            ClientEventHandler.fogColor[1] = 0.05f;
            ClientEventHandler.fogColor[2] = 0.05f;
        }
    }

    private static void renderWellsprings(Level world, Player player) {
        world.getCapability(WorldMagicProvider.MAGIC).ifPresent(m -> m.getWellspringRegistry().getNearbyNodes(player.m_20183_(), 0, 32).forEach((pos, node) -> {
            int i;
            float spread;
            if (!(node.isClaimed() || player.m_21023_((MobEffect)EffectInit.ELDRIN_SIGHT.get()) || player.m_21023_((MobEffect)EffectInit.WELLSPRING_SIGHT.get()))) {
                return;
            }
            if (node.hasForcedYLevel() && Math.abs(player.m_20186_() - (double)node.getYLevel()) > 32.0) {
                return;
            }
            Affinity aff = node.getAffinity().getShiftAffinity();
            double yPos = node.hasForcedYLevel() ? (double)node.getYLevel() : player.m_20186_();
            int[] colors = aff.getColor();
            int[] sparkleColors = null;
            float scale = 1.0f;
            float strength = node.getStrength();
            float lightSpread = spread = strength / 25.0f / 2.0f;
            int affPfxAmount = 2;
            float lightScale = 1.0f;
            float beamVelUp = 0.1f;
            int lightLifetime = 20;
            float[] velocities = new float[]{0.0f, 0.2f, 0.0f};
            Vec3 llPos = new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
            MAParticleType type = null;
            switch (aff) {
                case FIRE: 
                case HELLFIRE: {
                    type = (MAParticleType)((Object)((Object)((Object)ParticleInit.FLAME.get())));
                    scale = 0.3f;
                    break;
                }
                case WATER: 
                case ICE: {
                    type = (MAParticleType)((Object)((Object)((Object)ParticleInit.WATER.get())));
                    scale = 0.02f + (float)Math.random() * 0.04f;
                    spread = (float)((double)spread + 0.35);
                    lightScale = 0.75f;
                    break;
                }
                case EARTH: {
                    type = (MAParticleType)((Object)((Object)((Object)ParticleInit.DUST.get())));
                    scale = 0.2f + (float)(Math.random() * (double)0.2f) * spread;
                    velocities = new float[]{0.0f, -0.13f, 0.0f};
                    sparkleColors = new int[]{30, 14, 10};
                    colors = new int[]{30, 14, 10};
                    affPfxAmount = 3;
                    lightScale = 0.625f * spread + 0.1f;
                    lightLifetime = 20;
                    beamVelUp = 0.01f;
                    lightSpread = 0.02f * spread;
                    if (!(Math.random() < (double)(spread + 0.25f))) break;
                    world.m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.EARTH.get())).setPhysics(false).setMaxAge(60).setScale(0.1f).setMover(new ParticleOrbitMover(llPos.m_7096_(), yPos, llPos.m_7094_(), 0.1, -0.025, 1.0f * spread)), llPos.m_7096_(), yPos - 3.0 + Math.random() * 10.0, llPos.m_7094_(), 0.0, 0.0, 0.0);
                    break;
                }
                case WIND: {
                    type = (MAParticleType)((Object)((Object)((Object)ParticleInit.AIR_ORBIT.get())));
                    affPfxAmount = (int)Math.ceil(8.0f * spread);
                    scale = 0.2f;
                    sparkleColors = new int[]{20, 20, 20};
                    colors = new int[]{40, 40, 40};
                    velocities = new float[]{0.3f, 0.2f, spread * 2.0f};
                    lightScale = 0.5f * spread + 0.15f;
                    beamVelUp = 0.2f;
                    spread *= 0.0f;
                    break;
                }
                case ENDER: {
                    type = (MAParticleType)((Object)((Object)((Object)ParticleInit.ENDER_VELOCITY.get())));
                    scale = 0.3f;
                    lightScale = 0.4f;
                    lightSpread = 0.5f - lightSpread;
                    spread = 0.5f - spread;
                    world.m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ENDER_VELOCITY.get())).setPhysics(false).setMaxAge(60).setScale(0.1f).setMover(new ParticleOrbitMover(llPos.m_7096_(), yPos, llPos.m_7094_(), Math.random() * 0.1, Math.random() * 0.07, 0.4)), llPos.m_7096_(), yPos - 3.0 + Math.random() * 10.0, llPos.m_7094_(), 0.0, 0.0, 0.0);
                    break;
                }
                case ARCANE: {
                    type = (MAParticleType)((Object)((Object)((Object)ParticleInit.ARCANE_MAGELIGHT.get())));
                    scale = 0.15f;
                    affPfxAmount = 3;
                    colors = new int[]{102, 32, 232};
                    lightSpread = 0.05f;
                    if (player.m_9236_().m_46467_() % 20L != 0L) break;
                    world.m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.TRAIL_ORBIT.get())).setColor(colors[0], colors[1], colors[2]).setPhysics(false).setMaxAge(60), llPos.m_7096_(), yPos - 4.0, llPos.m_7094_(), 0.25, 0.25, (double)spread);
                    break;
                }
            }
            if (aff != Affinity.UNKNOWN) {
                for (i = 0; i < 15; ++i) {
                    world.m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.LIGHT_VELOCITY.get())).setScale(lightScale).setColor(colors[0], colors[1], colors[2]).setMaxAge(lightLifetime), llPos.m_7096_() - (double)lightSpread + Math.random() * (double)lightSpread * 2.0, yPos - 3.0 + Math.random() * 10.0, llPos.m_7094_() - (double)lightSpread + Math.random() * (double)lightSpread * 2.0, 0.0, (double)beamVelUp, 0.0);
                }
            }
            if (type != null) {
                for (i = 0; i < affPfxAmount; ++i) {
                    MAParticleType particle = new MAParticleType(type).setScale(scale).setPhysics(false);
                    if (sparkleColors != null) {
                        particle.setColor((int)sparkleColors[0], sparkleColors[1], sparkleColors[2]);
                    }
                    world.m_7106_((ParticleOptions)particle, llPos.m_7096_() - (double)spread + Math.random() * (double)spread * 2.0, yPos - 3.0 + Math.random() * 10.0, llPos.m_7094_() - (double)spread + Math.random() * (double)spread * 2.0, (double)velocities[0], (double)velocities[1], (double)velocities[2]);
                }
            }
            if (player.m_9236_().m_46467_() % 20L == 0L) {
                if (!node.hasForcedYLevel()) {
                    world.m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.TRAIL_ORBIT.get())).setColor(colors[0], colors[1], colors[2]).setScale(0.2f), llPos.m_7096_(), yPos - 1.0, llPos.m_7094_(), 0.25, 0.25, 0.65);
                } else {
                    int rnd = (int)(Math.random() * 4.0);
                    Vec3 start = new Vec3(llPos.m_7096_() - 0.5, yPos - 2.0, llPos.m_7094_() - 0.5);
                    Vec3 end = null;
                    Vec3 control_a = null;
                    Vec3 control_b = null;
                    switch (rnd) {
                        case 0: {
                            end = new Vec3(llPos.m_7096_(), yPos + 2.0, llPos.m_7094_() + 5.0);
                            control_a = new Vec3(llPos.m_7096_(), yPos + 4.0, llPos.m_7094_() + 1.0);
                            control_b = new Vec3(llPos.m_7096_(), yPos + 4.0, llPos.m_7094_() + 3.0);
                            break;
                        }
                        case 1: {
                            end = new Vec3(llPos.m_7096_() + 5.0, yPos + 2.0, llPos.m_7094_());
                            control_a = new Vec3(llPos.m_7096_() + 1.0, yPos + 4.0, llPos.m_7094_());
                            control_b = new Vec3(llPos.m_7096_() + 3.0, yPos + 4.0, llPos.m_7094_());
                            break;
                        }
                        case 2: {
                            end = new Vec3(llPos.m_7096_() - 5.0, yPos + 2.0, llPos.m_7094_());
                            control_a = new Vec3(llPos.m_7096_() - 1.0, yPos + 4.0, llPos.m_7094_());
                            control_b = new Vec3(llPos.m_7096_() - 3.0, yPos + 4.0, llPos.m_7094_());
                            break;
                        }
                        case 3: {
                            end = new Vec3(llPos.m_7096_(), yPos + 2.0, llPos.m_7094_() - 5.0);
                            control_a = new Vec3(llPos.m_7096_(), yPos + 4.0, llPos.m_7094_() - 1.0);
                            control_b = new Vec3(llPos.m_7096_(), yPos + 4.0, llPos.m_7094_() - 3.0);
                        }
                    }
                    world.m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.TRAIL_BEZIER.get())).setColor(colors[0], colors[1], colors[2]).setMaxAge(30).setAgePadding(5).setScale(0.2f).setMover(new ParticleBezierMover(start, end, control_a, control_b)), start.f_82479_, start.f_82480_, start.f_82481_, end.f_82479_, end.f_82480_, end.f_82481_);
                }
            }
        }));
    }

    @SubscribeEvent
    public static void entityTick(LivingEvent.LivingTickEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc == null || mc.f_91074_ == null || event.getEntity() == null) {
            return;
        }
        if (event.getEntity() == mc.f_91074_) {
            return;
        }
        if (event.getEntity().m_20280_((Entity)mc.f_91074_) > 256.0) {
            return;
        }
        MobEffectInstance existingEffect = event.getEntity().m_21124_(MobEffects.f_19619_);
        if (mc.f_91074_.m_21023_((MobEffect)EffectInit.ELDRIN_SIGHT.get()) && (existingEffect == null || existingEffect.m_19557_() < 5)) {
            event.getEntity().m_7292_(new MobEffectInstance(MobEffects.f_19619_, 20, 0, false, false));
        }
    }

    @SubscribeEvent
    public static void onMouseClick(InputEvent.InteractionKeyMappingTriggered event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        MobEffectInstance posession = mc.f_91074_.m_21124_((MobEffect)EffectInit.POSSESSION.get());
        if (event.isAttack() && posession != null && posession.m_19564_() > 0) {
            event.setCanceled(true);
            ClientMessageDispatcher.sendPosessionClickInput();
        }
    }

    @SubscribeEvent
    public static void onMouseWheel(InputEvent.MouseScrollingEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        if (mc.f_91074_.m_6117_()) {
            ItemStack using = mc.f_91074_.m_21211_();
            ISpellDefinition recipe = null;
            if (using.m_41720_() instanceof ItemSpellBook) {
                recipe = SpellRecipe.fromNBT(((ItemSpellBook)using.m_41720_()).getSpellCompound(using, (Player)mc.f_91074_));
            } else if (using.m_41720_() instanceof ICanContainSpell) {
                recipe = ((ICanContainSpell)using.m_41720_()).getSpell(using);
            }
            if (recipe != null && recipe.isValid() && recipe.isChanneled()) {
                event.setCanceled(true);
                float maximum = recipe.getShape().getValue(Attribute.RANGE);
                mc.f_91074_.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> {
                    float delta = (float)event.getScrollDelta();
                    m.offsetFocusDistance(delta, maximum);
                    ClientMessageDispatcher.sendPlayerFocusDistanceChange(delta, maximum);
                });
                event.setResult(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent
    public static void playerInputEvent(MovementInputUpdateEvent event) {
        boolean teleporting;
        MobEffectInstance posession;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        if (spaceTapTimer > 0L) {
            --spaceTapTimer;
        }
        if (mc.f_91074_.m_21023_((MobEffect)EffectInit.CONFUSION.get()) && GeneralConfigValues.ConfuseAffectsPlayers) {
            event.getInput().f_108567_ = -event.getInput().f_108567_;
            event.getInput().f_108566_ = -event.getInput().f_108566_;
        }
        if ((posession = mc.f_91074_.m_21124_((MobEffect)EffectInit.POSSESSION.get())) != null && posession.m_19564_() > 0) {
            ClientMessageDispatcher.sendPosessionMovementInput(event.getInput().f_108568_ ? 1.0f : (event.getInput().f_108569_ ? -1.0f : 0.0f), event.getInput().f_108570_ ? 1.0f : (event.getInput().f_108571_ ? -1.0f : 0.0f), event.getInput().f_108572_, event.getInput().f_108573_, mc.f_91074_.m_146908_(), mc.f_91074_.f_20885_, mc.f_91074_.m_146909_());
            PossessionInputMessage msg = PossessionInputMessage.movement(event.getInput().f_108568_ ? 1.0f : (event.getInput().f_108569_ ? -1.0f : 0.0f), event.getInput().f_108570_ ? 1.0f : (event.getInput().f_108571_ ? -1.0f : 0.0f), event.getInput().f_108572_, event.getInput().f_108573_, mc.f_91074_.m_146908_(), mc.f_91074_.f_20885_, mc.f_91074_.m_146909_());
            if (mc.f_91074_.getPersistentData().m_128441_("posessed_entity_id")) {
                int id = mc.f_91074_.getPersistentData().m_128451_("posessed_entity_id");
                Entity e2 = mc.f_91074_.m_9236_().m_6815_(id);
                if (e2 != null && e2 instanceof Mob) {
                    PossessionHelper.handleRemoteInput(msg, (Player)mc.f_91074_, (Mob)e2);
                }
            }
        }
        if (!mc.f_91074_.m_20096_() && event.getInput().f_108572_ && mc.f_91074_.f_20954_ == 0) {
            ItemStack boots = mc.f_91074_.m_6844_(EquipmentSlot.FEET);
            int enchLevel = boots.getEnchantmentLevel((Enchantment)EnchantmentInit.LEAPING.get());
            if (!boots.m_41619_() && enchLevel > 0) {
                mc.f_91074_.f_20954_ = 10;
                ClientMessageDispatcher.sendPlayerJump();
            }
        }
        if (!lastTickJump && event.getInput().f_108572_ && mc.f_91074_.m_21220_().stream().anyMatch(e -> e.m_19544_() instanceof IDoubleTapEndEarly)) {
            if (spaceTapTimer == 0L) {
                spaceTapTimer = 7L;
            } else {
                EffectHelper.removeDoubleTapEvents((Player)mc.f_91074_);
                ClientMessageDispatcher.sendRequestEndControlEffectEarlyMessage();
                spaceTapTimer = 0L;
            }
        }
        lastTickJump = event.getInput().f_108572_;
        int mask = InputDisabler.getDisableInputMask((LivingEntity)event.getEntity());
        IPlayerMagic magic = (IPlayerMagic)mc.f_91074_.getCapability(PlayerMagicProvider.MAGIC).orElse(null);
        boolean bl = magic == null ? false : (teleporting = magic.getIsTeleporting() || magic.getTeleportElapsedTicks() > 0);
        if ((mask & IInputDisable.InputMask.MOVEMENT.mask()) != 0 || teleporting) {
            event.getInput().f_108568_ = false;
            event.getInput().f_108569_ = false;
            event.getInput().f_108570_ = false;
            event.getInput().f_108571_ = false;
            event.getInput().f_108572_ = false;
            event.getInput().f_108567_ = 0.0f;
            event.getInput().f_108566_ = 0.0f;
            event.getInput().f_108573_ = false;
        } else if ((mask & IInputDisable.InputMask.JUMP.mask()) != 0 || teleporting) {
            event.getInput().f_108572_ = false;
            event.getInput().f_108573_ = false;
        }
    }

    public static boolean isKeyDown(KeyMapping keybind) {
        if (keybind.m_90862_()) {
            return false;
        }
        boolean isDown = false;
        switch (keybind.getKey().m_84868_()) {
            case KEYSYM: {
                isDown = InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)keybind.getKey().m_84873_());
                break;
            }
            case MOUSE: {
                isDown = GLFW.glfwGetMouseButton((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)keybind.getKey().m_84873_()) == 1;
            }
        }
        return isDown && keybind.getKeyConflictContext().isActive() && keybind.getKeyModifier().isActive(keybind.getKeyConflictContext());
    }

    @SubscribeEvent
    public static void onRenderWorldLast(RenderLevelStageEvent rwl) {
        if (rwl.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            return;
        }
        PoseStack matrixStack = rwl.getPoseStack();
        Minecraft mc = Minecraft.m_91087_();
        Vec3 projectedView = mc.f_91063_.m_109153_().m_90583_();
        MultiBufferSource.BufferSource buffers = mc.m_91269_().m_110104_();
        matrixStack.m_85836_();
        matrixStack.m_85837_(-projectedView.f_82479_, -projectedView.f_82480_, -projectedView.f_82481_);
        ClientEventHandler.renderMarkingRunes(mc, matrixStack, projectedView, buffers);
        ClientEventHandler.renderConstructWorldDiagnostics(mc, matrixStack, projectedView, buffers);
        MobEffectInstance inst = mc.f_91074_.m_21124_((MobEffect)EffectInit.DIVINATION.get());
        if (inst != null) {
            ClientEventHandler.renderNearbyOres(mc, matrixStack, projectedView, buffers, inst.m_19564_() + 2);
        }
        matrixStack.m_85849_();
        matrixStack.m_85836_();
        matrixStack.m_85837_(-projectedView.f_82479_, -projectedView.f_82480_, -projectedView.f_82481_);
        ClientEventHandler.renderDistantWellsprings((Level)mc.f_91073_, mc.m_91296_(), matrixStack, (MultiBufferSource)buffers, (Player)mc.f_91074_);
        matrixStack.m_85849_();
        buffers.m_109911_();
    }

    private static void renderDistantWellsprings(Level world, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, Player player) {
        world.getCapability(WorldMagicProvider.MAGIC).ifPresent(m -> m.getWellspringRegistry().getNearbyNodes(player.m_20183_(), 0, 128).forEach((pos, node) -> {
            double distAdjusted;
            double distPct;
            if (!(node.isClaimed() || player.m_21023_((MobEffect)EffectInit.ELDRIN_SIGHT.get()) || player.m_21023_((MobEffect)EffectInit.WELLSPRING_SIGHT.get()))) {
                return;
            }
            if (node.hasForcedYLevel() && Math.abs(player.m_20186_() - (double)node.getYLevel()) > 32.0) {
                return;
            }
            BlockPos adjPos = new BlockPos(pos.m_123341_(), player.m_20183_().m_123342_(), pos.m_123343_());
            double dist = Math.sqrt(player.m_20183_().m_123331_((Vec3i)adjPos));
            Affinity aff = node.getAffinity().getShiftAffinity();
            int alpha = 176;
            int distFalloff = 12;
            int distFalloffStart = 38;
            int height = 13;
            if (dist < (double)distFalloffStart && aff != Affinity.ENDER && aff != Affinity.UNKNOWN && (alpha = (int)((double)alpha * (distPct = 1.0 - (distAdjusted = (double)distFalloffStart - dist) / (double)distFalloff))) < 0) {
                alpha = 0;
            }
            if (!node.hasForcedYLevel()) {
                height = 255;
            }
            int[] color = aff.getColor();
            double yPos = node.hasForcedYLevel() ? (double)(node.getYLevel() - 4) : 0.0;
            Vec3 llPos = new Vec3((double)pos.m_123341_() + 0.5, yPos, (double)pos.m_123343_() + 0.5);
            matrixStack.m_85836_();
            matrixStack.m_85837_(llPos.f_82479_, llPos.f_82480_, llPos.f_82481_);
            WorldRenderUtils.renderBeam(world, partialTicks, matrixStack, buffer, 0xF00000, llPos, llPos.m_82520_(0.0, (double)height, 0.0), 1.0f, color, alpha, 0.25f, MARenderTypes.RITUAL_BEAM_RENDER_TYPE);
            matrixStack.m_85849_();
        }));
    }

    private static void renderConstructWorldDiagnostics(Minecraft mc, PoseStack matrixStack, Vec3 projectedView, MultiBufferSource.BufferSource buffers) {
        Construct c = HUDOverlayRenderer.instance.getTrackedConstruct();
        if (c == null) {
            return;
        }
        LinkedList<ConstructDiagnostics.TaskHistoryEntry> taskHistory = c.getDiagnostics().getTaskHistory();
        if (taskHistory.size() == 0) {
            return;
        }
        int drawDist = 4096;
        float opacity = 1.0f;
        float opacityDecrease = 0.9f / (float)taskHistory.size();
        RenderSystem.disableDepthTest();
        for (int i = taskHistory.size() - 1; i >= 0; --i) {
            matrixStack.m_85836_();
            ConstructDiagnostics.TaskHistoryEntry mostRecentTask = taskHistory.get(i);
            float[] color = mostRecentTask.colorFromStatusCode();
            if (mostRecentTask.getEntityID() > 0) {
                if (cachedRenderEntity == null || cachedRenderEntity.m_19879_() != mostRecentTask.getEntityID()) {
                    cachedRenderEntity = mc.f_91073_.m_6815_(mostRecentTask.getEntityID());
                }
                if (cachedRenderEntity != null && cachedRenderEntity.m_6084_() && mc.f_91074_.m_20280_(cachedRenderEntity) < (double)drawDist) {
                    LevelRenderer.m_109646_((PoseStack)matrixStack, (VertexConsumer)buffers.m_6299_(MARenderTypes.MARKING_RUNE_MARK), (AABB)new AABB(cachedRenderEntity.m_20183_()).m_82406_(0.375), (float)color[0], (float)color[1], (float)color[2], (float)opacity);
                }
            }
            if (mostRecentTask.getArea() != null && mc.f_91074_.m_20238_(mostRecentTask.getArea().m_82399_()) < (double)drawDist + Math.pow(mostRecentTask.getArea().m_82309_() / 2.0, 2.0)) {
                LevelRenderer.m_109646_((PoseStack)matrixStack, (VertexConsumer)buffers.m_6299_(MARenderTypes.MARKING_RUNE_MARK), (AABB)mostRecentTask.getArea(), (float)color[0], (float)color[1], (float)color[2], (float)opacity);
            }
            if (mostRecentTask.getPos() != null && mc.f_91074_.m_20238_(mostRecentTask.getPos()) < (double)drawDist) {
                LevelRenderer.m_109646_((PoseStack)matrixStack, (VertexConsumer)buffers.m_6299_(MARenderTypes.MARKING_RUNE_MARK), (AABB)new AABB(BlockPos.m_274446_((Position)mostRecentTask.getPos())).m_82406_(0.375), (float)color[0], (float)color[1], (float)color[2], (float)opacity);
            }
            opacity -= opacityDecrease;
            matrixStack.m_85849_();
        }
        Vec3 targetPos = c.getDiagnostics().getMovePos();
        if (targetPos != null && mc.f_91074_.m_20238_(targetPos) < (double)drawDist && mc.f_91074_.m_20280_((Entity)c) < (double)drawDist) {
            VertexConsumer consumer = buffers.m_6299_(MARenderTypes.MARKING_RUNE_MARK);
            BlockPos blockPos = BlockPos.m_274446_((Position)targetPos);
            LevelRenderer.m_109646_((PoseStack)matrixStack, (VertexConsumer)consumer, (AABB)new AABB(blockPos).m_82406_(0.375), (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            targetPos = Vec3.m_82512_((Vec3i)blockPos);
            Matrix4f positions = matrixStack.m_85850_().m_252922_();
            Matrix3f normals = matrixStack.m_85850_().m_252943_();
            Vec3 cPos = c.m_20182_();
            consumer.m_252986_(positions, (float)cPos.f_82479_, (float)cPos.f_82480_, (float)cPos.f_82481_).m_6122_(1, 1, 1, 1).m_252939_(normals, 1.0f, 0.0f, 0.0f).m_5752_();
            consumer.m_252986_(positions, (float)targetPos.f_82479_, (float)targetPos.f_82480_, (float)targetPos.f_82481_).m_6122_(1, 1, 1, 1).m_252939_(normals, 1.0f, 0.0f, 0.0f).m_5752_();
        }
        RenderSystem.enableDepthTest();
    }

    private static void renderMarkingRunes(Minecraft mc, PoseStack matrixStack, Vec3 projectedView, MultiBufferSource.BufferSource buffers) {
        Vec3 offsetVec;
        float offsetAmt;
        Direction face;
        int drawDist = 4096;
        ItemStack mainHand = mc.f_91074_.m_21205_();
        ItemStack offHand = mc.f_91074_.m_21206_();
        DirectionalPoint mainHandPos = null;
        DirectionalPoint offhandPos = null;
        boolean render = false;
        Item item = mainHand.m_41720_();
        if (item instanceof IPositionalItem) {
            IPositionalItem mhPosItem = (IPositionalItem)item;
            mainHandPos = mhPosItem.getDirectionalPoint(mainHand);
            render = true;
        }
        if ((item = offHand.m_41720_()) instanceof IPositionalItem) {
            IPositionalItem ohPosItem = (IPositionalItem)item;
            offhandPos = ohPosItem.getDirectionalPoint(offHand);
            render = true;
        }
        if (!render) {
            return;
        }
        boolean drawMainHand = false;
        boolean drawOffHand = false;
        RenderSystem.disableDepthTest();
        if (mainHandPos != null && mainHandPos.isValid() && mc.f_91074_.m_20275_((double)mainHandPos.getPosition().m_123341_(), (double)mainHandPos.getPosition().m_123342_(), (double)mainHandPos.getPosition().m_123343_()) < (double)drawDist) {
            LevelRenderer.m_109646_((PoseStack)matrixStack, (VertexConsumer)buffers.m_6299_(MARenderTypes.MARKING_RUNE_MARK), (AABB)new AABB(mainHandPos.getPosition()).m_82406_(0.25), (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
            face = mainHandPos.getDirection();
            offsetAmt = 0.4f;
            offsetVec = new Vec3((double)((float)face.m_122429_() * offsetAmt), (double)((float)face.m_122430_() * offsetAmt), (double)((float)face.m_122431_() * offsetAmt));
            LevelRenderer.m_109646_((PoseStack)matrixStack, (VertexConsumer)buffers.m_6299_(MARenderTypes.MARKING_RUNE_MARK), (AABB)new AABB(mainHandPos.getPosition()).m_82383_(offsetVec).m_82406_(0.49).m_82310_(-offsetVec.f_82479_, -offsetVec.f_82480_, -offsetVec.f_82481_), (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            drawMainHand = true;
        }
        if (offhandPos != null && offhandPos.isValid() && mc.f_91074_.m_20275_((double)offhandPos.getPosition().m_123341_(), (double)offhandPos.getPosition().m_123342_(), (double)offhandPos.getPosition().m_123343_()) < (double)drawDist) {
            LevelRenderer.m_109646_((PoseStack)matrixStack, (VertexConsumer)buffers.m_6299_(MARenderTypes.MARKING_RUNE_MARK), (AABB)new AABB(offhandPos.getPosition()).m_82406_(0.25), (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            face = offhandPos.getDirection();
            offsetAmt = 0.4f;
            offsetVec = new Vec3((double)((float)face.m_122429_() * offsetAmt), (double)((float)face.m_122430_() * offsetAmt), (double)((float)face.m_122431_() * offsetAmt));
            LevelRenderer.m_109646_((PoseStack)matrixStack, (VertexConsumer)buffers.m_6299_(MARenderTypes.MARKING_RUNE_MARK), (AABB)new AABB(offhandPos.getPosition()).m_82383_(offsetVec).m_82406_(0.49).m_82310_(-offsetVec.f_82479_, -offsetVec.f_82480_, -offsetVec.f_82481_), (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            drawOffHand = true;
        }
        if (drawMainHand && drawOffHand) {
            LevelRenderer.m_109646_((PoseStack)matrixStack, (VertexConsumer)buffers.m_6299_(MARenderTypes.MARKING_RUNE_MARK), (AABB)MathUtils.createInclusiveBB(mainHandPos.getPosition(), offhandPos.getPosition()), (float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        }
        RenderSystem.enableDepthTest();
    }

    private static void renderNearbyOres(Minecraft mc, PoseStack matrixStack, Vec3 projectedView, MultiBufferSource.BufferSource buffers, int radius) {
        ItemStack offhand = mc.f_91074_.m_21206_();
        boolean searchOffhand = offhand.m_41720_() instanceof BlockItem;
        BlockPos offset = BlockPos.m_274446_((Position)mc.f_91074_.m_20156_().m_82541_().m_82490_((double)radius));
        BlockPos origin = mc.f_91074_.m_20183_().m_121955_((Vec3i)offset);
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos target = origin.m_7918_(x, y, z);
                    BlockState state = mc.f_91073_.m_8055_(target);
                    if ((!searchOffhand || state.m_60734_() != ((BlockItem)offhand.m_41720_()).m_40614_()) && (searchOffhand || !(state.m_60734_() instanceof DropExperienceBlock) && !MATags.isBlockIn(state.m_60734_(), oredict_ores))) continue;
                    LevelRenderer.m_109646_((PoseStack)matrixStack, (VertexConsumer)buffers.m_6299_(MARenderTypes.MARKING_RUNE_MARK), (AABB)new AABB(target), (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onRenderOverlay(RenderBlockScreenEffectEvent event) {
        if (event.getBlockState().m_60734_() == Blocks.f_50083_) {
            Entity ridingEntity = event.getPlayer().m_20202_();
            if (ridingEntity != null && ridingEntity instanceof BubbleBoat && ((BubbleBoat)ridingEntity).isBrimstone()) {
                event.setCanceled(true);
            } else if (event.getPlayer().m_6844_(EquipmentSlot.HEAD).m_41720_() == ItemInit.BRIMSTONE_BOAT.get()) {
                event.setCanceled(true);
            } else if (CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)event.getPlayer(), (Item)ItemInit.EMBERGLOW_BRACELET.get()).isPresent()) {
                event.setCanceled(true);
            } else if (((DemonArmorItem)ItemInit.DEMON_ARMOR_CHEST.get()).isSetEquipped((LivingEntity)event.getPlayer())) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onInventoryGuiInit(ScreenEvent.Init.Post evt) {
        Screen screen = evt.getScreen();
        if (screen instanceof InventoryScreen || screen instanceof CreativeModeInventoryScreen) {
            boolean isCreative = screen instanceof CreativeModeInventoryScreen;
            Tuple<Integer, Integer> offsets = PlayerInventoryButton.getOffsets(isCreative);
            int x = (Integer)offsets.m_14418_();
            int y = (Integer)offsets.m_14419_();
            int textureOffsetX = 6;
            AbstractContainerScreen gui = (AbstractContainerScreen)screen;
            if (HUDOverlayRenderer.instance.getPinnedrecipe() != null || HUDOverlayRenderer.instance.getConstructDisplay().isValid()) {
                evt.addListener((GuiEventListener)new PlayerInventoryButton(gui, gui.getGuiLeft() + x, gui.f_96544_ / 2 + y, 5, 10, textureOffsetX, 27, 10, GuiTextures.Widgets.WIDGETS, button -> {
                    HUDOverlayRenderer.instance.setPinnedRecipe(null);
                    if (HUDOverlayRenderer.instance.getTrackedConstruct() != null) {
                        HUDOverlayRenderer.instance.getTrackedConstruct().setRequestingDiagnostics(false);
                        HUDOverlayRenderer.instance.setTrackedConstruct(null);
                    }
                    button.f_93623_ = false;
                    button.f_93624_ = false;
                }, (Component)Component.m_237115_((String)"gui.mna.clear_pinned_prompt")));
            }
            if (MultiblockRenderer.hasMultiblock) {
                evt.addListener((GuiEventListener)new PlayerInventoryButton(gui, gui.getGuiLeft() + x, gui.f_96544_ / 2 + y + 10, 5, 5, textureOffsetX, 47, 5, GuiTextures.Widgets.WIDGETS, button -> MultiblockRenderer.setMultiblock(null, null, true), (Component)Component.m_237115_((String)"gui.mna.clear_multiblock_prompt")));
                evt.addListener((GuiEventListener)new PlayerInventoryButton(gui, gui.getGuiLeft() + x, gui.f_96544_ / 2 + y + 20, 5, 5, textureOffsetX, 57, 5, GuiTextures.Widgets.WIDGETS, button -> MultiblockRenderer.toggleLowestLayerMode(), (Component)Component.m_237115_((String)"gui.mna.multiblock_mode_prompt")));
            }
        }
    }

    @SubscribeEvent
    public static void onFogRenderEvent(ViewportEvent.RenderFog event) {
        Minecraft mc;
        if (event.getCamera().m_167685_() == FogType.LAVA) {
            mc = Minecraft.m_91087_();
            if (((DemonArmorItem)ItemInit.DEMON_ARMOR_CHEST.get()).isSetEquipped((LivingEntity)mc.f_91074_) || CuriosInterop.IsItemInCurioSlot((Item)ItemInit.EMBERGLOW_BRACELET.get(), (LivingEntity)mc.f_91074_, SlotTypePreset.BRACELET)) {
                event.setNearPlaneDistance(-8.0f);
                event.setFarPlaneDistance(192.0f);
                event.setCanceled(true);
            }
        }
        if (event.getCamera().m_167685_() == FogType.WATER) {
            mc = Minecraft.m_91087_();
            mc.f_91074_.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> {
                if (p.getAlliedFaction() == Factions.UNDEAD) {
                    event.setNearPlaneDistance(-8.0f);
                    event.setFarPlaneDistance(192.0f);
                    event.setCanceled(true);
                }
            });
        }
        if (fogAmount > 0.0f) {
            float f1 = Mth.m_14179_((float)Math.min(1.0f, fogAmount), (float)event.getFarPlaneDistance(), (float)5.0f);
            float f2 = 0.0f;
            float f3 = f1 * 0.8f;
            RenderSystem.setShaderFogStart((float)f2);
            RenderSystem.setShaderFogEnd((float)f3);
        }
    }

    @SubscribeEvent
    public static void onFogColor(ViewportEvent.ComputeFogColor event) {
        if (fogAmount > 0.0f) {
            event.setRed(fogColor[0]);
            event.setGreen(fogColor[1]);
            event.setBlue(fogColor[2]);
        }
    }

    @SubscribeEvent
    public static void onTooltipRender(ItemTooltipEvent event) {
        Level world = ManaAndArtifice.instance.proxy.getClientWorld();
        if (world != null) {
            IRelic relic;
            Item c;
            Item item = event.getItemStack().m_41720_();
            if (item instanceof IRelic && (c = (relic = (IRelic)item).getHoverAddition(event.getItemStack(), world, event.getToolTip(), event.getFlags())) != null) {
                event.getToolTip().add(1, c);
            }
            if ((c = event.getItemStack().m_41720_()) instanceof ITieredItem) {
                ITieredItem item2 = (ITieredItem)c;
                if (event.getItemStack().m_41782_() && event.getItemStack().m_41783_().m_128441_("hideTier")) {
                    return;
                }
                int tier = item2.getTier(world, event.getItemStack());
                if (tier == -2) {
                    event.getToolTip().add(Component.m_237115_((String)"gui.mna.item-tier.none").m_130940_(ChatFormatting.GREEN));
                } else {
                    MutableBoolean metTier = new MutableBoolean(false);
                    if (tier > 0) {
                        Player clientPlayer = ManaAndArtifice.instance.proxy.getClientPlayer();
                        if (clientPlayer != null) {
                            clientPlayer.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> {
                                if (p.getTier() >= tier) {
                                    metTier.setTrue();
                                }
                            });
                        }
                        event.getToolTip().add(Component.m_237110_((String)"gui.mna.item-tier", (Object[])new Object[]{tier}).m_130940_(metTier.getValue() != false ? ChatFormatting.GREEN : ChatFormatting.RED));
                    } else {
                        event.getToolTip().add(Component.m_237115_((String)"gui.mna.item-tier.none").m_130940_(ChatFormatting.GREEN));
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onRecipesUpdated(RecipesUpdatedEvent event) {
        ItemInit.ITEMS.getEntries().forEach(i -> {
            Item item = (Item)i.get();
            if (item instanceof ITieredItem) {
                ITieredItem tiered = (ITieredItem)item;
                tiered.setCachedTier(tiered.resolveTier(ManaAndArtifice.instance.proxy.getClientWorld(), new ItemStack((ItemLike)item)));
            }
        });
    }

    static {
        slotKeysWereDown = new boolean[]{false, false, false, false, false, false, false, false, false, false};
        shiftPressed = false;
        fogAmount = 0.0f;
        fogDecay = 0.01f;
        decrementFog = 0;
        fogColor = new float[]{1.0f, 1.0f, 1.0f};
        spaceTapTimer = 0L;
        lastTickJump = false;
        cachedRenderEntity = null;
        oredict_ores = new ResourceLocation("forge", "ores");
    }
}

