/*
 * Decompiled with CFR 0.152.
 */
package com.mna.events.delayed;

import com.mna.api.timing.IDelayedEvent;
import com.mna.tools.TeleportHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.phys.Vec3;

public class DelayedDimensionTeleportEvent
implements IDelayedEvent {
    final LivingEntity target;
    final ServerLevel origin;
    final ServerLevel destination;

    public DelayedDimensionTeleportEvent(LivingEntity entity, ServerLevel origin, ServerLevel destination) {
        this.origin = origin;
        this.destination = destination;
        this.target = entity;
    }

    @Override
    public boolean tick() {
        this.teleportOnSchedule();
        return true;
    }

    @Override
    public String getID() {
        return "";
    }

    private void teleportOnSchedule() {
        Vec3 targetPosition = this.calculateDimensionDifferencePosition(this.target.m_20182_(), this.origin, this.destination);
        TeleportHelper.teleportEntity((Entity)this.target, (ResourceKey<Level>)this.destination.m_46472_(), targetPosition);
    }

    protected Vec3 calculateDimensionDifferencePosition(Vec3 origin, ServerLevel from, ServerLevel to) {
        WorldBorder worldborder = to.m_6857_();
        double minX = Math.max(-2.9999872E7, worldborder.m_61955_() + 16.0);
        double minZ = Math.max(-2.9999872E7, worldborder.m_61956_() + 16.0);
        double maxX = Math.min(2.9999872E7, worldborder.m_61957_() - 16.0);
        double maxZ = Math.min(2.9999872E7, worldborder.m_61958_() - 16.0);
        double scale = DimensionType.m_63908_((DimensionType)from.m_6042_(), (DimensionType)to.m_6042_());
        BlockPos scaledPos = BlockPos.m_274561_((double)Mth.m_14008_((double)(origin.f_82479_ * scale), (double)minX, (double)maxX), (double)Mth.m_14008_((double)origin.f_82480_, (double)5.0, (double)(to.m_151558_() - 2)), (double)Mth.m_14008_((double)(origin.f_82481_ * scale), (double)minZ, (double)maxZ));
        BlockPos searchPos = new BlockPos((Vec3i)scaledPos);
        int MIN_Y = 4;
        if (searchPos.m_123342_() >= to.m_6042_().f_63865_()) {
            int delta = to.m_6042_().f_63865_() - 3 - searchPos.m_123342_();
            searchPos = searchPos.m_7918_(0, delta, 0);
        }
        while (searchPos.m_123342_() > MIN_Y && !to.m_46859_(searchPos) && !to.m_46859_(searchPos.m_7494_())) {
            searchPos = searchPos.m_7495_();
        }
        while (searchPos.m_123342_() > MIN_Y && to.m_46859_(searchPos.m_7495_())) {
            searchPos = searchPos.m_7495_();
        }
        while (searchPos.m_123342_() < to.m_141928_() - 3 && !to.m_46859_(searchPos) && !to.m_46859_(searchPos.m_7494_())) {
            searchPos = searchPos.m_7494_();
        }
        if (!to.m_46859_(searchPos) && !to.m_46859_(searchPos.m_7494_())) {
            searchPos.m_7918_(0, to.m_141928_() - searchPos.m_123342_(), 0);
        }
        scaledPos = searchPos;
        return new Vec3((double)scaledPos.m_123341_() + 0.5, (double)scaledPos.m_123342_(), (double)scaledPos.m_123343_() + 0.5);
    }
}

