/*
 * Decompiled with CFR 0.152.
 */
package com.mna.gui.constructs;

import com.mna.api.entities.construct.ConstructCapability;
import com.mna.api.entities.construct.IConstructConstruction;
import com.mna.entities.attributes.AttributeInit;
import com.mna.entities.constructs.animated.Construct;
import com.mna.gui.GuiTextures;
import com.mna.gui.HUDOverlayRenderer;
import com.mna.gui.widgets.entity.ConstructDiagnosticsDisplay;
import com.mna.network.ClientMessageDispatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.registries.ForgeRegistries;

public class GuiConstructDiagnostics
extends Screen {
    private Construct eac;
    private static final int WHITE = FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255);
    private List<Component> tooltip = null;
    private int curMouseX = 0;
    private int curMouseY = 0;
    private int hoveredSlot = -1;

    public GuiConstructDiagnostics(Construct eac) {
        super((Component)Component.m_237113_((String)""));
        this.eac = eac;
        eac.setRequestingDiagnostics(true);
        this.tooltip = new ArrayList<Component>();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.m_169394_((Renderable)new ConstructDiagnosticsDisplay(this.f_96541_.f_91080_.f_96543_ / 2 - 128, this.f_96541_.f_91080_.f_96544_ / 2 - 128, this.eac));
        this.m_142416_((GuiEventListener)new ImageButton(this.f_96541_.f_91080_.f_96543_ / 2 + 1, this.f_96541_.f_91080_.f_96544_ / 2 - 128, 14, 14, 24, 216, 14, GuiTextures.Entities.CONSTRUCT_DIAGNOSTICS, 256, 256, button -> {
            if (HUDOverlayRenderer.instance.getConstructDisplay().isValid()) {
                HUDOverlayRenderer.instance.setTrackedConstruct(null);
            } else {
                HUDOverlayRenderer.instance.setTrackedConstruct(this.eac);
            }
        }));
    }

    public void m_7861_() {
        super.m_7861_();
        if (HUDOverlayRenderer.instance.getTrackedConstruct() != this.eac) {
            this.eac.setRequestingDiagnostics(false);
        }
    }

    public void m_88315_(GuiGraphics pGuiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.tooltip.clear();
        this.hoveredSlot = -1;
        this.curMouseX = mouseX;
        this.curMouseY = mouseY;
        this.m_280273_(pGuiGraphics);
        int cX = this.f_96541_.f_91080_.f_96543_ / 2 - 128;
        int cY = this.f_96541_.f_91080_.f_96544_ / 2 - 128;
        pGuiGraphics.m_280218_(GuiTextures.Entities.CONSTRUCT_DIAGNOSTICS, cX, cY, 0, 0, 256, 215);
        int yPos = 0;
        int xPos = 0;
        int step = 0;
        if (this.eac.m_6084_()) {
            IConstructConstruction data = this.eac.getConstructData();
            xPos = cX + 151;
            yPos = cY + 118;
            step = 13;
            for (ConstructCapability cap : data.getEnabledCapabilities()) {
                this.renderCapabilityIcon(pGuiGraphics, xPos, yPos, cap);
                if ((xPos += step) <= cX + 242) continue;
                xPos = cX + 151;
                yPos += step;
            }
            Fluid stored = this.eac.getStoredFluid();
            MutableComponent storedFluid = Component.m_237115_((String)"");
            if (stored != null) {
                storedFluid = Component.m_237115_((String)ForgeRegistries.FLUIDS.getKey((Object)this.eac.getStoredFluid()).toString());
            }
            this.renderStatText(pGuiGraphics, cX + 165, cY + 6, (Component)Component.m_237113_((String)String.format("%.1f", Float.valueOf(this.eac.m_21223_()))), (Component)Component.m_237115_((String)"gui.mna.construct.health"));
            this.renderStatText(pGuiGraphics, cX + 165, cY + 19, (Component)Component.m_237113_((String)String.format("%d", (int)this.eac.m_21051_((Attribute)AttributeInit.INTELLIGENCE.get()).m_22135_())), (Component)Component.m_237115_((String)"gui.mna.construct.intelligence"));
            this.renderStatText(pGuiGraphics, cX + 165, cY + 32, (Component)Component.m_237113_((String)String.format("%.1f", Float.valueOf((float)this.eac.m_21051_((Attribute)AttributeInit.PERCEPTION_DISTANCE.get()).m_22135_()))), (Component)Component.m_237115_((String)"gui.mna.construct.perception"));
            this.renderStatText(pGuiGraphics, cX + 165, cY + 45, (Component)Component.m_237113_((String)String.format("%.1f", Float.valueOf((float)this.eac.m_21051_(Attributes.f_22283_).m_22135_()))), (Component)Component.m_237115_((String)"gui.mna.construct.attack_speed"));
            this.renderStatText(pGuiGraphics, cX + 165, cY + 58, (Component)Component.m_237113_((String)String.format("%.1f", Float.valueOf((float)this.eac.m_21051_(Attributes.f_22281_).m_22135_()))), (Component)Component.m_237115_((String)"gui.mna.construct.damage"));
            this.renderStatText(pGuiGraphics, cX + 165, cY + 71, (Component)Component.m_237113_((String)String.format("%.1f", Float.valueOf((float)this.eac.m_21051_((Attribute)AttributeInit.RANGED_DAMAGE.get()).m_22135_()))), (Component)Component.m_237115_((String)"gui.mna.construct.ranged_damage"));
            this.renderStatText(pGuiGraphics, cX + 165, cY + 84, (Component)Component.m_237113_((String)String.format("%.1f", Float.valueOf((float)this.eac.m_21051_(Attributes.f_22282_).m_22135_()))), (Component)Component.m_237115_((String)"gui.mna.construct.knockback"));
            this.renderStatText(pGuiGraphics, cX + 165, cY + 97, (Component)Component.m_237113_((String)String.format("%.1f", Float.valueOf(this.eac.getBuoyancy()))), (Component)Component.m_237115_((String)"gui.mna.construct.buoyancy"));
            this.renderStatText(pGuiGraphics, cX + 217, cY + 6, (Component)Component.m_237113_((String)String.format("%.1f", Float.valueOf((float)this.eac.m_21051_(Attributes.f_22279_).m_22135_() * 10.0f))), (Component)Component.m_237115_((String)"gui.mna.construct.move_speed"));
            this.renderStatText(pGuiGraphics, cX + 217, cY + 19, (Component)Component.m_237113_((String)String.format("%d", (int)this.eac.m_21051_(Attributes.f_22284_).m_22135_())), (Component)Component.m_237115_((String)"gui.mna.construct.armor"));
            this.renderStatText(pGuiGraphics, cX + 217, cY + 32, (Component)Component.m_237113_((String)String.format("%.1f", Float.valueOf((float)this.eac.m_21051_(Attributes.f_22285_).m_22135_()))), (Component)Component.m_237115_((String)"gui.mna.construct.toughness"));
            this.renderStatText(pGuiGraphics, cX + 217, cY + 45, (Component)Component.m_237113_((String)String.format("%.1f", Float.valueOf(data.calculateExplosionResistance()))), (Component)Component.m_237115_((String)"gui.mna.construct.explosion_resist"));
            this.renderStatText(pGuiGraphics, cX + 217, cY + 58, (Component)Component.m_237113_((String)String.format("%.1f", Float.valueOf((float)this.eac.m_21051_(Attributes.f_22278_).m_22135_()))), (Component)Component.m_237115_((String)"gui.mna.construct.knockback_resist"));
            this.renderStatText(pGuiGraphics, cX + 217, cY + 71, (Component)Component.m_237113_((String)String.format("%d", this.eac.getSlots())), (Component)Component.m_237115_((String)"gui.mna.construct.inventory_slots"));
            this.renderStatText(pGuiGraphics, cX + 217, cY + 84, (Component)Component.m_237113_((String)String.format("%d", this.eac.getStoredFluidAmount())), (Component)Component.m_237110_((String)"gui.mna.construct.stored_fluid_amount", (Object[])new Object[]{storedFluid.getString(), this.eac.getTankCapacity(0)}));
            this.renderStatText(pGuiGraphics, cX + 217, cY + 97, (Component)Component.m_237113_((String)String.format("%d", (int)this.eac.getMana())), (Component)Component.m_237110_((String)"gui.mna.construct.mana", (Object[])new Object[]{(int)this.eac.getMaxMana()}));
            this.renderItem(pGuiGraphics, cX + 152, cY + 168, 0, this.eac.m_21205_());
            this.renderItem(pGuiGraphics, cX + 234, cY + 168, 1, this.eac.m_21206_());
            this.renderItem(pGuiGraphics, cX + 152, cY + 186, 2, this.eac.getConstructData().getHat());
            this.renderItem(pGuiGraphics, cX + 234, cY + 186, 3, this.eac.getConstructData().getBanner());
            if (this.eac.getSlots() > 0) {
                step = 18;
                for (int i = 0; i < 9 && i < this.eac.getSlots(); ++i) {
                    this.renderItem(pGuiGraphics, cX + 175 + step * (i % 3), cY + 150 + (int)((double)step * Math.floor(i / 3)), i + 4, this.eac.getStackInSlot(i));
                }
                MutableComponent text = Component.m_237113_((String)String.format("%d", this.eac.getSlotLimit(0)));
                int iconWidth = 14;
                int width = this.f_96547_.m_92852_((FormattedText)text) + iconWidth;
                xPos = cX + 201 - width / 2;
                pGuiGraphics.m_280218_(GuiTextures.Entities.CONSTRUCT_DIAGNOSTICS, xPos, cY + 206, ((Integer)ConstructCapability.ITEM_STORAGE.getIconCoords().getFirst()).intValue(), ((Integer)ConstructCapability.ITEM_STORAGE.getIconCoords().getSecond()).intValue(), 11, 11);
                this.renderStatText(pGuiGraphics, xPos + iconWidth, cY + 206, (Component)text, (Component)Component.m_237113_((String)"Storage capacity of each slot in the construct's backpack."));
            }
        }
        super.m_88315_(pGuiGraphics, mouseX, mouseY, partialTicks);
        if (this.tooltip != null) {
            ArrayList split = new ArrayList();
            this.tooltip.forEach(line -> split.addAll(this.f_96547_.m_92923_((FormattedText)line, 128)));
            pGuiGraphics.m_280245_(this.f_96547_, split, mouseX, mouseY);
        }
    }

    private void renderStatText(GuiGraphics pGuiGraphics, int x, int y, Component c, Component tooltip) {
        int width = this.f_96547_.m_92852_((FormattedText)c);
        int iconPadding = 16;
        Objects.requireNonNull(this.f_96547_);
        if (this.isCursorWithin(x - iconPadding, y, width + iconPadding, 9)) {
            this.tooltip.add(tooltip);
        }
        pGuiGraphics.m_280614_(this.f_96547_, c, x, y, WHITE, false);
    }

    private void renderCapabilityIcon(GuiGraphics pGuiGraphics, int x, int y, ConstructCapability cap) {
        int size = 11;
        if (this.isCursorWithin(x, y, size, size)) {
            this.tooltip.add((Component)Component.m_237115_((String)("gui.mna.construct." + cap.name().toLowerCase())));
        }
        pGuiGraphics.m_280218_(GuiTextures.Entities.CONSTRUCT_DIAGNOSTICS, x, y, ((Integer)cap.getIconCoords().getFirst()).intValue(), ((Integer)cap.getIconCoords().getSecond()).intValue(), size, size);
    }

    private void renderItem(GuiGraphics pGuiGraphics, int x, int y, int index, ItemStack stack) {
        if (stack.m_41619_()) {
            return;
        }
        int size = 18;
        if (this.isCursorWithin(x, y, size, size)) {
            this.tooltip.addAll(stack.m_41651_((Player)this.f_96541_.f_91074_, (TooltipFlag)TooltipFlag.Default.f_256752_));
            this.hoveredSlot = index;
        }
        pGuiGraphics.m_280480_(stack, x, y);
        pGuiGraphics.m_280370_(this.f_96547_, stack, x, y);
    }

    private boolean isCursorWithin(int x, int y, int width, int height) {
        return this.curMouseX > x && this.curMouseX < x + width && this.curMouseY > y && this.curMouseY < y + height;
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.hoveredSlot > -1) {
            ClientMessageDispatcher.sendAnimatedConstructDropItemMessage(this.eac, this.hoveredSlot);
        }
        return super.m_6375_(mouseX, mouseY, button);
    }
}

