/*
 * Decompiled with CFR 0.152.
 */
package com.mna.gui.item;

import com.mna.ManaAndArtifice;
import com.mna.Registries;
import com.mna.api.capabilities.IPlayerProgression;
import com.mna.api.capabilities.IPlayerRoteSpells;
import com.mna.api.sound.SFX;
import com.mna.api.spells.attributes.Attribute;
import com.mna.api.spells.attributes.AttributeValuePair;
import com.mna.api.spells.base.IModifiable;
import com.mna.api.spells.base.ISpellComponent;
import com.mna.api.spells.parts.Modifier;
import com.mna.api.spells.parts.Shape;
import com.mna.api.spells.parts.SpellEffect;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.mna.capabilities.playerdata.rote.PlayerRoteSpellsProvider;
import com.mna.gui.GuiTextures;
import com.mna.gui.base.SearchableGuiJeiDisable;
import com.mna.gui.block.GuiInscriptionTable;
import com.mna.gui.containers.item.ContainerRoteBook;
import com.mna.gui.widgets.AttributeButton;
import com.mna.gui.widgets.BorderedImageButton;
import com.mna.gui.widgets.ImageButtonWithAlphaBlend;
import com.mna.gui.widgets.RGBPicker;
import com.mna.gui.widgets.SpellPartList;
import com.mna.items.ItemInit;
import com.mna.items.SpellIconList;
import com.mna.items.sorcery.ItemSpell;
import com.mna.network.ClientMessageDispatcher;
import com.mna.tools.DidYouKnowHelper;
import com.mojang.datafixers.util.Pair;
import java.awt.Point;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class GuiRoteBook
extends SearchableGuiJeiDisable<ContainerRoteBook> {
    private static final int MAX_COMPONENTS = 5;
    ImageButton[] pieceWidgets;
    ImageButton activeShapeButton;
    ImageButton[] activeComponentButtons;
    ArrayList<ImageButton> shapeAttributeButtons;
    HashMap<Integer, ArrayList<ImageButton>> componentAttributeButtons;
    ArrayList<ImageButton> inactiveCategoryButtons;
    ArrayList<ImageButton> activeCategoryButtons;
    private SpellPartList list;
    private Button nameAndIcon;
    final float textScaleFactor = 0.5f;
    static final int textColor = FastColor.ARGB32.m_13660_((int)255, (int)49, (int)49, (int)49);
    static final int textColorLight = FastColor.ARGB32.m_13660_((int)255, (int)200, (int)200, (int)200);
    final int colWidth = 38;
    final int rowHeight = 13;
    final int texSize = 32;
    final List<Component> currentTooltip;
    IPlayerRoteSpells playerRote = null;
    IPlayerProgression playerProgression = null;
    private boolean namingSpell = true;
    private int page = 0;
    private int numPages = 0;
    private int hoveredIndex;
    EditBox nameBox;
    Component nameValue;
    ModelButton currentButton;
    RGBPicker colors;
    private static ArrayList<Pair<Integer, Integer>> pipLocations = new ArrayList();
    ArrayList<ModelButton> iconButtons;
    private Button prev;
    private Button next;
    private Button clear;

    public GuiRoteBook(ContainerRoteBook screenContainer, Inventory inv, Component titleIn) {
        super(screenContainer, inv, titleIn);
        this.f_97726_ = 256;
        this.f_97727_ = 256;
        this.activeComponentButtons = new ImageButton[5];
        this.inactiveCategoryButtons = new ArrayList();
        this.activeCategoryButtons = new ArrayList();
        this.iconButtons = new ArrayList();
        this.numPages = (int)Math.floor((float)SpellIconList.ALL.length / 100.0f);
        this.currentTooltip = new ArrayList<Component>();
    }

    public void addTooltipLine(Component comp) {
        this.currentTooltip.add(comp);
    }

    public boolean m_6050_(double p_mouseScrolled_1_, double p_mouseScrolled_3_, double p_mouseScrolled_5_) {
        return this.list.m_6050_(p_mouseScrolled_1_, p_mouseScrolled_3_, p_mouseScrolled_5_);
    }

    protected void m_7856_() {
        this.m_169413_();
        this.activeCategoryButtons.clear();
        this.inactiveCategoryButtons.clear();
        super.m_7856_();
        this.initSpellIcons();
        int tbWidth = 130;
        int x = this.f_97735_ + this.f_97726_ / 2 - tbWidth / 2;
        int y = this.f_97736_ + this.f_97727_ - 95;
        this.initSearch(this.f_97735_ + 6, this.f_97736_ + 185, 59, 18);
        this.playerRote = (IPlayerRoteSpells)this.f_96541_.f_91074_.getCapability(PlayerRoteSpellsProvider.ROTE).orElse(null);
        this.playerProgression = (IPlayerProgression)this.f_96541_.f_91074_.getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
        this.nameAndIcon = (Button)this.m_142416_((GuiEventListener)new ImageButton(this.f_97735_ + 228, this.f_97736_ + 12, 16, 16, 228, 12, 0, GuiTextures.Items.BOOK_OF_ROTE, 256, 256, button -> this.toggleNaming()));
        this.list = new SpellPartList(false, true, this.f_97735_, this.f_97736_, 66, 190, 117, 57, s -> this.OnShapeClicked((Shape)s), c -> this.OnComponentClicked((SpellEffect)c), m -> {}, tt -> this.currentTooltip.add((Component)tt));
        this.m_7787_((GuiEventListener)this.list);
        this.shapeAttributeButtons = new ArrayList();
        this.componentAttributeButtons = new HashMap();
        for (int i = 0; i < 5; ++i) {
            this.componentAttributeButtons.put(i, new ArrayList());
        }
        int sliderX = this.f_97735_ - 35;
        this.colors = new RGBPicker(sliderX, this.f_97736_ + 211, this::adjustSpellColors);
        this.m_142416_((GuiEventListener)this.colors);
        this.mapUIToCurrentSpell();
        x = this.f_97735_ + 256;
        y = this.f_97736_ + 6;
        for (int i = 0; i < ((ContainerRoteBook)this.f_97732_).getSize(); ++i) {
            int idx = i;
            if (i < 8) {
                this.inactiveCategoryButtons.add((ImageButton)this.m_142416_((GuiEventListener)new IndexButton(x, y, 37, 22, 0, 0, 22, GuiTextures.Items.BOOK_OF_ROTE_EXTRAS, 256, 256, btn -> {
                    this.setActiveIndex(idx);
                    ((ContainerRoteBook)this.f_97732_).changeIndex(idx);
                    ItemSpell.setCustomIcon(this.currentButton.icon, ((ContainerRoteBook)this.f_97732_).getIconIndex());
                    this.mapUIToCurrentSpell();
                }, i + 1, false)));
                this.activeCategoryButtons.add((ImageButton)this.m_142416_((GuiEventListener)new IndexButton(x, y, 37, 22, 0, 44, 22, GuiTextures.Items.BOOK_OF_ROTE_EXTRAS, 256, 256, btn -> {}, i + 1, true)));
            } else {
                this.inactiveCategoryButtons.add((ImageButton)this.m_142416_((GuiEventListener)new IndexButton(x, y, 37, 22, 37, 0, 22, GuiTextures.Items.BOOK_OF_ROTE_EXTRAS, 256, 256, btn -> {
                    this.setActiveIndex(idx);
                    ((ContainerRoteBook)this.f_97732_).changeIndex(idx);
                    ItemSpell.setCustomIcon(this.currentButton.icon, ((ContainerRoteBook)this.f_97732_).getIconIndex());
                    this.mapUIToCurrentSpell();
                }, i + 1, false)));
                this.activeCategoryButtons.add((ImageButton)this.m_142416_((GuiEventListener)new IndexButton(x, y, 37, 22, 37, 44, 22, GuiTextures.Items.BOOK_OF_ROTE_EXTRAS, 256, 256, btn -> {}, i + 1, true)));
            }
            y += 22;
            if (i != 7) continue;
            x = this.f_97735_ - 37;
            y = this.f_97736_ + 6;
        }
        this.setActiveIndex(((ContainerRoteBook)this.f_97732_).getActiveIndex());
        this.namingSpell = true;
        this.toggleNaming();
    }

    private void initSpellIcons() {
        int nameWidth = 218;
        int nameHeight = 256;
        int i = this.f_97735_ + this.f_97726_ / 2 - nameWidth / 2;
        int j = this.f_97736_ + this.f_97727_ / 2 - nameHeight / 2;
        this.currentButton = new ModelButton(this.f_97735_ + 12, j + 12, -1, btn -> {});
        this.m_142416_((GuiEventListener)this.currentButton);
        this.nameBox = new EditBox(this.f_96541_.f_91062_, i + nameWidth / 2 - 80, j + 10, 160, 20, this.nameValue);
        this.nameBox.m_94144_(((ContainerRoteBook)this.f_97732_).getName());
        this.nameBox.m_94199_(60);
        this.nameBox.m_94151_(this::nameChanged);
        this.m_142416_((GuiEventListener)this.nameBox);
        this.nameBox.m_94190_(false);
        this.nameBox.m_93692_(true);
        this.m_7522_((GuiEventListener)this.nameBox);
        this.page = 0;
        this.clear = (Button)this.m_142416_((GuiEventListener)new ImageButton(this.f_97735_ + this.f_97726_ - 28, this.f_97736_ + 12, 15, 18, 222, 7, 0, GuiTextures.Items.SPELL_CUSTOMIZE, 256, 256, button -> this.toggleNaming()));
        this.prev = (Button)this.m_142416_((GuiEventListener)new ImageButton(this.f_97735_ + 9, this.f_97736_ + this.f_97727_ - 18, 9, 14, 247, 31, 14, GuiTextures.Items.SPELL_CUSTOMIZE, 256, 256, button -> {
            --this.page;
            if (this.page <= 0) {
                this.page = 0;
                this.prev.f_93623_ = false;
            }
            this.next.f_93623_ = true;
            this.initIconButtons();
            this.m_7522_((GuiEventListener)this.nameBox);
        }));
        this.next = (Button)this.m_142416_((GuiEventListener)new ImageButton(this.f_97735_ + this.f_97726_ - 17, this.f_97736_ + this.f_97727_ - 18, 9, 14, 247, 60, 14, GuiTextures.Items.SPELL_CUSTOMIZE, 256, 256, button -> {
            ++this.page;
            if (this.page >= this.numPages) {
                this.page = this.numPages;
                this.next.f_93623_ = false;
            }
            this.prev.f_93623_ = true;
            this.initIconButtons();
            this.m_7522_((GuiEventListener)this.nameBox);
        }));
        this.prev.f_93623_ = false;
        i += 3;
        j += 20;
        this.initIconButtons();
    }

    @Override
    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            if (this.namingSpell) {
                this.toggleNaming();
            } else {
                this.m_7379_();
            }
            return true;
        }
        if (this.nameBox.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        return this.nameBox.m_93696_() && this.nameBox.m_94213_() && keyCode != 256 ? true : super.m_7933_(keyCode, scanCode, modifiers);
    }

    private void adjustSpellColors(Integer[] argb) {
        ((ContainerRoteBook)this.f_97732_).setCurColor(FastColor.ARGB32.m_13660_((int)argb[3], (int)argb[0], (int)argb[1], (int)argb[2]));
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        super.m_6375_(mouseX, mouseY, button);
        if (this.namingSpell) {
            this.m_7522_((GuiEventListener)this.nameBox);
            if (button == 1 && this.nameBox.m_5953_(mouseX, mouseY)) {
                this.nameBox.m_94144_("");
            }
        } else if (button == 1 && this.searchBox.m_5953_(mouseX, mouseY)) {
            this.searchBox.m_94144_("");
        }
        return false;
    }

    private void toggleNaming() {
        if (!this.namingSpell) {
            this.namingSpell = true;
            this.resetActiveSpell();
            this.list._active = false;
            this.nameAndIcon.f_93623_ = false;
            this.nameAndIcon.f_93624_ = false;
            this.searchBox.f_93623_ = false;
            this.searchBox.f_93624_ = false;
            this.colors.f_93623_ = false;
            this.colors.f_93624_ = false;
            this.page = 0;
            this.prev.f_93623_ = false;
            this.prev.f_93624_ = true;
            this.next.f_93623_ = true;
            this.next.f_93624_ = true;
            this.clear.f_93623_ = true;
            this.clear.f_93624_ = true;
            for (ModelButton btn : this.iconButtons) {
                btn.f_93623_ = true;
                btn.f_93624_ = true;
            }
            this.nameBox.f_93623_ = true;
            this.nameBox.f_93624_ = true;
            if (this.activeShapeButton != null) {
                this.activeShapeButton.f_93623_ = false;
                this.activeShapeButton.f_93624_ = false;
            }
            if (this.activeComponentButtons != null) {
                for (int i = 0; i < this.activeComponentButtons.length; ++i) {
                    if (this.activeComponentButtons[i] == null) continue;
                    this.activeComponentButtons[i].f_93623_ = false;
                    this.activeComponentButtons[i].f_93624_ = false;
                }
            }
        } else {
            this.namingSpell = false;
            this.page = 0;
            this.prev.f_93623_ = false;
            this.prev.f_93624_ = false;
            this.next.f_93623_ = false;
            this.next.f_93624_ = false;
            this.clear.f_93623_ = false;
            this.clear.f_93624_ = false;
            for (ModelButton btn : this.iconButtons) {
                btn.f_93623_ = false;
                btn.f_93624_ = false;
            }
            this.nameBox.f_93623_ = false;
            this.nameBox.f_93624_ = false;
            this.nameAndIcon.f_93623_ = true;
            this.nameAndIcon.f_93624_ = true;
            this.searchBox.f_93623_ = true;
            this.searchBox.f_93624_ = true;
            this.list._active = true;
            this.colors.f_93623_ = true;
            this.colors.f_93624_ = true;
            this.mapUIToCurrentSpell();
        }
    }

    private void nameChanged(String newName) {
        ((ContainerRoteBook)this.f_97732_).setName(newName);
    }

    @Override
    protected void searchTermChanged(String newName) {
        this.currentSearchTerm = newName.toLowerCase();
        this.list.clear();
        this.list.reInit(this.currentSearchTerm);
    }

    private void initIconButtons() {
        int nameHeight = 256;
        int top = this.f_97736_ + this.f_97727_ / 2 - nameHeight / 2;
        for (ModelButton button2 : this.iconButtons) {
            this.m_169411_((GuiEventListener)button2);
        }
        this.iconButtons.clear();
        int x = this.f_97735_ + 26;
        int y = top + 45;
        int count = 1;
        for (int i = this.page * 100; i < SpellIconList.ALL.length; ++i) {
            int idx = i;
            ModelButton btn = new ModelButton(x, y, i, button -> {
                ((ContainerRoteBook)this.f_97732_).setIconIndex(idx);
                ItemSpell.setCustomIcon(this.currentButton.icon, idx);
            });
            this.m_142416_((GuiEventListener)btn);
            this.iconButtons.add(btn);
            x += 21;
            if (count % 10 == 0 && count != 0) {
                x = this.f_97735_ + 26;
                y += 21;
            }
            if (count == 100) break;
            ++count;
        }
        ItemSpell.setCustomIcon(this.currentButton.icon, ((ContainerRoteBook)this.f_97732_).getIconIndex());
    }

    private void setActiveIndex(int index) {
        if (index < 0 || index >= this.activeCategoryButtons.size()) {
            return;
        }
        this.activeCategoryButtons.forEach(b -> {
            b.f_93623_ = false;
            b.f_93624_ = false;
        });
        this.inactiveCategoryButtons.forEach(b -> {
            b.f_93623_ = true;
            b.f_93624_ = true;
        });
        this.activeCategoryButtons.get((int)index).f_93623_ = true;
        this.activeCategoryButtons.get((int)index).f_93624_ = true;
        this.inactiveCategoryButtons.get((int)index).f_93623_ = false;
        this.inactiveCategoryButtons.get((int)index).f_93624_ = false;
    }

    private void resetActiveSpell() {
        this.setupShapeAttributeButtons(null);
        if (this.activeShapeButton != null) {
            this.m_169411_((GuiEventListener)this.activeShapeButton);
        }
        for (int index : this.componentAttributeButtons.keySet()) {
            this.clearAttributeButtons(this.componentAttributeButtons.get(index));
        }
    }

    private void mapUIToCurrentSpell() {
        int i;
        this.resetActiveSpell();
        for (i = 0; i < this.activeComponentButtons.length; ++i) {
            this.m_169411_((GuiEventListener)this.activeComponentButtons[i]);
            this.activeComponentButtons[i] = null;
        }
        if (((ContainerRoteBook)this.f_97732_).getShape() != null) {
            this.setupShapeWidgetsFor(((ContainerRoteBook)this.f_97732_).getShape().getPart());
        }
        for (i = 0; i < 5; ++i) {
            if (((ContainerRoteBook)this.f_97732_).getComponent(i) == null) continue;
            this.setupComponentWidgetsFor(((ContainerRoteBook)this.f_97732_).getComponent(i).getPart(), i);
        }
        this.nameBox.m_94144_(((ContainerRoteBook)this.f_97732_).getName());
        int color = ((ContainerRoteBook)this.f_97732_).getCurColor();
        this.colors.setValue(FastColor.ARGB32.m_13665_((int)color), FastColor.ARGB32.m_13667_((int)color), FastColor.ARGB32.m_13669_((int)color), FastColor.ARGB32.m_13655_((int)color));
    }

    private void setupShapeAttributeButtons(Shape shape) {
        this.clearAttributeButtons(this.shapeAttributeButtons);
        if (shape == null) {
            return;
        }
        this.setupAttributeButtons(60, 48, this.shapeAttributeButtons, shape);
    }

    private void setupAttributeButtons(int xStart, int yStart, ArrayList<ImageButton> addTo, IModifiable<? extends ISpellComponent> modifiable) {
        int count = 0;
        for (AttributeValuePair attribute : modifiable.getModifiableAttributes()) {
            boolean attributeModifiable = false;
            for (Modifier m : Registries.Modifier.get().getValues()) {
                if (!m.modifiesType(attribute.getAttribute()) || (!this.playerRote.isRote(m) || this.playerProgression.getTier() < m.getTier(ManaAndArtifice.instance.proxy.getClientWorld())) && !this.f_96541_.f_91074_.m_7500_()) continue;
                attributeModifiable = true;
                break;
            }
            int row = (int)Math.floor(count / 2);
            int col = count % 2;
            int xOffset = xStart + 38 * col;
            int yOffset = yStart + 13 * row;
            if (attributeModifiable) {
                ImageButtonWithAlphaBlend upButton = (ImageButtonWithAlphaBlend)this.m_142416_((GuiEventListener)new ImageButtonWithAlphaBlend(this.f_97735_ + xOffset + 1, this.f_97736_ + yOffset - 3, 8, 5, 0, 48, 0, GuiTextures.WizardLab.INSCRIPTION_TABLE_WIDGETS, 128, 128, button -> {
                    ((ContainerRoteBook)this.f_97732_).increaseAttribute((Player)this.f_96541_.f_91074_, modifiable, attribute.getAttribute(), (Level)this.f_96541_.f_91073_, Screen.m_96638_());
                    GuiInscriptionTable.checkAndShowShiftTooltip();
                }));
                ImageButtonWithAlphaBlend downButton = (ImageButtonWithAlphaBlend)this.m_142416_((GuiEventListener)new ImageButtonWithAlphaBlend(this.f_97735_ + xOffset + 1, this.f_97736_ + yOffset + 2, 8, 5, 0, 53, 0, GuiTextures.WizardLab.INSCRIPTION_TABLE_WIDGETS, 128, 128, button -> {
                    ((ContainerRoteBook)this.f_97732_).decreaseAttribute((Player)this.f_96541_.f_91074_, modifiable, attribute.getAttribute(), (Level)this.f_96541_.f_91073_, Screen.m_96638_());
                    GuiInscriptionTable.checkAndShowShiftTooltip();
                }));
                addTo.add(upButton);
                addTo.add(downButton);
            }
            Point texCoord = GuiTextures.Attribute_Icon_Mappings.get((Object)attribute.getAttribute());
            int blitSize = 8;
            float scaleFactor = (float)blitSize / 52.0f;
            ImageButton iconButton = (ImageButton)this.m_142416_((GuiEventListener)new AttributeButton(this.f_97735_ + xOffset - 8, this.f_97736_ + yOffset - 2, blitSize, blitSize, (int)((float)texCoord.x * scaleFactor), (int)((float)texCoord.y * scaleFactor), 0, GuiTextures.Widgets.ATTRIBUTE_ICONS, (int)(208.0f * scaleFactor), (int)(208.0f * scaleFactor), button -> {}, new String[]{attribute.getAttribute().getLocaleKey(), ((ISpellComponent)((Object)modifiable)).getDescriptionTooltip(attribute.getAttribute())}, this::addTooltipLine));
            addTo.add(iconButton);
            ++count;
        }
    }

    private void clearAttributeButtons(ArrayList<ImageButton> attributeButtons) {
        for (ImageButton button : attributeButtons) {
            this.m_169411_((GuiEventListener)button);
        }
        attributeButtons.clear();
    }

    private void setupShapeWidgetsFor(Shape shape) {
        int texSize = 32;
        if (shape != null) {
            if (this.activeShapeButton != null) {
                this.m_169411_((GuiEventListener)this.activeShapeButton);
            }
            this.activeShapeButton = (ImageButton)this.m_142416_((GuiEventListener)new BorderedImageButton(this.f_97735_ + 13, this.f_97736_ + 47, texSize, texSize, 0, 0, 0, shape.getGuiIcon(), texSize, texSize, button -> {
                ((ContainerRoteBook)this.f_97732_).setShape(null);
                this.mapUIToCurrentSpell();
            }).setBorder(shape.isSilverSpell()));
        }
        this.setupShapeAttributeButtons(shape);
    }

    private void OnShapeClicked(Shape shape) {
        ((ContainerRoteBook)this.f_97732_).setShape(shape);
        this.mapUIToCurrentSpell();
        if (this.searchBox != null) {
            this.searchBox.m_94208_(0);
        }
    }

    private void setupComponentWidgetsFor(SpellEffect component, int index) {
        int texSize = 32;
        if (component != null) {
            if (this.activeComponentButtons[index] != null) {
                this.m_169411_((GuiEventListener)this.activeComponentButtons[index]);
            }
            AbstractMap.SimpleEntry<Integer, Integer> coords = this.getComponentRenderCoordinates(index);
            this.activeComponentButtons[index] = (ImageButton)this.m_142416_((GuiEventListener)new BorderedImageButton(coords.getKey(), coords.getValue(), 32, 32, 0, 0, 0, component.getGuiIcon(), 32, 32, button -> {
                ((ContainerRoteBook)this.f_97732_).removeComponent(index);
                this.mapUIToCurrentSpell();
            }).setBorder(component.isSilverSpell()));
        }
        this.setupComponentAttributeButtons(component, index);
    }

    private void setupComponentAttributeButtons(SpellEffect component, int index) {
        this.clearAttributeButtons(this.componentAttributeButtons.get(index));
        if (component == null) {
            return;
        }
        AbstractMap.SimpleEntry<Integer, Integer> coords = this.getComponentRenderCoordinates(index, -this.f_97735_ + 47, -this.f_97736_ + 1);
        this.setupAttributeButtons(coords.getKey(), coords.getValue(), this.componentAttributeButtons.get(index), component);
    }

    private void OnComponentClicked(SpellEffect component) {
        if (this.searchBox != null) {
            this.searchBox.m_94208_(0);
        }
        for (int i = 0; i < 5; ++i) {
            if (((ContainerRoteBook)this.f_97732_).getComponent(i) != null) continue;
            ((ContainerRoteBook)this.f_97732_).addComponent(component);
            this.mapUIToCurrentSpell();
            return;
        }
    }

    private AbstractMap.SimpleEntry<Integer, Integer> getComponentRenderCoordinates(int index) {
        return this.getComponentRenderCoordinates(index, 0, 0);
    }

    private AbstractMap.SimpleEntry<Integer, Integer> getComponentRenderCoordinates(int index, int offsetX, int offsetY) {
        int x = this.f_97735_ + 13;
        int y = this.f_97736_ + 94;
        if (index == 1 || index == 4) {
            y += 47;
        }
        if (index == 2) {
            y -= 47;
        }
        if (index > 1) {
            x += 124;
        }
        return new AbstractMap.SimpleEntry<Integer, Integer>(x + offsetX, y + offsetY);
    }

    public void m_7861_() {
        this.checkAndShowDamageStackingTip();
        super.m_7861_();
        ((ContainerRoteBook)this.f_97732_).copySpellChangesToInventory();
        ClientMessageDispatcher.sendRoteSpellsUpdate((ContainerRoteBook)this.f_97732_);
    }

    private void checkAndShowDamageStackingTip() {
        Minecraft mc = Minecraft.m_91087_();
        if (((ContainerRoteBook)this.f_97732_).countNonDelayedDamageComponents() > 1) {
            DidYouKnowHelper.CheckAndShowDidYouKnow((Player)mc.f_91074_, "helptip.mna.damage_type_stacking");
        }
    }

    @Override
    public void m_88315_(GuiGraphics pGuiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.currentTooltip.clear();
        this.hoveredIndex = -1;
        super.m_88315_(pGuiGraphics, mouseX, mouseY, partialTicks);
        if (this.currentTooltip.size() > 0) {
            pGuiGraphics.m_280677_(this.f_96547_, this.currentTooltip, Optional.empty(), mouseX, mouseY);
        }
        this.m_280072_(pGuiGraphics, mouseX, mouseY);
    }

    protected void m_280003_(GuiGraphics pGuiGraphics, int mouseX, int mouseY) {
        if (this.namingSpell) {
            return;
        }
        int xPos = 71;
        int yPos = 48;
        int count = 0;
        pGuiGraphics.m_280168_().m_85836_();
        pGuiGraphics.m_280168_().m_85841_(0.5f, 0.5f, 0.5f);
        if (((ContainerRoteBook)this.f_97732_).getShape() != null) {
            for (Attribute attribute : ((ContainerRoteBook)this.f_97732_).getShape().getContainedAttributes()) {
                int row = (int)Math.floor(count / 2);
                int col = count % 2;
                this.drawAttributeValue(pGuiGraphics, xPos + col * 38, yPos + row * 13, ((ContainerRoteBook)this.f_97732_).getShape().getValueWithoutMultipliers(attribute));
                ++count;
            }
        }
        for (int i = 0; i < 5; ++i) {
            AbstractMap.SimpleEntry<Integer, Integer> coords = this.getComponentRenderCoordinates(i, -this.f_97735_ + 58, -this.f_97736_ + 1);
            xPos = coords.getKey();
            yPos = coords.getValue();
            count = 0;
            if (((ContainerRoteBook)this.f_97732_).getComponent(i) == null) continue;
            for (Attribute attribute : ((ContainerRoteBook)this.f_97732_).getComponent(i).getContainedAttributes()) {
                int row = (int)Math.floor(count / 2);
                int col = count % 2;
                this.drawAttributeValue(pGuiGraphics, xPos + col * 38, yPos + row * 13, ((ContainerRoteBook)this.f_97732_).getComponent(i).getValueWithoutMultipliers(attribute));
                ++count;
            }
        }
        String header = I18n.m_118938_((String)"gui.mna.mana_cost", (Object[])new Object[0]) + ":";
        String manaCost = String.format("%.1f", Float.valueOf(((ContainerRoteBook)this.f_97732_).getManaCost((Player)this.f_96541_.f_91074_)));
        String complexityHeader = I18n.m_118938_((String)"gui.mna.complexity", (Object[])new Object[0]) + ":";
        String complexity = String.format("%.1f / %d", Float.valueOf(((ContainerRoteBook)this.f_97732_).getComplexity((Player)this.f_96541_.f_91074_)), this.playerProgression.getTierMaxComplexity());
        float manaCostWidth = (float)this.f_96547_.m_92895_(manaCost) * 0.5f;
        float headerWidth = (float)this.f_96547_.m_92895_(header) * 0.5f;
        float complexityHeaderWidth = (float)this.f_96547_.m_92895_(complexityHeader) * 0.5f;
        float padding = 2.0f;
        float summaryXPos = 35.0f;
        float summaryYPos = 25.0f;
        pGuiGraphics.m_280056_(this.f_96547_, complexityHeader, (int)(summaryXPos / 0.5f), (int)(summaryYPos / 0.5f), textColor, false);
        summaryXPos += complexityHeaderWidth + padding;
        if (((ContainerRoteBook)this.f_97732_).getComplexity((Player)this.f_96541_.f_91074_) <= (float)this.playerProgression.getTierMaxComplexity()) {
            pGuiGraphics.m_280056_(this.f_96547_, complexity, (int)(summaryXPos / 0.5f), (int)(summaryYPos / 0.5f), textColor, false);
        } else {
            pGuiGraphics.m_280056_(this.f_96547_, complexity, (int)(summaryXPos / 0.5f), (int)(summaryYPos / 0.5f), ChatFormatting.RED.m_126665_().intValue(), false);
        }
        summaryXPos = (float)(this.f_97726_ - 33) - headerWidth - manaCostWidth - padding;
        summaryYPos = 25.0f;
        pGuiGraphics.m_280056_(this.f_96547_, header, (int)(summaryXPos / 0.5f), (int)(summaryYPos / 0.5f), textColor, false);
        pGuiGraphics.m_280056_(this.f_96547_, manaCost, (int)((summaryXPos += headerWidth + padding) / 0.5f), (int)(summaryYPos / 0.5f), textColor, false);
        pGuiGraphics.m_280168_().m_85849_();
        MutableComponent curSpellName = Component.m_237113_((String)((ContainerRoteBook)this.f_97732_).getName());
        int curNameWidth = this.f_96547_.m_92852_((FormattedText)curSpellName);
        pGuiGraphics.m_280614_(this.f_96547_, (Component)curSpellName, this.f_97726_ / 2 - curNameWidth / 2, 12, textColor, false);
        for (int d = 0; d < 16; ++d) {
            Pair<Integer, Integer> pip = pipLocations.get(d);
            if (((ContainerRoteBook)this.f_97732_).getActiveIndex() == d) {
                pGuiGraphics.m_280163_(GuiTextures.Items.BOOK_OF_ROTE_EXTRAS, ((Integer)pip.getFirst()).intValue(), ((Integer)pip.getSecond()).intValue(), 0.0f, 126.0f, 2, 2, 256, 256);
            }
            if (this.hoveredIndex != d) continue;
            pGuiGraphics.m_280163_(GuiTextures.Items.BOOK_OF_ROTE_EXTRAS, ((Integer)pip.getFirst()).intValue(), ((Integer)pip.getSecond()).intValue(), 0.0f, 124.0f, 2, 2, 256, 256);
        }
    }

    private void drawAttributeValue(GuiGraphics pGuiGraphics, int x, int y, float value) {
        String valueString = String.format("%.1f", Float.valueOf(value));
        pGuiGraphics.m_280056_(this.f_96547_, valueString, (int)((float)x / 0.5f), (int)((float)y / 0.5f), textColor, false);
    }

    protected void m_7286_(GuiGraphics pGuiGraphics, float partialTicks, int mouseX, int mouseY) {
        this.m_280273_(pGuiGraphics);
        int i = this.f_97735_;
        int j = this.f_97736_;
        pGuiGraphics.m_280218_(GuiTextures.Items.BOOK_OF_ROTE, i, j, 0, 0, this.f_97726_, this.f_97727_);
        pGuiGraphics.m_280218_(GuiTextures.Items.BOOK_OF_ROTE, i + 54, j + 178, 54, 178, 148, 78);
        this.list.m_88315_(pGuiGraphics, mouseX, mouseY, partialTicks);
        if (this.namingSpell) {
            int bannerWidth = 246;
            int bannerHeight = 30;
            pGuiGraphics.m_280163_(GuiTextures.Items.SPELL_CUSTOMIZE, i + this.f_97726_ / 2 - bannerWidth / 2, j + 5, 0.0f, 0.0f, bannerWidth, bannerHeight, this.f_97726_, this.f_97727_);
            int iconsWidth = 219;
            int iconsHeight = 219;
            pGuiGraphics.m_280163_(GuiTextures.Items.SPELL_CUSTOMIZE, i + this.f_97726_ / 2 - iconsWidth / 2, j + 38, 0.0f, 31.0f, iconsWidth, iconsHeight, this.f_97726_, this.f_97727_);
        }
    }

    public boolean m_7979_(double p_mouseDragged_1_, double p_mouseDragged_3_, int p_mouseDragged_5_, double p_mouseDragged_6_, double p_mouseDragged_8_) {
        if (this.list.isScrolling()) {
            return this.list.m_7979_(p_mouseDragged_1_, p_mouseDragged_3_, p_mouseDragged_5_, p_mouseDragged_6_, p_mouseDragged_8_);
        }
        if (this.colors.m_7979_(p_mouseDragged_1_, p_mouseDragged_3_, p_mouseDragged_5_, p_mouseDragged_6_, p_mouseDragged_8_)) {
            return true;
        }
        return super.m_7979_(p_mouseDragged_1_, p_mouseDragged_3_, p_mouseDragged_5_, p_mouseDragged_6_, p_mouseDragged_8_);
    }

    static {
        pipLocations.add((Pair<Integer, Integer>)new Pair((Object)224, (Object)202));
        pipLocations.add((Pair<Integer, Integer>)new Pair((Object)230, (Object)203));
        pipLocations.add((Pair<Integer, Integer>)new Pair((Object)236, (Object)206));
        pipLocations.add((Pair<Integer, Integer>)new Pair((Object)239, (Object)212));
        pipLocations.add((Pair<Integer, Integer>)new Pair((Object)240, (Object)218));
        pipLocations.add((Pair<Integer, Integer>)new Pair((Object)239, (Object)224));
        pipLocations.add((Pair<Integer, Integer>)new Pair((Object)236, (Object)230));
        pipLocations.add((Pair<Integer, Integer>)new Pair((Object)230, (Object)233));
        pipLocations.add((Pair<Integer, Integer>)new Pair((Object)224, (Object)234));
        pipLocations.add((Pair<Integer, Integer>)new Pair((Object)218, (Object)233));
        pipLocations.add((Pair<Integer, Integer>)new Pair((Object)212, (Object)230));
        pipLocations.add((Pair<Integer, Integer>)new Pair((Object)209, (Object)224));
        pipLocations.add((Pair<Integer, Integer>)new Pair((Object)208, (Object)218));
        pipLocations.add((Pair<Integer, Integer>)new Pair((Object)209, (Object)212));
        pipLocations.add((Pair<Integer, Integer>)new Pair((Object)212, (Object)206));
        pipLocations.add((Pair<Integer, Integer>)new Pair((Object)218, (Object)203));
    }

    public class IndexButton
    extends ImageButton {
        boolean isActive;
        int index;

        public IndexButton(int x, int y, int width, int height, int xTexStart, int yTexStart, int hoverOffset, ResourceLocation textureFile, int texWidth, int texHeight, Button.OnPress clickHandler, int index, boolean active) {
            super(x, y, width, height, xTexStart, yTexStart, hoverOffset, textureFile, texWidth, texHeight, clickHandler, (Component)Component.m_237113_((String)""));
            this.index = index;
            this.isActive = active;
        }

        public void m_87963_(GuiGraphics pGuiGraphics, int mousex, int mousey, float partialTick) {
            super.m_87963_(pGuiGraphics, mousex, mousey, partialTick);
            if (this.f_93623_ && this.f_93624_) {
                boolean left = this.index > 8;
                ItemStack spellStack = ((ContainerRoteBook)GuiRoteBook.this.f_97732_).getStack(this.index - 1);
                pGuiGraphics.m_280480_(spellStack, left ? this.m_252754_() + 18 : this.m_252754_() + 3, this.m_252907_() + 3);
                if (this.m_198029_()) {
                    GuiRoteBook.this.hoveredIndex = this.index - 1;
                }
            }
        }

        public void m_7435_(SoundManager soundHandler) {
            soundHandler.m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SFX.Gui.PAGE_FLIP, (float)((float)(0.8 + Math.random() * 0.4))));
        }
    }

    class ModelButton
    extends Button {
        public ItemStack icon;

        public ModelButton(int x, int y, int index, Button.OnPress pressedAction) {
            super(x, y, 16, 16, (Component)Component.m_237113_((String)""), pressedAction, f_252438_);
            this.icon = new ItemStack((ItemLike)ItemInit.SPELL.get());
            ItemSpell.setCustomIcon(this.icon, index);
        }

        public void m_87963_(GuiGraphics pGuiGraphics, int mouseX, int mouseY, float partialTicks) {
            pGuiGraphics.m_280480_(this.icon, this.m_252754_(), this.m_252907_());
        }

        public void m_93692_(boolean focus) {
        }
    }
}

