/*
 * Decompiled with CFR 0.152.
 */
package com.mna.gui.widgets.entity;

import com.mna.entities.constructs.animated.Construct;
import com.mna.entities.constructs.animated.ConstructDiagnostics;
import com.mna.gui.GuiTextures;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FastColor;

public class ConstructDiagnosticsDisplay
extends AbstractWidget {
    private Construct construct;
    private LinkedList<ConstructDiagnostics.LogEntry> lastDiagnostics;
    private Font font;

    public ConstructDiagnosticsDisplay(int pX, int pY, Construct construct) {
        super(pX, pY, 142, 231, (Component)Component.m_237113_((String)""));
        this.construct = construct;
        Minecraft mc = Minecraft.m_91087_();
        this.font = mc.f_91062_;
    }

    public boolean isValid() {
        return this.construct != null;
    }

    protected void m_87963_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.construct == null) {
            return;
        }
        if (this.construct.m_6084_()) {
            this.lastDiagnostics = (LinkedList)this.construct.getDiagnostics().getMessages().clone();
        } else {
            ConstructDiagnostics.LogEntry iLoveYou = new ConstructDiagnostics.LogEntry(Component.m_237115_((String)"mna.constructs.feedback.death").getString(), null);
            ConstructDiagnostics.LogEntry lastLogLine = this.lastDiagnostics.peekLast();
            if (lastLogLine == null || !lastLogLine.equals(iLoveYou)) {
                this.lastDiagnostics.add(iLoveYou);
            }
        }
        pGuiGraphics.m_280218_(GuiTextures.Entities.CONSTRUCT_DIAGNOSTICS, this.m_252754_(), this.m_252907_(), 0, 0, 143, 207);
        int zebraCount = 0;
        int textXOffset = 16;
        int xPos = this.m_252754_();
        int yPos = this.m_252907_() + 4;
        Iterator<ConstructDiagnostics.LogEntry> diagnosticsIterator = this.lastDiagnostics.descendingIterator();
        while (diagnosticsIterator.hasNext()) {
            ConstructDiagnostics.LogEntry s = diagnosticsIterator.next();
            if (s.icon != null) {
                pGuiGraphics.m_280163_(s.icon, this.m_252754_() + 2, yPos, 0.0f, 0.0f, 16, 16, 16, 16);
            }
            for (FormattedText props : this.font.m_92865_().m_92414_((FormattedText)Component.m_237113_((String)s.message), 135 - textXOffset, Style.f_131099_)) {
                pGuiGraphics.m_280488_(this.font, props.getString(), this.m_252754_() + textXOffset + 4, yPos, zebraCount % 2 == 0 ? FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255) : FastColor.ARGB32.m_13660_((int)255, (int)100, (int)100, (int)100));
                Objects.requireNonNull(this.font);
                if ((yPos += 9) <= this.m_252907_() + 195) continue;
                break;
            }
            ++zebraCount;
            if ((yPos += 3) <= this.m_252907_() + 195) continue;
            break;
        }
        int statusIconOffset = 14;
        int taskXStep = 24;
        xPos = this.m_252754_();
        yPos = this.m_252907_() - 24;
        Iterator<ConstructDiagnostics.TaskHistoryEntry> taskHistoryIterator = this.construct.getDiagnostics().getTaskHistory().descendingIterator();
        while (taskHistoryIterator.hasNext()) {
            ConstructDiagnostics.TaskHistoryEntry e = taskHistoryIterator.next();
            pGuiGraphics.m_280218_(GuiTextures.Entities.CONSTRUCT_DIAGNOSTICS, xPos, yPos, 0, 217, 20, 20);
            if (e.getIcon() != null) {
                pGuiGraphics.m_280163_(e.getIcon(), xPos + 2, yPos + 2, 0.0f, 0.0f, 16, 16, 16, 16);
            }
            switch (e.getStatus()) {
                case SUCCESS: {
                    pGuiGraphics.m_280218_(GuiTextures.Entities.CONSTRUCT_DIAGNOSTICS, xPos + statusIconOffset, yPos + statusIconOffset, 0, 237, 8, 8);
                    break;
                }
                case FAILURE: {
                    pGuiGraphics.m_280218_(GuiTextures.Entities.CONSTRUCT_DIAGNOSTICS, xPos + statusIconOffset, yPos + statusIconOffset, 8, 237, 8, 8);
                    break;
                }
                case RUNNING: {
                    pGuiGraphics.m_280218_(GuiTextures.Entities.CONSTRUCT_DIAGNOSTICS, xPos + statusIconOffset, yPos + statusIconOffset, 16, 237, 8, 8);
                }
            }
            xPos += taskXStep;
        }
    }

    public void setConstruct(Construct construct) {
        this.construct = construct;
    }

    public Construct getConstruct() {
        return this.construct;
    }

    protected void m_168797_(NarrationElementOutput pNarrationElementOutput) {
    }
}

