/*
 * Decompiled with CFR 0.152.
 */
package com.mna.gui.widgets.lodestar;

import com.mna.ManaAndArtifice;
import com.mna.api.blocks.DirectionalPoint;
import com.mna.api.entities.construct.ai.parameter.ConstructAITaskParameter;
import com.mna.api.entities.construct.ai.parameter.ConstructTaskAreaParameter;
import com.mna.api.items.IPositionalItem;
import com.mna.gui.widgets.lodestar.LodestarParameter;
import com.mna.items.ItemInit;
import com.mna.items.runes.ItemRuneMarking;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;

public class AreaParameterInput
extends LodestarParameter<Pair<DirectionalPoint, DirectionalPoint>> {
    public static final int V = 22;
    private ItemStack markRuneA = new ItemStack((ItemLike)ItemInit.RUNE_MARKING.get());
    private ItemStack markRuneB = new ItemStack((ItemLike)ItemInit.RUNE_MARKING.get());

    public AreaParameterInput(boolean lowTier, int x, int y, Button.OnPress pressHandler, Component tooltip) {
        super(lowTier, x, y, 22, null, pressHandler, tooltip);
    }

    public AreaParameterInput(boolean lowTier, int x, int y, Pair<DirectionalPoint, DirectionalPoint> defaultValue, Button.OnPress pressHandler, Component tooltip) {
        super(lowTier, x, y, 22, defaultValue, pressHandler, tooltip);
    }

    @Override
    public void m_87963_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.m_87963_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        if (this.markRuneA.m_41782_()) {
            pGuiGraphics.m_280480_(this.markRuneA, this.m_252754_() + 19, this.m_252907_() + 3);
        }
        if (this.markRuneB.m_41782_()) {
            pGuiGraphics.m_280480_(this.markRuneB, this.m_252754_() + 37, this.m_252907_() + 3);
        }
    }

    @Override
    public void saveTo(ConstructAITaskParameter param) {
        if (param instanceof ConstructTaskAreaParameter && this.value != null) {
            ((ConstructTaskAreaParameter)param).setPoints((DirectionalPoint)((Pair)this.value).getFirst(), (DirectionalPoint)((Pair)this.value).getSecond());
        }
    }

    @Override
    public void loadFrom(ConstructAITaskParameter param) {
        if (param instanceof ConstructTaskAreaParameter) {
            this.value = ((ConstructTaskAreaParameter)param).getPoints();
            if (this.value != null) {
                if (((Pair)this.value).getFirst() != null) {
                    ((ItemRuneMarking)ItemInit.RUNE_MARKING.get()).setLocation(this.markRuneA, (DirectionalPoint)((Pair)this.value).getFirst());
                } else {
                    this.markRuneA.m_41751_(null);
                }
                if (((Pair)this.value).getSecond() != null) {
                    ((ItemRuneMarking)ItemInit.RUNE_MARKING.get()).setLocation(this.markRuneB, (DirectionalPoint)((Pair)this.value).getSecond());
                } else {
                    this.markRuneB.m_41751_(null);
                }
            }
        }
    }

    public void m_5716_(double mouseX, double mouseY) {
        ItemStack carried = this.getCursorHeldItem();
        ItemStack slotItem = this.getSlotItemFromClick(mouseX, mouseY);
        if (slotItem.m_41619_()) {
            return;
        }
        if (!carried.m_41619_() && carried.m_41720_() instanceof IPositionalItem) {
            ((ItemRuneMarking)ItemInit.RUNE_MARKING.get()).copyPositionFrom(carried, slotItem);
        } else {
            slotItem.m_41751_(null);
        }
        if (this.markRuneA.m_41782_() && this.markRuneB.m_41782_()) {
            this.setValue(new Pair((Object)((ItemRuneMarking)ItemInit.RUNE_MARKING.get()).getDirectionalPoint(this.markRuneA), (Object)((ItemRuneMarking)ItemInit.RUNE_MARKING.get()).getDirectionalPoint(this.markRuneB)));
        } else {
            DirectionalPoint a = null;
            DirectionalPoint b = null;
            if (this.markRuneA.m_41782_()) {
                a = ((ItemRuneMarking)ItemInit.RUNE_MARKING.get()).getDirectionalPoint(this.markRuneA);
            }
            if (this.markRuneB.m_41782_()) {
                b = ((ItemRuneMarking)ItemInit.RUNE_MARKING.get()).getDirectionalPoint(this.markRuneB);
            }
            this.setValue(new Pair((Object)a, b));
        }
        super.m_5716_(mouseX, mouseY);
    }

    private ItemStack getSlotItemFromClick(double mouseX, double mouseY) {
        int padding = 16;
        if (mouseX < (double)(this.m_252754_() + padding)) {
            return ItemStack.f_41583_;
        }
        if (mouseX < (double)(this.m_252754_() + padding + (this.f_93618_ - padding) / 2)) {
            return this.markRuneA;
        }
        return this.markRuneB;
    }

    @Override
    public List<Component> getTooltipItems() {
        List<Component> baseTT = super.getTooltipItems();
        baseTT.add((Component)Component.m_237113_((String)" "));
        ((ItemRuneMarking)ItemInit.RUNE_MARKING.get()).m_7373_(this.markRuneA, ManaAndArtifice.instance.proxy.getClientWorld(), baseTT, (TooltipFlag)TooltipFlag.Default.f_256752_);
        baseTT.add((Component)Component.m_237113_((String)"-------"));
        ((ItemRuneMarking)ItemInit.RUNE_MARKING.get()).m_7373_(this.markRuneB, ManaAndArtifice.instance.proxy.getClientWorld(), baseTT, (TooltipFlag)TooltipFlag.Default.f_256752_);
        return baseTT;
    }
}

