/*
 * Decompiled with CFR 0.152.
 */
package com.mna.interop;

import com.mna.interop.CurioRenderer;
import com.mna.interop.HatRenderer;
import com.mna.interop.StaffRenderer;
import com.mna.interop.WandRenderer;
import com.mna.items.ItemInit;
import java.util.Optional;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import org.apache.commons.lang3.mutable.MutableBoolean;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.SlotTypeMessage;
import top.theillusivec4.curios.api.SlotTypePreset;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

@Mod.EventBusSubscriber(modid="mna", bus=Mod.EventBusSubscriber.Bus.MOD)
public class CuriosInterop {
    @SubscribeEvent
    public static void initCuriosSlots(InterModEnqueueEvent event) {
        CuriosInterop.IMCRegisterCurioSlot(SlotTypePreset.HEAD);
        CuriosInterop.IMCRegisterCurioSlot(SlotTypePreset.BRACELET);
        CuriosInterop.IMCRegisterCurioSlot(SlotTypePreset.BELT);
        CuriosInterop.IMCRegisterCurioSlot(SlotTypePreset.NECKLACE);
        CuriosInterop.IMCRegisterCurioSlot(SlotTypePreset.CHARM);
        CuriosInterop.IMCRegisterCurioSlot(SlotTypePreset.CURIO);
        CuriosInterop.IMCRegisterCurioSlot(SlotTypePreset.BACK);
        CuriosInterop.IMCRegisterCurioSlot(SlotTypePreset.RING, 2);
    }

    @SubscribeEvent
    public static void clientCurioSetup(FMLClientSetupEvent evt) {
        CuriosRendererRegistry.register((Item)((Item)ItemInit.FLUID_JUG.get()), () -> new CurioRenderer());
        CuriosRendererRegistry.register((Item)((Item)ItemInit.FLUID_JUG_INFINITE_LAVA.get()), () -> new CurioRenderer());
        CuriosRendererRegistry.register((Item)((Item)ItemInit.FLUID_JUG_INFINITE_WATER.get()), () -> new CurioRenderer());
        CuriosRendererRegistry.register((Item)((Item)ItemInit.STAFF_PHYLACTERY.get()), () -> new CurioRenderer());
        CuriosRendererRegistry.register((Item)((Item)ItemInit.STAFF_AMETHYST.get()), () -> new StaffRenderer());
        CuriosRendererRegistry.register((Item)((Item)ItemInit.STAFF_AUM.get()), () -> new StaffRenderer());
        CuriosRendererRegistry.register((Item)((Item)ItemInit.STAFF_CERUBLOSSOM.get()), () -> new StaffRenderer());
        CuriosRendererRegistry.register((Item)((Item)ItemInit.STAFF_CHIMERITE.get()), () -> new StaffRenderer());
        CuriosRendererRegistry.register((Item)((Item)ItemInit.STAFF_DESERTNOVA.get()), () -> new StaffRenderer());
        CuriosRendererRegistry.register((Item)((Item)ItemInit.STAFF_EMERALD.get()), () -> new StaffRenderer());
        CuriosRendererRegistry.register((Item)((Item)ItemInit.STAFF_GLASS.get()), () -> new StaffRenderer());
        CuriosRendererRegistry.register((Item)((Item)ItemInit.STAFF_GOLD.get()), () -> new StaffRenderer());
        CuriosRendererRegistry.register((Item)((Item)ItemInit.STAFF_IRON.get()), () -> new StaffRenderer());
        CuriosRendererRegistry.register((Item)((Item)ItemInit.STAFF_LAPIS.get()), () -> new StaffRenderer());
        CuriosRendererRegistry.register((Item)((Item)ItemInit.STAFF_NETHERQUARTZ.get()), () -> new StaffRenderer());
        CuriosRendererRegistry.register((Item)((Item)ItemInit.STAFF_PRISMARINECRYSTAL.get()), () -> new StaffRenderer());
        CuriosRendererRegistry.register((Item)((Item)ItemInit.STAFF_PRISMARINESHARD.get()), () -> new StaffRenderer());
        CuriosRendererRegistry.register((Item)((Item)ItemInit.STAFF_REDSTONE.get()), () -> new StaffRenderer());
        CuriosRendererRegistry.register((Item)((Item)ItemInit.STAFF_SKULL.get()), () -> new StaffRenderer());
        CuriosRendererRegistry.register((Item)((Item)ItemInit.STAFF_SKULL_ALT.get()), () -> new StaffRenderer());
        CuriosRendererRegistry.register((Item)((Item)ItemInit.STAFF_TARMA.get()), () -> new StaffRenderer());
        CuriosRendererRegistry.register((Item)((Item)ItemInit.STAFF_VINTEUM.get()), () -> new StaffRenderer());
        CuriosRendererRegistry.register((Item)((Item)ItemInit.STAFF_WAKEBLOOM.get()), () -> new StaffRenderer());
        CuriosRendererRegistry.register((Item)((Item)ItemInit.WAND_AMETHYST.get()), () -> new WandRenderer());
        CuriosRendererRegistry.register((Item)((Item)ItemInit.WAND_AUM.get()), () -> new WandRenderer());
        CuriosRendererRegistry.register((Item)((Item)ItemInit.WAND_CERUBLOSSOM.get()), () -> new WandRenderer());
        CuriosRendererRegistry.register((Item)((Item)ItemInit.WAND_CHIMERITE.get()), () -> new WandRenderer());
        CuriosRendererRegistry.register((Item)((Item)ItemInit.WAND_DESERTNOVA.get()), () -> new WandRenderer());
        CuriosRendererRegistry.register((Item)((Item)ItemInit.WAND_EMERALD.get()), () -> new WandRenderer());
        CuriosRendererRegistry.register((Item)((Item)ItemInit.WAND_GLASS.get()), () -> new WandRenderer());
        CuriosRendererRegistry.register((Item)((Item)ItemInit.WAND_GOLD.get()), () -> new WandRenderer());
        CuriosRendererRegistry.register((Item)((Item)ItemInit.WAND_IRON.get()), () -> new WandRenderer());
        CuriosRendererRegistry.register((Item)((Item)ItemInit.WAND_LAPIS.get()), () -> new WandRenderer());
        CuriosRendererRegistry.register((Item)((Item)ItemInit.WAND_NETHERQUARTZ.get()), () -> new WandRenderer());
        CuriosRendererRegistry.register((Item)((Item)ItemInit.WAND_PRISMARINECRYSTAL.get()), () -> new WandRenderer());
        CuriosRendererRegistry.register((Item)((Item)ItemInit.WAND_PRISMARINESHARD.get()), () -> new WandRenderer());
        CuriosRendererRegistry.register((Item)((Item)ItemInit.WAND_REDSTONE.get()), () -> new WandRenderer());
        CuriosRendererRegistry.register((Item)((Item)ItemInit.WAND_SKULL.get()), () -> new WandRenderer());
        CuriosRendererRegistry.register((Item)((Item)ItemInit.WAND_SKULL_ALT.get()), () -> new WandRenderer());
        CuriosRendererRegistry.register((Item)((Item)ItemInit.WAND_TARMA.get()), () -> new WandRenderer());
        CuriosRendererRegistry.register((Item)((Item)ItemInit.WAND_VINTEUM.get()), () -> new WandRenderer());
        CuriosRendererRegistry.register((Item)((Item)ItemInit.WAND_WAKEBLOOM.get()), () -> new WandRenderer());
        CuriosRendererRegistry.register((Item)((Item)ItemInit.HAT_FEZ.get()), () -> new HatRenderer());
        CuriosRendererRegistry.register((Item)((Item)ItemInit.HAT_LARGE_WITCH.get()), () -> new HatRenderer());
        CuriosRendererRegistry.register((Item)((Item)ItemInit.HAT_STYLED_SKULL.get()), () -> new HatRenderer());
        CuriosRendererRegistry.register((Item)((Item)ItemInit.HAT_TALL_COWBOY.get()), () -> new HatRenderer());
    }

    private static void IMCRegisterCurioSlot(SlotTypePreset slot) {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new SlotTypeMessage.Builder(slot.getIdentifier()).build());
    }

    public static void IMCRegisterCurioSlot(SlotTypePreset slot, int quantity) {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new SlotTypeMessage.Builder(slot.getIdentifier()).size(quantity).build());
    }

    public static boolean IsItemInCurioSlot(Item item, LivingEntity entity, SlotTypePreset slot) {
        MutableBoolean exists = new MutableBoolean(false);
        CuriosApi.getCuriosInventory((LivingEntity)entity).ifPresent(handler -> handler.findFirstCurio(item).ifPresent(slotResult -> exists.setValue(slotResult.slotContext().getIdentifier() == slot.getIdentifier())));
        return exists.booleanValue();
    }

    public static Optional<SlotResult> GetSingleItem(LivingEntity entity, Item ... items) {
        Optional output = Optional.empty();
        LazyOptional curioInventory = CuriosApi.getCuriosInventory((LivingEntity)entity);
        if (curioInventory.isPresent()) {
            for (Item item : items) {
                Optional slotRes = ((ICuriosItemHandler)curioInventory.resolve().get()).findFirstCurio(item);
                if (!slotRes.isPresent()) continue;
                output = slotRes;
                break;
            }
        }
        return output;
    }

    public static void DamageCurioInSlot(Item item, LivingEntity entity, SlotTypePreset slot, int damage) {
        CuriosApi.getCuriosInventory((LivingEntity)entity).ifPresent(handler -> handler.findFirstCurio(item).ifPresent(slotResult -> slotResult.stack().m_41622_(damage, entity, damager -> CuriosApi.broadcastCurioBreakEvent((SlotContext)slotResult.slotContext()))));
    }
}

