/*
 * Decompiled with CFR 0.152.
 */
package com.mna.interop.jei.categories;

import com.mna.api.capabilities.IPlayerProgression;
import com.mna.api.tools.MATags;
import com.mna.blocks.BlockInit;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.mna.gui.GuiTextures;
import com.mna.interop.jei.MARecipeTypes;
import com.mna.recipes.eldrin.EldrinAltarRecipe;
import com.mna.tools.render.GuiRenderUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.mutable.MutableInt;

public class EldrinAltarRecipeCategory
implements IRecipeCategory<EldrinAltarRecipe> {
    private final IDrawable background;
    private final IDrawable icon;
    private final String localizedName;
    private int xSize = 152;
    private int ySize = 177;

    public EldrinAltarRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(GuiTextures.Jei.ELDRIN, 0, 0, this.xSize, this.ySize).setTextureSize(152, 177).build();
        this.localizedName = I18n.m_118938_((String)"gui.mna.jei.eldrin_altar", (Object[])new Object[0]);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)BlockInit.ELDRIN_ALTAR.get()));
    }

    public Component getTitle() {
        return Component.m_237115_((String)this.localizedName);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, EldrinAltarRecipe recipe, IFocusGroup focuses) {
        int cX = this.xSize / 2 - 14;
        int cY = this.ySize / 2 + 15;
        float radians = -1.5707964f;
        float radianStep = 0.7853982f;
        int ingredDist = 44;
        builder.setShapeless();
        int count = 0;
        for (ResourceLocation rLoc : recipe.getRequiredItems()) {
            int ingredX = cX + (int)Math.round(Math.cos(radians) * (double)ingredDist);
            int ingredY = cY + (int)Math.round(Math.sin(radians) * (double)ingredDist);
            if (count++ == 0) {
                ingredX = cX;
                ingredY = cY;
            }
            if (count == 2 || count == 4) {
                ingredX += 4;
            } else if (count == 6 || count == 8) {
                ingredX -= 4;
            } else if (count == 5) {
                ++ingredY;
            } else if (count == 9) {
                --ingredY;
            }
            builder.addSlot(RecipeIngredientRole.INPUT, ingredX - 8, ingredY).addIngredients(Ingredient.m_43921_(MATags.smartLookupItem(rLoc).stream().map(item -> {
                ItemStack stack = new ItemStack((ItemLike)item);
                if (stack.m_41720_() == Items.f_42589_ && stack.m_41783_() == null) {
                    stack = PotionUtils.m_43549_((ItemStack)stack, (Potion)Potions.f_43599_);
                }
                return stack;
            })));
            radians += radianStep;
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 54, 29).addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)recipe.getResultItem());
    }

    public void draw(EldrinAltarRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics pGuiGraphics, double mouseX, double mouseY) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91062_ != null) {
            int playerTier;
            int tier = recipe.getTier();
            int color = tier <= (playerTier = ((IPlayerProgression)mc.f_91074_.getCapability(PlayerProgressionProvider.PROGRESSION).resolve().get()).getTier()) ? FastColor.ARGB32.m_13660_((int)255, (int)0, (int)128, (int)0) : FastColor.ARGB32.m_13660_((int)255, (int)255, (int)0, (int)0);
            MutableComponent name = Component.m_237115_((String)recipe.getResultItem().m_41778_().toString());
            MutableComponent tierPrompt = Component.m_237110_((String)"gui.mna.item-tier-short", (Object[])new Object[]{tier});
            int stringWidth = mc.f_91062_.m_92852_((FormattedText)name);
            int textX = this.xSize / 2 - stringWidth / 2;
            int textY = 5;
            pGuiGraphics.m_280614_(mc.f_91062_, (Component)name, 0, textY, FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255), false);
            pGuiGraphics.m_280614_(mc.f_91062_, (Component)tierPrompt, 0, 15, color, false);
            GuiRenderUtils.renderFactionIcon(pGuiGraphics, recipe.getFactionRequirement(), textX + stringWidth + 3, textY);
            GuiRenderUtils.renderByproducts(pGuiGraphics, this.xSize / 2 + 1, 8, recipe, true);
            int affStep = 24;
            int affX = this.xSize - 27;
            int affY = (Boolean)mc.f_91066_.f_92043_.m_231551_() != false ? 22 : 24;
            MutableInt count = new MutableInt(0);
            recipe.getPowerRequirements().forEach((a, v) -> {
                int rY = affY + count.getAndIncrement() * affStep;
                String aText = a.name();
                float scale = (Boolean)mc.f_91066_.f_92043_.m_231551_() != false ? 1.0f : 0.7f;
                pGuiGraphics.m_280168_().m_85836_();
                pGuiGraphics.m_280168_().m_85841_(scale, scale, scale);
                pGuiGraphics.m_280056_(mc.f_91062_, aText, (int)((float)affX / scale), (int)((float)(rY + 6) / scale), FastColor.ARGB32.m_13660_((int)255, (int)a.getColor()[0], (int)a.getColor()[1], (int)a.getColor()[2]), false);
                String vText = String.format("%.0f", v);
                pGuiGraphics.m_280056_(mc.f_91062_, vText, (int)((float)affX / scale), (int)((float)(rY + 16) / scale), FastColor.ARGB32.m_13660_((int)255, (int)a.getColor()[0], (int)a.getColor()[1], (int)a.getColor()[2]), false);
                pGuiGraphics.m_280168_().m_85849_();
            });
            RenderSystem.enableBlend();
        }
    }

    public RecipeType<EldrinAltarRecipe> getRecipeType() {
        return MARecipeTypes.ELDRIN_ALTAR;
    }
}

