/*
 * Decompiled with CFR 0.152.
 */
package com.mna.interop.jei.categories;

import com.mna.api.capabilities.IPlayerProgression;
import com.mna.api.tools.MATags;
import com.mna.blocks.BlockInit;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.mna.gui.GuiTextures;
import com.mna.interop.jei.JEIInterop;
import com.mna.interop.jei.MARecipeTypes;
import com.mna.interop.jei.ingredients.ManaweavePatternIngredient;
import com.mna.recipes.manaweaving.ManaweavingRecipe;
import com.mna.tools.render.GuiRenderUtils;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class ManaweavingAltarRecipeCategory
implements IRecipeCategory<ManaweavingRecipe> {
    private final IDrawable background;
    private final IDrawable icon;
    private final String localizedName;
    private int xSize = 152;
    private int ySize = 177;

    public ManaweavingAltarRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(GuiTextures.Jei.MANAWEAVING_ALTAR, 0, 0, this.xSize, this.ySize).setTextureSize(152, 177).build();
        this.localizedName = I18n.m_118938_((String)"gui.mna.jei.manaweaving_altar", (Object[])new Object[0]);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)BlockInit.MANAWEAVING_ALTAR.get()));
    }

    public RecipeType<ManaweavingRecipe> getRecipeType() {
        return MARecipeTypes.MANAWEAVING;
    }

    public Component getTitle() {
        return Component.m_237115_((String)this.localizedName);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ManaweavingRecipe recipe, IFocusGroup focuses) {
        int x = 29;
        int y = 30;
        int reagentIdx = 0;
        builder.setShapeless();
        for (ResourceLocation rLoc : recipe.getRequiredItems()) {
            builder.addSlot(RecipeIngredientRole.INPUT, x + reagentIdx % 3 * 22, y + (int)Math.floor(reagentIdx / 3) * 22).addIngredients(this.resolveIngredient(rLoc));
            ++reagentIdx;
        }
        int xStep = 24;
        x = 8;
        y = 150;
        for (ResourceLocation rLoc : recipe.getRequiredPatterns()) {
            builder.addSlot(RecipeIngredientRole.INPUT, x, y).addIngredient((IIngredientType)JEIInterop.MANAWEAVE_PATTERN, (Object)new ManaweavePatternIngredient(rLoc));
            ++reagentIdx;
            x += xStep;
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 108, 52).addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)recipe.getResultItem());
    }

    private Ingredient resolveIngredient(ResourceLocation rLoc) {
        return Ingredient.m_43921_(MATags.smartLookupItem(rLoc).stream().map(item -> {
            ItemStack stack = new ItemStack((ItemLike)item);
            if (stack.m_41720_() == Items.f_42589_ && stack.m_41783_() == null) {
                stack = PotionUtils.m_43549_((ItemStack)stack, (Potion)Potions.f_43599_);
            }
            return stack;
        }));
    }

    public void draw(ManaweavingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics pGuiGraphics, double mouseX, double mouseY) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91062_ != null) {
            int playerTier;
            int tier = recipe.getTier();
            int color = tier <= (playerTier = ((IPlayerProgression)mc.f_91074_.getCapability(PlayerProgressionProvider.PROGRESSION).resolve().get()).getTier()) ? FastColor.ARGB32.m_13660_((int)255, (int)0, (int)128, (int)0) : FastColor.ARGB32.m_13660_((int)255, (int)255, (int)0, (int)0);
            MutableComponent name = Component.m_237115_((String)recipe.getResultItem().m_41778_().toString());
            MutableComponent tierPrompt = Component.m_237110_((String)"gui.mna.item-tier", (Object[])new Object[]{tier});
            int stringWidth = mc.f_91062_.m_92852_((FormattedText)name);
            int textX = this.xSize / 2 - stringWidth / 2;
            int textY = 5;
            pGuiGraphics.m_280614_(mc.f_91062_, (Component)name, textX, textY, FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255), false);
            pGuiGraphics.m_280614_(mc.f_91062_, (Component)tierPrompt, this.xSize / 2 - mc.f_91062_.m_92852_((FormattedText)tierPrompt) / 2, 15, color, false);
            GuiRenderUtils.renderFactionIcon(pGuiGraphics, recipe.getFactionRequirement(), textX + stringWidth + 3, textY);
            GuiRenderUtils.renderByproducts(pGuiGraphics, this.xSize / 2 + 16, 78, recipe, false);
        }
    }
}

