/*
 * Decompiled with CFR 0.152.
 */
package com.mna.inventory;

import com.mna.ManaAndArtifice;
import com.mna.api.ManaAndArtificeMod;
import com.mna.inventory.stack_extension.AbstractItemHandler;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.ItemStack;

public class ItemInventoryBase
extends AbstractItemHandler {
    protected final ItemStack stack;
    private static final String TAG_ITEMS = "Items";

    public ItemInventoryBase(ItemStack stack) {
        super(54);
        this.stack = stack;
        this.setup();
    }

    public ItemInventoryBase(ItemStack stack, int numSlots) {
        super(numSlots);
        this.stack = stack;
        this.setup();
    }

    public void setup() {
        this.readItemStack();
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public void readItemStack() {
        if (this.stack.m_41783_() != null && this.stack.m_41783_().m_128441_(TAG_ITEMS)) {
            if (this.stack.m_41783_().m_128469_(TAG_ITEMS).m_128441_("slots")) {
                this.deserialize(this.stack.m_41783_().m_128469_(TAG_ITEMS));
            } else {
                this.readNBT(this.stack.m_41783_());
            }
        }
    }

    public void writeItemStack() {
        if (this.isEmpty()) {
            this.stack.m_41749_(TAG_ITEMS);
        } else {
            CompoundTag tag = this.stack.m_41784_();
            tag.m_128365_(TAG_ITEMS, (Tag)this.serialize());
        }
    }

    protected boolean isSameItem(ItemStack a, ItemStack b) {
        return a.m_41720_() == b.m_41720_() && ManaAndArtificeMod.getItemHelper().AreTagsEqual(a, b);
    }

    protected void moveItemToEmptySlots(ItemStack stack) {
        for (int i = 0; i < this.size(); ++i) {
            ItemStack itemstack = this.getStackInSlot(i);
            if (!itemstack.m_41619_()) continue;
            this.setStackInSlot(i, stack.m_41777_());
            stack.m_41764_(0);
            return;
        }
    }

    protected void moveItemToOccupiedSlotsWithSameType(ItemStack stack) {
        for (int i = 0; i < this.size(); ++i) {
            ItemStack itemstack = this.getStackInSlot(i);
            if (!this.isSameItem(itemstack, stack)) continue;
            this.moveItemsBetweenStacks(stack, itemstack, i);
            if (!stack.m_41619_()) continue;
            return;
        }
    }

    protected void moveItemsBetweenStacks(ItemStack source, ItemStack dest, int slot) {
        int i = Math.min(this.getSlotLimit(slot, dest), dest.m_41741_());
        int j = Math.min(source.m_41613_(), i - dest.m_41613_());
        if (j > 0) {
            dest.m_41769_(j);
            source.m_41774_(j);
            this.markDirty();
        }
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        return true;
    }

    private void readNBT(CompoundTag compound) {
        ManaAndArtifice.LOGGER.info("Upconverting old ritual kit to Practitioner's Pouch");
        NonNullList list = NonNullList.m_122780_((int)this.getSlots(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)compound, (NonNullList)list);
        int mySlotIndex = 0;
        for (int i = 0; i < list.size(); ++i) {
            if (((ItemStack)list.get(i)).m_41619_()) continue;
            this.setStackInSlot(mySlotIndex++, (ItemStack)list.get(i));
        }
        this.writeItemStack();
    }

    public NonNullList<ItemStack> getNonAirItems() {
        NonNullList items = NonNullList.m_122779_();
        this.stacks.forEach(is -> {
            if (!is.isEmpty()) {
                items.add((Object)is.getStackOriginal());
            }
        });
        return items;
    }

    public NonNullList<ItemStack> getAllItems() {
        NonNullList items = NonNullList.m_122779_();
        this.stacks.forEach(is -> items.add((Object)is.getStackOriginal()));
        return items;
    }
}

