/*
 * Decompiled with CFR 0.152.
 */
package com.mna.items;

import com.mna.api.ManaAndArtificeMod;
import com.mna.api.capabilities.CodexBreadcrumb;
import com.mna.api.items.TieredItem;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.mna.gui.containers.providers.NamedGuideBook;
import com.mna.items.renderers.books.CodexBookRenderer;
import com.mna.tools.DidYouKnowHelper;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.util.NonNullLazy;
import net.minecraftforge.network.NetworkHooks;

public class ItemGuideBook
extends TieredItem {
    private int guiOpenCount = 0;
    private long lastActivateTime = 0L;

    public ItemGuideBook() {
        super(new Item.Properties().m_41487_(1));
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private final NonNullLazy<BlockEntityWithoutLevelRenderer> ister = NonNullLazy.of(() -> new CodexBookRenderer(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_()));

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return (BlockEntityWithoutLevelRenderer)this.ister.get();
            }
        });
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack book = player.m_21120_(hand);
        if (hand == InteractionHand.MAIN_HAND) {
            if (!world.f_46443_) {
                if (!ManaAndArtificeMod.checkMagicUnlock((ServerLevel)world, player)) {
                    NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new NamedGuideBook());
                }
            } else {
                player.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> {
                    if (p.peekCodexBreadcrumb() != null && p.peekCodexBreadcrumb().Type == CodexBreadcrumb.Type.RECIPE) {
                        if (world.m_46467_() - this.lastActivateTime < 200L) {
                            ++this.guiOpenCount;
                            if (this.guiOpenCount >= 4) {
                                DidYouKnowHelper.CheckAndShowDidYouKnow(player, "helptip.mna.pin_recipe");
                            }
                        }
                    } else {
                        this.guiOpenCount = 0;
                    }
                    this.lastActivateTime = world.m_46467_();
                });
            }
        }
        return InteractionResultHolder.m_19090_((Object)book);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos blockpos;
        Level world = context.m_43725_();
        BlockState blockstate = world.m_8055_(blockpos = context.m_8083_());
        if (blockstate.m_60713_(Blocks.f_50624_)) {
            return LecternBlock.m_269125_((Entity)context.m_43723_(), (Level)world, (BlockPos)blockpos, (BlockState)blockstate, (ItemStack)context.m_43722_()) ? InteractionResult.m_19078_((boolean)world.f_46443_) : InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }
}

