/*
 * Decompiled with CFR 0.152.
 */
package com.mna.items.armor;

import com.mna.api.items.ITieredItem;
import com.mna.items.ItemInit;
import com.mna.items.armor.MAArmorMaterial;
import com.mna.items.base.INoCreativeTab;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.DyeableArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class BrokenMageArmor
extends DyeableArmorItem
implements ITieredItem<BrokenMageArmor>,
INoCreativeTab {
    private static final String NBT_RESTORE = "previous_item";
    private static final String NBT_OTHER_ID = "previous_item_id";
    private int _tier = -1;

    public BrokenMageArmor(ArmorItem.Type slot) {
        super((ArmorMaterial)MAArmorMaterial.BROKEN, slot, new Item.Properties().m_41487_(1).setNoRepair());
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return 0;
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)Component.m_237115_((String)"item.mna.broken_repair_prompt").m_130940_(ChatFormatting.AQUA));
    }

    public static BrokenMageArmor getBySlot(EquipmentSlot slot) {
        if (slot == null) {
            return null;
        }
        switch (slot) {
            case CHEST: {
                return (BrokenMageArmor)ItemInit.BROKEN_ROBES.get();
            }
            case FEET: {
                return (BrokenMageArmor)ItemInit.BROKEN_BOOTS.get();
            }
            case HEAD: {
                return (BrokenMageArmor)ItemInit.BROKEN_HOOD.get();
            }
            case LEGS: {
                return (BrokenMageArmor)ItemInit.BROKEN_LEGGINGS.get();
            }
        }
        return null;
    }

    public ItemStack convertFrom(ItemStack other) {
        if (!(other.m_41720_() instanceof ArmorItem) || ((ArmorItem)other.m_41720_()).m_266204_() != this.m_266204_()) {
            return ItemStack.f_41583_;
        }
        ItemStack outputStack = new ItemStack((ItemLike)this);
        if (other.m_41720_() instanceof DyeableArmorItem) {
            ((DyeableArmorItem)other.m_41720_()).m_41115_(outputStack, ((DyeableArmorItem)other.m_41720_()).m_41121_(other));
        }
        CompoundTag tag = outputStack.m_41784_();
        if (other.m_41782_()) {
            tag.m_128365_(NBT_RESTORE, (Tag)other.m_41783_());
        }
        tag.m_128359_(NBT_OTHER_ID, ForgeRegistries.ITEMS.getKey((Object)other.m_41720_()).toString());
        return outputStack;
    }

    public ItemStack restore(ItemStack me) {
        CompoundTag tag = me.m_41783_();
        if (tag == null) {
            return ItemStack.f_41583_;
        }
        ResourceLocation restore = new ResourceLocation(tag.m_128461_(NBT_OTHER_ID));
        Item item = (Item)ForgeRegistries.ITEMS.getValue(restore);
        if (item == null) {
            return ItemStack.f_41583_;
        }
        ItemStack outputStack = new ItemStack((ItemLike)item);
        if (tag.m_128441_(NBT_RESTORE)) {
            outputStack.m_41751_((CompoundTag)tag.m_128423_(NBT_RESTORE));
        }
        return outputStack;
    }

    public static boolean hasRestore(ItemStack stack) {
        ResourceLocation restore;
        Item item;
        return !(stack.m_41720_() instanceof BrokenMageArmor) || !stack.m_41782_() || !stack.m_41783_().m_128441_(NBT_RESTORE) || !stack.m_41783_().m_128441_(NBT_OTHER_ID) || (item = (Item)ForgeRegistries.ITEMS.getValue(restore = new ResourceLocation(stack.m_41783_().m_128461_(NBT_OTHER_ID)))) != null;
    }

    @Override
    public void setCachedTier(int tier) {
        this._tier = tier;
    }

    @Override
    public int getCachedTier() {
        return this._tier;
    }
}

