/*
 * Decompiled with CFR 0.152.
 */
package com.mna.items.armor;

import com.mna.ManaAndArtifice;
import com.mna.api.config.GeneralConfigValues;
import com.mna.api.faction.IFaction;
import com.mna.api.items.IFactionSpecific;
import com.mna.api.items.ITieredItem;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.api.tools.RLoc;
import com.mna.capabilities.playerdata.magic.PlayerMagicProvider;
import com.mna.effects.EffectInit;
import com.mna.factions.Factions;
import com.mna.items.ItemInit;
import com.mna.items.armor.IBrokenArmorReplaceable;
import com.mna.items.armor.ISetItem;
import com.mna.items.base.IManaRepairable;
import com.mna.items.renderers.CouncilArmorRenderer;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.util.GeckoLibUtil;

public class CouncilArmorItem
extends ArmorItem
implements GeoItem,
ISetItem,
ITieredItem<CouncilArmorItem>,
IFactionSpecific,
IBrokenArmorReplaceable<CouncilArmorItem>,
IManaRepairable {
    private AnimatableInstanceCache animCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final ResourceLocation council_armor_set_bonus = RLoc.create("council_armor_set_bonus");
    public static final String council_armor_set_bonus_key = "council_armor_set_bonus";
    public static final String council_armor_reflect_counters_key = "council_armor_reflect_counters";
    private static final float MANA_COST_PER_TICK = 0.75f;
    private int _tier = -1;

    public CouncilArmorItem(ArmorMaterial materialIn, ArmorItem.Type slot, Item.Properties builder) {
        super(materialIn, slot, builder.m_41497_(Rarity.EPIC));
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private GeoArmorRenderer<?> renderer;

            @NotNull
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                if (this.renderer == null) {
                    this.renderer = new CouncilArmorRenderer();
                }
                this.renderer.prepForRender((Entity)livingEntity, itemStack, equipmentSlot, original);
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar registrar) {
        registrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, state -> state.setAndContinue(RawAnimation.begin().thenLoop("animation.model.ambient")))});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animCache;
    }

    @Override
    public ResourceLocation getSetIdentifier() {
        return council_armor_set_bonus;
    }

    public void onArmorTick(ItemStack stack, Level world, Player player) {
        this.usedByPlayer(player);
        if (this.isSetEquipped((LivingEntity)player) && this == ItemInit.COUNCIL_ARMOR__CHEST.get()) {
            player.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> {
                if (player.m_150110_().f_35935_ && !player.m_21023_((MobEffect)EffectInit.LEVITATION.get())) {
                    if (world.f_46443_) {
                        Vec3 look = player.m_20156_().m_82537_(new Vec3(0.0, 1.0, 0.0));
                        float offset = (float)(Math.random() * 0.2);
                        look = look.m_82490_((double)offset);
                        world.m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ARCANE.get())), player.m_20185_() + look.f_82479_, player.m_20186_(), player.m_20189_() + look.f_82481_, 0.0, (double)-0.05f, 0.0);
                        world.m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ARCANE.get())), player.m_20185_() - look.f_82479_, player.m_20186_(), player.m_20189_() - look.f_82481_, 0.0, (double)-0.05f, 0.0);
                    } else {
                        m.getCastingResource().consume((LivingEntity)player, 0.75f);
                    }
                }
                if (!m.getCastingResource().hasEnoughAbsolute((LivingEntity)player, 0.75f)) {
                    ManaAndArtifice.instance.proxy.setFlightEnabled(player, false);
                } else {
                    ManaAndArtifice.instance.proxy.setFlightEnabled(player, true);
                    if (!player.m_7500_() && !player.m_5833_()) {
                        ManaAndArtifice.instance.proxy.setFlySpeed(player, 0.02f);
                        if (player.m_150110_().f_35935_) {
                            player.m_6858_(false);
                        }
                    } else {
                        ManaAndArtifice.instance.proxy.setFlySpeed(player, 0.05f);
                    }
                }
            });
        }
    }

    @Override
    public void applySetBonus(LivingEntity living, EquipmentSlot ... setSlots) {
        if (living instanceof Player) {
            living.getPersistentData().m_128379_(council_armor_set_bonus_key, true);
            ((Player)living).getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> {
                m.getCastingResource().addModifier(council_armor_set_bonus_key, 750.0f);
                m.getCastingResource().addRegenerationModifier(council_armor_set_bonus_key, -0.25f);
            });
        }
    }

    @Override
    public void removeSetBonus(LivingEntity living, EquipmentSlot ... setSlots) {
        if (living instanceof Player) {
            living.getPersistentData().m_128379_(council_armor_set_bonus_key, false);
            ((Player)living).getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> {
                m.getCastingResource().removeModifier(council_armor_set_bonus_key);
                m.getCastingResource().removeRegenerationModifier(council_armor_set_bonus_key);
            });
            ManaAndArtifice.instance.proxy.setFlySpeed((Player)living, 0.05f);
            ManaAndArtifice.instance.proxy.setFlightEnabled((Player)living, false);
        }
    }

    @Override
    public int itemsForSetBonus() {
        return 4;
    }

    @Override
    public int getCachedTier() {
        return this._tier;
    }

    @Override
    public void setCachedTier(int tier) {
        this._tier = tier;
    }

    @Override
    public IFaction getFaction() {
        return Factions.COUNCIL;
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        ISetItem.super.addSetTooltip(tooltip);
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    private static int[] getReflectCharges(Player player) {
        int[] reflections = !player.getPersistentData().m_128441_(council_armor_reflect_counters_key) ? new int[GeneralConfigValues.SpellweaverReflectCharges] : player.getPersistentData().m_128465_(council_armor_reflect_counters_key);
        if (reflections.length != GeneralConfigValues.SpellweaverReflectCharges) {
            reflections = new int[GeneralConfigValues.SpellweaverReflectCharges];
        }
        return reflections;
    }

    private static void updateReflectCharges(Player player, int[] reflections) {
        player.getPersistentData().m_128385_(council_armor_reflect_counters_key, reflections);
    }

    public static boolean consumeReflectCharget(Player player) {
        int[] reflections = CouncilArmorItem.getReflectCharges(player);
        for (int i = 0; i < reflections.length; ++i) {
            if (reflections[i] > 0) continue;
            reflections[i] = GeneralConfigValues.SpellweaverReflectTime;
            CouncilArmorItem.updateReflectCharges(player, reflections);
            return true;
        }
        return false;
    }

    public static void tickReflectCharges(Player player) {
        int[] reflections = CouncilArmorItem.getReflectCharges(player);
        for (int i = 0; i < reflections.length; ++i) {
            if (reflections[i] <= 0) continue;
            int n = i;
            reflections[n] = reflections[n] - 1;
        }
        CouncilArmorItem.updateReflectCharges(player, reflections);
    }

    @Override
    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return IBrokenArmorReplaceable.super.damageItem(stack, amount * 3, entity, onBroken);
    }

    @Override
    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        IManaRepairable.super.m_6883_(stack, worldIn, entityIn, itemSlot, isSelected);
    }
}

