/*
 * Decompiled with CFR 0.152.
 */
package com.mna.items.armor;

import com.mna.items.ItemInit;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public enum MAArmorMaterial implements ArmorMaterial
{
    BROKEN("broken", 5, new int[]{0, 0, 0, 0}, 0, SoundEvents.f_11678_, 0.0f, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemInit.INFUSED_SILK.get()})),
    INFUSED_SILK("infused_silk", 5, new int[]{1, 2, 3, 1}, 15, SoundEvents.f_11678_, 0.0f, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemInit.INFUSED_SILK.get()})),
    BONE("bone", 33, new int[]{3, 6, 8, 3}, 10, SoundEvents.f_11673_, 2.0f, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42679_})),
    DEMON("demon", 33, new int[]{3, 6, 8, 3}, 15, SoundEvents.f_11679_, 3.0f, 0.1f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42418_})),
    FEY("fey", 33, new int[]{2, 5, 6, 2}, 9, SoundEvents.f_11678_, 0.0f, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50195_})),
    COUNCIL("council", 33, new int[]{1, 4, 5, 2}, 12, SoundEvents.f_11673_, 0.0f, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemInit.RUNIC_SILK.get()}));

    private static final int[] MAX_DAMAGE_ARRAY;
    private final String name;
    private final int maxDamageFactor;
    private final int[] damageReductionAmountArray;
    private final int enchantability;
    private final SoundEvent soundEvent;
    private final float toughness;
    private final float knockbackResistance;
    private final Supplier<Ingredient> repairMaterial;

    private MAArmorMaterial(String name, int maxDamageFactor, int[] damageReductionAmountArray, int enchantability, SoundEvent soundEvent, float toughness, float knockbackResistance, Supplier<Ingredient> repairMaterial) {
        this.name = name;
        this.maxDamageFactor = maxDamageFactor;
        this.damageReductionAmountArray = damageReductionAmountArray;
        this.enchantability = enchantability;
        this.soundEvent = soundEvent;
        this.toughness = toughness;
        this.knockbackResistance = knockbackResistance;
        this.repairMaterial = repairMaterial;
    }

    public int m_266425_(ArmorItem.Type pType) {
        return MAX_DAMAGE_ARRAY[pType.m_266308_().m_20749_()] * this.maxDamageFactor;
    }

    public int m_7366_(ArmorItem.Type pType) {
        return this.damageReductionAmountArray[pType.m_266308_().m_20749_()];
    }

    public int m_6646_() {
        return this.enchantability;
    }

    public SoundEvent m_7344_() {
        return this.soundEvent;
    }

    public Ingredient m_6230_() {
        return this.repairMaterial.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public String m_6082_() {
        return "mna:" + this.name;
    }

    public float m_6651_() {
        return this.toughness;
    }

    public float m_6649_() {
        return this.knockbackResistance;
    }

    static {
        MAX_DAMAGE_ARRAY = new int[]{13, 15, 16, 11};
    }
}

