/*
 * Decompiled with CFR 0.152.
 */
package com.mna.items.artifice;

import com.mna.api.items.TieredItem;
import com.mna.gui.containers.providers.NamedFilterItem;
import com.mna.inventory.ItemInventoryBase;
import com.mna.items.base.IItemWithGui;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class FilterItem
extends TieredItem
implements IItemWithGui<FilterItem> {
    public static final int INVENTORY_SIZE = 24;

    public FilterItem() {
        super(new Item.Properties().m_41487_(1));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        if (world.f_46443_) {
            return InteractionResultHolder.m_19098_((Object)player.m_21120_(hand));
        }
        if (IItemWithGui.super.openGuiIfModifierPressed(this.m_7968_(), player, world)) {
            return InteractionResultHolder.m_19096_((Object)player.m_21120_(hand));
        }
        return InteractionResultHolder.m_19098_((Object)player.m_21120_(hand));
    }

    @Override
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flags) {
        IItemWithGui.super.m_7373_(stack, world, tooltip, flags);
        this.addContentsDescription(stack, world, tooltip);
    }

    public void addContentsDescription(ItemStack stack, Level world, List<Component> tooltip) {
        ItemInventoryBase inv = new ItemInventoryBase(stack);
        NonNullList<ItemStack> nonAir = inv.getNonAirItems();
        if (nonAir.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < Math.min(nonAir.size(), 5); ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(Component.m_237115_((String)((ItemStack)nonAir.get(i)).m_41778_()).getString());
            }
            if (nonAir.size() > 4) {
                sb.append("...");
            }
            tooltip.add((Component)Component.m_237113_((String)sb.toString()).m_130940_(ChatFormatting.GREEN));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"item.mna.filter_item.empty").m_130940_(ChatFormatting.RED));
        }
        tooltip.add((Component)Component.m_237115_((String)"item.mna.filter_item.match_durability").m_7220_((Component)Component.m_237115_((String)(this.getMatchDurability(stack) ? "item.mna.filter_item.yes" : "item.mna.filter_item.no")).m_130940_(ChatFormatting.GOLD)));
        tooltip.add((Component)Component.m_237115_((String)"item.mna.filter_item.match_tag").m_7220_((Component)Component.m_237115_((String)(this.getMatchTag(stack) ? "item.mna.filter_item.yes" : "item.mna.filter_item.no")).m_130940_(ChatFormatting.GOLD)));
    }

    @Override
    public MenuProvider getProvider(ItemStack stack) {
        return new NamedFilterItem();
    }

    public void setItems(ItemStack filter, NonNullList<ItemStack> list, boolean matchDurability, boolean matchTag) {
        int i;
        ItemInventoryBase inv = new ItemInventoryBase(filter, 24);
        for (i = 0; i < inv.size(); ++i) {
            inv.setStackInSlot(i, ItemStack.f_41583_);
        }
        for (i = 0; i < Math.min(inv.size(), list.size()); ++i) {
            inv.setStackInSlot(i, (ItemStack)list.get(i));
        }
        inv.writeItemStack();
        this.setMatchDurability(filter, matchDurability);
        this.setMatchTag(filter, matchTag);
    }

    public void setMatchDurability(ItemStack stack, boolean durability) {
        stack.m_41784_().m_128379_("match_durability", durability);
    }

    public boolean getMatchDurability(ItemStack stack) {
        if (!stack.m_41782_()) {
            return false;
        }
        return stack.m_41783_().m_128471_("match_durability");
    }

    public void setMatchTag(ItemStack stack, boolean durability) {
        stack.m_41784_().m_128379_("match_tag", durability);
    }

    public boolean getMatchTag(ItemStack stack) {
        if (!stack.m_41782_()) {
            return false;
        }
        return stack.m_41783_().m_128471_("match_tag");
    }
}

