/*
 * Decompiled with CFR 0.152.
 */
package com.mna.items.artifice;

import com.mna.Registries;
import com.mna.api.affinity.Affinity;
import com.mna.api.faction.IFaction;
import com.mna.api.items.TieredItem;
import com.mna.blocks.tileentities.EldrinAltarTile;
import com.mna.blocks.tileentities.ManaweavingAltarTile;
import com.mna.items.base.IRadialInventorySelect;
import com.mna.items.renderers.books.RecipeCopyBookRenderer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.util.NonNullLazy;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class ItemRecipeCopyBook
extends TieredItem
implements DyeableLeatherItem,
IRadialInventorySelect {
    private static final String NBT_RECIPE_OUTPUT = "recipe_output";
    private static final String NBT_RECIPE_COST = "recipe_cost";
    private static final String NBT_RECIPE_INPUTS = "recipe_inputs";
    private static final String NBT_RECIPE_FACTION = "faction";
    private static final String NBT_RECIPE_TIER = "tier";
    private static final String NBT_RECIPE_PATTERN_COUNT = "pattern_count";
    private static final String NBT_RECIPE_TYPE = "recipe_type";
    private static final String NBT_RECIPE_CONTAINER = "recipes";
    private static final String NBT_MODE = "mode";
    public static final int RECIPE_SLOTS = 16;
    private static final byte RECIPE_TYPE_MANAWEAVING = 0;
    private static final byte RECIPE_TYPE_ELDRIN = 1;

    public ItemRecipeCopyBook() {
        super(new Item.Properties().m_41497_(Rarity.UNCOMMON));
    }

    public InteractionResult m_6225_(UseOnContext pContext) {
        BlockPos pos = pContext.m_8083_();
        BlockEntity tile = pContext.m_43725_().m_7702_(pos);
        ItemStack stack = pContext.m_43722_();
        Modes mode = ItemRecipeCopyBook.getMode(stack);
        if (pContext.m_43723_().m_6047_()) {
            ItemRecipeCopyBook.toggleMode(stack);
        } else if (tile != null) {
            if (tile instanceof ManaweavingAltarTile) {
                ManaweavingAltarTile mwTile = (ManaweavingAltarTile)tile;
                if (mode == Modes.COPY ? !ItemRecipeCopyBook.copyRememberedRecipe(stack, mwTile) : !ItemRecipeCopyBook.pasteRememberedRecipe(stack, mwTile, pContext.m_43723_())) {
                    return InteractionResult.FAIL;
                }
            } else if (tile instanceof EldrinAltarTile) {
                EldrinAltarTile eTile = (EldrinAltarTile)tile;
                if (mode == Modes.COPY ? !ItemRecipeCopyBook.copyRememberedRecipe(stack, eTile) : !ItemRecipeCopyBook.pasteRememberedRecipe(stack, eTile, pContext.m_43723_())) {
                    return InteractionResult.FAIL;
                }
            }
            return InteractionResult.m_19078_((boolean)pContext.m_43725_().m_5776_());
        }
        return InteractionResult.PASS;
    }

    @Override
    public void m_7373_(ItemStack pStack, Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        Modes mode = ItemRecipeCopyBook.getMode(pStack);
        if (mode == Modes.COPY) {
            pTooltipComponents.add((Component)Component.m_237115_((String)"item.mna.recipe_copy_book.copy").m_130940_(ChatFormatting.AQUA));
        } else {
            int slot = ItemRecipeCopyBook.getSlot(pStack);
            ItemStack output = ItemRecipeCopyBook.getOutputItem(pStack, slot);
            MutableComponent tileEntityName = Component.m_237115_((String)(ItemRecipeCopyBook.getTileType(pStack, slot) == 0 ? "block.mna.manaweaving_altar" : "block.mna.eldrin_altar")).m_130940_(ChatFormatting.AQUA);
            pTooltipComponents.add((Component)Component.m_237115_((String)"item.mna.recipe_copy_book.paste").m_130940_(ChatFormatting.AQUA).m_7220_((Component)Component.m_237110_((String)"item.mna.recipe_copy_book.paste_2", (Object[])new Object[]{Component.m_237115_((String)output.m_41778_()).m_130940_(ChatFormatting.AQUA), tileEntityName}).m_130940_(ChatFormatting.WHITE)));
        }
        IRadialInventorySelect.super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }

    public boolean m_5812_(ItemStack pStack) {
        return ItemRecipeCopyBook.getMode(pStack) == Modes.PASTE;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            NonNullLazy<BlockEntityWithoutLevelRenderer> ister = NonNullLazy.of(() -> new RecipeCopyBookRenderer(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_()));

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return (BlockEntityWithoutLevelRenderer)this.ister.get();
            }
        });
    }

    public static boolean copyRememberedRecipe(ItemStack stack, ManaweavingAltarTile tile) {
        ItemStack output = tile.getReCraftOutput();
        List<ItemStack> inputs = tile.getReCraftInput();
        IFaction faction = tile.getLastCraftFaction();
        int tier = tile.getLastCraftTier();
        int patternCount = tile.getLastCraftPatternCount();
        if (output.m_41619_() || inputs.size() == 0) {
            return false;
        }
        CompoundTag outputTag = new CompoundTag();
        output.m_41739_(outputTag);
        ListTag inputsTag = new ListTag();
        inputs.forEach(is -> {
            CompoundTag item = new CompoundTag();
            is.m_41739_(item);
            inputsTag.add((Object)item);
        });
        CompoundTag data = new CompoundTag();
        data.m_128365_(NBT_RECIPE_OUTPUT, (Tag)outputTag);
        data.m_128365_(NBT_RECIPE_INPUTS, (Tag)inputsTag);
        data.m_128405_(NBT_RECIPE_TIER, tier);
        data.m_128405_(NBT_RECIPE_PATTERN_COUNT, patternCount);
        if (faction != null) {
            data.m_128359_(NBT_RECIPE_FACTION, Registries.Factions.get().getKey((Object)faction).toString());
        }
        data.m_128344_(NBT_RECIPE_TYPE, (byte)0);
        int slot = ItemRecipeCopyBook.getSlot(stack);
        ItemRecipeCopyBook.setSlotData(stack, slot, data);
        return true;
    }

    public static boolean copyRememberedRecipe(ItemStack stack, EldrinAltarTile tile) {
        ItemStack output = tile.getReCraftOutput();
        List<ItemStack> inputs = tile.getReCraftInput();
        IFaction faction = tile.getLastCraftFaction();
        int tier = tile.getLastCraftTier();
        if (output.m_41619_() || inputs.size() == 0) {
            return false;
        }
        CompoundTag outputTag = new CompoundTag();
        output.m_41739_(outputTag);
        ListTag inputsTag = new ListTag();
        inputs.forEach(is -> {
            CompoundTag item = new CompoundTag();
            is.m_41739_(item);
            inputsTag.add((Object)item);
        });
        CompoundTag affTag = new CompoundTag();
        tile.getReCraftEldrin().entrySet().forEach(e -> affTag.m_128350_(((Affinity)((Object)((Object)e.getKey()))).name(), ((Float)e.getValue()).floatValue()));
        CompoundTag data = new CompoundTag();
        data.m_128365_(NBT_RECIPE_OUTPUT, (Tag)outputTag);
        data.m_128365_(NBT_RECIPE_INPUTS, (Tag)inputsTag);
        data.m_128365_(NBT_RECIPE_COST, (Tag)affTag);
        data.m_128405_(NBT_RECIPE_TIER, tier);
        if (faction != null) {
            data.m_128359_(NBT_RECIPE_FACTION, Registries.Factions.get().getKey((Object)faction).toString());
        }
        data.m_128344_(NBT_RECIPE_TYPE, (byte)1);
        int slot = ItemRecipeCopyBook.getSlot(stack);
        ItemRecipeCopyBook.setSlotData(stack, slot, data);
        return true;
    }

    public static boolean pasteRememberedRecipe(ItemStack stack, ManaweavingAltarTile tile, @Nullable Player player) {
        int slot = ItemRecipeCopyBook.getSlot(stack);
        CompoundTag data = ItemRecipeCopyBook.getSlotData(stack, slot);
        if (data == null) {
            return false;
        }
        if (!(data.m_128441_(NBT_RECIPE_TYPE) && data.m_128445_(NBT_RECIPE_TYPE) == 0 && data.m_128425_(NBT_RECIPE_TIER, 3) && data.m_128425_(NBT_RECIPE_PATTERN_COUNT, 3) && data.m_128425_(NBT_RECIPE_INPUTS, 9) && data.m_128425_(NBT_RECIPE_OUTPUT, 10))) {
            return false;
        }
        CompoundTag outputTag = data.m_128469_(NBT_RECIPE_OUTPUT);
        ListTag inputTag = data.m_128437_(NBT_RECIPE_INPUTS, 10);
        int tier = data.m_128451_(NBT_RECIPE_TIER);
        int patternCount = data.m_128451_(NBT_RECIPE_PATTERN_COUNT);
        String factionID = data.m_128461_(NBT_RECIPE_FACTION);
        ItemStack output = ItemStack.m_41712_((CompoundTag)outputTag);
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        inputTag.forEach(tag -> inputs.add(ItemStack.m_41712_((CompoundTag)((CompoundTag)tag))));
        IFaction faction = (IFaction)Registries.Factions.get().getValue(new ResourceLocation(factionID));
        tile.setReCraftRecipe(output, inputs, faction, tier, patternCount);
        if (player != null) {
            tile.reCraft(player);
        }
        return true;
    }

    public static boolean pasteRememberedRecipe(ItemStack stack, EldrinAltarTile tile, @Nullable Player player) {
        int slot = ItemRecipeCopyBook.getSlot(stack);
        CompoundTag data = ItemRecipeCopyBook.getSlotData(stack, slot);
        if (!(data.m_128441_(NBT_RECIPE_TYPE) && data.m_128445_(NBT_RECIPE_TYPE) == 1 && data.m_128425_(NBT_RECIPE_TIER, 3) && data.m_128425_(NBT_RECIPE_INPUTS, 9) && data.m_128425_(NBT_RECIPE_OUTPUT, 10) && data.m_128425_(NBT_RECIPE_COST, 10))) {
            return false;
        }
        CompoundTag outputTag = data.m_128469_(NBT_RECIPE_OUTPUT);
        CompoundTag outputCost = data.m_128469_(NBT_RECIPE_COST);
        ListTag inputTag = data.m_128437_(NBT_RECIPE_INPUTS, 10);
        int tier = data.m_128451_(NBT_RECIPE_TIER);
        String factionID = data.m_128461_(NBT_RECIPE_FACTION);
        ItemStack output = ItemStack.m_41712_((CompoundTag)outputTag);
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        inputTag.forEach(tag -> inputs.add(ItemStack.m_41712_((CompoundTag)((CompoundTag)tag))));
        IFaction faction = (IFaction)Registries.Factions.get().getValue(new ResourceLocation(factionID));
        HashMap<Affinity, Float> powerRequirements = new HashMap<Affinity, Float>();
        for (Affinity aff : Affinity.values()) {
            if (!outputCost.m_128441_(aff.name())) continue;
            powerRequirements.put(aff, Float.valueOf(outputCost.m_128457_(aff.name())));
        }
        tile.setReCraftRecipe(output, inputs, faction, tier, powerRequirements);
        if (player != null) {
            tile.reCraft(player);
        }
        return true;
    }

    @Override
    public int capacity() {
        return 16;
    }

    @Override
    public int getIndex(ItemStack stack) {
        return ItemRecipeCopyBook.getSlot(stack);
    }

    @Override
    public void setIndex(ItemStack stack, int index) {
        ItemRecipeCopyBook.setSlot(stack, index);
    }

    @Override
    public IItemHandlerModifiable getInventory(final ItemStack stackEquipped, @Nullable Player player) {
        return new IItemHandlerModifiable(){

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return false;
            }

            @NotNull
            public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                return ItemStack.f_41583_;
            }

            @NotNull
            public ItemStack getStackInSlot(int slot) {
                return ItemRecipeCopyBook.getOutputItem(stackEquipped, slot);
            }

            public int getSlots() {
                return ItemRecipeCopyBook.this.capacity();
            }

            public int getSlotLimit(int slot) {
                return 64;
            }

            @NotNull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                return ItemStack.f_41583_;
            }

            public void setStackInSlot(int slot, @NotNull ItemStack stack) {
            }
        };
    }

    public static Modes getMode(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return Modes.COPY;
        }
        return Modes.values()[tag.m_128451_(NBT_MODE) % Modes.values().length];
    }

    public static void toggleMode(ItemStack stack) {
        int idx = (ItemRecipeCopyBook.getMode(stack).ordinal() + 1) % Modes.values().length;
        stack.m_41784_().m_128405_(NBT_MODE, idx);
    }

    public static int getSlot(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return 0;
        }
        return tag.m_128451_("index");
    }

    public static void setSlot(ItemStack stack, int slot) {
        stack.m_41784_().m_128405_("index", slot);
        ItemStack output = ItemRecipeCopyBook.getOutputItem(stack, slot);
        Modes mode = ItemRecipeCopyBook.getMode(stack);
        if (output.m_41619_() && mode == Modes.PASTE) {
            ItemRecipeCopyBook.toggleMode(stack);
        } else if (!output.m_41619_() && mode == Modes.COPY) {
            ItemRecipeCopyBook.toggleMode(stack);
        }
    }

    public static CompoundTag getSlotData(ItemStack stack, int slot) {
        if (stack.m_41783_() == null) {
            return null;
        }
        return stack.m_41783_().m_128469_("recipes_" + slot);
    }

    public static void setSlotData(ItemStack stack, int slot, CompoundTag data) {
        stack.m_41784_().m_128365_("recipes_" + slot, (Tag)data);
        if (ItemRecipeCopyBook.getSlot(stack) == slot && ItemRecipeCopyBook.getMode(stack) == Modes.COPY) {
            ItemRecipeCopyBook.toggleMode(stack);
        }
    }

    public static ItemStack getOutputItem(ItemStack stack, int slot) {
        CompoundTag tag = ItemRecipeCopyBook.getSlotData(stack, slot);
        if (tag == null || !tag.m_128425_(NBT_RECIPE_OUTPUT, 10)) {
            return ItemStack.f_41583_;
        }
        return ItemStack.m_41712_((CompoundTag)tag.m_128469_(NBT_RECIPE_OUTPUT));
    }

    public static int getTileType(ItemStack stack, int slot) {
        CompoundTag tag = ItemRecipeCopyBook.getSlotData(stack, slot);
        if (tag == null || !tag.m_128425_(NBT_RECIPE_TYPE, 1)) {
            return 0;
        }
        return tag.m_128451_(NBT_RECIPE_TYPE);
    }

    public static int getTier(ItemStack stack, int slot) {
        CompoundTag tag = ItemRecipeCopyBook.getSlotData(stack, slot);
        if (tag == null || !tag.m_128425_(NBT_RECIPE_TIER, 3)) {
            return 0;
        }
        return tag.m_128451_(NBT_RECIPE_TIER);
    }

    public static IFaction getFaction(ItemStack stack, int slot) {
        CompoundTag tag = ItemRecipeCopyBook.getSlotData(stack, slot);
        if (tag == null || !tag.m_128425_(NBT_RECIPE_FACTION, 8)) {
            return null;
        }
        return (IFaction)Registries.Factions.get().getValue(new ResourceLocation(tag.m_128461_(NBT_RECIPE_FACTION)));
    }

    public static enum Modes {
        COPY,
        PASTE;

    }
}

