/*
 * Decompiled with CFR 0.152.
 */
package com.mna.items.constructs.parts.arms;

import com.mna.ManaAndArtifice;
import com.mna.api.entities.construct.ConstructCapability;
import com.mna.api.entities.construct.ConstructMaterial;
import com.mna.api.entities.construct.ConstructSlot;
import com.mna.api.entities.construct.ItemConstructPart;
import com.mna.api.spells.ICanContainSpell;
import com.mna.effects.EffectInit;
import com.mna.items.sorcery.ItemSpell;
import com.mna.spells.SpellCaster;
import com.mna.spells.crafting.SpellRecipe;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class ConstructPartCasterArmLeft
extends ItemConstructPart
implements ICanContainSpell {
    public ConstructPartCasterArmLeft(ConstructMaterial material) {
        super(material, ConstructSlot.LEFT_ARM, 128);
    }

    @Override
    public ConstructCapability[] getEnabledCapabilities() {
        return new ConstructCapability[]{ConstructCapability.CAST_SPELL};
    }

    @Override
    public float getAttackDamage() {
        return 0.0f;
    }

    @Override
    public int getAttackSpeedModifier() {
        return 10;
    }

    @Override
    public float getRangedAttackDamage() {
        return 0.0f;
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> lines, TooltipFlag flags) {
        super.m_7373_(stack, world, lines, flags);
        ICanContainSpell.super.getSpell(stack).addItemTooltip(stack, world, lines, ManaAndArtifice.instance.proxy.getClientPlayer());
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack held = player.m_21120_(hand);
        return ItemSpell.castSpellOnUse(held, world, player, hand, this::shouldConsumeMana);
    }

    public int m_8105_(ItemStack p_41454_) {
        return 99999;
    }

    public void m_5929_(Level pLevel, LivingEntity player, ItemStack stack, int count) {
        if (player instanceof Player) {
            ItemSpell.castSpellOnChannelTick(stack, (Player)player, count, this::shouldConsumeChanneledMana);
        }
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity entityLiving) {
        if (entityLiving instanceof Player) {
            ((Player)entityLiving).m_21253_();
        }
        return stack;
    }

    public void m_5551_(ItemStack stack, Level worldIn, LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof Player) {
            Player player = (Player)entityLiving;
            SpellRecipe recipe = SpellRecipe.fromNBT(stack.m_41783_());
            SpellCaster.setCooldown(stack, player, recipe.getCooldown((LivingEntity)player));
            if (this.shouldConsumeMana(stack)) {
                if (entityLiving.m_21023_((MobEffect)EffectInit.MANA_STUNT.get()) && entityLiving.m_21124_((MobEffect)EffectInit.MANA_STUNT.get()).m_19564_() == 5) {
                    entityLiving.m_21195_((MobEffect)EffectInit.MANA_STUNT.get());
                }
                SpellCaster.AddAffinityAndMagicXP(recipe, player, recipe.getMaxChannelTime() - timeLeft);
            }
        }
    }

    public boolean m_5812_(ItemStack p_41453_) {
        return SpellRecipe.stackContainsSpell(p_41453_);
    }

    protected boolean shouldConsumeMana(ItemStack stack) {
        return true;
    }

    protected boolean shouldConsumeChanneledMana(Player player, ItemStack stack) {
        return true;
    }
}

