/*
 * Decompiled with CFR 0.152.
 */
package com.mna.items.constructs.parts.arms;

import com.mna.api.entities.construct.ConstructCapability;
import com.mna.api.entities.construct.ConstructMaterial;
import com.mna.api.entities.construct.ConstructSlot;
import com.mna.api.entities.construct.FluidParameterRegistry;
import com.mna.api.entities.construct.ItemConstructPart;
import com.mna.api.events.construct.ConstructSprayEffectEvent;
import com.mna.api.tools.MATags;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;

public class ConstructPartFluidNozzleRight
extends ItemConstructPart {
    public ConstructPartFluidNozzleRight(ConstructMaterial material) {
        super(material, ConstructSlot.RIGHT_ARM, 64);
    }

    @Override
    public ConstructCapability[] getEnabledCapabilities() {
        return new ConstructCapability[]{ConstructCapability.FLUID_DISPENSE};
    }

    @Override
    public float getAttackDamage() {
        return 0.0f;
    }

    @Override
    public int getAttackSpeedModifier() {
        return 10;
    }

    @Override
    public float getRangedAttackDamage() {
        return 0.0f;
    }

    public int m_8105_(ItemStack stack) {
        return 100;
    }

    public UseAnim m_6164_(ItemStack p_41452_) {
        return UseAnim.BOW;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        FluidStack backpackFluid = this.getBackpackFluid((LivingEntity)player);
        if (!backpackFluid.isEmpty()) {
            player.m_6672_(hand);
            world.m_6263_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), FluidParameterRegistry.INSTANCE.forFluid(backpackFluid.getFluid()).spraySound(), SoundSource.NEUTRAL, 0.25f, (float)(0.9 + Math.random() * 0.1));
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        if (!player.m_9236_().m_5776_()) {
            player.m_213846_((Component)Component.m_237115_((String)"item.mna.constructs.construct_fluid_nozzle.no_backpack"));
            player.m_36335_().m_41524_((Item)this, 60);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public void m_5929_(Level world, LivingEntity living, ItemStack stack, int ticksRemaining) {
        FluidStack backpackFluid;
        if (ticksRemaining < 2 && living instanceof Player) {
            ((Player)living).m_36335_().m_41524_((Item)this, 60);
            ((Player)living).m_5810_();
        }
        if (!(backpackFluid = this.getBackpackFluid(living)).isEmpty() && this.consumeBackpackFluid(living)) {
            FluidParameterRegistry.FluidParameter flParam = FluidParameterRegistry.INSTANCE.forFluid(backpackFluid.getFluid());
            if (world.f_46443_) {
                for (int i = 0; i < flParam.getParticleQuantity(); ++i) {
                    Vec3 fwd = living.m_20156_();
                    Vec3 particlePos = living.m_20182_().m_82520_(0.0, (double)(living.m_20192_() / 5.0f * 4.0f), 0.0).m_82549_(fwd);
                    Vec3 vel = flParam.adjustVelocity(fwd);
                    world.m_7106_(flParam.particle(), particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, vel.f_82479_, vel.f_82480_, vel.f_82481_);
                }
            } else {
                AABB bb = living.m_20191_().m_82377_(0.0, 1.0, 0.0);
                Vec3 look = living.m_20156_();
                bb = bb.m_82369_(look.m_82490_(8.0));
                world.m_6249_((Entity)living, bb, e -> {
                    if (!(e instanceof LivingEntity) || e == living) {
                        return false;
                    }
                    return living.m_142582_(e);
                }).stream().map(e -> (LivingEntity)e).forEach(e -> {
                    ConstructSprayEffectEvent effectEvt = new ConstructSprayEffectEvent(living, (LivingEntity)e, backpackFluid.getFluid(), false, false);
                    MinecraftForge.EVENT_BUS.post((Event)effectEvt);
                });
            }
        } else {
            ((Player)living).m_36335_().m_41524_((Item)this, 60);
            ((Player)living).m_5810_();
        }
    }

    public void m_5551_(ItemStack stack, Level world, LivingEntity living, int ticksRemaining) {
        if (living instanceof Player) {
            ((Player)living).m_36335_().m_41524_((Item)this, 60);
        }
    }

    private FluidStack getBackpackFluid(LivingEntity living) {
        Optional equipped = CuriosApi.getCuriosHelper().findFirstCurio(living, is -> MATags.isItemIn(is.m_41720_(), MATags.Items.FLUID_ARM_PLAYER_TANKS));
        if (equipped.isEmpty()) {
            return FluidStack.EMPTY;
        }
        Optional fluid = FluidUtil.getFluidContained((ItemStack)((SlotResult)equipped.get()).stack());
        if (fluid.isEmpty()) {
            return FluidStack.EMPTY;
        }
        return (FluidStack)fluid.get();
    }

    private boolean consumeBackpackFluid(LivingEntity living) {
        Optional equipped = CuriosApi.getCuriosHelper().findFirstCurio(living, is -> MATags.isItemIn(is.m_41720_(), MATags.Items.FLUID_ARM_PLAYER_TANKS));
        if (equipped.isEmpty()) {
            return false;
        }
        LazyOptional fluid = FluidUtil.getFluidHandler((ItemStack)((SlotResult)equipped.get()).stack());
        if (!fluid.isPresent()) {
            return false;
        }
        if (((IFluidHandlerItem)fluid.resolve().get()).drain(10, IFluidHandler.FluidAction.SIMULATE).getAmount() == 10) {
            ((IFluidHandlerItem)fluid.resolve().get()).drain(10, IFluidHandler.FluidAction.EXECUTE);
            return true;
        }
        return false;
    }
}

