/*
 * Decompiled with CFR 0.152.
 */
package com.mna.items.manaweaving;

import com.mna.ManaAndArtifice;
import com.mna.api.capabilities.IPlayerMagic;
import com.mna.api.capabilities.IPlayerProgression;
import com.mna.api.faction.IFaction;
import com.mna.api.items.IShowHud;
import com.mna.api.items.TieredItem;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.api.sound.SFX;
import com.mna.blocks.BlockInit;
import com.mna.capabilities.playerdata.magic.PlayerMagicProvider;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.mna.entities.manaweaving.Manaweave;
import com.mna.gui.containers.providers.NamedCantrips;
import com.mna.items.base.IItemWithGui;
import com.mna.items.base.IRadialMenuItem;
import com.mna.network.ClientMessageDispatcher;
import com.mna.recipes.manaweaving.ManaweavingPattern;
import com.mna.recipes.manaweaving.ManaweavingPatternHelper;
import com.mna.sound.ItemInUseLoopingSound;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.joml.Vector3f;

public class ItemManaweaverWand
extends TieredItem
implements IShowHud,
IItemWithGui<ItemManaweaverWand>,
IRadialMenuItem {
    public static final float MANA_COST_PER_TICK = 1.0f;
    private static final int AUTOWEAVE_TICKS_REQUIRED = 30;
    private static final String KEY_STORED_ALTAR = "altar_location";
    private static final String KEY_MODEL_DATA = "CustomModelData";
    private static final String KEY_SELECTED_PATTERN = "SelectedPattern";

    public ItemManaweaverWand() {
        this(new Item.Properties().m_41487_(1));
    }

    public ItemManaweaverWand(Item.Properties props) {
        super(props);
    }

    public boolean canEquip(ItemStack stack, EquipmentSlot armorType, Entity entity) {
        return armorType == EquipmentSlot.MAINHAND;
    }

    public void m_5551_(ItemStack stack, Level worldIn, LivingEntity entityLiving, int timeLeft) {
        if (!(entityLiving instanceof Player)) {
            return;
        }
        Player player = (Player)entityLiving;
        if (player.m_36335_().m_41519_((Item)this)) {
            return;
        }
        if (worldIn.f_46443_) {
            IPlayerMagic magic = (IPlayerMagic)player.getCapability(PlayerMagicProvider.MAGIC).orElse(null);
            IPlayerProgression progression = (IPlayerProgression)player.getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
            if (magic != null && progression != null) {
                Vector3f[] points = magic.getRememberedPoints();
                Vector3f[] looks = magic.getRememberedLooks();
                int useTicks = this.m_8105_(stack) - timeLeft;
                if (points.length > 0) {
                    ManaweavingPattern pattern = ItemManaweaverWand.getStoredPattern(worldIn, stack);
                    if (pattern == null) {
                        pattern = ManaweavingPattern.match(worldIn, progression.getTier(), points, looks);
                    } else if (useTicks < ItemManaweaverWand.getAutoweaveTicks((LivingEntity)player)) {
                        player.m_213846_((Component)Component.m_237115_((String)"item.mna.manaweaver_wand.channel_too_short"));
                        return;
                    }
                    if (pattern == null) {
                        player.m_213846_((Component)Component.m_237115_((String)"item.mna.manaweaver_wand.not_recognized"));
                    } else {
                        if (pattern.getTier() > progression.getTier()) {
                            player.m_213846_((Component)Component.m_237115_((String)"item.mna.manaweaver_wand.low_tier"));
                            return;
                        }
                        double avgX = 0.0;
                        double avgZ = 0.0;
                        double minY = Double.MAX_VALUE;
                        for (Vector3f vec : points) {
                            avgX += (double)vec.x();
                            avgZ += (double)vec.z();
                            if (!((double)vec.y() < minY)) continue;
                            minY = vec.y();
                        }
                        ClientMessageDispatcher.sendManaweavePatternDrawn(player, pattern.m_6423_(), new Vec3(avgX /= (double)points.length, minY - 0.4, avgZ /= (double)points.length), player.m_7655_(), useTicks);
                    }
                }
            }
        }
        player.m_36335_().m_41524_(stack.m_41720_(), 5);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.m_21120_(handIn);
        MutableBoolean success = new MutableBoolean(true);
        playerIn.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> {
            if (m.isMagicUnlocked()) {
                if (!this.openGuiIfModifierPressed(itemstack, playerIn, worldIn)) {
                    if (worldIn.f_46443_) {
                        m.clearRememberedPoints();
                        this.PlayLoopingSound(SFX.Loops.MANAWEAVING, playerIn);
                    }
                    ManaweavingPattern pattern = ItemManaweaverWand.getStoredPattern(worldIn, itemstack);
                    LazyOptional progression = playerIn.getCapability(PlayerProgressionProvider.PROGRESSION);
                    if (pattern != null && progression.isPresent() && ((IPlayerProgression)progression.resolve().get()).getTier() < pattern.getTier()) {
                        ItemManaweaverWand.setStoredPattern(itemstack, null);
                    }
                    playerIn.m_6672_(handIn);
                } else {
                    success.setFalse();
                }
            } else {
                if (worldIn.f_46443_) {
                    playerIn.m_213846_((Component)Component.m_237115_((String)"item.mna.manaweaver_wand.confusion"));
                }
                playerIn.m_36335_().m_41524_((Item)this, 100);
            }
        });
        if (success.getValue().booleanValue()) {
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        return InteractionResultHolder.m_19100_((Object)itemstack);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        if (context.m_43723_().m_6047_()) {
            BlockState state = context.m_43725_().m_8055_(context.m_8083_());
            if (state.m_60734_() == BlockInit.MANAWEAVING_ALTAR.get()) {
                if (!context.m_43725_().m_5776_()) {
                    stack.m_41784_().m_128365_(KEY_STORED_ALTAR, (Tag)NbtUtils.m_129224_((BlockPos)context.m_8083_()));
                    stack.m_41784_().m_128405_(KEY_MODEL_DATA, 1);
                    context.m_43723_().m_213846_((Component)Component.m_237115_((String)"item.mna.manaweaver_wand.position_stored"));
                }
                return InteractionResult.FAIL;
            }
            if (stack.m_41782_() && stack.m_41783_().m_128441_(KEY_STORED_ALTAR)) {
                if (!context.m_43725_().m_5776_()) {
                    stack.m_41784_().m_128473_(KEY_STORED_ALTAR);
                    stack.m_41784_().m_128473_(KEY_MODEL_DATA);
                    context.m_43723_().m_213846_((Component)Component.m_237115_((String)"item.mna.manaweaver_wand.position_cleared"));
                }
                return InteractionResult.FAIL;
            }
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public static BlockPos getStoredBlockPos(ItemStack stack) {
        if (stack.m_41720_() instanceof ItemManaweaverWand && stack.m_41782_() && stack.m_41783_().m_128441_(KEY_STORED_ALTAR)) {
            return NbtUtils.m_129239_((CompoundTag)stack.m_41783_().m_128469_(KEY_STORED_ALTAR));
        }
        return null;
    }

    @Nullable
    public static ManaweavingPattern getStoredPattern(Level world, ItemStack stack) {
        ResourceLocation rLoc = ItemManaweaverWand.getStoredPatternID(world, stack);
        if (rLoc != null) {
            return ManaweavingPatternHelper.GetManaweavingRecipe(world, rLoc);
        }
        return null;
    }

    @Nullable
    public static ResourceLocation getStoredPatternID(Level world, ItemStack stack) {
        if (!stack.m_41782_() || !stack.m_41783_().m_128441_(KEY_SELECTED_PATTERN)) {
            return null;
        }
        ResourceLocation rLoc = new ResourceLocation(stack.m_41783_().m_128461_(KEY_SELECTED_PATTERN));
        return rLoc;
    }

    public static void setStoredPattern(ItemStack stack, ResourceLocation rLoc) {
        if (rLoc == null) {
            stack.m_41783_().m_128473_(KEY_SELECTED_PATTERN);
        } else {
            stack.m_41784_().m_128359_(KEY_SELECTED_PATTERN, rLoc.toString());
        }
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        Manaweave mw;
        if (entity instanceof Manaweave && !(mw = (Manaweave)entity).isMerging()) {
            IPlayerMagic magic = (IPlayerMagic)player.getCapability(PlayerMagicProvider.MAGIC).orElse(null);
            if (magic != null) {
                magic.getCastingResource().restore(mw.getManaReturn(player));
                magic.getCastingResource().setNeedsSync();
            }
            player.m_9236_().m_5594_(player, player.m_20183_(), SoundEvents.f_11898_, SoundSource.PLAYERS, 1.0f, 1.0f);
            mw.m_142687_(Entity.RemovalReason.DISCARDED);
            return false;
        }
        return super.onLeftClickEntity(stack, player, entity);
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.NONE;
    }

    public int m_8105_(ItemStack stack) {
        return 999999;
    }

    public void m_5929_(Level pLevel, LivingEntity player, ItemStack stack, int count) {
        LazyOptional magicContainer = player.getCapability(PlayerMagicProvider.MAGIC);
        LazyOptional progContainer = player.getCapability(PlayerProgressionProvider.PROGRESSION);
        if (magicContainer.isPresent()) {
            IPlayerMagic magic = (IPlayerMagic)magicContainer.orElse(null);
            if (!magic.isMagicUnlocked()) {
                player.m_21253_();
                return;
            }
            if (!magic.getCastingResource().hasEnoughAbsolute(player, 1.0f)) {
                if (player instanceof Player) {
                    ((Player)player).m_36335_().m_41524_((Item)this, 100);
                    if (player.m_9236_().m_5776_() && player == ManaAndArtifice.instance.proxy.getClientPlayer()) {
                        ((Player)player).m_213846_((Component)Component.m_237115_((String)"item.mna.manaweaver_wand.oom"));
                    }
                }
                player.m_21253_();
                return;
            }
            if (player.m_9236_().m_5776_()) {
                int ticksUsed;
                int[] color;
                IFaction faction;
                Vec3 eyePos = player.m_20299_(0.0f);
                Vec3 look = player.m_20154_();
                Vec3 position = eyePos.m_82549_(look);
                Vec3 particlePosition = eyePos.m_82549_(look.m_82490_(1.5));
                ((IPlayerMagic)magicContainer.orElse(null)).addRememberedPoint(position.m_252839_(), new Vector3f(Mth.m_14177_((float)player.m_146908_()), Mth.m_14177_((float)player.m_146909_()), 0.0f));
                MAParticleType particle = new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.BLUE_SPARKLE_STATIONARY.get())).setMaxAge(40);
                if (progContainer.isPresent() && (faction = ((IPlayerProgression)progContainer.resolve().get()).getAlliedFaction()) != null && (color = faction.getManaweaveRGB()) != null) {
                    particle.setColor(color[0], color[1], color[2]);
                }
                player.m_9236_().m_7106_((ParticleOptions)particle, particlePosition.f_82479_, particlePosition.f_82480_, particlePosition.f_82481_, 0.0, 0.0, 0.0);
                ManaweavingPattern pattern = ItemManaweaverWand.getStoredPattern(player.m_9236_(), stack);
                if (pattern != null && (ticksUsed = this.m_8105_(stack) - count) == ItemManaweaverWand.getAutoweaveTicks(player)) {
                    player.m_5496_(SoundEvents.f_11871_, 1.0f, 1.0f);
                }
            }
            magic.getCastingResource().consume(player, 1.0f);
        }
    }

    public boolean canContinueUsing(ItemStack oldStack, ItemStack newStack) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void PlayLoopingSound(SoundEvent soundID, Player player) {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new ItemInUseLoopingSound(soundID, player));
    }

    @Override
    public MenuProvider getProvider(ItemStack stack) {
        return new NamedCantrips();
    }

    @Override
    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        ManaweavingPattern stored = ItemManaweaverWand.getStoredPattern(worldIn, stack);
        if (stored != null) {
            tooltip.add((Component)Component.m_237110_((String)"item.mna.manaweaver_wand.auto", (Object[])new Object[]{Component.m_237115_((String)stored.m_6423_().toString()).getString()}).m_130940_(ChatFormatting.GOLD));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"item.mna.manaweaver_wand.manual").m_130940_(ChatFormatting.GOLD));
        }
        IItemWithGui.super.m_7373_(stack, worldIn, tooltip, flagIn);
        IRadialMenuItem.super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    public static int getAutoweaveTicks(LivingEntity living) {
        if (!(living instanceof Player)) {
            return 30;
        }
        Player player = (Player)living;
        IPlayerProgression progression = (IPlayerProgression)player.getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
        int ticks = 30;
        if (progression != null) {
            ticks -= 5 * progression.getTier();
        }
        return ticks;
    }
}

