/*
 * Decompiled with CFR 0.152.
 */
package com.mna.items.ritual;

import com.mna.api.capabilities.IPlayerMagic;
import com.mna.api.items.TieredItem;
import com.mna.capabilities.playerdata.magic.PlayerMagicProvider;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LazyOptional;

public class ItemPlayerCharm
extends TieredItem {
    private static final String KEY_PLAYER_TARGET_NAME = "player_target_name";
    private static final String KEY_PLAYER_TARGET_UUID = "player_target_uuid";
    private static final String KEY_PLAYER_TARGET_SALT = "player_target_salt";

    public ItemPlayerCharm() {
        super(new Item.Properties().m_41487_(1));
    }

    public boolean SetPlayerTarget(Player entity, ItemStack stack) {
        CompoundTag nbt = stack.m_41784_();
        LazyOptional magic = entity.getCapability(PlayerMagicProvider.MAGIC);
        if (magic.isPresent()) {
            nbt.m_128359_(KEY_PLAYER_TARGET_UUID, entity.m_20148_().toString());
            nbt.m_128405_(KEY_PLAYER_TARGET_SALT, ((IPlayerMagic)magic.orElse(null)).getTeleportSalt());
            nbt.m_128359_(KEY_PLAYER_TARGET_NAME, entity.m_36316_().getName());
            return true;
        }
        return false;
    }

    @Nullable
    public UUID getPlayerUUID(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt == null || !nbt.m_128441_(KEY_PLAYER_TARGET_UUID) || !nbt.m_128441_(KEY_PLAYER_TARGET_SALT)) {
            return null;
        }
        return UUID.fromString(nbt.m_128461_(KEY_PLAYER_TARGET_UUID));
    }

    @Nullable
    public Player GetPlayerTarget(ItemStack stack, Level world) {
        LazyOptional magic;
        UUID uuid = this.getPlayerUUID(stack);
        if (uuid == null) {
            return null;
        }
        CompoundTag nbt = stack.m_41783_();
        Player entity = world.m_46003_(uuid);
        if (entity != null && (magic = entity.getCapability(PlayerMagicProvider.MAGIC)).isPresent() && ((IPlayerMagic)magic.orElse(null)).getTeleportSalt() == nbt.m_128451_(KEY_PLAYER_TARGET_SALT)) {
            return entity;
        }
        return null;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        if (!worldIn.f_46443_) {
            CompoundTag nbt = stack.m_41783_();
            if (nbt == null) {
                nbt = new CompoundTag();
            }
            if (!nbt.m_128441_(KEY_PLAYER_TARGET_UUID) && !nbt.m_128441_(KEY_PLAYER_TARGET_SALT)) {
                this.SetPlayerTarget(playerIn, stack);
                playerIn.m_213846_((Component)Component.m_237115_((String)"item.mna.player_charm.attuned_success"));
            } else {
                playerIn.m_213846_((Component)Component.m_237115_((String)"item.mna.player_charm.attuned_failure"));
            }
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt == null) {
            tooltip.add((Component)Component.m_237115_((String)"item.mna.player_charm.not_attuned"));
            return;
        }
        String playerName = nbt.m_128461_(KEY_PLAYER_TARGET_NAME);
        if (playerName == null) {
            return;
        }
        tooltip.add((Component)Component.m_237110_((String)"item.mna.player_charm.attuned", (Object[])new Object[]{playerName}));
    }
}

